<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: upstream sent too big header while reading response header"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => 'To be ready soon.',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Internal Server Error: Option FollowSymLinks not allowed here"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => 'To be ready soon.',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "server reached max_children setting"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Symptoms</h4><ul><li><p>Websites that have PHP handler set as <strong>FPM application served by Apache</strong> or <strong>FPM application served by nginx</strong> at <strong>Domains</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP Settings</strong> experience one of the following issues:</p><ul><li><p>load slowly</p></li><li><p>not accessible (permanently or periodically) with a 50x error in a web-browser:</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily Unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p>The following message appears in the PHP-FPM error logfile <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (where <em>XX</em> is a PHP version used by the websites):</p><pre>WARNING: [pool example.com] server reached max_children setting (*), consider raising it</pre><ul><li><p>The message above is usually accompanied with this error:</p><pre>unable to read what child say: Bad file descriptor (9)</pre></li></ul></li><li><p>If nginx is enabled on the server, one of the following error messages may appear in domain\'s error logfile <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: example.com, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>The PHP-FPM <code>pm.max_children</code> has been reached by the website(s).</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Increase the pm.max_children limit',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Increase the <code>pm.max_children</code> limit for the affected domains:</p><ol><li><p>Connect to the Plesk server via <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Find affected domains using the command below:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Note:</strong> The number on the left indicates how many times the <code>pm.max_children</code> limit has been reached by the website.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener">Log in to Plesk</a>.</p></li><li><p>Go to <strong>Domains</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP Settings</strong> &gt; <strong>PHP-FPM Settings</strong>.</p></li><li><p>Increase the <code>pm.max_children</code> value for the domain and apply the changes. Increase this value for all domains listed in step 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Too many open files"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx fails to start/reload on a Plesk server: Too many open files</p><h4>Symptoms</h4><ul><li><p>The nginx service fails to start/reload with the following error in the <code>/var/log/nginx/error.log</code> file:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: Too many open files)</pre></li><li><p>Some or all websites are not accessible</p></li><li><p>Warning is shown in the <strong>Tools &amp; Settings &gt; Diagnose &amp; repair</strong>:</p><pre style="white-space: pre-wrap;">Checking for nginx ULIMIT value N domains have been found on server. Problem with nginx default limit for open files is possible</pre></li><li><p>NodeJS and Ruby web applications are showing 502 Bad Gateway error when performing some Plesk tasks such as creating domains, subscriptions, changes on Apache or Nginx, etc:</p><pre style="white-space: pre-wrap;">Server Error<br>502 Bad Gateway <br>Web server received an invalid response while acting as a gateway or proxy server.</pre></li><li><p>After <a href="https://support.plesk.com/hc/en-us/articles/12377676289815-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">installing a new certificate for the domain</a>, the old one is still shown in a web browser, however, the correct certificate is selected at the <strong>Domains &gt; example.com &gt; Hosting Settings</strong> page.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Nginx\'s virtual host opens 4 log files for each virtual host with physical hosting:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>As a result of this fact, the maximum number of open files is exceeded by the nginx server due to a big number of domains (usually, more than 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Increase the open files limit',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Warning:</strong> Execution of the <code>websrv_ulimits</code> utility without <strong>--no-restart</strong> option initiates rebuilding of web configuration files for all domains and can cause significant downtime in case of a big number of hosted websites.<br><br>Execute the command during the maintenance time frame.</div><p>It is good practice to set open files limit value more than <strong>number of domains in Plesk * 16</strong> at least. In example below provided actions how to set limit to 4096:</p><ol><li><p>Connect to the server via <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Set open files limit to 4096 for both Apache and Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Restart Apache and nginx services at <strong><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Tools &amp; Settings &gt; Services Management</strong> to apply changes.</p></li><li><p>Check that \'Max open files limit\' was applied properly, after web services restarting:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>If the solution above did not help, set the limit using the <code>ulimit</code> utility:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Response body too large"',
    'problem-detail.apache-modsec-response-body-too-large.description' => 'To be ready soon.',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Access denied with code 403"',
    'problem-detail.modsec-access-denied.description' => '<h4>Symptoms</h4><ul><li><p>ModSecurity is installed and enabled in <strong>Tools & Settings > Web Application Firewall (ModSecurity) > Web application firewall mode > On</strong>.</p></li><li>A website hosted in Plesk fails to load. It is not possible to perform operations on the website such as manage WordPress, access webmail, or access <code>robots.txt</code> file. The browser can display one of the following errors: <pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 Forbidden</pre><hr><pre>500 Internal Server Error</pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li>A ModSecurity error message like the one below appears in the <code>/var/log/modsec_audit.log</code> log file or on the Logs page in Plesk (<strong>Domains</strong> &gt; <strong>example.com</strong> &gt; <strong>Logs</strong>): <pre>ModSecurity: Access denied with code 403 (phase 2). Operator GE matched 5 at TX:anomaly_score. [file "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_4-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [line "57"] [id "949110"] [msg "Inbound Anomaly Score Exceeded (Total Score: 5)"] [severity "CRITICAL"] [tag "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com"] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>ModSecurity Web Application Firewall is enabled with a very restrictive rule set such as OWASP, Comodo, or a custom rule set like Imunify360. Restrictive rule sets can block some operations on the website.</p><p><Strong>Note:</strong> The ModSecurity error might indicate an attack on your server. Use the solutions below only if you are sure that ModSecurity blocks valid usage of your website.</p>',
    'problem-detail.modsec-access-denied.solution1.title' => 'Disable the ModSecurity rule set by ID or Tag',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>Find the ID of the rule that blocks the legitimate usage of your website. You can find the IDs inside error messages in the <code>/var/log/modsec_audit.log</code> log file. The ID is an integer number in quotation marks with the prefix <code>id</code> in square brackets, for example, <strong>[id "210831"]</strong>.</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/12377453278871" target="_blank" rel="noopener">Disable specific rule sets in Plesk</a>.</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => 'Switch to another ModSecurity rule set',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>Switch to a less restrictive ModSecurity rule set, for example, "Atomic ModSecurity Ruleset". To do so, go to <strong>Tools & Settings</strong> > <strong>Web Application Firewall (ModSecurity)</strong> > <strong>Settings</strong>, select <strong>Atomic Standard</strong>, and then click <strong>OK</strong> to apply the changes.</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Internal Server error 500: Allowed memory size of XXX exhausted"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>Symptoms</h4><ul><li><p>A website hosted in Plesk is not accessible:</p><pre>500 Internal Server Error</pre></li><li><p>The following error is shown in the website log:</p><pre>Got error "PHP message: PHP Fatal error: Allowed memory size of 4194304 bytes exhausted (tried to allocate 4000032 bytes) in /var/www/vhosts/example.com/httpdocs/somethingBig.php on line 3</pre></li> </ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>The website does not have enough memory allocated to be processed.</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => 'Increase memory_limit of the website',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510316183" target="_blank" rel="noopener">Read the KB article and follow the instructions</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "open_basedir restriction in effect"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>Symptoms</h4><ul><li><p>A website is not accessible with one of the following errors in the web browser:</p><pre>404 file not found</pre><hr><pre>500 Internal Server Error</pre><hr><pre>Error 500 move_uploaded_file(): open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s): (/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>The following error message appears on the domain\'s Logs page (<strong>Domains</strong> > <strong>example.com</strong> > <strong>Logs</strong>):</p><pre><...> open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s) <...></pre><hr><pre>Uncaught Exception: Session: Configured save path "/path/to/the/directory" is not a directory, doesn\'t exist or cannot be created.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'The PHP script is trying to access the directory for which access is not allowed. This restriction is defined by the PHP <code>open_basedir</code> directive individually for each domain. By default, <code>open_basedir</code> allows access to the <code>tmp</code> and domain\'s document root directories, as well as the system\'s default sessions path.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => 'Add the additional path to the open_basedir directive',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510714135" target="_blank" rel="noopener">Read the KB article and follow the instructions</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => 'Disable the open_basedir directive',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p>Go to <strong>Domains &gt example.com &gt PHP Settings</strong> page and set the <code>open_basedir</code> directive to "none".</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Forbidden AH01797: client denied by server configuration"',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>Symptoms</h4><ul><li><p>The website shows an error similar to the following one:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>The <code>/var/www/vhosts/system/example.com/logs/error_log</code> log file contains errors like the following one:</p><pre>AH01797: client denied by server configuration: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>The current Apache configuration does not allow access to the website.</p><p>For files such as .htaccess and .htpasswd, it is expected because these files must not be accessible via the web server.</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => 'Check the server configuration and .htaccess files',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Read the KB article and follow the instructions</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Cannot access a website directory in Plesk: 403 Forbidden"',
    'problem-detail.apache-no-directory-index.description' => '<h4>Symptoms</h4><ul><li><p>Cannot access a specific location of a website, for example, <code>http://example.com/some_folder</code>. The following error occurs:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>The following error appears in the <code>/var/www/vhosts/example.com/logs/error_log<code/> file:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>The requested directory does not contain index files or directory browsing is not enabled.</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => 'Add an index file to the directory',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Read the KB article and follow the instructions</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => 'Enable directory browsing',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Read the KB article and follow the instructions</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Cannot access a website directory in Plesk: 403 Forbidden"',
    'problem-detail.nginx-no-directory-index.description' => '<h4>Symptoms</h4><ul><li><p>Cannot access a specific location of a website, for example, <code>http://example.com/some_folder</code>. The following error occurs:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>The following error appears in the <code>/var/www/vhosts/example.com/logs/error_log file</code>:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>The requested directory does not contain index files or directory browsing is not enabled.</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => 'Add an index file to the directory',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Read the KB article and follow the instructions</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => 'Enable directory browsing',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Read the KB article and follow the instructions</a>.</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "server reached MaxRequestWorkers setting"',
    'problem-detail.apache-reached-max-request-workers.description' => 'To be ready soon.',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'PHP request body limit "client intended to send too large body"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => 'To be ready soon.',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'PHP request body limit "client intended to send too large body"',
    'problem-detail.nginx-client-sent-too-large-body.description' => 'To be ready soon.',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP sessions "503 Internal Server Error" or "Failed to read session data"',
    'problem-detail.php-failed-to-read-session-data.description' => 'To be ready soon.',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: unable to check htaccess file, ensure it is readable"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>Symptoms</h4><ul><li><p>A website hosted in Plesk is not working:</p><pre>You don\'t have permission to access / on this server. <br> Additionally, a 403 Forbidden error was encountered while trying to use an ErrorDocument to handle the request.</pre><p>Instead of the above error, you can also see the blank page.</p></li><li><p>The domain error log in <strong>Domains &gt example.com &gt Logs</strong> contains the following:</p><pre>(13)Permission denied: [client 203.0.113.2:39024] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: unable to check htaccess file, ensure it is readable and that "/var/www/vhosts/example.com/httpdocs/" is executable</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => 'Incorrect permissions for the domain\'s files or folders.',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => 'Repair permissions for the website content',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377773681815" target="_blank" rel="noopener">Read the KB article and follow the instructions</a>.</p></li></ol>',
];
