<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => '如果您的网站托管于一个独立 IP 地址上（不与其他用户或网站共享），您可在网站内创建一个其他用户可通过 FTP 匿名上传或下载文件的目录。匿名 FTP 一打开，用户将可使用“匿名”用户名与密码登录至目录，地址如 ftp://ftp.your-domain.com。',
    'anonymous-ftp.displayLogin' => '显示登录信息',
    'anonymous-ftp.loginText' => '信息文本',
    'anonymous-ftp.incomingDir' => '允许上传至接收目录',
    'anonymous-ftp.incomingSubDir' => '允许在接收目录中创建目录',
    'anonymous-ftp.incomingReadable' => '允许从接收目录中下载',
    'anonymous-ftp.quota' => '限制接收目录中的磁盘空间',
    'anonymous-ftp.maxConnections' => '限制同时连接的数量',
    'anonymous-ftp.bandwidth' => '限制此虚拟 FTP 域名的下载带宽',
    'anonymous-ftp.unlimited' => '无限',

    'aps.catalog.loading' => '加载中...',
    'aps.catalog.searchName' => '应用程序',
    'aps.catalog.searchVendor' => '厂商',
    'aps.catalog.searchPackager' => '打包者',
    'aps.catalog.searchLicenseType' => '许可证类型',
    'aps.catalog.searchLicenseTypeAny' => '任何',
    'aps.catalog.searchLicenseTypeFreeware' => '免费',
    'aps.catalog.searchLicenseTypeCommercial' => '商业',
    'aps.catalog.showSearch' => '显示搜索',
    'aps.catalog.hideSearch' => '隐藏搜索',
    'aps.catalog.buttonSearch' => '搜索',
    'aps.catalog.buttonResetSearch' => '重置搜索',
    'aps.catalog.showCategories' => '在下面选择一个目录或使用搜索框搜索应用程序',
    'aps.catalog.searchResults' => '搜索结果',
    'aps.catalog.buttonInstall' => '安装',
    'aps.catalog.buttonInstallTooltip' => '快速安装最新版本的应用程序，设置最优默认参数。',
    'aps.catalog.buttonAdvancedInstall' => '安装（自定义）',
    'aps.catalog.buttonAdvancedInstallTooltip' => '安装最新版本的应用程序，自定义所有参数。',
    'aps.catalog.buttonInstallOldVersion' => '安装版本',
    'aps.catalog.buttonInstallOldVersionTooltip' => '安装选定版本的应用程序，自定义所有参数。',
    'aps.catalog.buttonInstallDescription' => '若有激活码或仅想试用，请在网站上安装应用程序。',
    'aps.catalog.buttonInstallDescriptionFree' => '在网站上安装此免费应用程序。',
    'aps.catalog.version' => '版本',
    'aps.catalog.moreVersions' => '更多版本',
    'aps.catalog.release' => '发行版本',
    'aps.catalog.overview' => '概要',
    'aps.catalog.noApplicationsInCategory' => '此类别中无可用应用程序。请选择另一类别。',
    'aps.catalog.noCategoriesSelected' => '选择一类来浏览此类别中的所有应用程序。',
    'aps.catalog.noSearchResults' => '未搜索到匹配的应用程序。',
    'aps.catalog.connectionFailed' => '连接到应用程序目录失败。%%retryLink%%。',
    'aps.catalog.retry' => '重试',
    'aps.catalog.categoriesError' => '此刻无法加载类别列表。',
    'aps.catalog.applicationsError' => '此刻无法加载应用程序列表。',
    'aps.catalog.detailsError' => '此刻无法加载应用程序详情。',
    'aps.catalog.searchError' => '此刻无法加载搜索结果。',
    'aps.catalog.changelogEntry' => 'v%%version%% (Release %%release%%) - %%description%%',
    'aps.catalog.changelog' => '变更历史记录',
    'aps.catalog.officialApplicationSite' => '厂商信息',
    'aps.catalog.returnToCategories' => '< 返回应用程序列表',
    'aps.catalog.buttonUninstall' => '移除',
    'aps.catalog.gotoHome' => '首页',
    'aps.catalog.all' => '所有',
    'aps.catalog.buttonDetails' => '了解更多',
    'aps.catalog.buttonBuy' => '现在购买',
    'aps.catalog.buttonBuyTooltip' => '购买该应用',
    'aps.catalog.buttonBuyDescription' => '访问商店购买应用程序激活码。',
    'aps.catalog.buttonDownload' => '下载',
    'aps.catalog.buttonDownloadDescription' => '若已有激活码或仅想试用，请下载应用程序。',
    'aps.catalog.marketplaceMoreInfo' => '如需更多信息，请访问 %%link%%。',
    'aps.catalog.marketplaceMoreInfoLink' => '应用程序代理商网站',

    'aps.configure.installedAt' => "安装位置",
    'aps.configure.otherSettings' => "其他",
    'aps.configure.globalSettings' => '包设置',
    'aps.configure.passwordConfirmation' => '确认密码',
    'aps.configure.databaseParams' => '数据库参数',
    'aps.configure.noInstallationUrlAvailable' => '无（外部应用程序）',
    'aps.configure.updateSettingsSection' => '更新设置',
    'aps.configure.forceUpdates' => '当更新可用时自动更新此应用程序',
    'aps.configure.forceUpdatesHint' => '该应用程序将会接收自动更新以更新至新版本。 警告： 请谨慎使用此选项因为更新会在很大程度上影响应用程序的功能。 例如，应用程序扩展可能会在应用程序更新为其它版本后停止工作。',

    'aps.install.showAllSettings' => '显示所有设置',
    'aps.install.showLessSettings' => '显示最小设置',
    'aps.install.install' => '安装',
    'aps.install.otherSettings' => '其他设置',
    'aps.install.globalSettings' => '包设置',
    'aps.install.passwordConfirmation' => '确认密码',
    'aps.install.provisionsSectionLabel' => '安装路径',
    'aps.install.context' => '指定此 web 应用程序应该安装的位置',
    'aps.install.registerAsWebmailSection' => 'Web 邮箱注册',
    'aps.install.registerAsWebmailDescription' => "如果此应用程序是一个 web 邮箱客户端可选择此选项。然后该应用程序将出现在订阅与服务方案的邮件设置里的可用 web 邮箱服务中。该管理员可配置 web 邮箱的公共访问 URL，依次是服务器管理 > 设置 > Web 邮箱。",
    'aps.install.registerAsWebmailLabel' => '注册一个 web 邮箱服务',
    'aps.install.addItem' => '添加',
    'aps.install.removeItem' => '移除',
    'aps.install.updateSettingsSection' => '更新设置',
    'aps.install.forceUpdates' => '当更新可用时自动更新此应用程序',
    'aps.install.forceUpdatesHint' => '该应用程序将会接收自动更新以更新至新版本。 警告： 请谨慎使用此选项因为更新会在很大程度上影响应用程序的功能。 例如，应用程序扩展可能会在应用程序更新为其它版本后停止工作。',

    'aps.invalid-requirements.requirementsLegend' => '要求',
    'aps.invalid-requirements.domainLegend' => '网站',
    'aps.invalid-requirements.context' => '选择另一网站',
    'aps.invalid-requirements.backToApplicationList' => '返回应用程序列表',

    'aps.license.title' => '安装%%packageName%%',
    'aps.license.doYouAcceptLicense' => '若要安装此应用程序，您需要阅读最终用户许可协议并同意此协议。',
    'aps.license.licenseAgree' => '我接受许可协议',

    'aps.services-list-customization.settings' => '设置',

    'asp-dot-net.change-version.title' => '选择 ASP.NET 版本',
    'asp-dot-net.change-version.frameworkVersion' => 'ASP.NET Framework 版本',
    'asp-dot-net.change-version.success' => 'ASP.NET版本已更改。',

    'asp-dot-net.settings.casSettingsSection' => "代码访问安全性",
    'asp-dot-net.settings.clientScriptsSection' => "脚本库设置",
    'asp-dot-net.settings.connStringsSection' => "连接字符串管理器",
    'asp-dot-net.settings.customErrorsSection' => "自定义错误设置",
    'asp-dot-net.settings.frameworkVersionSection' => "Framework 版本",
    'asp-dot-net.settings.globalizationSection' => "全局化设置",
    'asp-dot-net.settings.otherSection' => "会话设置",
    'asp-dot-net.settings.pageAndRuntimeSection' => "编译和调试",
    'asp-dot-net.settings.authMode' => "验证模式",
    'asp-dot-net.settings.connStrings' => "连接字符串",
    'asp-dot-net.settings.connStringsInvalid' => "一些字段为空或者含有不正确的值。",
    'asp-dot-net.settings.connStringName' => "名称",
    'asp-dot-net.settings.connStringValue' => "连接参数",
    'asp-dot-net.settings.connStringsDescription' => "名称/连接参数",
    'asp-dot-net.settings.culture' => "区域性",
    'asp-dot-net.settings.customErrMode' => "自定义错误模式",
    'asp-dot-net.settings.customErrorRedirect' => "重定向 URL",
    'asp-dot-net.settings.customErrorStatus' => "状态代码",
    'asp-dot-net.settings.customErrorStatusInvalid' => "状态代码必须为整数。",
    'asp-dot-net.settings.customErrors' => "自定义错误",
    'asp-dot-net.settings.customErrorsDescription' => "状态代码/转发 URL",
    'asp-dot-net.settings.customErrorsInvalid' => "一些字段为空或者含有不正确的值。",
    'asp-dot-net.settings.debugMode' => "启用调试",
    'asp-dot-net.settings.defLanguage' => "网页默认语言",
    'asp-dot-net.settings.tempDirectory' => "临时目录",
    'asp-dot-net.settings.fileEnc' => "文件编码",
    'asp-dot-net.settings.fileEncInvalid' => "文件编码参数的指定值无效。",
    'asp-dot-net.settings.pathToLib' => "Microsoft 脚本库的路径",
    'asp-dot-net.settings.pathToLibInstall' => "安装",
    'asp-dot-net.settings.reqEnc' => "请求编码",
    'asp-dot-net.settings.reqEncInvalid' => "请求编码参数的指定值无效。",
    'asp-dot-net.settings.resEnc' => "响应编码",
    'asp-dot-net.settings.resEncInvalid' => "响应编码参数的指定值无效。",
    'asp-dot-net.settings.sessTimeout' => "会话超时(分钟)",
    'asp-dot-net.settings.sessTimeoutInvalid' => "会话超时参数的指定值无效。请输入一个不大于 %%max%% 的正整数。",
    'asp-dot-net.settings.connStringDuplicate' => "连接字符串名称已在使用中。",
    'asp-dot-net.settings.customErrorInvalidCode' => "状态代码必须在 100 与 999 之间",
    'asp-dot-net.settings.customErrorDuplicate' => "状态代码已在使用中。",
    'asp-dot-net.settings.trustLevel' => "代码访问安全性 (CAS) 信任级别",
    'asp-dot-net.settings.uiCulture' => "UI 区域性",
    'asp-dot-net.settings.version' => "版本",
    'asp-dot-net.settings.trustLevelAllowOverride' => '允许覆盖网站上的代码访问安全性 (CAS) 信任级别',
    'asp-dot-net.settings.updateSuccess' => '更新成功',

    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.cloneInProgress' => '克隆数据库 %%source%% 到数据库 %%destination%%.将会通过邮件通知您其进程(%%email%%)。',
    'database.clone.unableToClone' => '无法复制数据库 "%%source%%"。',
    'database.clone.unableToCreateExternalDatabase' => '无法在指定的服务器上创建数据库 "%%destination%%"。',
    'database.clone.databaseCloned' => '数据库 "%%source%%" 已复制。',
    'database.clone.emailSubjSuccess' => '数据库 "%%sourceDatabase%%" 被复制过。',
    'database.clone.emailSubjFailure' => '复制数据库 "%%sourceDatabase%%" 失败。',
    'database.clone.emailBodySuccess' => '数据库  "%%sourceDatabase%%" (%%sourceHost%%) was copied to the database "%%destDatabase%%" (%%destHost%%)。',
    'database.clone.emailBodyFailure' => '无法复制数据库"%%sourceDatabase%%" (%%sourceHost%%)  到数据库 "%%destDatabase%%" (%%destHost%%)。复制失败。',
    'database.clone.localServer' => '本地服务器',

    'database.repair-orphaned.formDescription' => '恢复流程后该用户被孤立。请提供用于该用户的密码以解决该问题。如果该用户是无需密码的系统用户，则留空密码字段运行修复工具。',
    'database.repair-orphaned.login' => '数据库用户名',
    'database.repair-orphaned.pass' => '密码',
    'database.repair-orphaned.pass2' => '确认密码',
    'database.repair-orphaned.users' => '一些用户需要您的关注。有多个被孤立用户需要进行修复才能正常运行。',
    'database.repair-orphaned.orphaned' => '用户被孤立。%%gui begin:link%%现在修复%%gui end:link%%.',
    'database.repair-orphaned.repair' => '修理',

    'database.repair.fixSelected' => '修复所选的',
    'database.repair.fix' => '修理',

    'database.user.username' => '数据库用户名',
    'database.user.password' => '密码',
    'database.user.passwordConfirmation' => '确认密码',
    'database.user.server' => '数据库服务器',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => '数据库',
    'database.user.anyDatabase' => '任何',
    'database.user.dataAccess' => '数据访问',
    'database.user.structureAccess' => '结构访问',
    'database.user.globalAccess' => '全局权限',
    'database.user.globalAccessHint' => '全局权限适用于该主机帐户内所有的数据库。',
    'database.user.aclRadio' => '访问控制',
    'database.user.aclLocalhost' => '仅允许本地连接',
    'database.user.aclAny' => '允许来自任何主机的远程连接',
    'database.user.aclCustom' => '允许远程连接来自',
    'database.user.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\n允许指定的主机代表该用户访问数据库。",
    'database.user.remoteAccess' => '远程访问',
    'database.user.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\n允许指定的主机通过防火墙规则访问数据库。在该列表中的修改将被您的主机提供商预先修改。",
    'database.user.example' => "例如：\n%%example%%",
    'database.user.denied' => '使用系统防火墙规则',
    'database.user.allowed' => '允许远程连接来自',
    'database.user.default' => '默认使用该用户的验证凭据访问 %%webadmin%%',
    'database.user.remoteAccessHint' => '请联系您的主机提供商确认您上述指定的选项符合传入连接 MariaDB/MySQL 的当前防火墙规则。',
    'database.user.phpMyAdmin' => 'phpMyAdmin',
    'database.user.webAdmin' => 'web Admin',
    'database.user.role' => '角色',
    'database.user.roleReadWrite' => '读取和写入',
    'database.user.roleWriteOnly' => '只写入',
    'database.user.roleReadOnly' => '只读取',
    'database.user.roleCustom' => '自定义',

    'database.versionCut' => 'v%%version%%',

    'deployment-section.deploymentDisabledHint' => '从 Git repository 上传文件',
    'deployment-section.deploymentEnabledHint' => '启用 Git 支持',
    'deployment-section.deploymentSectionLegend' => '要复制到主机的文件',
    'deployment-section.deploymentSectionDescriptionHint' => '如果保持禁用 Git 支持，将会创建一个空的根目录（网站/应用程序根目录和文档根目录），而站点将会在浏览器里显示默认的页面。您需要使用 FTP 或文件管理器上传站点文件到文档根目录。另外，还可以现在或之后启用 Git （在 网站与域名 中启用）从 Git repository 上传文件。',

    'dns-zone.add-acl-record.description' => '添加允许接收 DNS 区域副本的 DNS 服务器 IP 地址。',
    'dns-zone.add-acl-record.ipAddress' => 'IP 地址',
    'dns-zone.add-acl-record.ipAddressWithMask' => 'IP 地址/掩码',

    'dns-zone.record.add-title' => "添加资源记录到区域模板",
    'dns-zone.record.add-ns-title' => "添加域名服务器",
    'dns-zone.record.edit-title' => "编辑DNS记录",
    'dns-zone.record.edit-success' => "DNS 记录已更新。",
    'dns-zone.record.add-success' => "DNS 记录已创建。",
    'dns-zone.record.type' => "记录类型",
    'dns-zone.record.domainName' => "域名",
    'dns-zone.record.domainNamePostfix' => ".<domain>",
    'dns-zone.record.nameServer' => "域名服务器",
    'dns-zone.record.optionOff' => '关闭',
    'dns-zone.record.optionOn' => '开启',
    'dns-zone.record.protocol' => "协议",
    'dns-zone.record.priority' => "优先级",
    'dns-zone.record.priorityLow' => "低 (%%priority%%)",
    'dns-zone.record.priorityHigh' => "非常高 (%%priority%%)",
    'dns-zone.record.weightLow' => "低 (%%weight%%)",
    'dns-zone.record.weightHigh' => "非常高 (%%weight%%)",
    'dns-zone.record.ipAddress' => "IP 地址",
    'dns-zone.record.ipAddressDescription' => "例如，123.123.123.123",
    'dns-zone.record.ipAddressDescriptionExt' => "例如：<ip>, 123.123.123.123",
    'dns-zone.record.ipAddressV6' => "IPv6 地址",
    'dns-zone.record.ipAddressV6Description' => "例如，2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressV6DescriptionExt' => "例如：<ipv6>, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "例如，2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.ipAddressWithMaskDescriptionExt' => "例如：<ipv6>, <ip>, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "例如，2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.record.canonicalName' => "规范名称",
    'dns-zone.record.mailDomain' => "邮件域名",
    'dns-zone.record.mxServer' => "邮件交换服务器",
    'dns-zone.record.mxServerPriority' => "指定邮件交换服务器优先级。",
    'dns-zone.record.txtRecord' => "TXT 记录",
    'dns-zone.record.txtRecordString' => "输入记录字符串",
    'dns-zone.record.txtSpfSyntax' => "SPF 记录",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "指定的 TXT 记录值不正确。",
    'dns-zone.record.quotedTxtRecord' => "TXT 记录值必须是不带引号的单个字符串。",
    'dns-zone.record.dsRecord' => "DS 记录",
    'dns-zone.record.dsRecordDescription' => "示例：60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDSRecord' => "指定的 DS 记录值不正确。",
    'dns-zone.record.serviceName' => "服务名称",
    'dns-zone.record.serviceNameDescription' => '例如，SIP（不带下划线字符）。',
    'dns-zone.record.protocolNameDescription' => '例如，tcp（不带下划线字符）。',
    'dns-zone.record.portDescription' => '例如，25（不带下划线字符）。',
    'dns-zone.record.srvWeight' => "拥有相同优先级的记录的相对权重",
    'dns-zone.record.targetHost' => "目标主机",
    'dns-zone.record.targetHostDescription' => "例如，example.com",
    'dns-zone.record.targetPort' => "目标端口",
    'dns-zone.record.targetPortDescription' => '例如，8443.',
    'dns-zone.record.retrieveDataError' => "未找到记录数据。",
    'dns-zone.record.unknownTypeError' => "未知的 DNS 记录类型",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => '当存在其它 MX 记录时无法设置 NULL MX 记录。',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => '当存在 NULL MX 记录时，无法设置非 NULL MX 记录。',
    'dns-zone.record.masterShouldBeRemote' => "您必须在不同的主机上有两个不同的授权域名服务器。",
    'dns-zone.record.caaTag' => "标签",
    'dns-zone.record.caaRecord' => "值",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.tlsaPort' => '端口',
    'dns-zone.record.tlsaProtocol' => '协议',
    'dns-zone.record.tlsaUsage' => '使用',
    'dns-zone.record.tlsaSelector' => '选择器',
    'dns-zone.record.tlsaMatching' => '匹配类型',
    'dns-zone.record.tlsaCertData' => '证书关联数据',
    'dns-zone.record.tlsaSeeLinkForDetails' => '详见 %%link%%',
    'dns-zone.record.tlsaRfc6698Section211' => 'RFC6698，2.1.1 部分',
    'dns-zone.record.tlsaRfc6698Section212' => 'RFC6698，2.1.2 部分',
    'dns-zone.record.tlsaRfc6698Section213' => 'RFC6698，2.1.3 部分',
    'dns-zone.record.tlsaRfc6698Section214' => 'RFC6698，2.1.4 部分',

    'dns-zone.record.httpsPriorityAlias' => "别名（%%priority%%）",
    'dns-zone.record.httpsTargetHostDescription' => '例如，example.com。空值表示主机与域名相同。',
    'dns-zone.record.httpsProtocols' => '协议',
    'dns-zone.record.httpsProtocolsDescription' => '以逗号分隔的目标支持协议列表。例如，h3,h3-29,h2,http/1.1。',
    'dns-zone.record.httpsForceProtocols' => '仅强制使用指定的协议。以上协议列表不得为空。',
    'dns-zone.record.httpsIpv4hint' => 'IPv4 地址提示',
    'dns-zone.record.httpsIpv4hintDescription' => '以逗号分隔的 IPv4 地址列表，客户可使用这些地址访问服务。',
    'dns-zone.record.httpsIpv6hint' => 'IPv6 地址提示',
    'dns-zone.record.httpsIpv6hintDescription' => '以逗号分隔的 IPv6 地址列表，客户可使用这些地址访问服务。',

    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.ttl-seconds' => "秒",
    'dns-zone.record.invalidValue' => '值无效。可介于 1 秒到 2147483647 秒之间。',
    'dns-zone.record.ttlDefaultValue' => '默认值：%%value%% 秒',
    'dns-zone.record.invalidTTL' => '指定的 TTL 值无效。',
    'dns-zone.record.invalidIpAddress' => '指定的 IP 地址无效。',
    'dns-zone.record.invalidIpMaskPair' => '指定的 IP 地址/掩码对无效。',
    'dns-zone.record.invalidCName' => '指定的规范名称无效。',
    'dns-zone.record.invalidPort' => '指定的端口无效。',
    'dns-zone.record.invalidTLSACertData' => '指定的证书关联数据无效。',
    'dns-zone.record.invalidTLSAProtocol' => '指定的协议无效。',
    'dns-zone.record.invalidTLSAUsage' => '指定的用途无效。',
    'dns-zone.record.invalidTLSASelector' => '指定的选择器无效。',
    'dns-zone.record.invalidTLSAMatching' => '指定的匹配类型无效。',

    'dns-zone.restore-default.formHint' => "您可在此根据服务器上使用的默认 DNS 模板设置恢复原始的区域配置。请选择用于恢复区域的 IP 地址以及指定域名是否需要 www 别名。",
    'dns-zone.restore-default.ipv4' => "IPv4 地址",
    'dns-zone.restore-default.ipv4Hint' => "例如，123.123.123.123",
    'dns-zone.restore-default.ipv6' => "IPv6 地址",
    'dns-zone.restore-default.ipv6Hint' => "例如，2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => '指定的 IP 地址无效。',
    'dns-zone.restore-default.customIpHint' => "带有此 IP 地址的记录将被视为用户修改的记录，将不会与服务器级的 DNS 模板同步。",
    'dns-zone.restore-default.wwwPrefix' => "WWW 前缀",
    'dns-zone.restore-default.previewRecords' => "恢复用于网站预览的记录",

    'dns-zone.soa-record.soaMnameSection' => '主域名服务器',
    'dns-zone.soa-record.soaMname' => '域名服务器',
    'dns-zone.soa-record.soaMnameAutoselect' => '（自动选择）',
    'dns-zone.soa-record.soaRecordSection' => 'SOA 记录',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => '刷新',
    'dns-zone.soa-record.retry' => '重试',
    'dns-zone.soa-record.expire' => '过期',
    'dns-zone.soa-record.minimum' => '最小',
    'dns-zone.soa-record.rnameType' => '電子郵件（RNAME）',
    'dns-zone.soa-record.rnameTypeHint' => '对域名DNS区域负责的人的电子邮件地址。由DNS服务器在响应SOA查询时返回。',
    'dns-zone.soa-record.rnameTypeOwner' => '网站所有者的邮箱地址',
    'dns-zone.soa-record.rnameTypeDomain' => '域名電子電郵地址',
    'dns-zone.soa-record.rnameTypeDomainHint' => '只输入本地部分（ @<domain>之前）',
    'dns-zone.soa-record.rnameTypeExternal' => '外部邮箱地址',
    'dns-zone.soa-record.rnameEnforceEmail' => '禁止单独为每个域名更改 RNAME 电子邮箱地址',
    'dns-zone.soa-record.invalidValue' => '无效值。介于 1 秒到 68 年之间。',
    'dns-zone.soa-record.advancedSection' => '高级 DNS 功能',
    'dns-zone.soa-record.serialNumberFormat' => '选择使用 IETF 与 RIPE 推荐的序列号格式。',
    'dns-zone.soa-record.serialNumberFormatHint' => '如果您的域名通过注册商的SOA检查有问题，请选择该选项。许多域名注册商都需要这种序列号格式。',
    'dns-zone.soa-record.restoreDefaultButton' => '使用默认设置',
    'dns-zone.soa-record.zoneDefaultsSection' => '区域默认设置',
    'dns-zone.soa-record.unitSeconds' => '秒',
    'dns-zone.soa-record.unitMinutes' => '分钟',
    'dns-zone.soa-record.unitHours' => '小时',
    'dns-zone.soa-record.unitDays' => '天',
    'dns-zone.soa-record.unitWeeks' => '星期',
    'dns-zone.soa-record.refreshValueIsSmallWarning' => '刷新间隔值小于一小时，这会大大增加服务器流量和资源使用率。',
    'dns-zone.soa-record.minimumValueIsBigWarning' => '设置大于3小时的最小TTL值会使某些域名管理员无法访问您的域名。建议仅当您的域名注册商要求这样设置时，才设置这样的值。',
    'dns-zone.soa-record.success' => 'SOA 记录属性已更新。',
    'dns-zone.soa-record.restoreDefaultSuccess' => '默认的 SOA 记录已恢复。',

    'domain-info-section.domainName' => '域名',
    'domain-info-section.emptyDomainName' => '请提供域名。',
    'domain-info-section.ipAddress' => 'IP地址',
    'domain-info-section.shared' => '共享',
    'domain-info-section.exclusive' => '独立',
    'domain-info-section.ipAddressHint' => "托管网站的IP地址是网站虚拟机的网络地址。在此订阅中创建的所有网站将使用此IP地址。",
    'domain-info-section.ipAddressHint_powerUser' => "托管此网站的IP地址是网站虚拟机的网络地址。在此主机空间内创建的所有网站将使用此IP地址。",
    'domain-info-section.userName' => '用户名',
    'domain-info-section.userNameHint' => '与主机空间相关联的、用于通过 FTP 和 SSH 协议访问托管文件的系统用户帐户。',
    'domain-info-section.emptyLogin' => '请提供用户名。',
    'domain-info-section.password' => '密码',
    'domain-info-section.emptyPassword' => '请提供密码。',
    'domain-info-section.passwordConfirmation' => '重复密码',

    'email-address.generalTab' => '通用',
    'email-address.generalHint' => '如果此邮件账户与其他用户相关联（访问客户面板 功能已启用）, 在此页面上的修改会影响该用户的设置。而且，如果您更改了邮件地址和密码，其他用户的登录名和密码也将会更改为新的值。',
    'email-address.redirectTab' => '转发',
    'email-address.redirectHint' => '设置将电子邮件消息转发到一个或多个电子邮件地址。',
    'email-address.aliasesTab' => '邮件别名',
    'email-address.autoResponderTab' => '自动回复',
    'email-address.antispamTab' => '垃圾邮件过滤器',
    'email-address.autoResponderHint' => '设置在任何邮件进入您的邮箱时自动响应。自动回复是您不在办公室或在休假时设置的标准响应方式。',
    'email-address.antivirusTab' => '防病毒程序',
    'email-address.name' => '电子邮件地址',
    'email-address.externalEmail' => '外部邮箱地址',
    'email-address.externalEmailHint' => '如果您无法访问主要的电子邮箱地址，将用于重置您的密码。',
    'email-address.user' => '分配到',
    'email-address.password' => '密码',
    'email-address.passwordConfirmation' => '确认密码',
    'email-address.clientConfigurationLink' => '邮件配置器链接',
    'email-address.responderEnable' => '启用自动回复',
    'email-address.responderSubject' => '自动回复邮件主题',
    'email-address.responderContentType' => '邮件格式',
    'email-address.responderContentTypeHint' => '所有邮件客户端程序都支持纯文本格式，因此，所有收件人看到的邮件与您看到的相同。HTML邮件看起来较好，因您可以选择不同的字体及样式。但部分邮件客户端不支持HTML邮件，因此部分收件人可能看不到该格式文本。',
    'email-address.responderContentTypeTextPlain' => '纯文本',
    'email-address.responderContentTypeTextHtml' => 'HTML',
    'email-address.responderCodepage' => '文本编码',
    'email-address.responderCodepageHint' => '文本编码定义文字的显示方式。建议编码是UTF-8。',
    'email-address.responderReplyTo' => '转发到',
    'email-address.responderReplyToHint' => '当发送了自动响应时，原始信息将会被转发到指定的电子邮件地址。',
    'email-address.responderForwardAddress' => '转发到',
    'email-address.responderForwardAddressHint' => '当发送了自动响应时，原始信息将会被转发到指定的电子邮件地址。',
    'email-address.responderMessage' => '自动回复邮件文本',
    'email-address.responderReplyToEqualsEmail' => '指定的转发地址与该电子邮件地址一致。',
    'email-address.responderForwardAddressEqualsEmail' => '指定的转发地址与该电子邮件地址一致。',
    'email-address.responderReplyLimit' => '自动发送响应至唯一的电子邮件地址不超过（一日内）',
    'email-address.buttonAddResponderAttachment' => '添加附件',
    'email-address.buttonRemoveResponderAttachment' => '移除',
    'email-address.responderAttachment' => '附加文件',
    'email-address.redirectEnable' => '启用邮件转发',
    'email-address.redirectRemoveEnable' => '不要将转发的电子邮件的副本发送到 Plesk 邮箱',
    'email-address.redirectAddress' => '转发传入信息到以下电子邮件地址',
    'email-address.redirectAddressHint' => '指定电子邮件地址。您可每一行输入一个电子邮件地址，或者使用空格、逗号或分号隔开地址。',
    'email-address.role' => '用户角色。',
    'email-address.roleHint' => '用户角色会授权用户以管理优先权和到您为该角色所选定应用程序的访问权限。',
    'email-address.errorRedirectAddress' => '您指定了无效的电子邮箱地址：%value%。',
    'email-address.errorRedirectAddressMultiple' => '您指定了无效的电子邮箱地址：%value%。',
    'email-address.mailAlias' => "邮件别名",
    'email-address.mailAliasNone' => '无',
    'email-address.mailAliasHint' => "邮件别名是与主要的电子邮件地址相关联的其它电子邮件地址。主要电子邮件地址会接收到所有发送到邮件别名的邮件。",
    'email-address.buttonAddMailAlias' => '添加邮件别名',
    'email-address.buttonRemoveMailAlias' => '移除',
    'email-address.emptyEmail' => '指定转发所有传入信息所到的电子邮件地址。',
    'email-address.emailsIsEqual' => '外部的电子邮件地址与主要的电子邮件地址匹配。请另外指定一个外部的电子邮件地址。',
    'email-address.emptyPassword' => '您需要提供密码。',
    'email-address.emptyPasswordConfirmation' => '您需要确认密码。',
    'email-address.emptyAlias' => "为此电子邮件地址指定邮件别名。",
    'email-address.aliasEqualsEmail' => '指定的邮件别名与电子邮件地址一致。',
    'email-address.passwordHint' => '将用于访问邮箱以及登录 Plesk（如果启用了相应选项）。',
    'email-address.cyclicRedirect' => '无法设置电子邮件地址向其自己转发邮件',
    'email-address.errorMailnameReserved' => '指定的电子邮件地址已在使用中。',
    'email-address.antivirusEnable' => '为此电子邮件地址打开病毒防护功能',
    'email-address.antivirusHint' => '反病毒服务会拦截包含病毒的邮件并通知发件人和收件人此信息。',
    'email-address.antivirusSettings' => '查看是否有病毒',
    'email-address.antivirusSettingOnlyIncomingMail' => '仅限传入邮件',
    'email-address.antivirusSettingOnlyOutgoingMail' => '仅限传出邮件',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => '传入和传出邮件',
    'email-address.antispamHint' => '垃圾邮件过滤服务会检测出发送至电子邮件地址的垃圾邮件。您可以设置垃圾邮件过滤器删除垃圾邮件，通过更改其标题来标志其为垃圾邮件，或移动它们到邮件客户端通过 IMAP 可访问的特殊垃圾邮件文件夹中。垃圾邮件过滤器会通过广泛的本地和网络测试来识别垃圾邮件签名。',
    'email-address.antispamEnable' => '为此电子邮件地址打开垃圾邮件过滤功能',
    'email-address.antispamSettings' => '防垃圾邮件设置',
    'email-address.antispamSettingsMark' => '添加以下文本到信息主题来标记垃圾信息',
    'email-address.antispamSettingsMarkHint' => '如果您不想添加任何文本，保持该字段为空。如果您想要把评分包括在信息主题中请输入评分。',
    'email-address.antispamReportTextHint' => '输入您想要添加到垃圾邮件信息正文的文本。',
    'email-address.antispamSettingsDelete' => '删除所有垃圾邮件',
    'email-address.antispamSettingsDeleteHint' => '则从您的邮箱删除垃圾邮件。',
    'email-address.antispamSettingsMove' => '移动垃圾邮件到垃圾邮件文件夹',
    'email-address.antispamSettingsMoveHint' => '移动所有垃圾邮件到垃圾邮件文件夹。您可从邮件客户端程序或 web 邮箱访问此文件夹。若您正使用IMAP邮件帐户，则可使用垃圾邮件文件夹来调整垃圾邮件过滤器。',
    'email-address.antispamSettingsMoveWarning' => '无法实现“将垃圾邮件移动到垃圾邮件文件夹”，除非您禁用“转发”标签上的“不发送转发的电子邮件的副本”选项。',
    'email-address.antispamSettingsMoveJunk' => '将垃圾邮件移动到 "垃圾邮件" 文件夹。',
    'email-address.antispamSettingsMoveJunkHint' => '将所有的垃圾信息移动到 "垃圾邮件" 文件夹。可以从您的邮件客户端程序或 web 邮箱访问该文件夹。如果您使用的是 IMAP 邮件帐户，则可以使用 "垃圾邮件" 文件夹调控垃圾邮件过滤器。',
    'email-address.antispamShowAdvancedSection' => '显示高级设置',
    'email-address.antispamHideAdvancedSection' => '隐藏高级设置',
    'email-address.antispamLearnMore' => '了解如何“训练”垃圾邮件过滤器。',
    'email-address.antispamFilterScoreTitle' => '过滤器敏感度',
    'email-address.antispamFilterScoreHint' => '垃圾邮件过滤器会对每封邮件的内容和主题行执行多种不同测试。结果，每封邮件都会记录一些分数。分数越高，这封邮件为垃圾邮件的可能性越大。默认情况下，过滤器敏感度设置认为当邮件分数大于等于 7 时即被标识为垃圾邮件。如果在当前设置下您会收到大量垃圾邮件，可设置更小的值来把过滤器调整得更为敏感，例如 6。如果因为垃圾邮件过滤器而丢失了一些邮件，可设置更高的值来降低其敏感度，例如 8。',
    'email-address.antispamFilterScore' => '垃圾邮件过滤器敏感度',
    'email-address.antispamWhiteListTitle' => '白名单',
    'email-address.antispamWhiteListHint' => '垃圾邮件过滤器不会检查来自白名单列表中的发送者的电子邮件。',
    'email-address.antispamWhiteListField' => '白名单',
    'email-address.antispamWhiteListFieldHint' => '一行键入一个域名。地址应包含"*" 和"?" 通配符 (如*@domain.com、user?@*.com)',
    'email-address.antispamBlackListTitle' => '黑名单',
    'email-address.antispamBlackListHint' => '来自黑名单列表中的发送者的电子邮件会被归类为垃圾邮件。',
    'email-address.antispamBlackListField' => '黑名单',
    'email-address.antispamBlackListFieldHint' => '一行键入一个域名。地址应包含"*" 和 "?" 通配符 (如 *@domain.com, user?@*.com)',
    'email-address.antispamTrustedLanguagesTitle' => '可信的语言',
    'email-address.antispamTrustedLanguagesHint' => '以这些语言书写的邮件总会通过过滤器。',
    'email-address.antispamTrustedLocalesTitle' => '可信的区域设置',
    'email-address.antispamTrustedLocalesHint' => '使用指定区域设置群组的邮件将总会通过过滤器。区域设置群组包括最常用的字符集。例如，西方字符集包括用于英文和西欧语言中字母的编码。',
    'email-address.antispamTrustedNetworksTitle' => '可信的网络',
    'email-address.antispamTrustedNetworksHint' => '在可信的网络上运行的中继主机被视为不可能由垃圾邮件发件人操控，且此类中继主机不是开放中继或开放代理。',
    'email-address.antispamIpAddressesField' => 'IP地址',
    'email-address.antispamIpAddressesFieldHint' => '指定网络IP地址及掩码。',
    'email-address.mailBoxQuotaDomainDefault' => '默认大小 (%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => '默认大小',
    'email-address.mailBoxOutgoingMessages' => '传出邮件信息的最大数量',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => '默认（每小时 %%domainOutgoingMessages%% 条信息）',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => '该邮箱的自定义值',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => '信息',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => '默认',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => '默认大小',
    'email-address.mailBoxQuotaDomainSpecific' => '其它大小',
    'email-address.mailBoxQuotaDomainSpecificValue' => '另一大小值',
    'email-address.mailBoxQuotaDomainSpecificMultiplier' => '大小单位',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => '邮箱大小',
    'email-address.mailBoxQuotaUnlimited' => '无限',
    'email-address.mailBoxLimitReached' => '已达到邮箱数量上限。',
    'email-address.postboxEnabled' => '邮箱',
    'email-address.postboxEnabledYes' => '打开',
    'email-address.postboxEnabledNo' => '关闭',
    'email-address.description' => 'Plesk 中的描述',
    'email-address.descriptionHint' => '任何可访问该邮件帐户的用户都可看到该描述。',
    'email-address.longDescription' => '指定的描述太长。不得超过 %%max%% 个字符。',
    'email-address.loginAsUser' => '可用于登录 Plesk',
    'email-address.loginAsUserDescription' => '（用户名：%%username%%）',
    'email-address.maxCustomSizeDesc' => '邮箱大小不能超过默认大小。',
    'email-address.endDateEnable' => '关闭自动回复时间',

    'failed-request.enable-tracing.description' => '失败请求跟踪是一项资源密集型操作。跟踪将会在 %%days%% 日内自动停止。您可以在任何时候手动停止。',
    'failed-request.enable-tracing.statusCodes' => '状态代码',
    'failed-request.enable-tracing.statusCodesDescription' => '示例：401.3-999, 405',
    'failed-request.enable-tracing.provider' => '提供商',

    'file-manager.permissions.filePermissions' => '文件权限',
    'file-manager.permissions.directoryPermissions' => '目录权限',
    'file-manager.permissions.buttonSubmit' => '保存',
    'file-manager.permissions.buttonApply' => '保存并恢复',
    'file-manager.permissions.buttonCancel' => '取消',
    'file-manager.permissions.buttonAdvanced' => '高级',

    'file-manager.unix-file-permissions.group' => '群组',
    'file-manager.unix-file-permissions.owner' => '所有者',
    'file-manager.unix-file-permissions.others' => '其他',
    'file-manager.unix-file-permissions.readMode' => '读取',
    'file-manager.unix-file-permissions.writeMode' => '写入',
    'file-manager.unix-file-permissions.execMode' => '执行/搜索',
    'file-manager.unix-file-permissions.changeRecursive' => '递归地更改权限',

    'file-manager.windows-permissions.allow' => '允许',
    'file-manager.windows-permissions.deny' => '拒绝',
    'file-manager.windows-permissions.inheritFromParent' => '允许来自父级的可继承权限传播到此对象和所有子对象。包括此处明确定义的项目。',
    'file-manager.windows-permissions.replaceOnChildren' => '将所有子对象的权限项替换为此处显示的权限项。',
    'file-manager.windows-permissions.buttonAdvanced' => '高级',
    'file-manager.windows-permissions.applyTo' => '应用到:',
    'file-manager.windows-permissions.folderOnly' => '仅此文件夹',
    'file-manager.windows-permissions.subfolderOnly' => '仅子文件夹',
    'file-manager.windows-permissions.filesOnly' => '仅文件',
    'file-manager.windows-permissions.permissionsFor' => '权限主体',
    'file-manager.windows-permissions.applyOnto1' => '仅此文件夹',
    'file-manager.windows-permissions.applyOnto2' => '仅子文件夹',
    'file-manager.windows-permissions.applyOnto3' => '此文件夹和子文件夹',
    'file-manager.windows-permissions.applyOnto4' => '仅文件',
    'file-manager.windows-permissions.applyOnto5' => '此文件夹和文件',
    'file-manager.windows-permissions.applyOnto6' => '仅子文件夹和文件',
    'file-manager.windows-permissions.applyOnto7' => '此文件夹、子文件夹和文件',
    'file-manager.windows-permissions.notInherited' => '<not inherited>',

    'file-manager.editor.titleTextEditor' => 'Text Editor',
    'file-manager.editor.titleCodeEditor' => 'Code Editor',
    'file-manager.editor.titleHtmlEditor' => 'HTML 编辑器',
    'file-manager.editor.titleCodeViewer' => '查看',
    'file-manager.editor.buttonSubmit' => '保存',
    'file-manager.editor.buttonApply' => '保存并恢复',
    'file-manager.editor.buttonSaveAs' => '另存为......',
    'file-manager.editor.buttonCancel' => '取消',
    'file-manager.editor.exitConfirmationYes' => '是',
    'file-manager.editor.exitConfirmationNo' => '否',
    'file-manager.editor.fileOverwrite' => '文件已存在。',
    'file-manager.editor.fileOverwriteDescription' => '相同名称的文件已存在。您要覆盖它吗？',
    'file-manager.editor.exitConfirmation' => '您确定要关闭文件并放弃未保存的更改吗？',
    'file-manager.editor.buttonCodeEditor' => '在代码编辑器中编辑',
    'file-manager.editor.buttonTextEditor' => '在文本编辑器中编辑',

    'file-manager.html-editor.toolbar.textStyle' => '文本样式',
    'file-manager.html-editor.toolbar.textStyleDesc' => '文本样式',
    'file-manager.html-editor.toolbar.insert' => '插入',
    'file-manager.html-editor.toolbar.insertDesc' => '添加图像、视频、链接或表格',
    'file-manager.html-editor.toolbar.paste' => '从剪贴板粘贴',

    'file-manager.import-file.buttonSubmit' => '导入',
    'file-manager.import-file.fieldUrl' => '文件的 URL',
    'file-manager.import-file.fieldUrlDescription' => '指定源 URL，例如：\'https://example.com/example.tgz\'。',
    'file-manager.import-file.fieldUrlFullDescription' => '完整的 URL 模式如下：\'https://user:password@example.com/example.tgz\'。用户名称和密码是备选的。支持的协议有 http、https、ftp、ftps。含有特殊字符或空格的 URL 部分使用 URL编码。',
    'file-manager.import-file.failure' => '无法导入文件。',

    'file-manager.rotation-settings.title' => '回收站循环设置',
    'file-manager.rotation-settings.rotationBySize' => '按大小循环',
    'file-manager.rotation-settings.rotationBySizeUnits' => 'MB',
    'file-manager.rotation-settings.rotationBySizeHint' => '只要超过了回收站的指定限制，该选项就会删除新文件。',
    'file-manager.rotation-settings.rotationByDate' => '按日期循环',
    'file-manager.rotation-settings.rotationByDateUnits' => '天',
    'file-manager.rotation-settings.rotationByDateHint' => '该选项将删除存储在回收站中超过指定天数的文件。',
    'file-manager.rotation-settings.save' => '保存',
    'file-manager.rotation-settings.cancel' => '取消',

    'ftp-user.description' => '如果您想与他人合作制作网站或为其他用户托管子域名，您可为他们创建其他的 FTP 帐号。',
    'ftp-user.generalSection' => '常用',
    'ftp-user.login' => 'FTP 帐户名称',
    'ftp-user.home' => '主目录',
    'ftp-user.systemArea' => '创建可访问主目录之外的文件的 FTP 帐户',
    'ftp-user.password' => '密码',
    'ftp-user.passwordConfirmation' => '确认密码',
    'ftp-user.hardQuotaSection' => '硬盘配额',
    'ftp-user.hardQuota' => '硬盘配额',
    'ftp-user.hardQuotaUnlimited' => '无限',
    'ftp-user.permissionsSection' => '权限',
    'ftp-user.permissionRead' => '读取权限',
    'ftp-user.permissionWrite' => '写入权限',
    'ftp-user.selectButtonLabel' => '选择目录',
    'ftp-user.popupTitle' => '选择目录',
    'ftp-user.limitMbUnits' => 'MB',

    'mail-list.listName' => '邮件列表地址',
    'mail-list.enabled' => '已启用',
    'mail-list.administratorEmail' => '邮件列表管理员的邮件',
    'mail-list.password' => '密码',
    'mail-list.passwordConfirmation' => '确认密码',
    'mail-list.subscribers' => '订户',
    'mail-list.subscribersHint' => '指定电子邮件地址。您可每一行输入一个电子邮件地址，或者使用空格、逗号或分号隔开地址。',
    'mail-list.notify' => '建立邮件列表后通知管理员',
    'mail-list.emptyPassword' => '提供一个密码。',
    'mail-list.emptyPasswordConfirmation' => '请确认密码。',
    'mail-list.errorSubscribers' => '无效的电子邮件地址。%value%.',
    'mail-list.errorMaillistReserved' => '指定的邮件列表地址已在使用。',

    'mail-settings.copyToClipboard' => '将 DNS 记录复制到剪贴板。',
    'mail-settings.copySuccess' => 'DNS 记录已复制到剪贴板。',
    'mail-settings.hint' => '在此处您可以为该域名修改邮件服务设置。',
    'mail-settings.service' => '此域名的邮件服务',
    'mail-settings.nonExist' => '如何处理不存在用户的邮件',
    'mail-settings.nonExistBounceWithMessage' => '退回信息',
    'mail-settings.nonExistBounceWithMessagePlaceholder' => '该地址不再接受邮件。',
    'mail-settings.nonExistBounce' => '退信',
    'mail-settings.nonExistCatch' => '转发至地址',
    'mail-settings.nonExistCatchAddressPlaceholder' => '输入转发地址',
    'mail-settings.nonExistCatchDescription' => '邮件地址应该属于选定的域名。只有管理员可以为多个域名指定外部地址或一个地址。',
    'mail-settings.nonExistExternal' => '重定向到该 IP 地址的外部邮件服务器：',
    'mail-settings.nonExistReject' => '拒绝',
    'mail-settings.nonExistDiscard' => '拒绝',
    'mail-settings.webmail' => 'Web 邮箱',
    'mail-settings.webmailNone' => '无',
    'mail-settings.webmailComponentNotInstalled' => '未安装 web 邮箱组件。',
    'mail-settings.webmailSubdomainAlreadyExists' => '这是一个名为 %%subdomain%% 的子域名。',
    'mail-settings.webmailCertificate' => 'web 邮箱的 SSL/TLS 证书',
    'mail-settings.webmailCertificateNone' => '未选定',
    'mail-settings.mailCertificate' => '用于邮箱的 SSL/TLS 证书',
    'mail-settings.mailCertificateNone' => '未选定',
    'mail-settings.serverCertificateNotSelected' => '证书已分配，但该域的邮件未受到保护。要完成保护该域的邮件，%%certLink%%。',
    'mail-settings.serverCertificatesList' => '保护此邮件服务器',
    'mail-settings.mailLists' => '启用邮件列表',
    'mail-settings.mailAutodiscovery' => '启用邮件 autodiscover',
    'mail-settings.mailAutodiscoveryDescription' => '查看其在 %%link%% 中是如何工作运行的',
    'mail-settings.mailAutodiscoveryDescriptionLink' => '知识库',
    'mail-settings.domainKeys' => '使用 DKIM 垃圾邮件防护系统签名发件信息',
    'mail-settings.activeDkimSelector' => '激活 DKIM 选择器',
    'mail-settings.defaultDkimSelector' => ' （Plesk 默认）',
    'mail-settings.dkimSelectorName' => '选择器名称',
    'mail-settings.buttonCreateSelector' => '创建新的 DKIM 选择器',
    'mail-settings.createSelectorDialogTitle' => '创建 DKIM 选择器',
    'mail-settings.removeSelectorDialogTitle' => '移除 DKIM 选择器',
    'mail-settings.removeSelectorConfirmation' => "是否移除选择器'%%selector%%'及其关联的密钥和 DNS 记录吗？",
    'mail-settings.buttonConfirm' => '确定',
    'mail-settings.buttonCreate' => '创建',
    'mail-settings.buttonCancel' => '取消',
    'mail-settings.labelRemoveSelector' => '移除',
    'mail-settings.labelActiveSelector' => '活动',
    'mail-settings.greyListing' => '对此域名上所有邮件帐户启用灰名单过滤垃圾邮件功能',
    'mail-settings.howToConfigureExternalDns' => '如何配置外部 DNS',
    'mail-settings.howToConfigureExternalDnsAlways' => '若您使用外部 DNS 服务器而想要启用 DKIM 签名，则需要您自己在 DNS 服务器上配置 DKIM DNS 记录。',
    'mail-settings.howToConfigureExternalDnsEnabled' => '具体操作是使用下面的 DKIM DNS 记录：',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => '若您有用于发送邮件的域名别名，请同时为其添加 DKIM DNS 记录。请将用于主域名的相同记录用于域名别名。',
    'mail-settings.howToConfigureExternalDnsDisabled' => '若要查看需要配置的 DKIM DNS 记录，请选择 "%%option%%" 复选框，请应用它并再次打开此弹出窗口。',
    'mail-settings.mailServiceDisabled' => '禁用',
    'mail-settings.mailServiceDisabledIncoming' => '已为接收邮件禁用',
    'mail-settings.mailServiceDisabledHint' => 'Plesk将不会在此域名上提供任何邮件服务。',
    'mail-settings.mailServiceDisabledIncomingHint' => '此域名只能发送邮件，且只能使用 Sendmail。',
    'mail-settings.mailServiceEnabled' => '启用',
    'mail-settings.mailServiceEnabledHint' => '此域名可以发送和接收邮件。',
    'mail-settings.mailServiceNotConfigured' => '未配置',
    'mail-settings.mailServiceNotConfiguredHint' => 'Plesk将不会在此域名上提供任何邮件服务。',
    'mail-settings.warning' => '这将永久移除域名的邮箱和所有已收到和发送的电子邮件。',
    'mail-settings.show.title' => '移除 %%domain%% 的所有邮箱和电子邮件',
    'mail-settings.show.checkbox' => '永久移除 %%domain%% 的所有邮箱，包括接收的和发送的电子邮件。',

    'role.roleSection' => '常规',
    'role.name' => '用户角色名称',
    'role.description' => '描述',
    'role.generalPermissionsSection' => '访问 Plesk 服务',
    'role.applicationsAccessSection' => '访问应用程序',
    'role.permissionAllow' => '允许',
    'role.permissionDeny' => '拒绝',
    'role.emptyRoleName' => '请提供角色名称。',
    'role.installedAt' => '安装位置',
    'role.noInstallationUrlAvailable' => '外部应用程序',
    'role.invalidRoleName' => '指定的用户角色名称无效。不可以在角色名称中使用问号和引号。',
    'role.longRoleName' => '指定用户角色名太长。',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => '因下列原因部分操作不可用: 操作权限未授予当前所选的订阅，或分配的资源量不足于执行操作。',
    'role.servicesPermissionsDescription' => '为有该角色的所有用户定义访问已安装的应用程序或 Plesk 服务的权限。如果您授予用户访问某个应用程序的权限，那么他们将可在客户面板中访问该应用程序。',
    'role.emailActivation' => '通过电子邮件激活该角色的账户',

    'service.admin-access.adminAccess' => '管理访问',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => '这些凭据将用于管理访问此应用程序。',
    'service.admin-access.login' => '管理员用户名',
    'service.admin-access.password' => '管理员密码',
    'service.admin-access.passwordConfirmation' => '确认密码',

    'service.info.service-entry-point.availableAt' => '可用',
    'service.info.service-entry-point.customize' => '自定义快捷方式',
    'service.info.service-entry-point.displayNameLabel' => '快捷方式名称',
    'service.info.service-entry-point.displayNameDescription' => '请提供此快捷方式名称。此名称显示在快捷方式图标下方。这些快捷方式显示在授权访问此应用程序的用户我的服务页面。',
    'service.info.service-entry-point.descriptionLabel' => '快捷方式描述',
    'service.info.service-entry-point.descriptionDescription' => '提供此快捷方式的描述。当鼠标指针悬停在快捷方式上方时，则会显示有关此快捷方式用途的简短说明。',
    'service.info.service-entry-point.iconLabel' => '点击选择快捷方式图标',
    'service.info.service-entry-point.iconCurrent' => '当前图标',
    'service.info.service-entry-point.errorEmptyName' => '请提供快捷方式名称',
    'service.info.service-entry-point.errorLongName' => '快捷方式名称应介于1到255个字符之间。',
    'service.info.service-entry-point.errorLongDescription' => '快捷方式描述应介于0到255个字符之间。',
    'service.info.service-entry-point.hiddenLabel' => '隐藏快捷方式',
    'service.info.service-entry-point.hiddenDescription' => '请对用户隐藏此快捷方式。',

    'service.info.service-permission.assignedUser' => "授权管理员访问此用户",
    'service.info.service-permission.assignedUserNone' => '未分配用户',

    'shared-ssl.master-ssl.switchedOn' => '启用共享 SSL/TLS',
    'shared-ssl.master-ssl.domainName' => '将与其它网站共享其 SSL/TLS 证书的网站的域名',
    'shared-ssl.master-ssl.none' => '无',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => '没有启用 共享 SSL/TLS 因为没有已启用 SSL/TLS 支持的域名。',

    'smarthost.configuration.checkConnection.success' => '与 smarthost 的连接已建立。',
    'smarthost.settings.title' => 'Smarthost 设置',
    'smarthost.settings.useSmarthost' => '通过 smarthost 发送邮件',
    'smarthost.success' => '%%domain%% 的 Smarthost 配置已更新。',

    'user.email.email' => '电子邮件地址',
    'user.email.emptyEmail' => '您需要提供一个邮箱地址。',
    'user.email.internalEmailHint' => '在 Plesk 中创建新的邮箱地址或使用外部的邮箱地址。',
    'user.email.longInternalEmail' => '电子邮件地址太长。',
    'user.email.longInternalEmailMailboxAddressMailServer' => '用于该邮件服务器的电子邮件地址的用户名部分太长。请指定一个用户名，且不得超过 %%max%% 个字符。',
    'user.email.longInternalEmailFullAddressMailServer' => '用于该邮件服务器的电子邮件地址太长。请指定一个地址，且不得超过 %%max%% 个字符。',
    'user.email.externalEmail' => '外部邮箱地址',
    'user.email.externalEmailHint' => '如果您无法访问主要的电子邮箱地址，将用于重置您的密码。',
    'user.email.emailsIsEqual' => '外部的邮箱地址与主要的邮箱地址匹配。指定其它的外部邮箱地址。',
    'user.email.atLeastOneEmailShouldBeSet' => '请指定内部或外部的电子邮件地址。',

    'user.profileSection' => '常规信息',
    'user.contactName' => '联系人姓名',
    'user.email' => '电子邮件地址',
    'user.role' => '用户角色',
    'user.accountSection' => 'Plesk 偏好设置',
    'user.login' => '用户名',
    'user.password' => '密码',
    'user.oldPassword' => '旧密码',
    'user.buttonBack' => '返回',
    'user.generalTab' => '常规',
    'user.applicationsAccessSection' => '服务',
    'user.generalPermissionsSection' => '权限',
    'user.contactsTab' => '联系详情',
    'user.passwordConfirmation' => '确认密码',
    'user.internalEmailPasswordChanged' => '更改密码也将更改内部电子邮件地址密码。',
    'user.emailName' => '电子邮件地址',
    'user.emailType' => '邮件类型',
    'user.companyName' => '公司名称',
    'user.phone' => '电话号码',
    'user.imNumber' => '即时消息',
    'user.imType' => '即时通信应用程序',
    'user.fax' => '传真号码',
    'user.address' => '地址',
    'user.city' => '城市',
    'user.state' => '省/市/自治区',
    'user.zip' => '邮编',
    'user.country' => '国家',
    'user.additionalInfo' => '其他信息',
    'user.additionalInfoHint' => '仅限纯文本，将忽略所有 HTML 标签。',
    'user.language' => 'Plesk 语言',
    'user.buttonChangePassword' => '更改密码',
    'user.permissionAllow' => '允许',
    'user.permissionDeny' => '拒绝',
    'user.permissionInherited' => '由角色定义',
    'user.emptyContactName' => '请提供联系人姓名。',
    'user.emptyLogin' => '请提供用户名。',
    'user.emptyPassword' => '请提供密码。',
    'user.emptyPasswordConfirmation' => '请确认密码。',
    'user.oldPasswordIsIncorrect' => '旧密码不正确。请重试。',
    'user.chooseDomainBoxTitle' => '选择另一域名:',
    'user.userIsActive' => '用户处于活动状态',
    'user.userIsActiveHint' => '活动的用户可访问 Plesk。',
    'user.emailActivation' => '通过电子邮件激活账户',
    'user.emailHint' => '要向用户提供托管于此服务器上的电子邮件地址，请进入 邮件 标签，创建指定的电子邮件地址并与该用户建立关联。',
    'user.emailContactHint' => '如果您想要使用托管于该服务器上的电子邮件地址可联系您的服务提供商。',
    'user.personalEmailHint' => "可以在 邮件 标签上更改此用户的电子邮件地址。",
    'user.externalMailRedirectHint' => '只能为托管于此服务器上的电子邮件地址激活转发功能。要创建电子邮件地址，请进入 邮件 标签。',
    'user.externalMailRedirectHint2' => '只能为托管于此服务器上的电子邮件地址激活转发功能。',
    'user.externalMailAutoResponderHint' => '只能为托管于此服务器上的电子邮件地址激活自动回复。要创建电子邮件地址，请进入 邮件 标签。',
    'user.externalMailAutoResponderHint2' => '只能为托管于此服务器上的电子邮件地址激活自动回复功能。',
    'user.roleHint' => '用户角色授予用户管理权限，以及访问所选角色对应的应用程序。',
    'user.cannotManageMail' => "您不具备权限管理邮件设置与服务。",
    'user.longCompanyName' => '指定的公司名称太长。',
    'user.longPhone' => '指定的电话号码太长。',
    'user.longFax' => '指定的传真号太长。',
    'user.longAddress' => '指定的地址太长。',
    'user.longCity' => '指定的城市名称太长。',
    'user.phoneRegexNotMatch' => '指定的电话号码无效。',
    'user.faxRegexNotMatch' => '指定的传真号无效。',
    'user.shortCity' => '指定的城市名称太短。',
    'user.limitSubscription' => '访问订阅',
    'user.limitSubscriptionHint' => '允许用户只能访问指定的订阅。值“所有”授权用户访问您主机帐户里的所有订阅。',
    'user.limitSubscriptionAll' => '所有',
    'user.deletedSubscription' => '移除的订阅',

    'web.add-domain-alias.title' => '添加一个域名别名',
    'web.add-domain-alias.createdSuccessfully' => "已创建域名别名 %%name%%。",
    'web.add-domain-alias.domainAliasName' => '域名别名',
    'web.add-domain-alias.domainAliasNameHint' => '例如，example.net',
    'web.add-domain-alias.forDomain' => '基于域名',
    'web.add-domain-alias.settingsSectionLegend' => '设置',
    'web.add-domain-alias.settingsDns' => '将DNS区域与主域名进行同步',
    'web.add-domain-alias.settingsMail' => '邮件服务',
    'web.add-domain-alias.settingsWeb' => '网站服务',
    'web.add-domain-alias.settingsSeoRedirect' => '使用 HTTP 301 代码重定向',
    'web.add-domain-alias.settingsSeoRedirectHint' => '当访客打开别名的 URL，他们将会被重定向至主域名的 URL。Plesk 会使用搜索引擎友好 HTTP 301 重定向，这表示搜索引擎排名将不会在两个 URL 之间分割。',
    'web.add-domain-alias.settingsTomcat' => 'Java web 应用程序',
    'web.add-domain-alias.invalidDomainGuid' => '无效的域名',

    'web.add-domain.formTitle' => '添加新域名',
    'web.add-domain.portalLink' => '服务端口',
    'web.add-domain.domainName' => '域名',
    'web.add-domain.domainNameHint' => "例如，example.com",
    'web.add-domain.assignToCustomer' => '分配该域名给一个客户',
    'web.add-domain.customer' => '选择一个客户',
    'web.add-domain.createNewCustomer' => '创建一个新客户',
    'web.add-domain.selectExistingCustomer' => '选择一名现有客户：',
    'web.add-domain.customerContactInfoHint' => '输入客户联系信息。您可以稍后指定所有其它信息，如电话号码和地址。',
    'web.add-domain.customerLoginInfoHint' => '客户面板的验证凭据',
    'web.add-domain.target' => '主机空间',
    'web.add-domain.createNewTarget' => '创建一个新订阅',
    'web.add-domain.createNewTarget_powerUser' => '创建新主机空间',
    'web.add-domain.selectExistingTarget' => '选择一个现有订阅：',
    'web.add-domain.selectExistingTarget_powerUser' => '选择一个现有主机空间：',
    'web.add-domain.dns' => '激活 DNS 服务',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => '激活邮件服务',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => '如果订阅的设置允许按每域名管理邮件权限则适用。如果不允许，将从订阅获取实际的邮件服务状态。',
    'web.add-domain.hostingManagementOptions' => '主机类型',
    'web.add-domain.websiteHosting' => '网站主机',
    'web.add-domain.websiteForwarding' => '转发',
    'web.add-domain.websiteNoHosting' => '无主机',
    'web.add-domain.hostingSettingsSectionLegend' => '主机设置',
    'web.add-domain.domainCreatedSuccessfully' => '成功创建域名%%domainName%%。',
    'web.add-domain.webspaceLegend' => '主机空间设置',
    'web.add-domain.addWhmWebsiteTitle' => '添加新网站',
    'web.add-domain.addWhmWebsiteHint' => "您可以选择在服务器上托管网站。",
    'web.add-domain.selectWhmDomain' => '选择域名',
    'web.add-domain.customerLegend' => '客户信息',
    'web.add-domain.credentials' => '系统用户验证凭据',
    'web.add-domain.credentialsHint' => '通过 FTP 和 SSH 访问托管的文件',
    'web.add-domain.credentialsHintWin' => '以通过 FTP 和 RDP 访问托管的文件',
    'web.add-domain.buttonAddDomain' => '添加域名',

    'web.add-subdomain.formTitle' => '添加子域名',
    'web.add-subdomain.formGeneralHint' => '子域名是网站其它部分的互联网地址。子域名包含主域名和一个前缀。如，若域名是 domain.com，子域名则可能是 store.domain.com。',
    'web.add-subdomain.formGeneralHintAdditional' => '您还可通过输入 * 符号替代名称创建一个通配符子域名。不管网站访客在浏览器中输入的域名是什么都会被重导向至该子域。',
    'web.add-subdomain.subdomainName' => '子域名',
    'web.add-subdomain.subdomainNameHint' => '输入 * 创建通配符子域名。',
    'web.add-subdomain.forDomain' => '父级域名',
    'web.add-subdomain.subdomainCreatedSuccessfully' => '已创建子域名。',
    'web.add-subdomain.hostingSettingsSectionLegend' => '主机设置',

    'web.setupService.formTitle' => '设置服务： %%serviceReference%%',
    'web.setupService.successfullyUpdated' => '已成功更新 \'%%serviceReference%%\' 服务。',

    'web.site-copy.subdomainsGroup' => '%%siteName%%子域名：',
    'web.site-copy.destinationTypeSection' => '复制目标',
    'web.site-copy.destinationType' => '选择复制网站文件的地址',
    'web.site-copy.destinationTypeSite' => 'Plesk 中的网站',
    'web.site-copy.destinationTypeSiteDescription' => '复制网站文件到该帐户下托管的其他网站。如果您有 FTP，访问服务器上的其他帐户，请使用 FTP 存储选项。',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => '复制网站文件到服务器上托管的其他网站。',
    'web.site-copy.destinationTypeSiteSelect' => '网站名称',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "站点 %%source%% 的文件无法复制到 %%destination%% 因为 %%destination%% 是文件当中的一部分 — 其文档根目录是 %%source%% 文档根目录的子目录。",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "站点 %%destination%%  的文件无法移除因为 %%source%% 文件是其中一部分 — %%source%% 文档根目录是 %%destination%% 的子目录。",
    'web.site-copy.destinationTypeFtp' => 'FTP 存储',
    'web.site-copy.destinationTypeFtpDescription' => '复制网站文件到此服务器或外部服务器上的一个 FTP 帐户。',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => '复制网站文件到一个外部服务器上的 FTP 帐户。',
    'web.site-copy.destinationTypeFtpHost' => "服务器主机名",
    'web.site-copy.destinationTypeFtpPort' => "端口",
    'web.site-copy.destinationTypeFtpFolder' => '目录',
    'web.site-copy.destinationTypeFtpUser' => '用户名',
    'web.site-copy.destinationTypeFtpPassword' => '密码',
    'web.site-copy.destinationTypeFtpMode' => 'FTP 连接方式',
    'web.site-copy.destinationTypeFtpModeActive' => '主动模式',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => '在主动模式中，Plesk 会发送其 IP 地址和将要监听的端口号到一台外部服务器，而该服务器会启动 TCP 连接。如果服务 Plesk 的服务器没有防火墙保护，建议使用该模式。',
    'web.site-copy.destinationTypeFtpModePassive' => '被动模式',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => '如果服务 Plesk 的服务器有防火墙保护而无法接受传入 TCP 连接，则可使用被动模式。',
    'web.site-copy.existingFiles' => '如何处理现有的文件',
    'web.site-copy.existingFilesKeep' => '保留目的网站上的现有文件',
    'web.site-copy.existingFilesKeepDescription' => '覆盖目的网站上同名的现有文件。',
    'web.site-copy.existingFilesDelete' => '删除所有现有文件',
    'web.site-copy.existingFilesDeleteDescription' => '复制前，删除目的网站上的文件。',
    'web.site-copy.emptyLogin' => '指定一个 FTP 帐户用户名。',
    'web.site-copy.emptyHost' => '指定一个服务器主机名。',
    'web.site-copy.emptyPort' => '指定一个服务器主机端口。',
    'web.site-copy.copyInProgress' => '复制网站 %%sourceName%% 到 %%destinationName%%。将会通过邮件通知您其进程(%%email%%)。',
    'web.site-copy.unableToCopy' => '复制网站文件失败。',
    'web.site-copy.siteCopied' => '网站文件已复制过。',
    'web.site-copy.emailSubjSuccess' => '已复制过网站 "%%source%%" 文件。',
    'web.site-copy.emailSubjFailure' => '复制网站 "%%source%%" 文件失败。',
    'web.site-copy.emailBodySuccess' => '网站 "%%source%%"  文件复制到 "%%destination%%"。',
    'web.site-copy.emailBodyFailure' => '复制网站 "%%source%%" 文件到 "%%destination%%" 失败： %%message%%',

    'web._shared.forwardingSettingsSectionLegend' => '转发设置',
    'web._shared.forwardDestination' => '目标地址',
    'web._shared.forwardDestinationHint' => '目的网站的 URL',
    'web._shared.forwardingTypeOptions' => '转发类型',
    'web._shared.forwardingFrame' => '帧转发',
    'web._shared.forwardingFrameHint' => '重定向网站访客到另一网站，但不向访客显示目标地址，让访客不知道被重定向。',
    'web._shared.forwardingHttpCode301' => '永久移动（代码 301）',
    'web._shared.forwardingHttpCode301Hint' => '重定向网站访问者到其它网站并向他们显示目的地址。此类重定向会保持网站搜索引擎的排名。',
    'web._shared.forwardingHttpCode302' => '暂时移动（代码 302）',
    'web._shared.forwardingHttpCode302Hint' => '当您不想让搜索引擎索引此临时网站时，可重定向访问者到临时网站副本。',
    'web._shared.documentRoot' => '文档根目录',
    'web._shared.documentRootHint' => '进入网站主目录的路径。',
    'web._shared.documentRootHintDisabledDueApplications' => '因web应用程序安装到此网站上，无法更改文档根目录。',
    'web._shared.ipAddress' => 'IP地址',
    'web._shared.shared' => '共享',
    'web._shared.exclusive' => '独立',
    'web._shared.ipAddressHint' => "托管此网站的IP地址是网站虚拟主机的网络地址。",
    'web._shared.certificateFromDomainRepository' => '%%name%%（%%repositoryName%%）',
    'web._shared.certificateFromOtherRepository' => '%%name%%（其他库）',
    'web._shared.certificate' => '证书',
    'web._shared.sameCertificatesHint' => '选定的证书将用于托管在同一独立 IP 地址上的所有网站。',
    'web._shared.differentCertificatesHint' => '此订阅与两个带有不同证书的独立 IP 地址相关联。选定的证书将代替安装于托管在这两个 IP 地址上的网站上的证书。',
    'web._shared.differentIpTypesCertificateHint' => '此订阅与一个共享及一个独立 IP 地址关联。选定的证书也将用于托管于独立 IP 地址上的所有其他网站。',
    'web._shared.certificateNotSelected' => '未选定',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => '在您的 repository 中没有 SSL/TLS 证书。要添加证书请进入 %%link%%。',
    'web._shared.sslCertificatesRepositoryLink' => '此页面',
    'web._shared.seoRedirectDirection' => '偏好域名',
    'web._shared.seoRedirectDirectionHint' => '选择将要通过 SEO 安全 HTTP 301 重定向将网站访客重定向到的 URL（有或无 www. 前缀）。',
    'web._shared.seoRedirectDirectionNone' => '无',
    'web._shared.limitMbUnits' => 'MB',

    'web-user.settings.allowScripts' => '允许网站用户使用脚本。',

    'web-user.name' => '用于通过 FTP 连接到服务器的用户名',
    'web-user.longName' => '该用户名太长（允许最多 %max% 个字符）。',
    'web-user.password' => '密码',
    'web-user.passwordConfirmation' => '确认密码',
    'web-user.hardDiskQuota' => '硬盘配额',
    'web-user.hardDiskQuotaUnlimited' => '无限',
    'web-user.hardDiskQuotaIsNotSupported' => '（由于服务器文件系统的配置不支持硬盘配额）',
    'web-user.megabytes' => 'MB',

    'web-user.__asp_win_support' => 'Microsoft ASP支持',
    'web-user.__asp_dot_net_support' => 'Microsoft ASP.NET支持',
    'web-user.__ssi_support' => 'SSI支持',
    'web-user.__php_support' => 'PHP 支持',
    'web-user.__cgi_support' => 'CGI支持',
    'web-user.__perl_unix_support' => 'Perl支持',
    'web-user.__perl_win_support' => 'Perl支持',
    'web-user.__python_unix_support' => 'Python支持',
    'web-user.__python_win_support' => 'Python支持',
    'web-user.__fastcgi_unix_support' => 'FastCGI 支持',
    'web-user.__webstat_support' => '网站统计',
    'web-user.__apache_errdocs' => '自定义错误文档',
    'web-user.__hosting_write_modify' => '其他写入/修改权限',
    'web-user.__hosting_webdeploy' => 'Web Deploy 发布',


    'requiredFields' => '必填字段',
];
