<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'title' => 'Überprüfung der Websiteprotokolle',

    'regularCheck' => 'Automatische Überprüfung',
    'manualCheck' => 'Manuelle Überprüfung',

    'promoTitle' => 'Nicht verfügbare oder fehlerhafte Websites rasch erkennen',
    'promoDescription' => 'Oft sind Probleme auf Websites für Besucher sichtbar, Administratoren erkennen die Fehler aber nur, wenn sie die Websiteprotokolle regelmäßig überprüfen. Mit unserer brandneuen Protokollprüfung kann dies automatisiert werden. So ist auch eine effizientere Problemlösung möglich.',
    'promoMore' => 'Mehr erfahren',
    'promoButton' => 'OK',
    'checkEnabledTitle' => 'Automatische Überprüfung ist aktiviert',
    'checkDisabledTitle' => 'Automatische Überprüfung ist deaktiviert',
    'disabledDescription' => 'Aktivieren Sie diese Option, um automatisch Probleme zu erkennen, die dazu führen können, dass Websites nicht mehr verfügbar sind oder nicht richtig funktionieren.',
    'websitesAllChecked' => '{count, plural, one {# Website wird} other {# Websites werden}} täglich überprüft',
    'websitesAllCheckedAt' => '{count, plural, one {# Website wird} other {# Websites werden}} täglich um %%time%% überprüft',
    'websitesChecked' => '%%count%% von %%totalCount%% Websites werden täglich überprüft',
    'websitesCheckedAt' => '%%count%% von %%totalCount%% Websites werden täglich um %%time%% überprüft',
    'checkedWebsites' => 'Liste der überprüften Websites',
    'lastCheckDescription' => 'Die letzte Überprüfung dauerte %%duration%% Minuten.',
    'durationLess' => 'weniger als 0,1',
    'month0' => '%%date%% Jan.',
    'month1' => '%%date%% Feb.',
    'month2' => '%%date%% März',
    'month3' => '%%date%% Apr.',
    'month4' => '%%date%% Mai',
    'month5' => '%%date%% Juni',
    'month6' => '%%date%% Juli',
    'month7' => '%%date%% Aug.',
    'month8' => '%%date%% Sept.',
    'month9' => '%%date%% Okt.',
    'month10' => '%%date%% Nov.',
    'month11' => '%%date%% Dez.',
    'export' => 'Bericht als CSV exportieren',
    'buttonRun' => 'Manuelle Überprüfung durchführen',
    'buttonRunDescription' => 'Sie können Websites mit behobenen Problemen erneut überprüfen oder Probleme finden, die bei der letzten Überprüfung nicht vorhanden waren.',

    'websites.title' => 'Zu überprüfende Websites',
    'websites.description' => '%%selected%% von %%total%% Websites sind ausgewählt',
    'websites.search' => 'Websites suchen...',
    'websites.new' => 'Alle neu erstellten Websites',
    'websites.newHint' => 'Wählen Sie diese Option aus, um automatisch alle neuen Websites zu prüfen.',
    'websites.existing' => 'Alle vorhandenen Websites',
    'websites.buttonSave' => 'Speichern',
    'websites.buttonCancel' => 'Abbrechen',
    'websites.updateSuccess' => 'Einstellungen wurden aktualisiert',

    'tabs.problemDetails' => 'Problemdetails',
    'tabs.affectedWebsites' => 'Betroffene Websites',

    'chart.requests' => 'Anfragen',
    'chart.errors' => 'Fehler',

    'affected-websites.selected' => '%%selectedCount%% von %%totalCount%% Websites sind ausgewählt',
    'affected-websites.none' => 'Ohne',
    'affected-websites.all' => 'Alle',
    'affected-websites.searchForWebsite' => 'Websites suchen',
    'affected-websites.websites' => 'Websites',
    'affected-websites.showProblemDetails' => 'Problemdetails anzeigen',

    'problem-report.domainTitle' => 'Problem erkannt auf %%domain%%',
    'problem-report.cumulativeTitle' => 'Problem erkannt auf {count, plural, one {# Website} other {# Websites}}',
    'problem-report.serverwideTitle' => 'Serverweites Problem erkannt',
    'problem-report.problemAppearsOn' => 'Problem erkannt auf {count, plural, one {# Website} other {# Websites}}',
    'problem-report.seeTheConsolidatedReport' => 'Konsolidierten Bericht anzeigen',
    'problem-report.cause' => 'Ursache',
    'problem-report.possibleSolutions' => 'Mögliche Lösungen',
    'problem-report.useAnOption' => 'Eine Option zur automatischen Lösung verwenden',
    'problem-report.repairTheWebsite' => 'Website reparieren',
    'problem-report.selectAndRepair' => 'Mehrere Websites auswählen und reparieren',
    'problem-report.distributionOfTheProblem' => 'Verteilung des Problems im Zeitverlauf',
    'problem-report.serverTimezone' => 'Zeitzone des Servers (UTC%%utcShift%%)',
    'problem-report.yourTimezone' => 'Ihre Zeitzone (UTC%%utcShift%%)',
    'problem-report.logEntries' => 'Beispiele für Protokolleinträge, die auf das Problem hinweisen',
    'problem-report.pleaseKeepInMind' => 'Hinweis: In Plesk werden Protokolle regelmäßig rotiert. Die erwähnten Protokolleinträge werden schlussendlich archiviert oder gelöscht.',
    'problem-report.weRecommendToRecheck' => '%%recheckWebsite%% – empfohlen nach jeder Problembehebung.',
    'problem-report.recheckWebsite' => 'Website manuell erneut überprüfen',
    'problem-report.option' => 'Option %%number%%:',
    'problem-report.recommended' => 'empfohlen',
    'problem-report.numberOfEntries' => 'Anzahl der Einträge',
    'problem-report.logEntry' => 'Protokolleintrag',
    'problem-report.logFile' => 'Logfile',
    'problem-report.openWebsiteLogs' => 'Websiteprotokolle öffnen',
    'problem-report.thisIsServerWideProblem' => 'Das ist ein serverweites Problem, das alle gehosteten Websites betrifft',
    'problem-report.serverWideTitle' => 'Serverweites Problem erkannt',
    'problem-report.checkDetectedIssue' => 'Das Problem wurde bei Überprüfung erkannt (Serverzeitzone - UTC%%timezone%%):',
    'problem-report.todayAt' => 'heute um %%time%%',
    'problem-report.yesterdayAt' => 'gestern um %%time%%',
    'problem-report.dateAt' => '%%date%% um %%time%%',
    'problem-report.firstProblemTime' => 'Erstes Mal – %%info%%',
    'problem-report.lastProblemTime' => 'Letztes Mal – %%info%%',

    'distribution-over-time.title' => 'Verteilung des Problems im Zeitverlauf',
    'distribution-over-time.titleYesterday' => 'Auftreten des Problems über Zeit (Gestern)',
    'distribution-over-time.titleToday' => 'Auftreten des Problems über Zeit (Heute)',
    'distribution-over-time.serverTimezone' => 'Zeitzone des Servers (UTC%%utcShift%%)',
    'distribution-over-time.yourTimezone' => 'Ihre Zeitzone (UTC%%utcShift%%)',
    'distribution-over-time.weRecomendComparing' => 'Wir empfehlen, das Diagramm mit der Fehlerverteilung mit %%link%% in Monitoring zu vergleichen',
    'distribution-over-time.resourceUsageCharts' => 'Diagramme zur Ressourcennutzung',
    'distribution-over-time.noDataForRecentTime' => 'Keine Daten für die letzte Zeit. %%suggestion%%',
    'distribution-over-time.pleseEnableRegularCheck' => 'Aktivieren Sie die automatische Überprüfung oder überprüfen Sie die Website manuell',
    'distribution-over-time.pleseIncludeWebsiteForCheck' => 'Fügen Sie die Website zur Liste der automatisch überprüften Websites hinzu oder überprüfen Sie die Website manuell',
    'distribution-over-time.pleaseWaitUntilRegularCheckWillBeStarted' => 'Warten Sie, bis die automatische Überprüfung beginnt oder überprüfen Sie die Website manuell',
    'distribution-over-time.enableRegularCheck' => 'Automatische Überprüfung aktivieren',
    'distribution-over-time.addWebsiteToRegularCheckList' => 'Fügen Sie die Website zur Liste der automatisch überprüften Websites hinzu',
    'distribution-over-time.runManualCheck' => 'Manuelle Überprüfung durchführen',

    'report.title' => 'Bericht zur letzten Überprüfung',
    'report.groupByWebsites' => 'Gruppiert nach Websites',
    'report.groupByProblems' => 'Nach Problemen',
    'report.columnWebsite' => 'Webseite',
    'report.columnStatus' => 'Probleme',
    'report.columnProblem' => 'Problem',
    'report.columnAppearedOn' => 'Detected on',
    'report.serverWideName' => 'Serverweite Probleme',
    'report.serverWideDescription' => 'Diese Probleme betreffen den ganzen Server und alle gehosteten Websites.',
    'report.statusProblemsFound' => '%%count%% erkannt',
    'report.statusProblemsFoundFull' => '{count, plural, one {# Problem} other {# Probleme}} erkannt',
    'report.statusProblemsSolved' => '%%count%% gelöst',
    'report.statusProblemsSolvedFull' => '{count, plural, one {# Problem} other {# Probleme}} gelöst',
    'report.statusSuccess' => 'Keine Probleme',
    'report.serverWide' => 'Der ganze Server',
    'report.appearedOn' => '{count, plural, one {# Website} other {# Websites}}',
    'report.recheckWebsite' => 'Website erneut überprüfen',
    'report.actionOpen' => 'Öffnen',
    'report.actionManage' => 'Verwalten',
    'report.actionLogs' => 'Protokolle anzeigen',
    'report.searchWebsite' => 'Websites suchen...',
    'report.searchProblem' => 'Probleme finden...',
    'report.groupByProblemsTotal' => '{totalRows, plural, one {# Problem} other {# Probleme}} auf {websitesCount, plural, one {# Website} other {# Websites}}',
    'report.noProblemsTitle' => 'Keine Probleme gefunden auf {websitesCount, plural, one {# Website} other {# Websites}}',
    'report.noProblemsDescription' => 'Ihre Websites scheinen gut in Schuss zu sein. Gut gemacht!',

    'problems.columnTitle' => 'Problem',
    'problems.columnRegular' => 'Automatische Überprüfung',
    'problems.columnManual' => 'Manuelle Überprüfung',
    'problems.run' => '%%fromDate%% %%fromTime%% – %%toDate%% %%toTime%%',
    'problems.runSameDay' => '%%toDate%% von %%fromTime%% bis %%toTime%%',
    'problems.notRun' => 'noch nicht durchgeführt',
    'problems.resultDetected' => 'Erkannt',
    'problems.resultNotDetected' => 'Nicht erkannt',
    'problems.resultNoProblems' => 'Keine Probleme',

    'new-check.title' => 'Manuelle Überprüfung',
    'new-check.titleForWebsite' => 'Manuelle Überprüfung von %%website%%',
    'new-check.titleRunning' => 'Manuelle Überprüfung von {count, plural, one {# Website} other {# Websites}}',
    'new-check.description' => '%%selected%% von %%total%% Websites sind ausgewählt',
    'new-check.depth' => 'Prüfzeitraum',
    'new-check.checkTheLast' => 'Überprüfen der letzten',
    'new-check.selectHours' => 'Stunden',
    'new-check.selectMinutes' => 'Minuten',
    'new-check.ifYouHaveAnyProblemActivities' => 'Wenn Sie versucht haben, die Probleme der Website zu beheben, legen Sie den Zeitraum nach diesem Versuch fest. Andernfalls werden in Plesk möglicherweise Probleme erkannt, die Sie bereits behoben haben.',
    'new-check.weAlsoRecommendVisiting' => 'Bevor Sie eine manuelle Überprüfung durchführen, sollten Sie %%visitingTheWebsite%% und versuchen, das Problem zu reproduzieren.',
    'new-check.visitingTheWebsite' => 'die Website aufrufen',
    'new-check.hours' => 'letzte Stunden',
    'new-check.websites' => 'Zu überprüfende Websites',
    'new-check.buttonSave' => 'Überprüfen',
    'new-check.buttonCancel' => 'Abbrechen',
    'new-check.search' => 'Websites suchen...',
    'new-check.checkProblems' => 'Websites mit Problemen bei der letzten Überprüfung',
    'new-check.allWebsites' => 'Alle Websites',
];
