<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'action-log.logFiles' => "ログファイル",
    'action-log.fromDate' => "開始：",
    'action-log.toDate' => "終了：",
    'action-log.clearLog' => "ログ消去",
    'action-log.downloadLog' => "ダウンロード",
    'action-log.loggedActions' => "記録するアクション",
    'action-log.storeLogsInDb' => "データベースにレコードを保存する範囲",
    'action-log.storeNumber' => "エントリ",
    'action-log.dontRemoveRecs' => "ログを削除しない",
    'action-log.confirmCleanLog' => "アクションログレコードを削除しますか？",
    'action-log.incorrectDate' => "指定された日付が無効です。",
    'action-log.incorrectNumPeriods' => "指定された範囲が無効です。",
    'action-log.incorrectNumRecords' => "指定されたレコード数が無効です。",
    'action-log.yes' => "はい",
    'action-log.no' => "いいえ",
    'action-log.mixed' => "（混合）",
    'action-log.period' => "期間",
    'action-log.invalidDatePeriod' => "無効な期間",
    'action-log.submitDone' => "アクションログ設定の変更が保存されました",
    'action-log.clearDone' => "アクションログがクリアされました。",
    'action-log.periodDay' => "日",
    'action-log.periodWeek' => "週間",
    'action-log.periodMonth' => "ヶ月",

    'admin-info.adminInfoSection' => '管理者用の情報',
    'admin-info.description-admin' => '管理者の説明',
    'admin-info.description-reseller' => 'リセラーの説明',
    'admin-info.description-owner' => '所有者の説明',
    'admin-info.description' => '説明',
    'admin-info.descriptionSuccess' => '説明が更新されました。',
    'admin-info.longDescription' => '入力した説明が長すぎます。%%max%% 文字以内にしてください。',
    'admin-info.add' => '説明を追加',
    'admin-info.edit' => '編集',
    'admin-info.remove' => '削除',
    'admin-info.confirmOnRemove' => 'この説明を削除しますか？',
    'admin-info.popupTitle-customer' => '顧客 %%name%% に関する %%descriptionType%%',
    'admin-info.popupTitle-reseller' => 'リセラー %%name%% に関する %%descriptionType%%',
    'admin-info.popupTitle-subscription' => '契約 %%name%% に関する %%descriptionType%%',
    'admin-info.popupTitle-site' => '%%name%% に関する %%descriptionType%%',
    'admin-info.popupHint-admin' => 'この説明は管理者にのみ表示されます。',
    'admin-info.popupHint-reseller' => 'この説明はリセラーおよび管理者に表示されます。',
    'admin-info.popupHint-owner' => 'この説明は作成者および作成者のホスティング事業者に表示されます。',
    'admin-info.customerDescriptionHint' => '顧客はこの説明を参照できません。',
    'admin-info.subscriptionDescriptionHint' => "この情報はホスティング事業者にのみ表示されます（Plesk 管理者またはリセラー）。",

    'apache-settings.formGeneralHint' => 'このウェブサイトの Apache ウェブサーバ設定を指定することができます。カスタム Apache 構成は、ウェブサイトのインデックスファイルに新しいファイルタイプを使用したい場合や、特定のファイル名拡張子と特定の MIME タイプを関連付けたい場合に便利です。デフォルト値にすると、Apache はサーバ全体の構成に定義されたディレクティブを使用します。Apache のフロントエンドサーバとして nginx を使用している場合、このページで nginx 設定も指定することができます。',
    'apache-settings.general' => 'Apache 共通設定',
    'apache-settings.example' => "例：\n%%example%%",
    'apache-settings.settingOn' => 'オン',
    'apache-settings.settingOff' => 'オフ（デフォルト）',
    'apache-settings.settingDefault' => 'デフォルト',
    'apache-settings.settingCustom' => 'カスタム値を入力',
    'apache-settings.mimeTypes' => 'MIME タイプ',
    'apache-settings.mimeTypesExample' => "text/plain .txt\nimage/jpeg .jpeg",
    'apache-settings.mimeTypesFullDescription' => 'MIME タイプは、ファイルの拡張子とファイルタイプを関連付けます。通常は、一般的なファイルタイプ用にカスタムファイル拡張子を作成するために使用されます。',
    'apache-settings.handlers' => 'ハンドラ',
    'apache-settings.handlersExample' => "php-script .php\ncgi-script .cgi",
    'apache-settings.handlersFullDescription' => "Apache ハンドラは、特定の拡張子のファイルが要求された場合にウェブサーバがファイルをどのように処理するかを定義します。例えば、「php-script .script」という文字列は、Apache が .script ファイルを php スクリプトとして処理することを意味します。",
    'apache-settings.deny' => 'サイトへのアクセスを拒否',
    'apache-settings.allow' => '除外',
    'apache-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\n指定されたホストとネットワークに対して、このサイトへのアクセスを禁止します。すべての接続を拒否するには「*」を使用します。",
    'apache-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\n指定したホストとネットワークは、サイトへのアクセスが許可されます。",
    'apache-settings.directoryIndex' => 'インデックスファイル',
    'apache-settings.directoryIndexExample' => "index.htm index.php index.pl",
    'apache-settings.directoryIndexFullDescription' => "サイトのインデックスページが要求された場合、Apache は指定されたファイルを探します。",
    'apache-settings.expires' => '期限切れ',
    'apache-settings.expiresStaticOnly' => '静的ファイルに対してのみ期限切れヘッダ付きで応答',
    'apache-settings.expiresFullDescription' => 'ウェブサーバは「期限切れ」応答ヘッダをウェブページに追加します。期限切れタイムスタンプは、ウェブページがリクエストされた時間に、上に指定された時間を加算することで計算されます。',
    'apache-settings.expiresStaticOnlyDescription' => '「期限切れ」ヘッダは静的ファイルにのみ追加されます。どのファイルが静的ファイルとして処理されるかは、「スマート静的ファイル処理」および「静的ファイルを nginx で直接処理」オプションによって制御されます。',
    'apache-settings.expiresUnitDays' => '日',
    'apache-settings.expiresUnitHours' => '時間',
    'apache-settings.expiresUnitMinutes' => '分',
    'apache-settings.expiresUnitSeconds' => '秒',
    'apache-settings.expiresSize' => '期限切れの条件',
    'apache-settings.expiresUnitSize' => '期限切れの条件の単位',
    'apache-settings.nginxCacheTimeoutSize' => 'キャッシュタイムアウト',
    'apache-settings.nginxCacheTimeoutUnitSize' => 'キャッシュタイムアウトの単位',
    'apache-settings.headers' => '追加ヘッダ',
    'apache-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000\nX-Frame-Options: DENY",
    'apache-settings.headersFullDescription' => "ウェブサーバにより、指定した HTTP 応答ヘッダが追加されます。",
    'apache-settings.restrictFollowSymLinks' => 'シンボリックリンクのフォローを制限する',
    'apache-settings.restrictFollowSymLinksDescription' => "このオプションをオンにすると、ユーザーが FollowSymLink ディレクティブを .htaccess で使用することが禁止され、サーバーのセキュリティが強化されます。",
    'apache-settings.nginx' => 'nginx 設定',
    'apache-settings.nginxProxyMode' => 'プロキシモード',
    'apache-settings.nginxProxyModeDescription' => 'Nginx が Apache にリクエストをプロキシします。Apache の使用を停止する場合はオフにしてください。',
    'apache-settings.nginxHttp3Enabled' => 'HTTP/3 サポート',
    'apache-settings.nginxHttp3EnabledDescription' => '試験的な機能です。稀に、ウェブサイトの可用性に影響を与える可能性があります。',
    'apache-settings.nginxTransparentMode' => 'スマート静的ファイル処理',
    'apache-settings.nginxTransparentModeDescription' => 'オフにすると、静的ファイルに対するすべての要求は Apache で処理されます。nginx は要求を変更せずに受け渡すだけです。このオプションをオフにするのは、トラブルシューティング目的のみにしてください。',
    'apache-settings.nginxServeStatic' => '静的ファイルを nginx で直接処理',
    'apache-settings.nginxStaticExtensionsLabel' => 'ファイル拡張子を指定 ',
    'apache-settings.nginxStaticExtensions' => 'ファイル拡張子をスペースまたは「|」記号で区切って指定します。これらのファイルへの要求は nginx で処理され、Apache には送られません。注意：Apache の書き換えルールは適用されません。',
    'apache-settings.nginxServePhp' => 'PHP を nginx で処理',
    'apache-settings.nginxServePhpDescription' => 'PHP ファイル（.php）は nginx と PHP-FPM で処理されます。オフにすると、PHP ファイルは Apache で処理されます。',
    'apache-settings.nginxClientMaxBodySize' => 'HTTP リクエストの最大許容ボディサイズ',
    'apache-settings.nginxClientMaxBodySizeDescription' => 'ボディが上限を超えているリクエストは HTTP 413 Payload Too Large で破棄されます（nginx ディレクティブ「client_max_body_size」の値で設定します）。',
    'apache-settings.nginxClientMaxBodySizeDisabled' => 'オプションは panel.ini のディレクティブ「clientMaxBodySize」の値が空またはゼロであることで、グローバルに無効化されています',
    'apache-settings.nginxCacheEnabled' => 'nginx キャッシュを有効にする',
    'apache-settings.nginxCacheEnabledDescription' => 'キャッシュにより、ウェブサイトの応答時間が短縮され、サーバの負荷が軽減されますが、取り扱いには注意が必要です。',
    'apache-settings.nginxCacheSize' => 'キャッシュサイズ',
    'apache-settings.nginxCacheSizeGb' => 'GB',
    'apache-settings.nginxCacheSizeMb' => 'MB',
    'apache-settings.nginxCacheSizeKb' => 'KB',
    'apache-settings.nginxCacheSizeBytes' => 'B',
    'apache-settings.nginxCacheTimeout' => 'キャッシュタイムアウト',
    'apache-settings.nginxCacheTimeoutDays' => '日',
    'apache-settings.nginxCacheTimeoutHours' => '時間',
    'apache-settings.nginxCacheTimeoutMinutes' => '分',
    'apache-settings.nginxCacheTimeoutSeconds' => '秒',
    'apache-settings.nginxCacheKey' => 'キャッシュキー',
    'apache-settings.nginxCacheCookies' => 'cookie のあるリクエストをキャッシュ',
    'apache-settings.nginxCacheBypassLocations' => '次の場所でキャッシュを無効にする',
    'apache-settings.nginxCacheBypass' => '次の場合にキャッシュをバイパス：',
    'apache-settings.nginxCacheBypassHeaderNocache' => 'リクエストで HTTP no-cache ヘッダを受け取った',
    'apache-settings.nginxCacheBypassHeaderAuth' => 'リクエストで HTTP 認証ヘッダを受け取った',
    'apache-settings.nginxCacheBypassGetNocache' => 'リクエストで GET nocache パラメータを受け取った',
    'apache-settings.nginxCacheUseStale' => 'キャッシュが古いレコードを戻す',
    'apache-settings.nginxCacheUseStale5xx' => 'Upstream が 5xx サーバエラーを返す',
    'apache-settings.nginxCacheUseStale4xx' => 'Upstream が 4xx クライアントエラーを返す',
    'apache-settings.nginxCacheUseStaleUpdating' => 'キャッシュを更新中です',
    'apache-settings.additional' => 'Apache 追加ディレクティブ',
    'apache-settings.additionalSettingsDescription' => '特定の設定が見つからない場合、以下のフィールドに追加してください。ディレクティブは最終的な Apache 構成に追加されます。最初のフィールドのディレクティブは、訪問者がサイトに HTTP アクセスすると使用されます。2 番目のフィールドは、HTTPS 用ディレクティブです。一般に、両フィールドにディレクティブを追加する必要があります。httpd.include と同じ構文にしてください。例えば、カスタムエラーページを設定したい場合、「ErrorDocument 401 /my_error_page.html」という行を追加してください。',
    'apache-settings.additionalSettings' => 'HTTP 用追加ディレクティブ',
    'apache-settings.additionalSslSettings' => 'HTTPS 用追加ディレクティブ',
    'apache-settings.additionalSettingsError' => 'Apache 構成が無効です。%%error%%',
    'apache-settings.rollbackFailed' => '現在の Apache 構成ファイルを使用したり、このファイルの旧バージョンにロールバックすることができません。無効な構成が含まれています。',
    'apache-settings.additionalNginx' => 'nginx 追加ディレクティブ',
    'apache-settings.additionalNginxSettingsDescription' => 'Apache の手前で機能する nginx リバースプロキシサーバの設定を指定します。ディレクティブによって、サーバ全体の nginx 構成がオーバーライドされます。例えば、接続タイムアウトの設定を変更したり、要求を gzip でパックすることができます。構文は、nginx.conf で使用する構文と同じものを使用してください。例えば、プロキシされたすべての要求を gzip で圧縮したい場合、「gzip_proxied any;」という行を追加します。',
    'apache-settings.additionalNginxSettings' => 'nginx 追加ディレクティブ',
    'apache-settings.additionalNginxSettingsError' => 'nginx 構成が無効です。%%error%%',
    'apache-settings.nginxRollbackFailed' => '最新の nginx 構成ファイルを使用することや、構成ファイルを前バージョンにロールバックすることができません。これらの両バージョンに、無効な構成が含まれています。',
    'apache-settings.clearCache' => 'キャッシュを消去',
    'apache-settings.clearCacheHint' => '%%website%% の nginx キャッシュを消去',
    'apache-settings.cacheHasClearedSuccessfuly' => 'キャッシュが正常に消去されました',

    'backup.backup-password-protection.securitySettingsSection' => 'バックアップのセキュリティ設定',
    'backup.backup-password-protection.backupPasswordFromFtpSettings' => 'リモートストレージの設定からパスワードを取得',
    'backup.backup-password-protection.backupPasswordManualInput' => 'パスワードを手入力',
    'backup.backup-password-protection.providePasswordCheckbox' => 'パスワードを入力',
    'backup.backup-password-protection.backupPassword' => 'パスワード',
    'backup.backup-password-protection.inputPasswordType' => 'パスワードのタイプ',
    'backup.backup-password-protection.confirmBackupPassword' => 'パスワード再入力',
    'backup.backup-password-protection.backupPasswordHint' => 'パスワードを忘れた場合は、このオプションをオフにしてください。オフにすると、一部の機密データが正しく復元されなくなる可能性があります。例えば、ユーザーパスワードがランダムなパスワードに変更され、インストール済み APS アプリケーションに関する情報が削除されます。',
    'backup.backup-password-protection.backupPasswordFtpHint' => 'このバックアップにパスワード保護を適用した場合、下のフィールドにパスワードを入力してください。パスワードを誤入力すると、バックアップが復元できません。代わりに、バックアップはローカルストレージに復元されます。',

    'backup.conflict-database.dbMappingLegend' => 'データベースサーバのマッピング',
    'backup.conflict-database.serverType' => 'サーバのタイプ',
    'backup.conflict-database.hostName' => 'ホスト名',
    'backup.conflict-database.port' => 'ポート',
    'backup.conflict-database.destinationDbServer' => '宛先データベースサーバ',
    'backup.conflict-database.mysql' => 'MariaDB/MySQL',
    'backup.conflict-database.postgresql' => 'PostgreSQL',
    'backup.conflict-database.mssql' => 'MSSQL',
    'backup.conflict-database.migrationDbServerNotFind' => 'データベースを復元できません。適切なデータベースサーバがありません。',

    'backup.conflict-ip.buttonUploadMappingFile' => 'IP マッピングファイルをアップロード',
    'backup.conflict-ip.ipMappingLegend' => 'IP マッピング',
    'backup.conflict-ip.buttonSaveCurrentMapping' => '現在の IP マッピングをファイルに保存',
    'backup.conflict-ip.ipAddressNotFound' => 'このタイプの IP アドレスには空きがありません。',
    'backup.conflict-ip.sharedIp' => '共用',
    'backup.conflict-ip.dedicatedIp' => '専用',
    'backup.conflict-ip.fileNotFound' => 'ファイルは空でなければなりません。',
    'backup.conflict-ip.invalidIpToMap' => '古い IP アドレスの値が無効です。%%ip%%',
    'backup.conflict-ip.invalidMappingValue' => '新しい IP アドレスの値が無効です。%%ip%%',
    'backup.conflict-ip.ipNotFound' => 'IP アドレス %%ip%% がデータベースにありません。',
    'backup.conflict-ip.uploadIpMappingFileLegend' => 'IP マッピングファイルをアップロード',
    'backup.conflict-ip.ipMappingFileHint' => 'IP マッピングファイルはテキストファイルです。ファイルの各行に、IP マッピングが <old IP address> <new IP address> という書式で含まれています。',
    'backup.conflict-ip.oldIp' => '古い IP アドレス',
    'backup.conflict-ip.newIp' => '新しい IP アドレス',

    'backup.copy-to-server.ignoreBackupSign' => '有効な署名のないバックアップファイルをアップロード',
    'backup.copy-to-server.wrongPassword' => '指定したパスワードが正しくありません。バックアップの復元中に、パスワードを再入力する必要があります。',
    'backup.copy-to-server.corruptedSignatureUploaded' => 'アップロード済みのバックアップファイル %%fileName%% は、変更または破損しているか、別のサーバで作成されたものか、バックアップファイルの署名をサポートしていない旧バージョンの Plesk で作成されたものです。このバックアップファイルからデータを復元する前に、このファイルのソースを信頼できるか確認してください。',
    'backup.copy-to-server.corruptedSignatureNotUploadedUser' => 'バックアップファイル %%fileName%% をアップロードできません。このファイルのデータは、変更または破損しているか、別のサーバまたは旧バージョンの Plesk で作成されています。このファイルのデータを復元するためには、ホスティング事業者までお問い合わせください。',
    'backup.copy-to-server.corruptedSignatureNotUploadedAdmin' => 'バックアップファイル %%fileName%% をアップロードできません。このファイルは変更されたか、破損しています。あるいは、別のサーバで作成されたか、バックアップファイルの署名をサポートしていない旧バージョンの Plesk で作成されています。このバックアップが信頼できる場合、［有効な署名のないバックアップファイルをアップロード］オプションをオンにしてアップロードをやり直してください。',
    'backup.copy-to-server.unableToMoveToLocalRepository' => "選択したバックアップ %%fileName%% をサーバストレージに移動できません。エラー: %%error%%。",
    'backup.copy-to-server.missedPartsWarning' => "増分バックアップのうち、次の部分がコピーされていません。%%endl%%%%missedParts%%%%endl%% 欠落部分をコピーしてください。",

    'backup.ftp-settings.isActive' => 'FTP（S）ストレージを使用',
    'backup.ftp-settings.host' => 'FTP サーバのホスト名または IP',
    'backup.ftp-settings.directory' => 'バックアップファイルストレージのディレクトリ',
    'backup.ftp-settings.directoryHint' => '例： /myfolder/mybackups/',
    'backup.ftp-settings.ftpLogin' => 'FTP ユーザー名',
    'backup.ftp-settings.ftpPassword' => 'FTP パスワード',
    'backup.ftp-settings.usePassiveMode' => 'パッシブモードを使用',
    'backup.ftp-settings.useFtps' => 'FTPS を使用',
    'backup.ftp-settings.errorHostIsLocal' => 'ローカル Plesk の FTP サーバをリモートストレージとして使用することは禁止されています。 リモートロケーションを指定してください。',
    'backup.ftp-settings.warningHostIsLocal' => 'FTP（S）ストレージ設定は、契約のファイルの保存先サーバにバックアップを保存するように構成されています。このような構成は、データ損失およびディスクスペース利用超過のリスクがあるため、推奨されません。',
    'backup.ftp-settings.enterFtpLogin' => '正しいユーザー名を入力してください。',
    'backup.ftp-settings.enterFtpPassword' => '正しいパスワードを入力してください。',

    'backup.remote-settings.isActive' => 'ストレージを使用',
    'backup.remote-settings.initError' => '%%extName%% 設定ページを初期化できません。%%error%%',

    'backup.remote-storages.backupSecuritySettings' => 'バックアップのセキュリティ設定',

    'backup.restore.detailsSection' => '説明',
    'backup.restore.contentInfoSection' => 'バックアップのコンテンツ',
    'backup.restore.restorationOptionsSection' => '復元オプション',
    'backup.restore.emailNotification' => '復元作業の完了時に通知を送信',
    'backup.restore.comments' => 'コメント',
    'backup.restore.creationDate' => '作成日',
    'backup.restore.systemNotes' => 'システムノート',
    'backup.restore.ownerAdmin' => '管理者が作成',
    'backup.restore.ownerReseller' => 'リセラーが作成',
    'backup.restore.ownerCustomer' => '顧客が作成',
    'backup.restore.ownerServiceUser' => '追加ユーザーによって作成',
    'backup.restore.partOfParentBackup' => '%%type%% バックアップの一部。',
    'backup.restore.server' => 'サーバ',
    'backup.restore.reseller' => 'リセラー',
    'backup.restore.client' => '顧客',
    'backup.restore.incremental' => '増分',
    'backup.restore.multiVolume' => 'マルチボリューム',
    'backup.restore.backupSize' => 'バックアップサイズ',
    'backup.restore.backupSizeFirstIncremental' => '%%this%%（今回の増分）+ %%base%%（初回バックアップ）= %%total%%',
    'backup.restore.backupSizeIncremental' => '%%this%%（今回の増分）+ %%prev%%（過去の増分） + %%base%%（初回バックアップ）= %%total%%',
    'backup.restore.download' => 'ダウンロード',
    'backup.restore.downloadHint' => 'バックアップファイルをローカルコンピュータにダウンロードします。',
    'backup.restore.downloadDisabled' => '現在、バックアップファイルのダウンロードは実行できません。後でお試しいただくか、サービスプロバイダまでお問い合わせください。',
    'backup.restore.copy' => 'サーバストレージにコピー',
    'backup.restore.copyHint' => '選択したバックアップファイルをサーバストレージにコピーします。',
    'backup.restore.contentInfo' => 'バックアップの内容',
    'backup.restore.restoreButton' => '復元',
    'backup.restore.mail' => 'メール',
    'backup.restore.domainConfiguration' => 'ドメイン構成',
    'backup.restore.virtualHost' => '仮想ホストのコンテンツ',
    'backup.restore.database' => 'データベース',
    'backup.restore.serverConfiguration' => 'サーバ設定',
    'backup.restore.serverConfigurationLicense' => 'ライセンスキー',
    'backup.restore.serverPersonalConfiguration' => '管理者アカウントの構成',
    'backup.restore.serverPersonalDomains' => '管理者のドメイン',
    'backup.restore.serverPersonalClients' => '管理者の顧客',
    'backup.restore.resellers' => 'リセラー',
    'backup.restore.resellerPersonalConfiguration' => 'リセラーアカウントの構成',
    'backup.restore.resellerPersonalDomains' => 'リセラーのドメイン',
    'backup.restore.resellerPersonalClients' => 'リセラーの顧客',
    'backup.restore.clientPersonalConfiguration' => '顧客アカウントの構成',
    'backup.restore.clientPersonalDomains' => '顧客のドメイン',
    'backup.restore.restoreModifiedSection' => '署名が破損していてもバックアップファイルを復元する',
    'backup.restore.restoreModifiedDump' => '有効な署名がなくてもこのバックアップを復元する',
    'backup.restore.resolutionPolicy' => '解決ポリシー',
    'backup.restore.resolutionPolicyDescription' => '変更日がより新しい復元対象オブジェクトが既に存在しているか、復元対象オブジェクトが現在システムに存在しない場合、タイミングの競合が発生します。',
    'backup.restore.backupRestoreFtpWrongPassword' => '指定したパスワードが正しくありません。バックアップファイルがサーバのローカルストレージにコピーされます。',
    'backup.restore.backupRestoreLocalWrongPassword' => 'バックアップを復元できません。指定したパスワードが正しくありません。',
    'backup.restore.serverContentAndConfiguration' => 'サーバの構成とコンテンツ',
    'backup.restore.serverConfigurationOnly' => 'サーバ構成',
    'backup.restore.resellerContentAndConfiguration' => 'リセラーアカウントの構成とコンテンツ',
    'backup.restore.resellerConfigurationOnly' => 'リセラーアカウントの構成',
    'backup.restore.clientContentAndConfiguration' => '顧客アカウントの構成とコンテンツ',
    'backup.restore.clientConfigurationOnly' => '顧客アカウントの構成',
    'backup.restore.domainContentAndConfiguration' => 'ドメインの構成とコンテンツ',
    'backup.restore.domainConfigurationOnly' => 'ドメイン構成',
    'backup.restore.restoreType' => '復元対象範囲',
    'backup.restore.restoreTypeFull' => 'すべてのオブジェクト（システム全体）',
    'backup.restore.restoreTypeGranular' => '選択したオブジェクト',
    'backup.restore.restoreObjectType' => '復元対象オブジェクトのタイプ',
    'backup.restore.restoreObjectTypeSubscriptions' => '契約',
    'backup.restore.restoreObjectTypeCustomers' => '顧客',
    'backup.restore.restoreObjectTypeResellers' => 'リセラー',
    'backup.restore.restoreObjectTypeMailUsers' => 'メールアカウント',
    'backup.restore.restoreObjectTypeDatabases' => 'データベース',
    'backup.restore.restoreObjectTypeCertificates' => 'SSL/TLS 証明書',
    'backup.restore.restoreObjectTypeSites' => 'サイト',
    'backup.restore.restoreObjectTypeDnsZones' => 'DNS ゾーン',
    'backup.restore.restoreObjectTypeMailLists' => 'メーリングリスト',
    'backup.restore.restoreObjectTypeWebContent' => 'ドメインのファイル',
    'backup.restore.restoreObjects' => '%%objectType%%',
    'backup.restore.restoreObjectsWebContent' => '選択したファイル',
    'backup.restore.restoreSubscriptionLookup' => '契約',
    'backup.restore.restoreComponents' => '復元対象コンポーネント',
    'backup.restore.errorLog' => 'エラーログ',
    'backup.restore.backupDetailsLogDoesntExist' => 'バックアップログがありません。',
    'backup.restore.dumpFailedSection' => 'エラーログ',
    'backup.restore.dumpFailed' => 'データを復元できません。このバックアップファイルは無効です。',
    'backup.restore.granularNotSupported' => '復元対象のオブジェクトを選択することができるのは、Plesk 12.0 以降で作成したバックアップを復元する場合に限られます。',
    'backup.restore.fullNotSupportedInResellerPowerUser' => 'バックアップからの全データの復元は、リセラーのパワーユーザービューではサポートされていません。復元するオブジェクトを選択してください。%%interfaceLink%% でインターフェースビューを変更することができます。',
    'backup.restore.interfaceLink' => 'インターフェース設定',
    'backup.restore.contentRestoreType' => '復元',
    'backup.restore.contentRestoreTypeSettingsOnly' => '選択したオブジェクトの構成のみ',
    'backup.restore.contentRestoreTypeFull' => '選択したオブジェクトの構成とコンテンツ',
    'backup.restore.errorWrongFormat' => 'バックアップは復元できません。構成ファイルが破損しています。',
    'backup.restore.errorContentError' => 'バックアップにコンテンツエラーが含まれているため、一部のバックアップデータを復元できません。',
    'backup.restore.warningSignError' => 'バックアップの署名を検証できません。このバックアップファイルは変更されているか、破損しているか、別のサーバまたは旧バージョンの Plesk で作成されている可能性があります。',
    'backup.restore.warningSignErrorNotAdmin' => 'このバックアップは Plesk 管理者のみが復元できます。',
    'backup.restore.warningPartial' => "増分バックアップのうち次の部分が見つかりません。 %%endl%%%%missedParts%%%%endl%% 一部のファイルが復元されない可能性があります。欠落部分をアップロードし、再び復元を試みてください。",
    'backup.restore.errorPackedInvalid' => 'バックアップを復元できません。バックアップファイルは変更されているか、破損しているか、旧バージョンの Plesk で作成されているか、紛失している可能性があります。',
    'backup.restore.warningDeprecatedBackupVersion' => '復元しようとしているバックアップは、サポートされない Plesk バージョンで作成されており、復元できません。古い Plesk バージョンからデータを移行するには、Plesk Migrator 拡張を使用してください。',
    'backup.restore.encryptionKeyError' => 'このバックアップの 1 つ以上のアカウントのパスワードが復元できないため、リセットされます。このバックアップは、別の Plesk サーバに作成され、その暗号化キーで暗号化された可能性があります。',
    'backup.restore.errorCorruptedContent' => '以下のファイルが見つからないか、破損しています：',
    'backup.restore.statusSection' => 'バックアップステータス',
    'backup.restore.statusDetails' => 'ステータスの詳細',
    'backup.restore.restoreBlocked' => 'バックアップを復元できません。',
    'backup.restore.restoreBlockedDescription' => '現在、タイプ %%backupType%% のバックアップを復元できません。復元するには、バックアップの所有者としてログインし、バックアップマネージャでこのバックアップ名をクリックします。',

    'backup.schedule.scheduleSection' => 'スケジュール',
    'backup.schedule.backupEnable' => 'このバックアップタスクをアクティブにする',
    'backup.schedule.backupPeriod' => 'バックアップタスクの実行スケジュール',
    'backup.schedule.on' => 'on',
    'backup.schedule.at' => 'at',
    'backup.schedule.every' => '毎',
    'backup.schedule.hours' => '{period, plural, other {時間}}',
    'backup.schedule.retainHours' => '時間',
    'backup.schedule.useIncremental' => '増分バックアップを使用',
    'backup.schedule.useIncrementalDisableHint' => '選択されたバックアップコンテンツは、フルバックアップの作成のみ可能です。',
    'backup.schedule.fullBackupPeriod' => 'フルバックアップを実行',
    'backup.schedule.hourly' => '時間単位',
    'backup.schedule.daily' => '毎日',
    'backup.schedule.weekly' => '毎週',
    'backup.schedule.monthly' => '毎月',
    'backup.schedule.yearly' => '毎年',
    'backup.schedule.days' => '日',
    'backup.schedule.weeks' => '週間',
    'backup.schedule.months' => 'ヶ月',
    'backup.schedule.years' => '年',
    'backup.schedule.backupTimeDescription' => 'タイムゾーン：%%timezone%%',
    'backup.schedule.systemTimeZone' => 'デフォルトのシステムタイムゾーン',
    'backup.schedule.first' => '1',
    'backup.schedule.last' => '最終',
    'backup.schedule.dayOfMonth' => '日',
    'backup.schedule.email' => 'このバックアップタスクを実行中にエラーが発生したときに、次の宛先に通知メールを送信',
    'backup.schedule.invalidFields' => '一部のフィールド（%%fields%%）が空であるか無効な値が含まれています。',
    'backup.schedule.maxDumpFiles' => '保存するフルバックアップファイルの最大数（スケジュール済みバックアップと手動バックアップの両方を含む）',
    'backup.schedule.retainDumpFilesFor' => 'フルバックアップの保持期間',
    'backup.schedule.maxDumpFilesUnlimitedDescription' => 'フルバックアップを自動削除しない場合、このフィールドは空欄にしてください。',
    'backup.schedule.maxDumpFilesLimitedDescription' => 'ホスティング事業者がサーバストレージに指定した上限は %%max%% です。したがって制限値は %%max%% 以下にしてください。',
    'backup.schedule.retainLimitedDescription' => 'ホスティング事業者によってサーバストレージに指定された上限は、{max, plural, other {フルバックアップ # 件}}です（スケジュールされたバックアップと手動バックアップをすべて含む）',
    'backup.schedule.backupToCloudIsNotAllowed' => 'リモートクラウドストレージに契約のスケジュール済みバックアップを保存する機能は有料であり、Plesk オンラインストアからご購入いただけます。',
    'backup.schedule.backupHourlyWarning' => '時間単位バックアップを有効にすると、サーバリソースの消費が増加する可能性があります。',
    'backup.schedule.titleHourly' => '時間単位バックアップの設定',
    'backup.schedule.titleDaily' => '日次バックアップの設定',
    'backup.schedule.titleWeekly' => '週次バックアップの設定',
    'backup.schedule.titleMonthly' => '月次バックアップの設定',
    'backup.schedule.titleCustom' => 'カスタムバックアップの設定',

    'backup.secure-backup.hint' => 'パスワードを使用して、Plesk データベースに含まれているユーザーのパスワードをバックアップ内で暗号化することができます。パスワード保護されたバックアップを復元するときにパスワードを指定しなければ、Plesk によってユーザーのパスワードがランダムに生成されます。',
    'backup.secure-backup.hintAdmin' => 'Plesk 暗号化キーまたはパスワードを使用して、バックアップ内に含まれる Plesk データベースのパスワードを暗号化できます。このキーは Plesk インストールごとに一意です。このキーで暗号化されたバックアップは、それが作成された Plesk インストールでのみ復元可能で、別の Plesk インストールでは復元できません。Plesk では、バックアップ内の機密データの一部が保護されません。リモートクラウドストレージにバックアップを保存し、クラウドストレージ側でバックアップの暗号化を有効にすることをお勧めします。',
    'backup.secure-backup.usePasswordProtection' => 'パスワード保護を使用する（推奨）',
    'backup.secure-backup.backupPasswordSource' => 'パスワードのタイプ',
    'backup.secure-backup.pleskKey' => 'Plesk の暗号化キー',
    'backup.secure-backup.userPassword' => '指定されたパスワード',
    'backup.secure-backup.password' => 'パスワード',
    'backup.secure-backup.passwordConfirmation' => 'パスワード再入力',

    'backup.subform.settingsSection' => 'バックアップ設定',
    'backup.subform.prefix' => 'バックアップ名にプレフィックスを追加',
    'backup.subform.comment' => 'コメント',
    'backup.subform.splitSize' => 'マルチボリュームバックアップを作成、ボリュームサイズ（MB）',
    'backup.subform.repository' => '保存場所',
    'backup.subform.repositoryDescription' => 'FTP（S）ストレージ設定が指定されていません。%%configure%%',
    'backup.subform.localAndSpecialRepositoryBackup' => 'サーバストレージと%%name%%の両方',
    'backup.subform.remoteRepositoryOption' => 'リモートストレージ',
    'backup.subform.remoteRepository' => 'リモートストレージ',
    'backup.subform.remoteRepositoryText' => 'リモートクラウドストレージを選択',
    'backup.subform.configureRemoteRepositories' => 'クラウドにバックアップを保存するには、<a href="%%url%%">リモートストレージを構成</a>してください。',
    'backup.subform.configureFtpRepository' => 'バックアップをオフサイトに保存するには、<a href="%%url%%">FTP ストレージを構成</a>してください。',
    'backup.subform.configureRemoteDesc' => 'バックアップをクラウドに保存するには、%%link%%してください。',
    'backup.subform.configureRemoteLink' => 'リモートストレージを構成',
    'backup.subform.configureFtpDesc' => 'バックアップをオフサイトに保存するには、%%link%%してください。',
    'backup.subform.configureFtpLink' => 'FTP ストレージを構成',
    'backup.subform.repositoryConfigure' => '構成',
    'backup.subform.email' => 'バックアップタスクの完了時に、次の宛先に通知メールを送信',
    'backup.subform.contentSection' => 'バックアップのコンテンツ',
    'backup.subform.domainConfiguration' => '構成',
    'backup.subform.domainConfigurationVhost' => 'ユーザーファイルおよびデータべース',
    'backup.subform.domainConfigurationFile' => 'ユーザーファイル',
    'backup.subform.domainConfigurationDatabase' => 'データベース',
    'backup.subform.domainConfigurationMail' => 'メールメッセージ',
    'backup.subform.content' => 'バックアップ',
    'backup.subform.backupAll' => 'すべての構成とコンテンツ',
    'backup.subform.backupConfiguration' => '構成のみ',
    'backup.subform.backupVhost' => 'メールメッセージ以外のすべての構成とコンテンツ',
    'backup.subform.backupMailFile' => 'ユーザーデータベースを除くすべての構成とコンテンツ',
    'backup.subform.backupMailDatabase' => 'ユーザーファイルを除くすべての構成とコンテンツ',
    'backup.subform.backupMail' => '構成とメールメッセージのみ',
    'backup.subform.backupDatabase' => '構成とユーザーデータベースのみ',
    'backup.subform.backupFile' => '構成とユーザーファイルのみ',
    'backup.subform.mssqlNativeBackup' => '可能であればネイティブ MS SQL バックアップ機能を使用',
    'backup.subform.mssqlNativeBackupAdmin' => 'ネイティブ MS SQL バックアップ機能を使用（リモートデータベースの場合、［ツールと設定］ >  ［データベースサーバ］でリモート MS SQL サーバのバックアップ設定を構成したことを確認してください）',
    'backup.subform.localRepository' => 'サーバストレージ',
    'backup.subform.localRepositoryPath' => 'サーバストレージ %%path%%',
    'backup.subform.backupNodeRepository' => '',
    'backup.subform.ftpRepository' => 'FTP（S）ストレージ（%%uri%%）の<a href="%%link%%">設定変更</a>',
    'backup.subform.ftpRepositoryText' => 'FTP（S）ストレージ（%%uri%%）',
    'backup.subform.type' => 'タイプ',
    'backup.subform.typeFullBackup' => 'フル',
    'backup.subform.typeIncremental' => '増分',
    'backup.subform.typeIncrementalDescription' => '前回のバックアップ後に変更されたウェブホスティングデータをバックアップします（データベースデータは常にフルバックアップされます）。',
    'backup.subform.incrementalNotAvailable' => '増分バックアップを作成するには、まずフルバックアップを作成してください。',
    'backup.subform.excludeLogs' => 'ログファイルを除外',
    'backup.subform.excludeFiles' => 'バックアップから特定のファイルを除外',
    'backup.subform.excludeFilesDescription' => 'ウェブスペース内のファイルのみを除外できます。ウェブスペースのルートを基準にして相対パスを指定します。個々のファイルはコンマで区切ってください。マスクシンボルの使用が許可されます（例： /somedir/log*）。',

    'backup.upload.uploadHint' => 'ここで Plesk ストレージにバックアップファイルをアップロードできます。最大ファイルサイズは 2 GB に制限されています。',
    'backup.upload.backupFile' => 'バックアップファイル',
    'backup.upload.removeLink' => '削除',
    'backup.upload.addFileLink' => '追加ファイルをアップロード',
    'backup.upload.backupSecuritySettings' => 'バックアップのセキュリティ設定',
    'backup.upload.signatureHint' => 'Plesk はバックアップファイルの構造と署名が有効であるかどうかをチェックします。変更されたファイル、破損ファイル、別のサーバで作成されたファイルは信頼できません。以下のオプションで、このようなファイルからデータを復元できます。このようなファイルをアップロードすると、セキュリティ上問題があるか、サーバが破壊する可能性があります。したがって、このオプションは、バックアップソースを信頼できる場合に限って選択してください。注記：11.5 より前の Plesk バージョンで作成したバックアップファイルには署名がないため、信頼できないと見なされます。このようなファイルは、ソースが信頼できる場合に復元してください。',
    'backup.upload.ignoreSign' => '有効な署名のないバックアップファイルをアップロード',
    'backup.upload.passwordHint' => 'このバックアップに対してパスワード保護を使用した場合、下のフィールドにパスワードを入力してください。パスワードを誤入力すると、警告が表示されますが、サーバへのバックアップファイルのアップロードは実行されます。バックアップを復元するときに、このパスワードの入力が再び要求されます。',
    'backup.upload.alreadyExistsWarning' => 'バックアップファイル %%fileName%% はサーバのローカルストレージに既に存在します。',
    'backup.upload.incorrectPasswordWarning' => '指定したパスワードが正しくありません。バックアップの復元中に、パスワードを再入力する必要があります。',
    'backup.upload.deprecatedDumpError' => 'アップロードしようとしているバックアップは、サポートされない Plesk バージョンで作成されており、インポートできません。古い Plesk バージョンからデータを移行するには、Plesk Migrator 拡張を使用してください。',
    'backup.upload.mailFormatWarning' => 'バックアップファイル %%fileName%% がストレージにアップロードされました。重要：バックアップファイル %%fileName%% には、サポートされないフォーマット（Plesk 8.3～8.6）が原因で復元できないメールコンテンツが含まれています。このメールコンテンツを復元するためには、Plesk バックアップツールを使用してこれをバックアップし、メールボックスコンテンツのバックアップオプションを選択し、メールサーバにダンプを復元するオプションを選択してください。',
    'backup.upload.corruptedSignatureAdminWarning' => 'アップロード済みのバックアップファイル（%%fileName%%）は、変更または破損しているか、別のサーバで作成されたものか、バックアップファイルの署名をサポートしていない旧バージョンの Plesk で作成されたものです。このバックアップファイルからデータを復元する前に、このファイルのソースを信頼できるか確認してください。',
    'backup.upload.corruptedSignatureAdminError' => 'バックアップファイル（%%fileName%%）をアップロードできません。このファイルは変更または破損しているか、別のサーバで作成されたものか、バックアップファイルの署名をサポートしていない旧バージョンの Plesk で作成されたものです。このバックアップを信頼できる場合、［有効な署名のないバックアップファイルをアップロード］オプションをオンにしてアップロードをやり直してください。',
    'backup.upload.corruptedSignatureUserWarning' => 'アップロード済みのバックアップファイル（%%fileName%%）は、変更または破損しているか、別のサーバまたは旧バージョンの Plesk で作成されています。',
    'backup.upload.corruptedSignatureUserError' => 'バックアップファイル（%%fileName%%）をアップロードできません。このファイルのデータは、変更または破損しているか、別のサーバまたは旧バージョンの Plesk で作成されています。このファイルのデータを復元するためには、ホスティング事業者までお問い合わせください。',
    'backup.upload.uploadError' => '%%fileName%% をサーバストレージ %%error%% にアップロードできません',
    'backup.upload.fileNotSelected' => 'アップロード用に選択されたファイルがありません。ファイルを少なくとも 1 つ選択してください。',
    'backup.upload.missedPartsWarning' => "増分バックアップのうち、次の部分がアップロードされていません。%%endl%%%%missedParts%%%%endl%% 欠落部分をアップロードしてください。",
    'backup.upload.unknownType' => '不明なオブジェクトタイプ',
    'backup.upload.storageLink' => '別のストレージ',
    'backup.upload.anotherStorage' => 'ダンプは%%storageLink%%にアップロードされました。',
    'backup.upload.resellerNotFound' => 'リセラー %%name%% が見つかりません。これを作成してから、アップロードしたダンプを復元してください。',
    'backup.upload.clientNotFound' => '顧客 %%name%% が見つかりません。これを作成してから、アップロードしたダンプを復元してください。',
    'backup.upload.domainNotFound' => 'ドメイン %%name%% が見つかりません。これを作成してから、アップロードしたダンプを復元してください。',

    'backup.web-content-dynamic.addButtonTitle' => 'ファイルを追加',
    'backup.web-content-dynamic.noItems' => 'ファイルが選択されていません',
    'backup.web-content-dynamic.hint' => 'チェックボックスでファイルとフォルダを選択してください。',
    'backup.web-content-dynamic.title' => 'ファイルを選択',
    'backup.web-content-dynamic.columnName' => '名前',
    'backup.web-content-dynamic.columnChangeDate' => '変更済み',
    'backup.web-content-dynamic.columnSize' => 'サイズ',
    'backup.web-content-dynamic.columnPermissions' => 'パーミッション',
    'backup.web-content-dynamic.columnUser' => 'ユーザー',
    'backup.web-content-dynamic.columnGroup' => 'グループ',
    'backup.web-content-dynamic.waitButtonTitle' => 'お待ちください',
    'backup.web-content-dynamic.loadingTitle' => '読み込み中...しばらくお待ちください。',

    'backup.invalidFields' => '一部のフィールドが空であるか無効な値が含まれています。',
    'backup.notEnoughDiskSpace' => '%%path%% には、バックアップの作成に十分なディスク容量がありません。空き容量が少なくとも %%required%% GB 必要です（空き容量は %%available%% GB）',

    'change-subscriptions-owner.ownerSection' => '新しい所有者',
    'change-subscriptions-owner.subscriptionsSection' => '選択した契約',
    'change-subscriptions-owner.owner' => '所有者',
    'change-subscriptions-owner.subscriptionName' => '契約',
    'change-subscriptions-owner.ownerName' => '所有者',
    'change-subscriptions-owner.currentIpAddress' => '現在の IP アドレス',
    'change-subscriptions-owner.newIpAddress' => '新しい IP アドレス',
    'change-subscriptions-owner.noIpAddress' => '使用可能な IP アドレスはありません',
    'change-subscriptions-owner.submit' => '再割り当て',
    'change-subscriptions-owner.warningCustom' => "契約は現在のサービスプランとの紐付けが解除され、「カスタム」になります。",
    'change-subscriptions-owner.warningEmptyPool' => "新しい所有者のプロバイダの IP プールが空です。プロバイダのプールに IP アドレスが少なくとも 1 つあることを確認してください。",

    'cgroups-settings.cgroupsSettingsTab' => 'RAM、CPU、ディスク I/O',
    'cgroups-settings.cgroupsSettingsTabDescription' => '契約によるシステムリソースの使用量に上限を設定します。Plesk はこの上限が超過されていないことを確認するために、Linux カーネルのコントロールグループ（cgroup）機能を使用します。',
    'cgroups-settings.cpuSettings' => 'CPU',
    'cgroups-settings.cpuSettingsDescription' => '各契約の CPU 使用率に上限を設定します。',
    'cgroups-settings.cpuPeriodLimit' => 'CPU 使用状況をチェックする期間',
    'cgroups-settings.percentUsageDescription' => 'サーバの合計 CPU 時間は %%total%%%%units%% です',
    'cgroups-settings.ramSettings' => 'RAM',
    'cgroups-settings.ramSettingsDescription' => '各契約の RAM 使用量に上限を設定します。契約でこの上限を超過すると、最も消費の多いプロセスが停止されます。',
    'cgroups-settings.ramPeriodLimit' => 'RAM 使用状況をチェックする期間',
    'cgroups-settings.diskSettings' => 'ディスク I/O',
    'cgroups-settings.diskReadSettings' => 'ディスク読取',
    'cgroups-settings.diskReadSettingsDescription' => '各契約のディスク読取帯域幅使用量に上限を設定します。',
    'cgroups-settings.diskReadPeriodLimit' => 'ディスク読取帯域幅の使用状況をチェックする期間',
    'cgroups-settings.diskWriteSettings' => 'ディスク書込',
    'cgroups-settings.diskWriteSettingsDescription' => '各契約のディスク書込帯域幅使用量に上限を設定します。',
    'cgroups-settings.diskWritePeriodLimit' => 'ディスク書込帯域幅の使用状況をチェックする期間',
    'cgroups-settings.limit' => '上限',
    'cgroups-settings.threshold' => '超過時に通知',
    'cgroups-settings.limitNotificationEnabled' => '通知は有効です',
    'cgroups-settings.periodFiveMinutes' => '5 分',
    'cgroups-settings.periodHour' => '1 時間',
    'cgroups-settings.periodDay' => '1 日（24 時間）',
    'cgroups-settings.mb' => 'MB',
    'cgroups-settings.mbs' => 'MB/秒',

    'custom-button.privateLabel' => '自分にのみ表示する',
    'custom-button.textLabel' => 'ボタンラベル',
    'custom-button.tooltipLabel' => 'ヘルプのテキスト',
    'custom-button.iconLabel' => '背景画像',
    'custom-button.priorityLabel' => '優先度',
    'custom-button.urlLabel' => 'URL',
    'custom-button.urlParamsLabel' => 'URL にパラメータを追加する',
    'custom-button.placeLabel' => '場所',
    'custom-button.internalLabel' => 'URL を Plesk で開く',
    'custom-button.internalDescription' => 'URL を Plesk 内のページで開くか、新しいブラウザウィンドウで開くかを指定してください。',
    'custom-button.noFrameLabel' => 'フレームを使用しない',
    'custom-button.noFrameDescription' => 'Plesk 拡張やアプリケーションにリンクするカスタムボタンを顧客パネルに追加する場合、この拡張/アプリケーションの表示形態（フレーム内に表示、Plesk GUI の一部として表示）を指定できます。',
    'custom-button.urlParamLabel_dom_id' => '契約 ID、ドメイン ID、およびドメインエイリアス ID を含める',
    'custom-button.urlParamLabel_dom_name' => 'プライマリドメイン名を含める',
    'custom-button.urlParamLabel_ftp_user' => 'FTP ユーザー名を含める',
    'custom-button.urlParamLabel_ftp_pass' => 'FTP パスワードを含める',
    'custom-button.urlParamLabel_cl_id' => '顧客 ID を含める',
    'custom-button.urlParamLabel_cname' => '顧客の会社名を含める',
    'custom-button.urlParamLabel_pname' => '顧客の担当者名を含める',
    'custom-button.urlParamLabel_email' => '顧客のメールアドレスを含める',
    'custom-button.buttonPlace_navigation' => '共通アクセス',
    'custom-button.buttonPlace_admin' => '管理者のホームページ',
    'custom-button.buttonPlace_admin-settings' => '管理者の［ツールと設定］ページ',
    'custom-button.buttonPlace_reseller' => "リセラーのホームページ",
    'custom-button.buttonPlace_reseller-settings' => 'リセラーの［ツールとユーティリティ］ページ',
    'custom-button.buttonPlace_client' => '顧客のホームページ',
    'custom-button.buttonPlace_domain' => "契約の［ウェブサイトとドメイン］ページ",
    'custom-button.buttonPlace_domain_powerUser' => "ウェブスペースの［ウェブサイトとドメイン］ページ",
    'custom-button.buttonPlace_domain-properties' => 'ウェブサイトツール',
    'custom-button.fileNotUploaded' => 'ファイルをアップロードできません。',

    'database-server-change-password.adminPassword' => '管理者パスワード',
    'database-server-change-password.success' => '管理者のパスワードが正常に更新されました。',

    'database-server-create.general' => '全般',
    'database-server-create.type' => 'データベースサーバタイプ',
    'database-server-create.unixSocket' => '（ローカル接続）',
    'database-server-create.host' => 'ホスト名または IP アドレス',
    'database-server-create.port' => 'ポート番号',
    'database-server-create.portDescription' => 'デフォルトポート番号を使用する場合は空白にします。',
    'database-server-create.version' => 'データベースサーババージョン',
    'database-server-create.default' => 'このサーバを %%type%% のデフォルトにする',
    'database-server-create.externalConnections' => 'ローカル MariaDB/MySQL サーバで外部接続を受け付ける',
    'database-server-create.externalConnectionsDescription' => 'この設定を変更すると、ローカル MariaDB/MySQL サーバが再起動します。Plesk に登録された他の MariaDB/MySQL サーバへのリモートアクセスを有効にするには、サーバの構成を手動で変更してください。',
    'database-server-create.authentication' => '認証',
    'database-server-create.authenticationAddDescription' => 'Plesk がデータベースサーバへのアクセスに使用するデータベース管理者のログイン情報を指定してください。これらのログイン情報の管理者アカウントがデータベースサーバに登録されている必要があります。',
    'database-server-create.authenticationEditDescription' => 'Plesk がデータベースサーバへのアクセスに使用するログイン情報を変更します。これらのログイン情報は、データベース管理者のログイン情報と同じである必要があります。例えば、管理者のログイン情報をデータベースサーバで変更した場合、後で Plesk でも変更する必要があります。',
    'database-server-create.authenticationChangeDescription' => 'Plesk がデータベースサーバーへのアクセスに使用するログイン情報を変更します。以下でユーザー名またはパスワードを変更すると、管理者権限を持つデータベースユーザーアカウントがデータベースサーバと Plesk の両方で更新されます。',
    'database-server-create.adminLogin' => 'ユーザー名',
    'database-server-create.adminPassword' => 'パスワード',
    'database-server-create.createSuccess' => 'データベースサーバが正常に作成されました。',
    'database-server-create.createError' => 'データベースサーバが作成されましたがエラーがあります：%%error%%',
    'database-server-create.updateSuccess' => 'データベースサーバが正常に更新されました。',
    'database-server-create.updateError' => 'データベースサーバが更新されましたがエラーがあります: %%error%%。',
    'database-server-create.backupSettings' => 'バックアップ',
    'database-server-create.backupTempDir' => '一時ディレクトリ',
    'database-server-create.backupTempDirDescription' => 'MS SQL サーバが存在するリモートサーバにおける物理フォルダへのパス。MS SQL サーバは、一時バックアップファイルの読み取りおよび書き込みのためにこのフォルダにアクセスできる必要があります。例：C:¥¥DirectoryPath',
    'database-server-create.backupNetworkTempDir' => '一時ネットワークディレクトリ',
    'database-server-create.backupNetworkTempDirDescription' => '上記の物理フォルダにマッピングされたネットワークシェアへのパス。Plesk は、バックアップファイルのダウンロードとアップロードのために共有フォルダにアクセスします。例：\\\\ServerName\\DirectoryPath',
    'database-server-create.backupNetworkUser' => 'ユーザー名',
    'database-server-create.backupNetworkUserDescription' => 'リモートサーバーに作成されたネットワークユーザーのユーザー名。例: ServerName\\UserName。ユーザーには、上に指定した共有フォルダへのアクセス権が必要です。',
    'database-server-create.backupNetworkPassword' => 'パスワード',

    'domain.connection-info.title' => '接続情報',
    'domain.connection-info.systemUserCredentials' => 'システムユーザーのログイン情報',
    'domain.connection-info.systemUserCredentialsHint' => 'FTP 経由のアクセスは常に有効です。SSH またはリモートデスクトップ経由のアクセス — %%details%%のみ。',
    'domain.connection-info.systemUserCredentialsHintDetails' => 'パーミッションが付与されている',
    'domain.connection-info.systemUserRemoveAccessEnabled' => 'SSH またはリモートデスクトップ経由のアクセスは有効で、状態を管理することはできません。',
    'domain.connection-info.systemUserRemoveAccessDisabled' => 'SSH またはリモートデスクトップ経由のアクセスは無効で、状態を管理することはできません。',
    'domain.connection-info.ipAddress' => 'IP アドレス',
    'domain.connection-info.copyIpAddressTooltip' => 'IP アドレスをクリップボードにコピー',
    'domain.connection-info.username' => 'ユーザー名',
    'domain.connection-info.copyUsernameTooltip' => 'ユーザー名をクリップボードにコピー',
    'domain.connection-info.password' => 'パスワード',
    'domain.connection-info.changeSystemUserPasswordTitle' => 'システムユーザーパスワードの変更',
    'domain.connection-info.changePasswordTooltip' => 'パスワード変更',
    'domain.connection-info.newPassword' => '新規パスワード',
    'domain.connection-info.manageAccess' => 'アクセス管理',
    'domain.connection-info.additionalFtpAccounts' => '追加 FTP アカウント',
    'domain.connection-info.database' => 'データベース',
    'domain.connection-info.databaseHint' => '%%number%% データベースのうち 1 つがこの契約に属しています。',
    'domain.connection-info.databaseNotCreatedHint' => 'データベースは作成されていません。',
    'domain.connection-info.databaseType.mysql' => 'MySQL',
    'domain.connection-info.databaseType.mssql' => 'MS SQL サーバ',
    'domain.connection-info.databaseType.postgresql' => 'PostgreSQL',
    'domain.connection-info.databaseType.mariadb' => 'MariaDB',
    'domain.connection-info.databaseType.percona' => 'Percona',
    'domain.connection-info.databaseHost' => 'ホスト',
    'domain.connection-info.databaseHostValue' => '%%value%%（%%fork%%）',
    'domain.connection-info.databaseName' => 'データベース名',
    'domain.connection-info.addDatabase' => 'データベースを追加',
    'domain.connection-info.manageDatabases' => 'データベースを管理',
    'domain.connection-info.phpMyAdmin' => 'PhpMyAdmin',
    'domain.connection-info.changeDatabaseUserPasswordTitle' => 'データベースユーザーのパスワード変更',
    'domain.connection-info.changeDatabaseUserPasswordNotice' => 'ここで変更した後で、忘れずにアプリケーションの構成ファイルでパスワードを更新してください。',
    'domain.connection-info.buttonSave' => '保存',
    'domain.connection-info.buttonSaving' => '保存中...',
    'domain.connection-info.buttonCancel' => 'キャンセル',
    'domain.connection-info.copyHostTooltip' => 'ホスト名をクリップボードにコピー',
    'domain.connection-info.copyDatabaseNameTooltip' => 'データベース名をクリップボードにコピー',
    'domain.connection-info.copyDatabaseUserTooltip' => 'データベースユーザーをクリップボードにコピー',

    'domain.move.title' => 'ドメイン %%name%% を移動',
    'domain.move.hint' => 'ドメインは、そのコンテンツ、構成ファイル、ログファイル、APS アプリケーションを含めて新しい契約に移動されます。',
    'domain.move.hintMain' => 'ドメインは、そのコンテンツ、構成ファイル、ログファイル、データベース、データベースユーザー、追加 FTP ユーザー、スケジュール済みタスク、SMB ユーザ、APS アプリケーションを含めて新しい契約に移動されます。',
    'domain.move.hintSubdomains' => 'サブドメイン %%subdomains%% は親ドメインとともに移動されます。',
    'domain.move.hintAliases' => 'ドメインエイリアス %%aliases%% は親ドメインとともに移動されます。',
    'domain.move.hintSubdomainsAndAliases' => 'サブドメイン %%subdomains%% とエイリアス %%aliases%% は親ドメインとともに移動されます。',
    'domain.move.labelDatabases' => 'ドメインを移動した後で、［データベース］タブを開いて関連するデータベースを移動してください。',
    'domain.move.hintDatabases' => '必要であれば、データベースを個別に移動してください。',

    'domain.move.Form.submitButton' => '移動',
    'domain.move.Form.cancelButton' => 'キャンセル',

    'domain.move.selectTarget' => '利用可能な契約',
    'domain.move.nothingFound' => '何も見つかりませんでした',
    'domain.move.targetIsRequred' => 'ドメインの移動先にする契約を選択してください。',
    'domain.move.selectNewSubscription' => '新規契約を作成',
    'domain.move.ipv4Address' => 'IPv4 アドレス',
    'domain.move.ipv4AddressHint' => 'ウェブサイトのホストに使用されている IP アドレスは、ウェブサイトの仮想ホストのネットワークアドレスです。',
    'domain.move.ipv6Address' => 'IPv6 アドレス',
    'domain.move.ipv6AddressHint' => 'ウェブサイトのホストに使用されている IP アドレスは、ウェブサイトの仮想ホストのネットワークアドレスです。',
    'domain.move.ipAddressIsNotSelected' => 'IP アドレスを 1 つ以上選択してください。',
    'domain.move.username' => 'ユーザー名',
    'domain.move.usernameHint' => 'ウェブサイトに紐付けられたシステムユーザーアカウント。ホストされているファイルに FTP または SSH 経由でアクセスするために使用されます。',
    'domain.move.usernameIsRequred' => 'ユーザー名を指定する必要があります。',
    'domain.move.password' => 'パスワード',
    'domain.move.passwordIsRequred' => 'パスワードを指定する必要があります。',
    'domain.move.noAvailableSubscriptions' => '利用可能な契約がありません',
    'domain.move.noWebHosting' => 'ドメインにウェブホスティングがないため、現時点ではシステムユーザーは作成されません。',

    'domain.rename.title' => 'ドメイン名を変更',
    'domain.rename.titleAlias' => 'ドメインエイリアス名を変更',
    'domain.rename.hint' => 'ドメイン名 %%domainName%% を変更しています',
    'domain.rename.hintAlias' => 'ドメインエイリアス名 %%domainName%% を変更しています',
    'domain.rename.name' => '新しいドメイン名',
    'domain.rename.nameAlias' => '新しいドメインエイリアス名',
    'domain.rename.domainNameIsRequired' => '必須フィールドが空です。 値を入力してください。',
    'domain.rename.submitButton' => '変更',
    'domain.rename.submitButtonProgress' => '変更中',
    'domain.rename.successMessage' => 'ドメイン名 %%oldName%% は %%newName%% に変更されました。',
    'domain.rename.successMessageAlias' => 'ドメインエイリアス名 %%oldName%% は %%newName%% に変更されました。',

    'domain.rename.Form.cancelButton' => 'キャンセル',

    'domain.outgoing-messages.hint' => 'このドメインからの送信メッセージ数の上限を変更することができます。指定した上限を超えてメッセージを送信することはできません。',
    'domain.outgoing-messages.domainOutgoingMessagesSubscriptionDefault' => 'デフォルト（%%domainOutgoingMessages%% 通/時間）',
    'domain.outgoing-messages.domainOutgoingMessagesSpecificHint' => '通/時間',
    'domain.outgoing-messages.domainOutgoingMessages' => '送信メッセージ数の上限',
    'domain.outgoing-messages.domainOutgoingMessagesCustomLimit' => 'このドメインのカスタム値',

    'domain.tech-domain-name.title' => 'ドメイン名を選択',
    'domain.tech-domain-name.techDomainTitle' => '一時ドメイン名',
    'domain.tech-domain-name.customDomainTitle' => '登録済みドメイン名',
    'domain.tech-domain-name.techDomainText' => '登録済みのドメイン名はありません',
    'domain.tech-domain-name.customDomainText' => '登録済みのドメイン名はあります',
    'domain.tech-domain-name.techDomain' => '一時ドメイン名',
    'domain.tech-domain-name.customDomain' => '登録済みドメイン名',
    'domain.tech-domain-name.domainName' => 'ドメイン名',
    'domain.tech-domain-name.techDomainDesc' => '適切なドメイン名を登録して購入するまで、一時ドメイン名がサイトへのアクセスに使用されます。このドメイン名は以下の条件に基づいて無料で提供されます。',
    'domain.tech-domain-name.techDomainRandom' => '名前はランダムに生成されます',
    'domain.tech-domain-name.techDomainDns' => '.plesk.page DNS ゾーンでホストされます',
    'domain.tech-domain-name.techDomainSwitch' => '後でいつでも、ドメイン設定でドメインの名前を変更することで、登録済みドメイン名に切り替えることができます。',
    'domain.tech-domain-name.error' => '予期しないエラーが発生しました。',
    'domain.tech-domain-name.errorNoIpAddress' => 'IP アドレスを選択する必要があります。',
    'domain.tech-domain-name.generating' => '生成中...',

    'get-password.label' => 'パスワードをリセット',
    'get-password.text' => 'Plesk に登録されたメールアドレスまたはユーザー名を入力すると、パスワードのリセットメールが届きます。',
    'get-password.emailLabel' => 'メールアドレス',
    'get-password.loginLabel' => 'ユーザー名',
    'get-password.send' => '送信',
    'get-password.cancel' => 'キャンセル',
    'get-password.errorInvalidEmail' => 'メールアドレスが認識されませんでした。再確認してやり直してください。',
    'get-password.messageSend' => "パスワードのリセットメールが、関連するメールアドレスに送信されました。\nメールが届かない場合、Plesk 管理者までお問い合わせください。",
    'get-password.rateLimitReached' => "パスワードリセットの試行回数が多すぎます。後で再試行してください。",
    'iis-settings.formGeneralHint' => 'デフォルト値を変更して、ウェブサイトの IIS ウェブサーバ設定を指定することができます。カスタム IIS 構成は、ウェブサイトのインデックスファイルに新しいファイルタイプを使用したい場合や、特定のファイル名拡張子と特定の MIME タイプを関連付けたい場合に便利です。デフォルト値はホスティング事業者によって定義されています。',
    'iis-settings.formGeneralHint_powerUser' => 'このウェブサイトの IIS ウェブサーバ設定を指定することができます。カスタム IIS 構成は、ウェブサイトのインデックスファイルに新しいファイルタイプを使用したい場合や、特定のファイル名拡張子と特定の MIME タイプを関連付けたい場合に便利です。デフォルト値にすると、IIS はデフォルト構成に定義されたディレクティブを使用します。',
    'iis-settings.virtualDirectoryLoadError' => '指定した仮想ディレクトリのプロパティを取得できません。%%errorMessage%%',
    'iis-settings.general' => '共通設定',
    'iis-settings.example' => "例：\n%%example%%",
    'iis-settings.settingOn' => 'オン',
    'iis-settings.settingOff' => 'オフ（デフォルト）',
    'iis-settings.settingDefault' => 'デフォルト',
    'iis-settings.settingCustom' => 'カスタム値を入力',
    'iis-settings.mimeTypes' => 'MIME タイプ',
    'iis-settings.mimeTypesExample' => "text/plain .mytxt\nimage/jpeg .myjpeg",
    'iis-settings.mimeTypesFullDescription' => 'MIME タイプは、ファイルの拡張子とファイルタイプを関連付けます。通常は、一般的なファイルタイプ用にカスタムファイル拡張子を作成するために使用されます。',
    'iis-settings.documents' => 'デフォルトドキュメント',
    'iis-settings.documentsOff' => '無効',
    'iis-settings.documentsCustom' => '値を入力',
    'iis-settings.documentsExample' => "Index.html\nIndex.htm\nIndex.cfm",
    'iis-settings.documentsFullDescription' => 'ブラウザがサイト内のドキュメント名を指定しない場合、IIS は既定のデフォルトドキュメントを探し、最初に検出されたドキュメントを提供します。デフォルトドキュメントが設定されていない場合、ディレクトリブラウジングをオンにすると、索引ページではなくディレクトリリスティングがブラウザに表示されます。',
    'iis-settings.expires' => '期限切れ',
    'iis-settings.expiresFullDescription' => 'ウェブサーバは「期限切れ」応答ヘッダをウェブページに追加します。期限切れタイムスタンプは、ウェブページがリクエストされた時間に、上に指定された時間を加算することで計算されます。',
    'iis-settings.expiresUnitDays' => '日',
    'iis-settings.expiresUnitHours' => '時間',
    'iis-settings.expiresUnitMinutes' => '分',
    'iis-settings.expiresUnitSeconds' => '秒',
    'iis-settings.headers' => '追加ヘッダ',
    'iis-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000; includeSubdomains;\nX-Frame-Options: DENY",
    'iis-settings.headersFullDescription' => 'ウェブサーバにより、指定した HTTP 応答ヘッダが追加されます。',
    'iis-settings.directoryBrowsing' => 'ディレクトリ参照',
    'iis-settings.directoryBrowsingDescription' => 'ユーザーに対し、デフォルト索引ページが使用できない場合などに、ウェブブラウザでのサイトのディレクトリリスティングの参照を許可します。',
    'iis-settings.securityTabDirectory' => 'ディレクトリセキュリティ設定',
    'iis-settings.allowAnonymous' => '匿名認証',
    'iis-settings.allowAnonymousDescription' => '匿名認証により、ユーザーはサイトのパブリックコンテンツにアクセスできますが、パスワード保護されたサイトコンテンツおよびファイルシステムレベルで保護されたコンテンツを使用することはできません。',
    'iis-settings.allowWindows' => 'Windows 認証',
    'iis-settings.allowWindowsDescription' => 'Windows 認証（旧名 NTLM）は、ファイルシステムレベルでサイトのコンテンツを保護します。',
    'iis-settings.requireSsl' => 'SSL/TLS が必要',
    'iis-settings.requireSslDescription' => 'サイトで SSL/TLS サポートが有効になっている場合、このオプションを選択するとウェブクライアント（ブラウザ）に対して HTTPS 接続の使用が強制されます。',
    'iis-settings.securityTabIpDeny' => 'アクセス制限設定',
    'iis-settings.deny' => 'サイトへのアクセスを拒否',
    'iis-settings.denyOff' => 'デフォルト',
    'iis-settings.denyCustom' => 'カスタム値を入力',
    'iis-settings.allow' => '除外',
    'iis-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\n指定されたホストとネットワークに対して、このサイトへのアクセスを禁止します。すべての接続を拒否するには「*」を使用します。",
    'iis-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\n指定したホストとネットワークは、サイトへのアクセスが許可されます。",
    'iis-settings.dynamicIpSecurity' => 'IIS Dynamic IP Restriction による DoS 攻撃の阻止',
    'iis-settings.isDenyByConcurrentRequests' => '1 つの IP アドレスからの同時要求数に基づいて IP アドレスを拒否する',
    'iis-settings.maxConcurrentRequests' => '同時要求の最大数',
    'iis-settings.isDenyByRequestRate' => '一定期間内の要求数に基づいて IP アドレスを拒否する',
    'iis-settings.maxRequests' => '要求の最大数',
    'iis-settings.requestInterval' => '期間（ミリ秒）',

    'ip-addresses-selector.ipAddress' => 'IP アドレス',
    'ip-addresses-selector.ipv4Address' => 'IPv4 アドレス',
    'ip-addresses-selector.ipv4AddressHint' => "ウェブサイトのホストに使用されている IP アドレスは、ウェブサイトの仮想ホストのネットワークアドレスです。",
    'ip-addresses-selector.ipv6Address' => 'IPv6 アドレス',
    'ip-addresses-selector.ipv6AddressHint' => "ウェブサイトをホスティングしている IP アドレス。ウェブサイトの仮想ホストのネットワークアドレスです。",
    'ip-addresses-selector.noIpAddressHint' => 'なし',
    'ip-addresses-selector.shared' => '共有',
    'ip-addresses-selector.exclusive' => '専用',
    'ip-addresses-selector.ipV6OnlyNotSupported' => 'FTP サーバが IPv6 をサポートしていません。IPv4 アドレスを少なくとも 1 つ割り当ててください。これを行わないと、FTP 経由でサーバにファイルをアップロードできなくなります。',

    'license-key-revert.description' => 'ライセンスキーは以下のプロパティに基づき復旧されます。',
    'license-key-revert.submitButton' => 'ロールバック',

    'license-key-upload.description' => 'アクティベーションコードを入力してライセンスキーをインストールします。',
    'license-key-upload.descriptionWithFileUpload' => 'アクティベーションコードを入力するかライセンスキーファイルをアップロードして、ライセンスキーをインストールします。',
    'license-key-upload.type' => '以下のいずれかを選択：',
    'license-key-upload.code' => 'アクティベーションコードを入力',
    'license-key-upload.codeDescription' => '受信したアクティベーションコードを貼り付けます。',
    'license-key-upload.file' => 'ライセンスキーファイルをアップロード',
    'license-key-upload.fileDescription' => 'ライセンスキーが含まれるファイルへのパスを指定してください。',
    'license-key-upload.submitButton' => 'インストール',

    'log-rotation.customLogsDescription' => 'カスタムログはローテーションされていません。',
    'log-rotation.logRotation' => 'ログローテーション',
    'log-rotation.logRotationCondition' => 'ログローテーション条件',
    'log-rotation.logRotationBySize' => 'サイズ単位',
    'log-rotation.logRotationByTime' => '時間単位',
    'log-rotation.logRotationDaily' => '毎日',
    'log-rotation.logRotationWeekly' => '毎週',
    'log-rotation.logRotationMonthly' => '毎月',
    'log-rotation.logRotationSizeDescription' => 'サイズは %%min%%～%%max%% kB にする必要があります。',
    'log-rotation.maximumNumberOfFiles' => '最大ログファイル数',
    'log-rotation.compress' => 'ログファイルを圧縮',
    'log-rotation.sendLogToEmail' => 'Plesk はウェブサーバと FTP サーバのログファイルからデータを取得後、このアドレスにログファイルをメール送信します。',
    'log-rotation.kb' => 'KB',
    'log-rotation.logRotationPeriodGreater' => '期間がサーバ全体の限度 %%max%% を超えてはいけません。',

    'login.loginLabel' => 'ユーザー名',
    'login.passwdLabel' => 'パスワード',
    'login.loginButtonLabel' => 'ログイン',
    'login.enterUsername' => 'ユーザー名を入力してください。',
    'login.enterPassword' => 'パスワードを入力してください。',
    'login.whatUsernamePassword' => 'どのユーザー名とパスワードを使用しますか？',
    'login.forgotPasswordLabel' => 'パスワードを忘れた場合',
    'login.cookies' => 'Plesk の Cookie ポリシー',
    'login.avoidSSLWarningsMsg' => 'Plesk ログイン時に SSL に関する警告を回避するには、%%link%% を使用してください',
    'login.digitalOceanMsg' => 'DigitalOcean で Plesk を使用するのは初めてですか？「root」と、このドロップレットの作成時に入力したパスワードを使用してログインしてください。%%link%%',
    'login.amazonLightsailMsg' => 'Lightsail で Plesk を使用するのは初めてですか？SSH 経由でサーバにアクセスし、「plesk login」コマンドを使用してください。%%link%%',
    'login.readGuide' => '完全版ガイドをお読みください。',
    'login.mobileApplicationMessage' => 'エクスペリエンス向上のために、%%name%% アプリケーションをインストールすることをお勧めします。',
    'login.mobileApplicationInstall' => '今すぐインストール',
    'login.mobileApplicationHide' => 'いいえ、必要ありません',

    'force-reset-password.saveButton' => '保存',
    'force-reset-password.title' => 'パスワード変更',
    'force-reset-password.passwordLabel' => '新規パスワード',

    'panel-access.title' => 'Plesk URL のカスタマイズ',
    'panel-access.hint' => 'Plesk へのログイン用カスタム URL を選択してください。これにより、ポート %%httpsPort%% 経由での Plesk ログインが不可能になることはありません。%%link%%',
    'panel-access.details' => '詳細',
    'panel-access.proxyEnabled' => 'サーバの IP アドレスに解決されるがホスティングに使用されない、すべてのドメインまたはサブドメイン',
    'panel-access.proxyDomain' => 'サーバの IP アドレスに解決されるがホスティングに使用されない、指定されたドメインまたはサブドメイン',
    'panel-access.proxyDisabled' => 'カスタム URL はありません。https://<server-IP-or-hostname>:%%httpsPort%% のみです',

    'panel-access.Form.submitButton' => '保存',
    'panel-access.Form.cancelButton' => 'キャンセル',

    'panel-access.domainNameIsRequired' => 'ドメイン名を指定する必要があります。',
    'panel-access.successMessage' => '選択されたログイン方法は適用されました。',
    'panel-access.notSupported' => 'Plesk で、選択したログイン方法がサポートされていません。',
    'panel-access.notViaDomainName' => 'このログイン方法を適用するには、最初のオプション（［...すべてのドメインまたはサブドメイン］）を選択し、https://%%domainName%% 経由で Plesk にログインしてから、2 番目のオプションを選択してください。',
    'panel-access.notViaPort' => 'このログイン方法を適用するには、まず Plesk に https://<server-IP-or-hostname>:%%httpsPort%% からログインしてください。',

    'php-settings.performance' => 'パフォーマンスとセキュリティの設定',
    'php-settings.performanceSettingsNote' => 'これらの値は、ドメインが「ホスティングパフォーマンス設定管理」権限を持つ契約に属していない限り、.htaccess、php.ini、または .user.ini ファイルを介してドメインごとに変更することはできません。',
    'php-settings.settings' => '共通設定',
    'php-settings.fastCgiSettings' => 'FastCGI 設定',
    'php-settings.fpmSettings' => 'PHP-FPM 設定',
    'php-settings.enableFastcgi' => 'FastCGI 設定を有効化',
    'php-settings.plainTextEditing' => '追加ディレクティブ',
    'php-settings.placeAdditionalCustomizationDirectivesHere' => '以下のフィールの入力することで、任意の PHP パラメータを定義できます。ディレクティブは PHP 構成に追加されます。php.ini と同じ構文を使用してください。たとえば、mSQL 拡張を自動的に読み込むには、「extension=msql.so」という行を追加します。',
    'php-settings.placeAdditionalCustomizationDirectivesHereAddonPlan' => '特定の PHP パラメータが見つからない場合、下のフィールドに追加してください。これらの追加ディレクティブは、メインサービスプランのディレクティブとマージされます。php.ini と同じ構文を使用してください。例えば、mSQL 拡張モジュールを自動的にロードしたい場合、「extension=msql.so」という行を追加します。',
    'php-settings.placeFpmAdditionalCustomizationDirectivesHere' => '以下のフィールの入力することで、任意の PHP パラメータを定義できます。ディレクティブは PHP 構成に追加されます。php.ini と同じ構文を使用してください。たとえば、mSQL 拡張を自動的に読み込むには、「extension=msql.so」という行を追加します。PHP-FPM プール設定をカスタマイズするには、[php-fpm-pool-settings] セパレータを追加し、その下に必要な設定を入力します。',
    'php-settings.additionalConfigurationDirectives' => '追加構成ディレクティブ',
    'php-settings.defaultValue' => 'デフォルト',
    'php-settings.predefinedValue' => '値を選択',
    'php-settings.customValue' => 'カスタム値を入力',
    'php-settings.phpSettingDescription_memory_limit' => 'スクリプトが確保できる最大メモリを、バイト数で指定します。',
    'php-settings.phpSettingDescription_max_execution_time' => 'スクリプトが強制終了されるまでの最大時間を、秒単位で指定します。',
    'php-settings.phpSettingDescription_max_input_time' => 'スクリプトが入力を解析する最大の時間を、秒単位で指定します。',
    'php-settings.phpSettingDescription_post_max_size' => 'POST メソッドで送信可能な最大データ量（バイト）です。通常、upload_max_filesize より大きく、memory_limit より小さく設定します。',
    'php-settings.phpSettingDescription_upload_max_filesize' => 'アップロードするファイルの最大サイズ（バイト）です。',
    'php-settings.phpSettingDescription_safe_mode' => 'PHP セーフモードは、主にセキュリティ上の理由でスクリプトの実行に様々な制約を加えます。',
    'php-settings.phpSettingDescription_safe_mode_include_dir' => 'safe_mode ディレクティブが有効な場合、指定したディレクトリ内のファイルは PHP スクリプトでアクセスできます。ディレクトリは include_path に存在する必要があります。',
    'php-settings.phpSettingDescription_safe_mode_exec_dir' => 'safe_mode ディレクティブが有効な場合、指定したディレクトリ内のプログラムは PHP スクリプトで実行できます。',
    'php-settings.phpSettingDescription_include_path' => 'スクリプトがファイルを 探すディレクトリのリスト（システムの PATH 変数と同じフォーマットにします）。ディレクトリを区切るには、Linux ではコロン（:）、Windows ではセミコロン（;）を使用します。',
    'php-settings.phpSettingDescription_sessionsave_path' => 'PHP セッションファイルを保存するディレクトリです。',
    'php-settings.phpSettingDescription_mailforce_extra_parameters' => 'mail() 関数の追加パラメータです。',
    'php-settings.phpSettingDescription_register_globals' => 'EGPCS（環境、GET、POST、Cookie、サーバ）変数のコンテンツをグローバル変数として登録します。',
    'php-settings.phpSettingDescription_open_basedir' => 'PHP スクリプトからアクセスできるファイルを、指定したディレクトリ内のファイルに限定します。ディレクトリを区切るには、Linux ではコロン（:）、Windows ではセミコロン（;）を使用します。',
    'php-settings.phpSettingDescription_error_reporting' => 'エラーレポートのレベルを指定します。',
    'php-settings.phpSettingDescription_display_errors' => 'エラーを出力に含めるかどうかを決定します。',
    'php-settings.phpSettingDescription_log_errors' => 'PHP エラーをログに記録するかどうかを指定します。',
    'php-settings.phpSettingDescription_allow_url_fopen' => 'PHP ファイル関数を使用してリモートロケーションから FTP または HTTP 経由でデータを取得することを許可します。',
    'php-settings.phpSettingDescription_file_uploads' => 'HTTP 経由のファイルアップロードを許可します。',
    'php-settings.phpSettingDescription_short_open_tag' => 'PHP タグの短縮型 ( ) を許可します。',
    'php-settings.phpSettingDescription_magic_quotes_gpc' => 'GPC（Get/Post/Cookie）処理に関する magic_quotes の状態\nを設定します。magic_quotes が on の場合、単一引用符、二重引用符、バックスラッシュ、NULL にはすべて自動的にバックスラッシュでエスケープ処理が行われます。',
    'php-settings.phpSettingDescription_disable_functions' => 'このディレクティブにより、特定の機能を無効にできます。関数名のコンマ区切りリストを受け付けます',
    'php-settings.phpSupport' => 'PHP サポート',
    'php-settings.phpRunAs' => 'PHP の実行タイプ',
    'php-settings.phpVersion' => 'PHP バージョン',
    'php-settings.phpHandlerOutdated' => '（サポート終了）',
    'php-settings.phpHandlerDeprecated' => '（非推奨）',
    'php-settings.phpServedByApache' => '＋Apache',
    'php-settings.phpServedByNginx' => '＋nginx',
    'php-settings.phpSettingsPhpVersion' => 'ご使用の PHP バージョンは %%version%% です。',
    'php-settings.phpSettingsPhpDisabled' => 'PHP はオフになっています。',
    'php-settings.phpHandlerTypeHint' => '以下は、ウェブサイトの PHP 構成の詳細です。ホスティング事業者から該当するパーミッションが付与されていれば、PHP 構成を変更することができます。',
    'php-settings.fpmDedicatedHandlerHint' => 'このハンドラを使用すると、ウェブサイトの安定性は向上しますが、メモリ消費量も増加します。',
    'php-settings.phpHandlerChangeHint' => 'PHP ハンドラの設定を変更しました。これらの変更を保存すると、サーバの構成のために、ウェブサイトの PHP スクリプトが %%interval%% 秒間停止する可能性があります。',
    'php-settings.phpHandlerOutdatedHint' => '新しい PHP バージョンを利用できるか確認するには、%%link%%、製品コンポーネントの「Web Hosting」カテゴリを調べてください。',
    'php-settings.phpHandlerOutdatedHintLink' => 'Plesk インストーラを開いて',
    'php-settings.phpHandlerTypeHelpLink' => '最も適切な PHP 設定を選択する方法について',
    'php-settings.phpHandlerTypeNotAvailableHint' => 'PHP サポートは有効にできません。現在のホスティング構成に、このドメインで使用できる PHP が含まれていません。',
    'php-settings.phpHandlersNotAvailableHint' => 'PHP サポートを有効にできません。現在の Plesk 構成に、使用可能な PHP が含まれていません。',
    'php-settings.phpHandlerTypeNotAvailableHelpLink' => '他の PHP バージョンを有効にする方法を確認してください。',
    'php-settings.phpSupportEditable' => '（PHP バージョン %%version%%、PHP を %%handler%% として実行）%%link%%',
    'php-settings.phpSupportReadonly' => '（バージョン：%%version%%; ハンドラ：%%handler%%）%%link%%',
    'php-settings.phpSupportReadonlyNotRegistered' => '（未登録）%%link%%',
    'php-settings.showPhpInfo' => 'phpinfo() ページを表示',
    'php-settings.phpSettingsFormError' => 'PHP 設定を取得できません。必要なデータがありません。',
    'php-settings.phpSettingsFormBrokenPhpHandler' => 'PHP 設定を取得できません。この PHP バージョンはインストールされていません。続行するには、選択した PHP バージョンをインストールするか、ドメイン用に別のバージョンを選択してください。',
    'php-settings.showPhpInfoTitle' => 'phpinfo() を表示',
    'php-settings.showPhpInfoDescription' => '一部の PHP 設定が変更されましたが、変更が保存されていません。phpinfo() ページに新しい値を表示するには、まず変更を適用してください。適用しないと、現在の値が表示されます。',
    'php-settings.showPhpInfoButton' => 'phpinfo() を表示',
    'php-settings.onState' => 'オン',
    'php-settings.offState' => 'オフ',
    'php-settings.description' => 'このページには、ウェブサイトの PHP 構成が表示されます。これらの設定はウェブサイトに固有であり、契約の他のウェブサイトには影響を与えません。ホスティング事業者から該当するパーミッションが付与されていれば、PHP 構成を変更することができます。カスタム PHP 構成を使用することによって、PHP スクリプトによるシステムリソースの消費を抑えたり、特定のウェブアプリケーションの要件に対応することなどができます。パラメータの値をデフォルトに設定すると、PHP はサーバ全体の PHP 構成からパラメータ値を使用します。',
    'php-settings.availableVariables' => 'パラメータ値には以下のプレースホルダを使用できます。',
    'php-settings.variableDocroot' => '{DOCROOT}： ウェブサイトのドキュメントルートディレクトリ。現在の値は %%DOCROOT%% です。%%HTTPS_DOCROOT%%',
    'php-settings.variableDocrootHttpsSame' => 'HTTPS ドキュメントルートディレクトリは http と同じです。',
    'php-settings.variableDocrootHttpsDifferent' => 'HTTPS ドキュメントルートディレクトリは %%DOCROOT%% です。',
    'php-settings.variableWebspaceRoot' => '{WEBSPACEROOT}： 契約のプライマリウェブサイトのドキュメントルートディレクトリ。',
    'php-settings.variableTmp' => '{TMP}： 一時ファイルを保存するディレクトリ。',
    'php-settings.note' => '注: 以下の設定は .htaccess、php.ini、または .user.ini ファイルに指定されたパラメータで上書きできます。',
    'php-settings.showHelp' => 'ヘルプを表示',
    'php-settings.select-ariaLabel' => '値を選択',
    'php-settings.tuxCarePhpPromo' => '古い PHP バージョンを使用するウェブサイトは攻撃ベクトルに変わる可能性があります。 %%link%% で今すぐ保護しましょう',
    'php-settings.tuxCarePhpLink' => 'TuxCare PHP 用延長ライフサイクルサポート',
    'php-settings.phpHandlerLabel' => 'PHP ハンドラ',
    'php-settings.phpHandlerIdLabel' => 'PHP の実行タイプ',

    'pmm.agent.sync.check' => '移行・移管エージェントがアップデートをチェックしています。',
    'pmm.agent.sync.updating' => '移行・移管エージェントの同期およびダウンロードを実行中',
    'pmm.agent.sync.done' => '移行・移管エージェントは正常に同期されました。',
    'pmm.agent.sync.downloadLink' => '移行開始前にソースホストにインストールする必要がある移行・移管エージェントファイルをダウンロードします。',
    'pmm.agent.sync.error' => '移行・移管エージェントがアップデートの取得に失敗しました。後でもう一度やり直してください。',

    'restore-password.title' => 'パスワード変更',
    'restore-password.passwordLabel' => '新規パスワード',
    'restore-password.buttonRestore' => '保存',
    'restore-password.buttonCancel' => 'キャンセル',
    'restore-password.isEmpty' => '必須フィールドが空欄になっています。値を入力してください。',
    'restore-password.errorInvalidSecret' => '無効なシークレットコード',
    'restore-password.errorNotFoundSecret' => '新しいシークレットコードをリクエストしてください',
    'restore-password.restoreSuccess' => 'パスワードが更新されました。新しいパスワードで Plesk またはメールアドレスにログインします。',

    'scheduler.settings.schedulerNotification' => 'スケジューラ通知',
    'scheduler.settings.notificationOff' => "オフ",
    'scheduler.settings.notificationDefault' => "デフォルトメールアドレスに送信（%%email%%）",
    'scheduler.settings.notificationCustom' => "指定メールアドレスに送信",
    'scheduler.settings.crontabSecureShell' => 'Crontab シェル',
    'scheduler.settings.schedulerTimezoneSelector' => 'タスクスケジュールの表示に使用するタイムゾーン',
    'scheduler.settings.schedulerTimezoneSelectorDefaultWithLabel' => 'システムのデフォルトタイムゾーンを使用（%%timezone%%）',
    'scheduler.settings.schedulerTimezoneSelectorDefault' => 'システムのデフォルトタイムゾーンを使用',
    'scheduler.settings.schedulerTimezoneSelectorCustom' => '使用するタイムゾーンを指定',

    'scheduler.task.active' => 'アクティブ',
    'scheduler.task.subscription' => '契約',
    'scheduler.task.subscription_powerUser' => 'ウェブスペース',
    'scheduler.task.type' => 'タスクタイプ',
    'scheduler.task.typeCommand' => 'コマンドを実行',
    'scheduler.task.typeUrl' => 'URL をフェッチ',
    'scheduler.task.typeScript' => 'PHP スクリプトを実行',
    'scheduler.task.command' => 'コマンド',
    'scheduler.task.arguments' => '引数',
    'scheduler.task.url' => 'URL',
    'scheduler.task.urlDescription' => '絶対 URL（http://example.com など）を指定してください。応答ステータスコードが 2xx または 3xx の場合、タスクは正常に実行されたとみなされます。',
    'scheduler.task.script' => 'スクリプトパス',
    'scheduler.task.scriptRelativePathDescription' => '例：%%path%%',
    'scheduler.task.scriptAbsolutePathDescription' => 'スクリプトのフルパスを指定します。例：%%path%%',
    'scheduler.task.scriptPhpVersion' => 'PHP バージョンを使用',
    'scheduler.task.scriptPathPopupTitle' => 'スクリプトパス',
    'scheduler.task.chooseFile' => 'ファイルを選択',
    'scheduler.task.run' => '実行',
    'scheduler.task.on' => 'on',
    'scheduler.task.at' => 'at',
    'scheduler.task.sysUser' => 'システムユーザー',
    'scheduler.task.hourly' => '毎時',
    'scheduler.task.daily' => '毎日',
    'scheduler.task.weekly' => '毎週',
    'scheduler.task.monthly' => '毎月',
    'scheduler.task.yearly' => '毎年',
    'scheduler.task.cronStyle' => 'Cron スタイル',
    'scheduler.task.cronStyleHint' => 'UNIX crontab は「分 時 日 月 曜日」形式で指定します。例えば、「0 22 * * 1-5」のようにします。Plesk はデフォルトシステムタイムゾーンを使用してタスクを実行します。',
    'scheduler.task.cronStyleWinHint' => '「分 時 日 月 曜日」形式で「0 22 * * 6,7」のように指定します。Plesk はデフォルトシステムタイムゾーンを使用してタスクを実行します。',
    'scheduler.task.notify' => '通知',
    'scheduler.task.notifyIgnore' => '通知しない',
    'scheduler.task.notifyErrors' => 'エラーのみ',
    'scheduler.task.notifyAlways' => '毎回',
    'scheduler.task.notifyErrorsHint' => '通知にはコマンドの標準エラーストリームが含まれます。ストリームが空の場合、通知は送信されません。',
    'scheduler.task.notifyErrorsHintWin' => '通知にはコマンド出力が含まれ、終了コードがゼロ以外の場合のみ送信されます。',
    'scheduler.task.notifyAlwaysHint' => '通知にはコマンド出力が含まれます。出力が空の場合、通知は送信されません。',
    'scheduler.task.notifyAlwaysHintWin' => '通知にはコマンド出力が含まれ、コマンド終了コードに関わらず送信されます。',
    'scheduler.task.emailType' => '通知の送信先',
    'scheduler.task.emailTypeDefault' => 'デフォルトのシステムユーザー (%%email%%)',
    'scheduler.task.emailTypeOwner' => '契約所有者（%%email%%）',
    'scheduler.task.emailTypeOwnerAdmin' => '管理者（%%email%%）',
    'scheduler.task.emailTypeCustom' => '他のユーザー',
    'scheduler.task.emailTypeCustomDescription' => '複数のアドレスをコンマで区切って指定できます。',
    'scheduler.task.minute' => '分',
    'scheduler.task.shortMinute' => '分',
    'scheduler.task.dayOfMonth' => '日',
    'scheduler.task.description' => '説明',
    'scheduler.task.scheduleTimezoneHint' => 'タスク実行時間のタイムゾーンは %%timezone%% です',
    'scheduler.task.runTaskNow' => '今すぐ実行',
    'scheduler.task.runningTask' => 'タスク "%%task%%" を実行中...',

    'server-settings.submitDone' => "サーバ設定を変更しました",
    'server-settings.systemSettings' => "システム設定",
    'server-settings.fullHostName' => "フルホスト名",
    'server-settings.trafficStatisticsPeriod' => "ウェブおよびトラフィック統計の保持期間",
    'server-settings.trafficStatisticsPeriodUnit' => "ヶ月",
    'server-settings.diskSpaceUsageCalculation' => "ディスクスペース使用状況の計算に含める",
    'server-settings.includeLogs' => "ログファイル",
    'server-settings.includeLogsAndStats' => "ログファイルおよび統計レポート",
    'server-settings.includeMysqlDatabases' => "MariaDB/MySQL データベース",
    'server-settings.includeMssqlDatabases' => "Microsoft SQL データベース",
    'server-settings.includePgsqlDatabases' => "PostgreSQL データベース",
    'server-settings.includeDatabases' => "データベース",
    'server-settings.includeRemoteDatabases' => "リモートデータベース",
    'server-settings.includeMailboxes' => "メールボックス",
    'server-settings.includeMailLists' => "メーリングリスト",
    'server-settings.includeDomainDumps' => "ドメインバックアップファイル",
    'server-settings.includeAdminDumps' => "管理者が作成したバックアップファイル",
    'server-settings.calculatingDiskSpaceUsage' => "ディスクスペース使用状況の計算時の基準",
    'server-settings.typeByte' => "ファイルサイズ",
    'server-settings.typeBlock' => "使用しているディスク容量",
    'server-settings.trafficCalculation' => "トラフィック計算に含める",
    'server-settings.inboundAndOutbound' => "送受信トラフィック",
    'server-settings.onlyInbound' => "受信トラフィックのみ",
    'server-settings.onlyOutbound' => "送信トラフィックのみ",
    'server-settings.forbidCreateDnsSubZone' => "ユーザーが他のユーザーの DNS スーパーゾーン内に DNS サブゾーンを作成することを禁止する",
    'server-settings.webDeployIncludePassword' => "Web Deploy パブリケーション設定ファイルにユーザーのパスワードを含める",
    'server-settings.forbidSysUserRename' => "顧客によるシステムユーザー名の変更を許可する",
    'server-settings.alwaysAllowSysUserRename' => "常に",
    'server-settings.ifPermissionIsGrantedAllowSysUserRename' => "ホスティング管理パーミッションが付与されている場合のみ",
    'server-settings.neverAllowSysUserRename' => "なし",
    'server-settings.forbidSubscriptionRename' => "顧客とリセラーによるメインドメイン名の変更を禁止する",
    'server-settings.preferredDomain' => "ウェブサイトの優先ドメイン",
    'server-settings.preferredDomainNone' => "なし",
    'server-settings.preferredDomainToLanding' => "domain.tld",
    'server-settings.preferredDomainToWww' => "www.domain.tld",
    'server-settings.ipLogging' => "IP ロギング",
    'server-settings.disableIpLogging' => "IIS、FTP、メールログで IP ロギングを無効にする",
    'server-settings.disableIpLoggingDescription' => "選択すると、IIS と MailEnable のログファイルに IP アドレスが記述されなくなります",
    'server-settings.anonymizeIps' => "IP アドレスを匿名化",
    'server-settings.logrotateAnonymizeIps' => "ログローテーション中およびウェブ統計の収集中に IP アドレスを匿名化",
    'server-settings.logrotateAnonymizeIpsDescription' => 'ローテーション後のスクリプトにより、ローテーションされたログファイル内の IPv4 アドレスの最後のオクテットが「0」に置換されてからアーカイブされます。IPv6 アドレスの場合、このスクリプトによってアドレスの最後のセクション（最後のコロンの後の 2 つのオクテット）が「0000」（完全表記）または「0」（省略表記）に置換されます。',
    'server-settings.logrotate' => "ログをローテーション",
    'server-settings.logrotateForce' => "すべてのドメインを対象に強制的にログローテーションを毎日実行",
    'server-settings.allowToStoreLogs' => "ウェブサイトのログの保存期間：",
    'server-settings.logrotatePeriod' => "日",
    'server-settings.configureUpdatePolicy' => "更新ポリシーを構成",

    'service-plan.mail.outgoing-messages.outgoingMessagesDefault' => 'サーバ全体のデフォルト値（%%default%% 通/時間）',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificPlan' => 'プランのカスタム値',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificSubscription' => '契約のカスタム値',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificHint' => '通',
    'service-plan.mail.outgoing-messages.mboxOutgoingMessages' => 'メールボックスからの送信メッセージ数（1 時間あたり）',
    'service-plan.mail.outgoing-messages.domainOutgoingMessages' => 'ドメインからの送信メッセージ数（1 時間あたり）',
    'service-plan.mail.outgoing-messages.subscriptionOutgoingMessages' => '契約からの送信メッセージ数（1 時間あたり）',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimit' => '1 時間あたりの上限を超えており、次の時間に送信すべきメッセージの割合（%）',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimitDescription' => '1 時間あたりにメールボックスから送信するメールメッセージの上限を 100 に、割合 (%) を 10% に設定すると、ユーザーは 1 時間あたり 110 件までメッセージを送信することができます。このうち 100 件は 1 時間の間に送信されますが、残りの 10 件はメールキューに入れられ、次の時間に送信するようスケジュールされます。',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmail' => 'Sendmail 使用ポリシー',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailDefault' => 'サーバ全体のデフォルト設定（Sendmail 許可）',
    'service-plan.mail.outgoing-messages.outgoingMessagesNotEnableSendmailDefault' => 'サーバ全体のデフォルト設定（Sendmail 不許可）',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomPlan' => 'プランのカスタム設定',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomSubscription' => '契約のカスタム設定',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomLabel' => 'この契約でスクリプトとユーザーに Sendmail の使用を許可する',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomHint' => 'オンにすると、スクリプトおよびユーザーは、たとえメールボックスおよびドメインの上限を超過していても、(契約のシステムユーザーの代理として) Sendmail を使用してメールメッセージを送信することができます。Sendmail 経由で送信できるメッセージの最大数は、契約全体の上限によって定義されます。',

    'setup.hint' => 'サーバ管理のためのコントロールパネル、Plesk へようこそ。Plesk は、コーディング対応環境を提供し、パワフルな拡張の数々が用意されているため、ウェブサイトとアプリの開発に役立ちます。Plesk を使い始めるには、セットアップを完了してください（数分ほどかかります）。',
    'setup.contactInfoSection' => '連絡先情報',
    'setup.contactInfoSectionHint' => '名前とメールアドレスを入力してサーバの所有者であることを証明すると、サーバに関する重要な通知をお届けします。企業のサーバ管理者である場合、個人名または個人のメールアドレスは入力しないでください。データ保護法の違反を防止するために、役職と会社メールアドレスを使用してください。',
    'setup.contactName' => '担当者名',
    'setup.emptyContactName' => '担当者名を入力してください。',
    'setup.contactNameTooLong' => 'この担当者名は長すぎます（%max% 文字以内にしてください）。',
    'setup.email' => 'メール',
    'setup.emptyEmail' => 'メールアドレスを入力してください。',
    'setup.passwordSection' => 'パスワード',
    'setup.passwordSectionHint' => '次回 Plesk にログインするときは、ユーザー名は「admin」を、パスワードを以下に入力したものを使用してください。',
    'setup.password' => 'パスワード',
    'setup.licenseSection' => 'ライセンス',
    'setup.licenseSectionHint' => 'Plesk の使用を開始するには、ライセンスをインストールする必要があります。',
    'setup.licenseType' => 'ライセンスタイプを選択',
    'setup.licenseTypePaid' => '有料ライセンスで続ける',
    'setup.activationCodeLabel' => 'ここにアクティベーションコードを入力',
    'setup.onlineStoreLink' => 'オンラインストア',
    'setup.licenseTypeTrial' => 'すべての機能を使用できる評価版ライセンスで続ける',
    'setup.activationCodeHint' => '購入済みの Plesk ライセンスがある場合、受信したアクティベーションコードをここに貼り付けてください。ない場合は%%onlineStoreLink%%で新規ライセンスを購入できます。',
    'setup.privacyPolicyLink' => 'WebPros プライバシーポリシー',
    'setup.trialLicenseAgreement' => 'WebPros International GmbH は、評価版ライセンスを発行するために、%%privacyPolicyLink%%に従い、提供された情報を内部システムで使用、処理します。',
    'setup.eulaAgreementLabel' => '私は%%link%%を読み、その内容に同意します。',
    'setup.eula' => 'エンドユーザーライセンス契約 (EULA)',
    'setup.invalidEulaAgreementValue' => 'エンドユーザーライセンス契約に同意していただく必要があります。',
    'setup.sendButton' => 'Plesk にログイン >>',
    'setup.resetPasswordOnFirstLogin' => '管理者のパスワードを次回ログイン時にリセットする',

    'spam-filter.add.titleBlack' => 'ブラックリストにアドレスを追加する',
    'spam-filter.add.titleWhite' => 'ホワイトリストにアドレスを追加する',
    'spam-filter.add.fileDescription' => 'UTF-8 エンコーディングのテキストファイルをアップロードしてください (*.txt、*.csv ファイルなど)。',
    'spam-filter.add.listDescription' => 'フォーマットのルール：<ul><li>個々のアドレスは、コンマ、セミコロン、改行、スペース、タブのいずれかの文字で区切ります。</li><li>非 ASCII 文字を @ 記号の左側で使用しないでください。</li><li>ワイルドカードとして「*」と「?」を使用できます（例：<nobr>*@domain.com、</nobr> <nobr>user?@*.com</nobr>）。</li><li>ドメイン名の非 ASCII 部分ではワイルドカードを使用しないでください。</li></ul>',
    'spam-filter.add.fromFile' => 'ファイルより取得',
    'spam-filter.add.fromList' => 'リストより取得',
    'spam-filter.add.success' => 'アドレスが追加されました',

    'ssl-certificate.add.name' => '証明書名',
    'ssl-certificate.add.longName' => '指定した証明書名が長過ぎます（最大 %max% 文字まで許可されます）。',
    'ssl-certificate.add.certificateNameUsed' => '%%name%% という名前の証明書は既に存在します。',
    'ssl-certificate.add.certificateAdded' => 'SSL/TLS 証明書が発行されました。機能させるには、証明書を割り当ててドメイン、メール、ウェブメールを保護してください。',
    'ssl-certificate.add.certificateUpdated' => 'SSL/TLS 証明書が正常に更新されました。',
    'ssl-certificate.add.settings' => '設定',
    'ssl-certificate.add.settingsHint' => 'このフォームを使用して、証明書のリクエストの生成、プロバイダから証明書の購入、または自己署名証明書の生成を実行します。',
    'ssl-certificate.add.settingsHint2' => 'リクエストとは、フォームで指定したドメインについての情報が含まれる CSR ファイルのことです。リクエストを認証局に送信し、証明書の発行を依頼することができます。次に、以下のいずれかのアップロードフォームを使用してアップロードします。',
    'ssl-certificate.add.settingsHint3' => '自己署名証明書とは、発行者自身が署名した身元証明書のことです。このような証明書を使用する場合、自らのサイトの身元を自ら証明することになります。自己署名証明書では SSL/TLS を使用できますが、信頼性と安全性は低いと見なされます。',
    'ssl-certificate.add.bits' => 'ビット',
    'ssl-certificate.add.country' => '国',
    'ssl-certificate.add.state' => '都道府県',
    'ssl-certificate.add.longState' => '指定した都道府県名が長過ぎます。',
    'ssl-certificate.add.city' => '所在地（市区町村）',
    'ssl-certificate.add.longCity' => '入力した市区町村名が長すぎます。',
    'ssl-certificate.add.shortCity' => '指定した市区町村名が短すぎます。',
    'ssl-certificate.add.companyName' => '組織名（会社）',
    'ssl-certificate.add.longCompanyName' => '入力した会社名が長すぎます。',
    'ssl-certificate.add.companyUnitName' => '部/課名',
    'ssl-certificate.add.longCompanyUnitName' => '指定した組織部門名が長過ぎます（最大 %max% 文字まで許可されます）。',
    'ssl-certificate.add.domainName' => 'ドメイン名',
    'ssl-certificate.add.email' => 'メール',
    'ssl-certificate.add.request' => 'リクエスト',
    'ssl-certificate.add.buyCertificate' => 'SSL/TLS 証明書を購入',
    'ssl-certificate.add.selfSigned' => '自己署名',
    'ssl-certificate.add.invalidCertificateParams' => '一部のフィールドが空であるか不適切な値が含まれています。値は 64 文字以内にする必要があります。国際化ドメイン名を使用している場合、ドメイン名のドットとドットの間のいずれの部分についても、ASCII 文字に変換して 63 文字を超えないことを確認してください。次のフィールドをチェックしてください。',
    'ssl-certificate.add.unableCreateCsr' => 'CSR を作成することができません。%%error%%',
    'ssl-certificate.add.unableCreateSelfSigned' => '自己署名証明書を作成することができません。%%error%%',
    'ssl-certificate.add.unableCreateUpload' => '証明書データを設定することができません。%%error%%',
    'ssl-certificate.add.unableSaveCertificate' => 'データベースに証明書を保存することができません。%%error%%',
    'ssl-certificate.add.uploadFiles' => '証明書ファイルをアップロード',
    'ssl-certificate.add.uploadFilesHint' => '証明書のコンポーネントをファイルとしてアップロードするには、このフォームを使用します。',
    'ssl-certificate.add.csr' => 'CSR',
    'ssl-certificate.add.privateKey' => "秘密キー（*.key）",
    'ssl-certificate.add.certificate' => "証明書（*.crt）",
    'ssl-certificate.add.caCertificate' => "CA 証明書（*-ca.crt）",
    'ssl-certificate.add.sendFiles' => "証明書をアップロード",
    'ssl-certificate.add.fileNotUploaded' => '証明書ファイル %%name%% をアップロードできません。',
    'ssl-certificate.add.unableSetPrivateKey' => '秘密キーを設定できません。%%error%%',
    'ssl-certificate.add.unableSetCertificate' => '証明書を設定できません。%%error%%',
    'ssl-certificate.add.unableSetCaCertificate' => 'CA 証明書を設定できません。%%error%%',
    'ssl-certificate.add.unableCheckCaCertificate' => 'CA 証明書が証明書に署名しているかどうかを確認できません。%%error%%',
    'ssl-certificate.add.removeCaCertificate' => '削除',
    'ssl-certificate.add.removeCaCertificateConfirmation' => 'CA 証明書を削除しますか？',
    'ssl-certificate.add.unableRemoveCaCertificate' => 'CA 証明書をクリアできません。%%error%%',
    'ssl-certificate.add.caCertificateRemoved' => '証明書の CA 部分が削除されました。',
    'ssl-certificate.add.rename' => '名前変更',
    'ssl-certificate.add.unableRenameCertificate' => '証明書名を変更できません。%%error%%',
    'ssl-certificate.add.certificateRenamed' => '証明書名は %%name%% に変更されました。',
    'ssl-certificate.add.uploadText' => "証明書をテキスト形式でアップロード",
    'ssl-certificate.add.uploadTextHint' => '証明書のコンポーネントをテキストとしてアップロードするには、このフォームを使用します。ファイルのコンテンツを該当フィールドにコピー＆ペーストしてください。',
    'ssl-certificate.add.sendText' => "証明書をアップロード",
    'ssl-certificate.add.componentIsMissing' => 'このコンポーネントはありません。',

    'ssl-certificate.find-private-key.findPrivateKey' => '証明書をアップロード',
    'ssl-certificate.find-private-key.formGeneralHint' => 'このサーバで証明書署名リクエストを作成した場合、証明書ファイルを受信したらここからアップロードします。別のサーバで生成された証明書と秘密キーのペアをアップロードしたい場合や、自己署名証明書を生成したい場合には、<b>［SSL/TLS 証明書を追加］</b>をクリックしてください。',
    'ssl-certificate.find-private-key.formCertificateAddingHint' => 'SSL/TLS 証明書をドメインに追加した後で、SSL/TLS サポートを有効化して、ウェブサイトのホスティング設定で証明書を選択する必要があります（<b>［ウェブサイトとドメイン］</b> > このドメインの<b>［ホスティング設定］</b> > <b>［セキュリティ］</b>）。',
    'ssl-certificate.find-private-key.uploadCertificate' => '証明書（*.crt）',
    'ssl-certificate.find-private-key.sendFile' => '証明書をアップロード',
    'ssl-certificate.find-private-key.fileNotUploaded' => '証明書ファイルをアップロードできません。',
    'ssl-certificate.find-private-key.invalidCertificateFormat' => '無効な証明書フォーマットです。',
    'ssl-certificate.find-private-key.unableFindPrivateKey' => '証明書に適した秘密キーが見つかりません。',

    'ssl-certificate.secure.certificate' => '証明書を選択',
    'ssl-certificate.secure.serverPool' => 'サーバプール',
    'ssl-certificate.secure.certificateName' => '%%certificateName%%（%%repositoryName%%）',

    'system-time.date' => "日付",
    'system-time.dateAndTime' => "日時",
    'system-time.daylight' => "夏時間の切り替えを自動調整する",
    'system-time.dayMonthYear' => "日-月-年",
    'system-time.domainNameOrIp' => "ドメイン名または IP アドレス",
    'system-time.hoursMinutesSeconds' => "時間:分:秒",
    'system-time.networkTime' => "ネットワーク時間",
    'system-time.submitDone' => "システム時刻が変更されました。",
    'system-time.synchronizedSystemTime' => "システム時間を同期する",
    'system-time.title' => "システム日時管理",
    'system-time.timezone' => "タイムゾーン",
    'system-time.time' => "時間",
    'system-time.updateSystemTime' => "システム時間をアップデートする",
    'system-time.yourTimezone' => "タイムゾーン",

    'web-app-firewall.pageHint' => 'ウェブアプリケーションファイアウォールは、ユーザーの定義したルールに基づいて受信 HTTP 要求のチェックとフィルタリングを行うことで、ウェブアプリケーションを保護します。',
    'web-app-firewall.webSitePageHint' => 'ウェブアプリケーションファイアウォール（ModSecurity）を構成します。',
    'web-app-firewall.ruleEngine' => 'ウェブアプリケーションファイアウォールのモード',
    'web-app-firewall.ruleEngineOn' => 'オン',
    'web-app-firewall.ruleEngineOnDescription' => 'それぞれの受信 HTTP 要求および関連する応答は、ルールのセットに対してチェックされます。チェックが成功すると、HTTP 要求がウェブサイトコンテンツに渡されます。チェックが失敗すると、イベントはログに記録され、通知が送信され、HTTP 応答にエラーコードが割り当てられます。',
    'web-app-firewall.ruleEngineOff' => 'オフ',
    'web-app-firewall.ruleEngineOffDescription' => '受信 HTTP 要求および関連する応答はチェックされません。',
    'web-app-firewall.ruleEngineDetectionOnly' => '検出のみ',
    'web-app-firewall.ruleEngineDetectionOnlyDescription' => 'それぞれの受信 HTTP 要求および関連する応答は、ルールのセットに対してチェックされます。チェックが成功すると、HTTP 要求がウェブサイトコンテンツに渡されます。チェックが失敗すると、イベントはログに記録され、ModSecurity は追加の処理を行いません。その他のサービス（Fail2ban など）は、引き続き、チェックが失敗した HTTP 要求で処理を実行できます。',
    'web-app-firewall.ruleSetsSection' => 'ルールセット',
    'web-app-firewall.ruleSetsSectionHint' => '受信 HTTP 要求のチェックに使用するルールセット（セキュリティルールが含まれるファイルパッケージ）を選択してください。',
    'web-app-firewall.ruleSet' => 'ルールセット',
    'web-app-firewall.ruleSetCrs' => 'OWASP（無料）',
    'web-app-firewall.ruleSetCrsDescription' => 'OWASP ModSecurity Core Rule Set は制限が多く、一部の機能がブロックされる可能性があります（ファイル共有、ウェブメールなど）。また、ウェブアプリケーションの一部の機能（WordPress プラグインなど）もブロックされる可能性があります。',
    'web-app-firewall.ruleSetCrsConfirmTitle' => '変更内容を適用しますか？',
    'web-app-firewall.ruleSetCrsConfirmDescription' => '時に、OWASP ルールが厳格すぎて、ファイル共有、ウェブメール、一部のウェブアプリケーションがブロックされる場合があります。',
    'web-app-firewall.ruleSetTortix' => 'Atomic Standard（無料、Atomic Advanced にアップグレード可能です）',
    'web-app-firewall.ruleSetTortixDescription' => 'ModSecurity Rules by Atomicorp のスターターバージョンです。基本的な保護を提供し、毎月更新されます。',
    'web-app-firewall.ruleSetTortixHowTo' => 'このルールセットを Atomic Advanced にアップグレードするには：',
    'web-app-firewall.ruleSetTortixBuy' => 'Plesk ウェブサイトと %%linkDocumentation%% から %%linkPleskStore%% を購入してください。',
    'web-app-firewall.ruleSetTortixLinkPleskStoreLabel' => 'Advanced ModSecurity Rules by Atomicorp',
    'web-app-firewall.ruleSetTortixLinkDocumentationLabel' => '購入した追加ライセンスキーをインストール',
    'web-app-firewall.ruleSetTortixSelect' => 'このルールセットを選択してください。名前が「Atomic Advanced（Plesk から購入）」に変わります。',
    'web-app-firewall.ruleSetTortixPro' => 'Atomic Advanced（Plesk から購入）',
    'web-app-firewall.ruleSetTortixProDescription' => 'Advanced ModSecurity Rules by Atomicorp は、Atomic Standard ルールと多数の高度な機能を提供します。',
    'web-app-firewall.ruleSetAtomic' => 'Atomic Advanced（Atomicorp から購入）',
    'web-app-firewall.ruleSetAtomicDescription' => 'Advanced ModSecurity Rules by Atomicorp は、Atomic Standard ルールと多数の高度な機能を提供します。',
    'web-app-firewall.ruleSetAtomicInstall' => '別の Atomicorp アカウントに切り替えます。',
    'web-app-firewall.ruleSetAtomicInstalled' => 'ルールセットがアクティブ化されました。',
    'web-app-firewall.ruleSetAtomicHowTo' => '既に Atomicorp アカウントをお持ちで、Atomic Advanced ルールを購入済みの場合、以下にアカウントのログイン情報を入力してこのルールセットを有効にしてください。',
    'web-app-firewall.ruleSetAtomicSwitchHowTo' => '既に Atomicorp アカウントをお持ちで、Atomic Advanced ルールを購入済みの場合、以下にアカウントのログイン情報を入力してアカウントを切り替えてください。',
    'web-app-firewall.ruleSetAtomicLogin' => 'ユーザー名',
    'web-app-firewall.ruleSetAtomicPassword' => 'パスワード',
    'web-app-firewall.ruleSetComodo' => 'Comodo（無料サブスクリプション）',
    'web-app-firewall.ruleSetComodoDescription' => 'Comodo の無料 ModSecurity ルール。基本的な保護を提供します。',
    'web-app-firewall.ruleSetComodoInstall' => '別の Comodo アカウントに切り替えます。',
    'web-app-firewall.ruleSetComodoInstalled' => 'ルールセットがアクティブ化されました。',
    'web-app-firewall.ruleSetComodoHowTo' => 'このルールセットを有効化するには：',
    'web-app-firewall.ruleSetComodoSwitchHowTo' => '別のアカウントに切り替えるには：',
    'web-app-firewall.ruleSetComodoRegister' => 'Comodo ウェブサイトで登録してください。',
    'web-app-firewall.ruleSetComodoCredentials' => 'このウェブサイトのユーザー名とパスワードを入力してください。',
    'web-app-firewall.ruleSetComodoLogin' => 'ユーザー名',
    'web-app-firewall.ruleSetComodoPassword' => 'パスワード',
    'web-app-firewall.ruleSetComodoFree' => 'Comodo（無料）',
    'web-app-firewall.ruleSetComodoFreeDescription' => 'Comodo の無料 ModSecurity ルール。基本的な保護を提供します。',
    'web-app-firewall.ruleSetCustom' => 'カスタムルールセット',
    'web-app-firewall.ruleSetCustomDescription' => 'ウェブアプリケーションファイアウォールのカスタムルールセットをアップロードします。サポートされるフォーマット：zip、tar.gz、tgz、tar.bz2、conf',
    'web-app-firewall.ruleSetCustomUpload' => '別のファイルを選択',
    'web-app-firewall.ruleSetError' => 'ModSecurity ルールセットのインストールに失敗しました。%%error%%',
    'web-app-firewall.ruleSetOWASPMissingError' => 'OWASP ルールセットがありません。Plesk インストーラを使用して ModSecurity を再インストールしてください。',
    'web-app-firewall.ruleSetCustomMissingError' => 'カスタムルールセットがありません。ルールセットを再インストールしてください。',
    'web-app-firewall.ruleSetAuthError' => '指定したユーザー名またはパスワードが無効です。',
    'web-app-firewall.ruleSetInvalid' => '選択したルールセットは %%webServer%% で機能しません。',
    'web-app-firewall.ruleSetSelectedInvalid' => '選択されたルールセットは、選択されたウェブサーバ上で機能しません。',
    'web-app-firewall.webServer' => 'ルールを実行',
    'web-app-firewall.webServerHint' => '対応するルールセットを確認するには、ウェブサーバと ModSecurity バージョンの適切な組み合わせを選択してください。',
    'web-app-firewall.webServerApache' => 'Apache (ModSecurity 2.9)',
    'web-app-firewall.webServerNginx' => 'Nginx (ModSecurity 3.0)',
    'web-app-firewall.webServerIis' => 'IIS (ModSecurity 2.9)',
    'web-app-firewall.nginxNotRunning' => 'リバースプロキシサーバ（nginx）がオフになっており、要求の処理に使用できません。<a href="%%serverUrl%%">別のウェブサーバ</a>を選択するか、<a href="%%servicesUrl%%">［サービス管理］ページ</a>でリバースプロキシサーバをオンに切り替えてください。',
    'web-app-firewall.nginxIsIncompatible' => '別の ModSecurity バージョンを選択すると、一部の設定が有効ではなくなる可能性があります（たとえば、ModSecurity 3 では正規表現を使用してセキュリティルールをオフにすることはできません）。変更を適用した後で、設定が期待どおりに機能することを確認してください。あるいは、設定をリセットして、セキュリティルールをデフォルト値に戻すこともできます。',
    'web-app-firewall.nginxResetCustomizations' => 'サーバとドメインの設定をリセットし、セキュリティルールをデフォルト値に戻すことができます。',
    'web-app-firewall.ruleSetUpdate' => 'ルールセットを更新',
    'web-app-firewall.ruleSetUpdateDaily' => '毎日',
    'web-app-firewall.ruleSetUpdateWeekly' => '毎週',
    'web-app-firewall.ruleSetUpdateMonthly' => '毎月',
    'web-app-firewall.currentRuleSet' => 'ルールセット',
    'web-app-firewall.currentRuleSetValue' => '%%ruleSet%% %%changeRuleSetLink%%',
    'web-app-firewall.currentRuleSetRunningOn' => '%%webServer%% で実行中の %%ruleSet%%',
    'web-app-firewall.changeRuleSetLink' => 'ルールセットを変更',
    'web-app-firewall.ruleSetRollbackFailed' => '現在の ModSecurity ルールセットを使用したり、前のバージョンにロールバックすることができません。無効なルールが含まれています。',
    'web-app-firewall.configurationSection' => '構成',
    'web-app-firewall.configurationSectionHint' => '事前定義されたパラメータセットまたはカスタム ModSecurity ディレクティブを使用してウェブアプリケーションファイアウォールを構成します。',
    'web-app-firewall.configPreset' => '事前定義された値セット',
    'web-app-firewall.configPresetFast' => '高速',
    'web-app-firewall.configPresetFastDescription' => 'HTTP 要求 の URI およびヘッダ部分が解析されます。',
    'web-app-firewall.configPresetTradeOff' => 'トレードオフ',
    'web-app-firewall.configPresetTradeOffDescription' => 'HTTP 要求の URI、ヘッダ、および要求の POST データが解析されます。',
    'web-app-firewall.configPresetThrough' => '完全',
    'web-app-firewall.configPresetThroughDescription' => 'HTTP 要求のヘッダ全体、要求の POST データ、および HTTP 応答の本文が解析されます。',
    'web-app-firewall.configCustom' => 'カスタムディレクティブ',
    'web-app-firewall.configCustomDescription' => "ここに ModSecurity ディレクティブを入力します。これは、以前に指定したディレクティブ（ルールセット、特定のルール、事前定義された値セットなど）をオーバーライドします。\n例：SecDebugLogLevel 6",
    'web-app-firewall.configCustomError' => '無効な ModSecurity 構成：%%error%%',
    'web-app-firewall.configRollbackFailed' => '最新の ModSecurity 構成ファイルを使用したり、前のバージョンにロールバックすることができません。無効な構成が含まれています。',
    'web-app-firewall.rulesSection' => 'セキュリティルールをオフにする',
    'web-app-firewall.rulesSectionHint' => 'セキュリティルールをオフにすることができます。これは、セキュリティルールが一部のウェブサイトに対して厳格すぎると思われる場合に役に立ちます。セキュリティルールを無効にするには、ルールの ID（340003、340005-340007 など）、タグ（CVE-2011-4898 など）、またはルールメッセージで使用される正規表現（XSS など）を指定してください。',
    'web-app-firewall.rulesSectionNginxHint' => 'セキュリティルールをオフにすることができます。これは、セキュリティルールが一部のウェブサイトに対して厳格すぎると思われる場合に役に立ちます。セキュリティルールを無効にするには、ルールの ID（340003、340005-340007 など）、タグ（CVE-2011-4898 など）、またはルールメッセージ（「セキュリティスキャナーに関連付けられている User-Agent が検出されました」など）を指定してください。',
    'web-app-firewall.filterById' => 'セキュリティルール ID',
    'web-app-firewall.filterByIdInvalid' => '次の値は有効ではありません: %%values%%。ルール ID は 913100、913105-913107 のように数字または数字の範囲で構成する必要があります。',
    'web-app-firewall.filterByIdInvalidRanges' => '次の範囲は有効ではありません：%%ranges%%。',
    'web-app-firewall.filterByTag' => 'タグ',
    'web-app-firewall.filterByTagActive' => 'アクティブ：',
    'web-app-firewall.filterByTagDeactivated' => '非アクティブ：',
    'web-app-firewall.filterByTagInvalid' => '次の選択した値が無効です: %%values%%。',
    'web-app-firewall.filterByRegexp' => 'ルールメッセージの正規表現',
    'web-app-firewall.filterByRegexpInvalid' => '次の値は有効ではありません：%%values%%。\', " のいずれも含めないでください。',
    'web-app-firewall.filterByRegexpNginx' => 'ルールメッセージ',
    'web-app-firewall.filterByRegexpNginxHint' => '厳密な一致のみがサポートされます。',
    'web-app-firewall.filterByRegexpNginxInvalid' => '次の値は有効ではありません：%%values%%。ルールメッセージには、文字、数字、スペース、または -:;.,!?#&$%*()/ を含める必要があります。',
    'web-app-firewall.auditLogSection' => 'ModSecurity 監査ログ',
    'web-app-firewall.auditLogHint1' => 'ModSecurity 監査ログファイルは、システム内で最も有益な情報を提供します。ModSecurity が何らかのイベントが発生したことを検知すると、監査ログファイルにエントリが生成されます。',
    'web-app-firewall.auditLogHint2' => 'ウェブアプリケーションファイアウォールのモードを「オフ」または「検出のみ」から「オン」に変更した後で、ウェブサイトの機能が停止することがあります。この場合、ModSecurity 監査ログを参照し、何が起こっているのかを確認してください。厳格すぎるセキュリティルールをオフにしたり、ウェブサイトを調整することができます。',
    'web-app-firewall.auditLogHint3' => 'あるウェブサイトに対し、HTTP 要求が完了しない理由を確認するには：',
    'web-app-firewall.auditLogPoint1' => '下の［ModSecurity ログファイル］リンクをクリックすると、新しいブラウザ画面に監査ログが表示されます。',
    'web-app-firewall.auditLogPoint2' => '検索機能（大部分のブラウザでは Ctrl+F）を使用して、問題が発生しているウェブサイト（ドメイン名）のイベントを探します（例：「your_domain.tld」）。ブラウザで「HOST: your_domain.tld」のようなエントリがハイライトされます。',
    'web-app-firewall.auditLogPoint3' => 'ハイライトされたエントリの 3 行上に「--eece5138-B--」のようなエントリがあります。ハイフンの間の 8 文字（この例では「eece5138」）は、HTTP 要求でトリガされたイベントの ID です。',
    'web-app-firewall.auditLogPoint4' => '同じイベント ID を持つエントリをさらに探します。イベント ID の後に「H」という文字が付いたエントリを探します（この例では「eece5138-H--」）。このエントリには、HTTP 要求のチェック時にトリガされたセキュリティルールの ID と説明が含まれています。セキュリティルールの ID とは、「id」というプレフィックスが付いた整数で、角括弧に囲まれています（例：[id "340003"]）。',
    'web-app-firewall.auditLogPoint5' => '文字列の一部（例：[id "3）を使用して、イベント内でセキュリティルール ID を探します。',
    'web-app-firewall.auditLogPoint6' => '下のセキュリティルールセクションで、この ID のセキュリティルールをオフにします。［セキュリティルール ID］フィールドにセキュリティルール ID（数字のみ）を入力し、［OK］をクリックしてください。',
    'web-app-firewall.auditLogViewLink' => 'ModSecurity ログファイル',
    'web-app-firewall.auditLogListLink' => 'ログアーカイブ',
    'web-app-firewall.errorLogSection' => 'エラーログ',
    'web-app-firewall.errorLogSectionHint' => 'ウェブアプリケーションファイアウォールのモードを「オフ」または「検出のみ」から「オン」に変更した後で、ウェブサイトの機能が停止することがあります。この場合、エラーログを参照し、何が起こっているのかを確認してください。厳格すぎるセキュリティルールをオフにしたり、ウェブサイトを調整することができます。',
    'web-app-firewall.errorLogViewLink' => 'エラーログファイル',
    'web-app-firewall.notificationStateEnabled' => 'ルールセットのアップデートに関する Plesk UI 通知はオンになっています。%%notificationLink%%',
    'web-app-firewall.notificationStateDisabled' => 'ルールセットのアップデートに関する Plesk UI 通知はオフになっています。%%notificationLink%%',
    'web-app-firewall.notificationLink' => '通知ページで管理する',
    'web-app-firewall.tradeoffAndThoroughModeWarning' => '「トレードオフ」または「完全」オプションを選択すると、WordPress サイトが誤作動したり、その他の望ましくない悪影響が生じる可能性があります。これは、以下の <a href="https://github.com/SpiderLabs/ModSecurity/issues/562" target="_blank">ModSecurity の問題</a>が原因です。',
    'web-app-firewall.fileNotUploaded' => 'ファイルをアップロードできません。',

    'web-server-settings.selectUnitSize' => '単位サイズを選択',
    'web-server-settings.inputSize' => 'サイズ入力',

    'ProtectedDirectory.pathLabel' => 'ディレクトリ名',
    'ProtectedDirectory.realmLabel' => '保護エリアのタイトル',
    'ProtectedDirectory.locationLabel' => 'ディレクトリの位置',
    'ProtectedDirectory.isNonSslLabel' => '非 SSL/TLS',
    'ProtectedDirectory.isCgiBinLabel' => 'cgi-bin',

    'SummaryReport.Layout.name' => 'レポート名',
    'SummaryReport.Layout.isDefault' => 'デフォルトレポートとして使用',
    'SummaryReport.Layout.sections' => 'セクション',
    'SummaryReport.Layout.general' => '全般',
    'SummaryReport.Layout.resellers' => 'リセラー',
    'SummaryReport.Layout.clients' => '顧客',
    'SummaryReport.Layout.personalClients' => '自社の顧客',
    'SummaryReport.Layout.domains' => 'ドメイン',
    'SummaryReport.Layout.personalDomains' => '個人ドメイン',
    'SummaryReport.Layout.type.full' => 'フル',
    'SummaryReport.Layout.type.summary' => '概要',

    'SummaryReport.Schedule.enable' => '有効化',
    'SummaryReport.Schedule.period' => '配信頻度',
    'SummaryReport.Schedule.daily' => '毎日',
    'SummaryReport.Schedule.weekly' => '毎週',
    'SummaryReport.Schedule.monthly' => '毎月',
    'SummaryReport.Schedule.email' => '宛先',
    'SummaryReport.Schedule.isEmpty' => '有効なメールアドレスを入力してください。',

    'MassMailForm.name' => 'テンプレート名',
    'MassMailForm.fromEmail' => '送信元（メールアドレス）',
    'MassMailForm.sendToAdmins' => 'Plesk 管理者に送信',
    'MassMailForm.sendToResellers' => 'リセラーに送信',
    'MassMailForm.sendToClients' => '顧客に送信',
    'MassMailForm.subject' => '件名',
    'MassMailForm.body' => 'メッセージテキスト',
    'MassMailForm.bodyDescription' => '
メッセージテキスト内で変数 <name> を使用できます（ただし、ヘッダを除く）。この変数は、顧客またはリセラーの担当者名に置き換えられます。',
    'MassMailForm.sendToResellersMode' => '送信先',
    'MassMailForm.sendToResellersModeAll' => 'すべてのリセラー',
    'MassMailForm.sendToResellersModeSelect' => '選択したリセラー',
    'MassMailForm.sendToResellersModeExcept' => '選択されたリセラー以外',
    'MassMailForm.sendToClientsMode' => '送信先',
    'MassMailForm.sendToClientsModeAll' => 'すべての顧客',
    'MassMailForm.sendToClientsModeSelect' => '選択した顧客',
    'MassMailForm.sendToClientsModeExcept' => '選択された顧客以外',

    'VirtualDirectory.DirectorySection.title' => '仮想ディレクトリ',
    'VirtualDirectory.DirectorySection.name' => '名前',
    'VirtualDirectory.DirectorySection.accessSource' => 'スクリプトソースへのアクセス',
    'VirtualDirectory.DirectorySection.accessRead' => '読み取りパーミッション',
    'VirtualDirectory.DirectorySection.accessWrite' => '書き込みパーミッション',
    'VirtualDirectory.DirectorySection.enableDirBrowsing' => 'ディレクトリ参照',
    'VirtualDirectory.DirectorySection.log' => '訪問をログに保存する',
    'VirtualDirectory.Path.path' => 'パス',
    'VirtualDirectory.Path.autoPathLabel' => '仮想ディレクトリと同名の物理ディレクトリを作成する',
    'VirtualDirectory.ApplicationSettingsSection.title' => 'アプリケーション設定',
    'VirtualDirectory.ApplicationSettingsSection.appCreate' => 'アプリケーションの作成',
    'VirtualDirectory.ApplicationSettingsSection.aspEnableParentPaths' => '親パスの使用を許可する',
    'VirtualDirectory.ApplicationSettingsSection.aspExecuteInMTA' => 'MTA（マルチスレッドアパートメント）モードでのアプリケーション実行を許可する',
    'VirtualDirectory.ScriptExecuteField.scriptExecute' => '実行パーミッション',
    'VirtualDirectory.SecuritySection.title' => 'ディレクトリのセキュリティ',
    'VirtualDirectory.SecuritySection.authAnonymous' => '匿名認証をオンにします',
    'VirtualDirectory.SecuritySection.authNTLM' => 'Windows 認証をオンにします',
    'VirtualDirectory.SecuritySection.requireSSL' => 'SSL/TLS が必要',
    'VirtualDirectory.scriptExecuteOption.none' => 'なし',
    'VirtualDirectory.scriptExecuteOption.script' => 'スクリプトのみ',
    'VirtualDirectory.scriptExecuteOption.scriptExecute' => 'スクリプトと実行可能ファイル',
    'VirtualDirectory.AspSection.title' => 'ASP 設定',
    'VirtualDirectory.AspSection.aspBufferingLimit' => 'ASP バッファの最大サイズ（KB）',
    'VirtualDirectory.AspSection.aspMaxRequestEntityAllowed' => 'ASP 要求のエンティティボディの最大サイズ（KB）',
    'VirtualDirectory.AspSection.aspEnableServerDebug' => 'ASP サーバサイドスクリプトのデバッグを有効にする',
    'VirtualDirectory.AspSection.aspEnableClientDebug' => 'ASP クライアントサイドスクリプトのデバッグを有効にする',
    'VirtualDirectory.AspSection.definedByIis' => 'IIS の定義を使用',
    'VirtualDirectory.AspSection.definedByIisWithSize' => 'IIS の定義を使用（%%size%% KB）',
    'VirtualDirectory.AspSection.definedByParent' => '親ディレクトリの定義を使用',
    'VirtualDirectory.AspSection.definedByParentWithSize' => '親ディレクトリの定義を使用（%%size%% KB）',
    'VirtualDirectory.AspSection.kbytes' => 'KB',
    'VirtualDirectory.CheckboxField.true' => 'はい',
    'VirtualDirectory.CheckboxField.false' => 'いいえ',
    'VirtualDirectory.DocumentsSection.title' => 'ドキュメント',
    'VirtualDirectory.DocumentsSection.enableDefaultDoc' => 'デフォルトドキュメントを使用',
    'VirtualDirectory.DefaultDocsField.defaultDocs' => 'デフォルトドキュメントの検索順序',
    'VirtualDirectory.DefaultDocsField.remove' => '削除',
    'VirtualDirectory.NewDefaultDoc.add' => '追加',
    'VirtualDirectory.NewDefaultDoc.addTooltip' => '一覧にファイルを追加します。',
    'VirtualDirectory.NewDefaultDoc.requiredWarning' => 'リストに追加するファイル名を入力.',
    'VirtualDirectory.PhysicalDirectoryConflictDialog.description' => '同じ名前の物理ディレクトリが既に存在します。続行すると、このディレクトリにアクセスできなくなります。続行してもよろしいですか？',
    'VirtualDirectory.PhysicalDirectoryConflictDialog.proceed' => '続ける',

    'VirtualDirectoryMimeType.extension' => '拡張',
    'VirtualDirectoryMimeType.content' => 'コンテンツ',
    'VirtualDirectoryMimeType.custom' => 'カスタム',
];