<?php
/**
 * Merges one contact into another.
 *
 * Copyright 2010-2017 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file LICENSE for license information (ASL).  If you
 * did not receive this file, see http://www.horde.org/licenses/apache.
 *
 * @author Jan Schneider <jan@horde.org>
 */

require_once __DIR__ . '/lib/Application.php';
Horde_Registry::appInit('turba');

$source = Horde_Util::getFormData('source');
$key = Horde_Util::getFormData('key');
$mergeInto = Horde_Util::getFormData('merge_into');
$driver = $injector->getInstance('Turba_Factory_Driver')->create($source);

if ($url = Horde::verifySignedUrl(Horde_Util::getFormData('url'))) {
    $url = new Horde_Url($url, true);
    $url = $url->unique();
} else {
    $url = Horde::url('', true);
}

try {
    $contact = $driver->getObject($mergeInto);
    $toMerge = $driver->getObject($key);
    $contact->merge($toMerge);
    $contact->store();
    $driver->delete($key);

    $notification->push(_("Successfully merged two contacts."), 'horde.success');
} catch (Horde_Exception $e) {
    $notification->push($e);
}

$url->redirect();
