<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => '추가 키 속성',
    'additional-key-info.update' => '추가 키 검색',
    'additional-key-info.updateDescription' => '추가 키를 검색하고 설치합니다.',
    'additional-key-info.download' => '키 다운로드',
    'additional-key-info.downloadDescription' => '현재 라이선스 키를 다운로드합니다.',
    'additional-key-info.install' => '키 설치',
    'additional-key-info.installDescription' => '현재 라이선스 키를 설치합니다.',
    'additional-key-info.revert' => '키 롤백',
    'additional-key-info.revertDescription' => '이전에 설치한 라이선스 키로 되돌립니다.',
    'additional-key-info.revertNotAvailableDescription' => '설치된 키가 없음.',
    'additional-key-info.installSuccess' => '라이선스 키 설치가 시작되었습니다.',

    'additional-key-revert.title' => '추가 키 롤백',
    'additional-key-revert.success' => '추가 키가 롤백되었습니다.',

    'additional-key-upload.title' => '라이선스 키 설치',
    'additional-key-upload.success' => '새 추가 키가 업로드되었습니다.',

    'additional-keys.title' => '추가 라이선스 키',

    'change-subscriptions-owner.title' => '선택한 구독을 다시 할당하는 중',
    'change-subscriptions-owner.success' => '구독 소유권이 변경되었습니다',

    'customers.hint' => '여기서 호스팅 서비스 고객의 계정을 관리합니다. 즉, 서비스 구독과 함께 새 계정을 만들고, 기존 고객을 관리하고, 계정을 제거합니다. 고객에게 제공되는 웹 사이트, 메일 또는 기타 서비스를 관리하려면 목록의 오른쪽 열에 있는 링크를 클릭하여 고객 패널로 이동합니다.',

    'customer-domains.hint' => '여기서 웹 사이트를 설정하고 관리합니다.',

    'customer-subscriptions.hint' => '여기서 고객의 구독을 관리합니다.',

    'domains.hint' => '여기에서 시스템에 등록된 모든 도메인 이름에 관한 정보를 확인하고 호스팅 서비스 관리를 진행할 수 있습니다. 본인 또는 호스팅 고객을 위해 도메인을 추가하려면 도메인 추가를 클릭하십시오. 도메인을 생성하는 동안 새 고객 및 구독을 생성하거나 기존 고객 중에서 선택하라는 메시지가 표시됩니다.',

    'database-servers.title' => '데이터베이스 서버',

    'database-server-create.title' => '새 데이터베이스 서버',

    'database-server-properties.title' => '데이터베이스 서버',

    'database-server-upgrade.drawerTitle' => 'MariaDB 업그레이드',
    'database-server-upgrade.drawerTitle.completed' => '업그레이드 완료',
    'database-server-upgrade.drawerSubTitle.line1' => '업그레이드가 진행 중인 동안에는 드로어를 닫을 수 없습니다.',
    'database-server-upgrade.drawerSubTitle.line2' => '업그레이드 도중에 문제가 발생하면 %%troubleshootingArticle%%를 참조하십시오.',
    'database-server-upgrade.drawerSubTitle.completed' => 'MariaDB 데이터베이스 서버가 %%releaseVersion%% 버전으로 업그레이드되었습니다. 문제가 발생하면 %%troubleshootingArticle%%의 지시 사항을 따르십시오.',
    'database-server-upgrade.upToDate' => '이미 LTS 버전이 설치되었습니다.',
    'database-server-upgrade.troubleshootingArticle' => '이 KB 문서',
    'database-server-upgrade.troubleshootingArticleDescription' => '%%troubleshootingArticle%%를 사용해 MariaDB 업그레이드 관련 문제를 해결하십시오.',

    'database-server-upgrade.chooseReleaseStep.infoBlock.par1' => '로컬 MariaDB 데이터베이스 서버를 현재 장기 지원(LTS) 버전으로 업그레이드합니다.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par2' => '업그레이드 전에 서버를 백업하고, 웹 사이트의 이용량이 적을 때 업그레이드를 시작할 것을 권장합니다.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par3' => 'MariaDB 업그레이드 동안에는 Plesk 서버 및 호스팅된 웹 사이트를 이용할 수 없습니다. MariaDB 업그레이드는 일반적으로 오류가 발생하지 않으며 약 10분이 소요되지만, 서버 전체에 영향을 미칠 수 있습니다.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par4' => '참고: MariaDB 5.5를 사용 중일 경우, Plesk가 우선 MariaDB 10.5로 업그레이드합니다. 업그레이드가 완료되면 이 마법사를 다시 시작해 MariaDB의 현재 LTS 버전으로 업그레이드하십시오.',
    'database-server-upgrade.chooseReleaseStep.currentVersionTitle' => '현재 버전',
    'database-server-upgrade.chooseReleaseStep.currentMariaDBVersion' => 'MariaDB %%version%%',
    'database-server-upgrade.chooseReleaseStep.selectVersion' => '업그레이드할 버전을 선택하십시오',
    'database-server-upgrade.chooseReleaseStep.noMajorReleases' => '주요 릴리스가 없습니다',
    'database-server-upgrade.chooseReleaseStep.releaseNotes' => '릴리스 정보',
    'database-server-upgrade.chooseReleaseStep.releaseDate' => '출시일: %%date%%',
    'database-server-upgrade.chooseReleaseStep.endOfLifeDate' => '폐쇄일: %%date%%',
    'database-server-upgrade.chooseReleaseStep.notDetected' => 'OS 공급업체 또는 MariaDB 공급업체가 제공한 MariaDB fork만 업그레이드할 수 있습니다.',

    'database-server-upgrade.preUpgradeCheckProgressStep.title' => '업그레이드 전 검사',
    'database-server-upgrade.preUpgradeCheckProgressStep.configChecker' => 'MariaDB 구성 파일 구문 분석 중',
    'database-server-upgrade.preUpgradeCheckProgressStep.mysqlChecker' => 'mysqlcheck로 데이터베이스 분석 중',
    'database-server-upgrade.preUpgradeCheckProgressStep.packageManagerChecker' => '패키지 관리자 구성 분석 중',
    'database-server-upgrade.preUpgradeCheckProgressStep.systemCompatibilityChecker' => '시스템 호환성 검사 중',
    'database-server-upgrade.preUpgradeCheckProgressStep.webSocketChecker' => 'WebSocket 검사 중',

    'database-server-upgrade.preUpgradeCheckStep.shouldBeConfirmed' => '업그레이드를 진행하려면 모든 확인란을 선택하십시오. 업그레이드로 인한 구성 변경에 동의하며 복구 옵션에 액세스할 수 있다는 점을 확인해야 합니다.',
    'database-server-upgrade.preUpgradeCheckStep.removedSystemVariables' => '새로운 버전과의 호환성을 위하여 다음 변수가 제거됩니다:',
    'database-server-upgrade.preUpgradeCheckStep.removedConfigFiles' => '다음 구성 파일은 업그레이드될 Mariadb-서버 패키지의 일부이므로 제거됩니다:',
    'database-server-upgrade.preUpgradeCheckStep.fromFiles' => '{count, plural, other {파일 #개: {files}}}의 {variable}',
    'database-server-upgrade.preUpgradeCheckStep.accessToolsSection' => '복구 옵션 액세스(서버 명령줄 콘솔 및 Repair Kit)',
    'database-server-upgrade.preUpgradeCheckStep.sshAccess' => '서버에 대한 SSH 액세스 권한이 있습니다',
    'database-server-upgrade.preUpgradeCheckStep.sshAccessDescription' => 'SSH 클라이언트를 사용하거나 새로운 브라우저 탭에서 %%sshTerminalExtension%%을 여십시오(업그레이드가 완료될 때까지 SSH 터미널 확장 프로그램 창을 닫아서는 안 됩니다). 업그레이드가 실패할 경우 SSH 액세스 권한이 있으면 복원이 한결 수월합니다.',
    'database-server-upgrade.preUpgradeCheckStep.sshTerminalExtension' => 'SSH 터미널 확장 프로그램',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccess' => 'Repair Kit 액세스 권한이 있습니다',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccessDescription' => '새로운 브라우저 탭에서 %%repairKit%%를 열고 관리자 자격 증명으로 로그인하십시오. 업그레이드가 완료될 때까지 Repair Kit 확장 프로그램 창을 닫아서는 안 됩니다.',
    'database-server-upgrade.preUpgradeCheckStep.repairKit' => 'Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.dumpSection' => '데이터베이스 백업',
    'database-server-upgrade.preUpgradeCheckStep.withDump' => '업그레이드 전에 서버에 호스팅된 모든 데이터베이스를 백업하십시오',
    'database-server-upgrade.preUpgradeCheckStep.withDumpDescription' => 'Plesk가 데이터베이스의 백업을 %%path%% 디렉터리에 저장할 것입니다.',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailable' => 'Plesk의 WebSocket을 사용할 수 없습니다',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailableDescription' => 'WebSocket을 사용하지 않으면 업그레이드 프로세스의 실시간 출력을 확인할 수 없습니다.',

    'database-server-upgrade.submitPopover.title' => '진행하기 전 잠재적인 데이터 손실을 방지하기 위해 호스팅된 데이터베이스의 덤프를 생성할 것을 권장합니다. 덤프를 생성하지 않고 계속하시겠습니까?',

    'database-server-databases.title' => '데이터베이스',

    'database-server-change-password.title' => '관리자의 암호',

    'home.title' => '홈',

    'license.title' => '라이선스 정보',

    'primary-key-info.title' => 'Plesk 라이선스 키',
    'primary-key-info.update' => '키 가져오기',
    'primary-key-info.updateDescription' => '주문한 라이선스 키를 검색하고 설치합니다.',
    'primary-key-info.upload' => '키 설치',
    'primary-key-info.uploadDescription' => '새 라이선스 키를 업로드하고 설치합니다.',
    'primary-key-info.revert' => '키 롤백',
    'primary-key-info.revertDescription' => '이전에 설치한 라이선스 키로 되돌립니다.',
    'primary-key-info.expireTitle' => 'Plesk 키가 만료되었습니다',
    'primary-key-info.header' => '이로 인해, 일부 핵심 서비스를 이용할 수 없게 되었습니다. %%warning%%',
    'primary-key-info.headWarning' => '웹사이트가 위험해질 수 있습니다!',
    'primary-key-info.softwareUpdatesTitle' => '소프트웨어 업데이트',
    'primary-key-info.softwareUpdates' => '%%title%%가 꺼져 있습니다. 시스템이 위협에 취약할 수 있습니다.',
    'primary-key-info.websiteBackupsTitle' => '웹사이트 백업',
    'primary-key-info.websiteBackups' => '%%title%%을 더 이상 이용할 수 없습니다. 데이터 손실의 위험이 있습니다.',
    'primary-key-info.sslCertificatesTitle' => 'SSL/TLS 인증서',
    'primary-key-info.sslCertificates' => '%%title%%가 자동으로 갱신되지 않습니다. 신뢰 및 보안에 위험 요소가 될 수 있습니다.',
    'primary-key-info.monitoringTitle' => '모니터링',
    'primary-key-info.monitoring' => '%%title%%을 이용할 수 없습니다. 오버로드 및 성능 문제를 간과할 수 있습니다.',
    'primary-key-info.fileDbManagementTitle' => '파일 및 데이터베이스 관리',
    'primary-key-info.fileDbManagement' => '%%title%%가 꺼져 있습니다. 파일 및 데이터베이스를 효율적으로 관리할 수 없습니다.',
    'primary-key-info.technicalSupportTitle' => '기술 지원',
    'primary-key-info.technicalSupport' => '%%title%%을 이용할 수 없습니다. 서버 문제 관련하여 필요한 지원을 받지 못하게 되면 장기적인 서비스 중단으로 이어질 수 있습니다.',
    'primary-key-info.renewLicense' => '이 서비스들을 복구하려면 지금 새로운 Plesk 라이센스를 구매하십시오.',
    'primary-key-info.footer' => '질문이 있거나 도움이 필요하실 경우, ',
    'primary-key-info.supportLink' => 'Plesk 고객지원에 문의하세요',

    'primary-key-revert.title' => '라이선스 키 롤백',
    'primary-key-revert.success' => 'Plesk 키가 롤백되었습니다.',

    'primary-key-upload.title' => '라이선스 키 설치',
    'primary-key-upload.success' => '새 Plesk 키가 업로드되었습니다.',

    'resellers.hint' => '여기에서 리셀러(호스팅 서비스를 재판매하고 자체 웹 사이트를 호스팅하는 고객) 계정을 관리합니다. 즉, 서비스 구독과 함께 새 계정을 만들고, 기존 리셀러를 관리하며 계정을 제거합니다.',

    'reseller-customers.hint' => '여기에서 고객을 설정하고 관리합니다.',

    'reseller-domains.hint' => '여기서 웹 사이트를 설정하고 관리합니다.',

    'reseller-subscriptions.hint' => '여기에서 대리점의 구독을 관리합니다.',

    'subscriptions.hint' => '고객은 호스팅 플랜에 가입하여 귀하의 호스팅 서비스를 제공받습니다. 여기에서 이러한 구독과 함께 웹 사이트를 호스팅하기 위해 만든 자체 구독도 관리할 수 있습니다. 구독을 통해 제공되는 웹 사이트, 메일 또는 기타 서비스를 관리하려면 목록의 오른쪽 열에 있는 링크를 클릭하여 구독자의 고객 패널로 이동하십시오.',

    'server-mail-settings.title' => '설정',
    'server-mail-spam-filter.title' => '스팸 필터링',
    'server-mail-antivirus.title' => '안티 바이러스',
    'server-mail-black-list.title' => '차단 목록',
    'server-mail-white-list.title' => '허용 목록',
    'server-mail-queue.title' => '메일 대기열',
    'server-mail-statistics.title' => '통계',
    'server-mail-smarthost.title' => '스마트호스트',

    'server-spam-filter.settings' => '설정',
    'server-spam-filter.black-list' => '차단 목록',
    'server-spam-filter.white-list' => '허용 목록',

    'firewall.title' => '방화벽 관리',
    'firewall-general.title' => '일반',
    'firewall-general.toggleStatus' => '방화벽 보호',
    'firewall-general.buttonDefault' => '기본값으로 초기화',
    'firewall-general.buttonPanic' => '패닉 모드',
    'firewall-general.confirmationDefault' => '방화벽 설정을 기본 설정으로 재설정하시겠습니까?',
    'firewall-general.confirmationPanic' => '패닉 모드를 사용하시겠습니까? 사용자가 도메인에 액세스할 수 없으며 일부 네트워크 서비스의 작동이 중지될 수 있습니다.',
    'firewall-general.successDefault' => '방화벽 설정이 기본 설정으로 재설정되었습니다.',
    'firewall-general.successPanic' => '패닉 모드가 활성화되었습니다.',
    'firewall-general.info' => '보안상 이유로 인해 방화벽이 명시적으로 허용된 연결을 제외한 모든 연결을 차단합니다. 규칙을 생성하여 연결을 허용할 수 있습니다. 자세한 내용은 문서를 참조하십시오.',
    'firewall-general.interfaces' => '네트워크 인터페이스',
    'firewall-icmp.title' => 'ICMP 프로토콜',
    'firewall-rules.title' => '방화벽 규칙',

    'dns.title' => 'DNS 설정',
    'dns-records.title' => '영역 레코드 템플릿',
    'dns-soa-record.title' => '영역 설정 템플릿',

    'php-handler.title' => '%%name%% 설정',
    'php-handler.extensions.title' => '확장 프로그램',
    'php-handler.extensions.description' => '이 PHP 확장 설정은 이 처리기에만 적용됩니다.',
    'php-handler.extensions.descriptionShared' => '이 설정은 다음과 같은 PHP 처리기에서 공통입니다: %%handlers%%. 이 처리기를 사용하는 모든 웹 사이트에 설정을 적용합니다.',
    'php-handler.extensions.buttonManage' => 'PECL 패키지 관리',
    'php-handler.extensions.manage.title' => 'PECL 패키지 관리',
    'php-handler.extensions.manage.risks' => 'PHP 확장 프로그램은 제삼자 PECL 패키지가 공급합니다. 설치에 대한 일체의 책임은 귀하에게 있습니다.',
    'php-handler.extensions.manage.description' => 'PECL 패키지를 설치, 업그레이드, 제거합니다. 변경 사항은 %%handlers%% 처리기로 구동 중인 모든 웹 사이트에 적용됩니다.',
    'php-handler.extensions.manage.notFound' => '왜 원하는 패키지가 목록에 없나요?',
    'php-handler.extensions.manage.limitations' => '제어판 제공자가 공급하는 PHP 확장 프로그램과 OS 공급업체는 목록에 표시되지 않습니다.',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.refresh' => "새로 고침",
    'ServerInformation.sectionGeneral' => "일반",
    'ServerInformation.cpu' => "CPU",
    'ServerInformation.version' => "버전",
    'ServerInformation.os' => "운영 체제",
    'ServerInformation.key' => "Plesk 라이선스 키",
    'ServerInformation.uptime' => "가동 시간",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} other {#일}} {hours, plural, other {#시간}} {minutes, plural, other {#분}}",
    'ServerInformation.sectionCpu' => "CPU 사용률",
    'ServerInformation.la1min' => "마지막 1분",
    'ServerInformation.la5min' => "마지막 5분",
    'ServerInformation.la15min' => "마지막 15분",
    'ServerInformation.sectionMemory' => "메모리 사용량",
    'ServerInformation.memoryHardware' => "하드웨어",
    'ServerInformation.memoryTotalNoKernel' => "총 용량(커널 제외)",
    'ServerInformation.memoryTotal' => "전체",
    'ServerInformation.memoryUsed' => "사용 중",
    'ServerInformation.memoryFree' => "여유 공간",
    'ServerInformation.memoryShared' => "공유",
    'ServerInformation.memoryBuffer' => "버퍼",
    'ServerInformation.memoryCached' => "캐시됨",
    'ServerInformation.memoryAvailable' => "사용 가능함",
    'ServerInformation.memoryUsage' => "사용",
    'ServerInformation.sectionSwap' => "스왑 사용량",
    'ServerInformation.sectionVirtualMemory' => "가상 메모리 사용량",
    'ServerInformation.swapTotal' => "전체",
    'ServerInformation.swapUsed' => "사용 중",
    'ServerInformation.swapFree' => "여유 공간",
    'ServerInformation.swapUsage' => "사용",
    'ServerInformation.sectionHarddisk' => "하드 디스크 사용량",
    'ServerInformation.harddiskDirectory' => "파일 시스템",
    'ServerInformation.harddiskProtectedDir' => "중요 디렉터리",
    'ServerInformation.harddiskTotal' => "전체",
    'ServerInformation.harddiskUsed' => "사용 중",
    'ServerInformation.harddiskAvailable' => "사용 가능함",
    'ServerInformation.harddiskCapacity' => "용량",
    'ServerInformation.sectionDomains' => "도메인",
    'ServerInformation.activeDomains' => "활성화됨",
    'ServerInformation.inactiveDomains' => "비활성화됨",
    'ServerInformation.problemDomains' => "문제",
    'ServerInformation.refreshed' => "정보 새로 고침.",

    'ServerAbout.copyright' => '© 2025 WebPros International GmbH. All rights reserved.',
    'ServerAbout.linkLicenseManagement' => '라이선스 정보로 이동',
    'ServerAbout.panelVersion' => '버전',
    'ServerAbout.installedPatchVersion' => '#%%patch%% 업데이트',
    'ServerAbout.licenseKey' => '라이선스 키',
    'ServerAbout.productDescription' => 'Plesk는 응용 프로그램, 웹 사이트, 호스팅 비즈니스를 운영, 자동화 및 확장시키는 선도적인 WebOps 플랫폼입니다.',
    'ServerAbout.readEula' => '%%link%%을(를) 읽어 보십시오.',
    'ServerAbout.linkEula' => '최종 사용자 라이선스 계약',
    'ServerAbout.visitForum' => '%%link%% 방문',
    'ServerAbout.linkForum' => 'Plesk 포럼',
    'ServerAbout.followUs' => '팔로우하기',
    'ServerAbout.visitSite' => '%%link%%에서 자세히 알아보기',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => '%%link%%에서 영감 얻기',
    'ServerAbout.linkBlog' => 'Plesk 블로그',

    'ServerAbout.darkThemePromoTitle' => '축하합니다!',
    'ServerAbout.darkThemePromoDescription' => '마법 고양이를 찾으셨습니다.',
    'ServerAbout.darkThemePromoButton' => '어둠을 받아들여라!',
    'ServerAbout.darkThemeTourDescription' => '이 옵션을 전환하면 인터페이스의 어두운 테마를 활성화 또는 비활성화합니다.',
    'ServerAbout.darkThemeTourButton' => '확인',

    'ts-sessions.title' => '터미널 서버 세션',
    'ts-sessions-properties.title' => '세션 속성',

    'BandwidthLimiting.bandwidthThrottling' => 'QoS가 설치되지 않아 대역폭 제한을 제어할 수 없습니다.',
    'BandwidthLimiting.virtualHostingRequired' => '대역폭 제한은 웹 호스팅이 있는 도메인에만 사용할 수 있습니다.',
    'BandwidthLimiting.bandwidthLabel' => '최대 대역폭 사용량',
    'BandwidthLimiting.bandwidthHint' => '대역폭 사용량 제한은 HTTP 프로토콜을 통해 전송되는 데이터에만 적용됩니다.',
    'BandwidthLimiting.maxConnectionLabel' => '연결 제한',
    'BandwidthLimiting.maxConnectionHint' => '대역폭을 제한하는 경우 웹 사이트에 대한 동시 연결 수도 제한하는 것이 좋습니다. 그러지 않으면 웹 사이트에 대한 요청이 많을 경우 웹 서버 프로세스가 서버 부하를 증가시킵니다.',
    'BandwidthLimiting.kbps' => 'KB/초',
    'BandwidthLimiting.success' => '대역폭 제한 설정이 변경되었습니다.',
    'BandwidthLimiting.unlimited' => '제한 없음',

    'ip-address-domains.title' => '%%type%% IP 주소를 사용하는 웹 사이트 %%ipAddress%%',
    'ip-address-domains.site' => '사이트',
    'ip-address-domains.setAsDefault' => '기본값으로 설정',
    'ip-address-domains.type-SHARED' => '공유',
    'ip-address-domains.type-EXCLUSIVE' => '전용',

    'HotlinkProtection.virtualHostingRequired' => '핫링크 보호는 웹 호스팅이 있는 도메인에만 사용할 수 있습니다.',
    'HotlinkProtection.enabledLabel' => '핫링크 보호 활성화',
    'HotlinkProtection.extensionsLabel' => '보호된 파일 확장명',
    'HotlinkProtection.friendsLabel' => '안전한 웹 사이트 주소',
    'HotlinkProtection.success' => '핫링크 보호 설정이 변경되었습니다.',

    'Odbc.add' => 'ODBC DSN 추가',
    'Odbc.resourceUsage' => '%%used%% 생성됨 / %%allowed%% 허용됨.',
    'Odbc.limitExceeded' => 'ODBC DSN 연결 한도를 초과했습니다.',
    'Odbc.unlimited' => '제한 없음',
    'Odbc.addTooltip' => 'ODBC 데이터 소스를 추가합니다.',
    'Odbc.status' => '상태',
    'Odbc.name' => '연결 이름',
    'Odbc.driver' => '드라이버',
    'Odbc.description' => '연결 설명',
    'Odbc.hostname' => '호스트 이름',
    'Odbc.statusSystem' => '이것은 시스템 DSN입니다.',
    'Odbc.statusConfigured' => 'DSN이 구성되었습니다.',
    'Odbc.statusNotConfigured' => 'DSN이 구성되지 않았습니다.',
    'Odbc.noSelectionText' => '제거할 항목을 1개 이상 선택하십시오.',
    'Odbc.removeConfirmation' => '{count, plural, =1 {{name} 연결을} other {선택한 연결 #개를}} 제거하시겠습니까?',
    'Odbc.removeSuccess' => '선택한 연결이 제거되었습니다.',

    'DomainAliasSettings.title' => '도메인 별칭 설정',
    'DomainAliasSettings.updateSuccess' => '도메인 별칭 %%name%%의 속성이 변경되었습니다. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => '웹 사이트 설정이 %%restartInterval%%분 이내에 적용됩니다.',

    'Home.Backup.offStatus' => '잘못된 백업입니다. 이 파일에서 데이터를 복원할 수 없습니다.',
    'Home.Backup.task-failedStatus' => '백업 작업에 실패했습니다.',
    'Home.Backup.activeSchedule' => '일정: %%schedule%%',
    'Home.Backup.activeSchedules' => '일정: %%schedules%%',
    'Home.Backup.noSchedule' => "백업 일정이 지정되지 않았습니다",
    'Home.Backup.period_hourly' => '일정 시간별 %%schedule%%',
    'Home.Backup.period_daily' => '일일 %%schedule%%',
    'Home.Backup.period_weekly' => '매주 %%schedule%%',
    'Home.Backup.period_monthly' => '매월 %%schedule%%',
    'Home.Backup.create' => '백업 생성',
    'Home.Backup.schedule' => '예약',
    'Home.ChangeLog.seeHistory' => '변경 히스토리 보기',
    'Home.CustomButtons.add' => '사용자 지정 버튼 추가',
    'Home.CustomButtons.noButtons' => '사용자 지정 버튼이 없습니다',
    'Home.Customization.title' => '대시보드',
    'Home.Customization.description' => '확인할 옵션을 선택하십시오',
    'Home.Customization.pleskSection' => 'Plesk',
    'Home.Customization.serverSection' => '서버',
    'Home.Customization.securitySection' => '보안',
    'Home.Customization.backup' => '마지막 서버 백업',
    'Home.Customization.ipBan' => 'IP 주소 금지',
    'Home.Customization.mailQueue' => '메일 대기열',
    'Home.Customization.mySubscriptions' => '내 구독',
    'Home.Customization.overusedSubscriptions' => '초과 사용이 있는 구독',
    'Home.Customization.serverInfo' => '서버 정보',
    'Home.Customization.updates' => 'Plesk 업데이트',
    'Home.Customization.promo' => '프로모',
    'Home.Customization.changeLog' => '새로운 내용',
    'Home.Customization.customButtons' => '사용자 지정 버튼',
    'Home.EmptyView.title' => '어떤 옵션을 볼지 선택해 대시보드를 최대한 활용하십시오.',
    'Home.EmptyView.titleLocked' => '서버 공급자에 의해 대시보드가 잠겨 있습니다.',
    'Home.EmptyView.customize' => '사용자 지정',
    'Home.Extension.title' => '확장명',
    'Home.IpBan.banned' => '금지',
    'Home.IpBan.trusted' => '신뢰',
    'Home.IpBan.more' => '더 보기',
    'Home.MailQueue.total' => '전체',
    'Home.MailQueue.deferred' => '지연됨',
    'Home.MailQueue.held' => '보류 중',
    'Home.MailQueue.more' => '더 보기',
    'Home.MailQueue.clean' => '메일 대기열 지우기',
    'Home.MailQueue.checkLogs' => '로그 확인',
    'Home.MailQueue.repair' => '복구',
    'Home.MailQueue.cleanConfirmQuestion' => '메일 대기열을 지우시겠습니까?',
    'Home.MailQueue.cleanConfirmYes' => '예',
    'Home.MailQueue.cleanConfirmNo' => '아니오',
    'Home.MailQueue.queueCleaned' => '메일 대기열이 성공적으로 삭제되었습니다.',
    'Home.OverusedSubscriptions.empty' => '초과 사용이 있는 구독이 없습니다',
    'Home.OverusedSubscriptions.usage' => '%%formattedValue%% 중 %%formattedUsed%%',
    'Home.OverusedSubscriptions.more' => '초과 사용이 있는 모든 구독 보기: [%%total%%]',
    'Home.OverusedSubscriptions.list' => '목록에서 열기',
    'Home.PromoNewHomeView.title' => '새로운 홈페이지에 오신 것을 환영합니다!',
    'Home.PromoNewHomeView.description' => '문제가 발생하면 피드백을 공유하여 주시면 감사하겠습니다. 여러분의 피드백은 추후 개선에 큰 도움이 됩니다.',
    'Home.PromoNewHomeView.feedback' => '피드백 공유',
    'Home.PromoNewHomeView.switch' => '"홈"으로 다시 전환하기',
    'Home.ServerInfo.hostname' => '호스트 이름',
    'Home.ServerInfo.ipAddress' => 'IP 주소',
    'Home.ServerInfo.publicIpAddress' => '공용 IP 주소',
    'Home.ServerInfo.os' => 'OS',
    'Home.ServerInfo.uptime' => '가동 시간',
    'Home.ServerInfo.uptimeValue' => "{days, plural, =0 {} other {#일}} {hours, plural, other {#시간}} {minutes, plural, other {#분}}",
    'Home.ServerInfo.more' => '더 보기',
    'Home.Subscriptions.add' => '새로 추가',
    'Home.Subscriptions.empty' => '구독을 만들면 서버의 격리된 공간에 여러 웹사이트를 호스팅할 수 있습니다. %%link%%',
    'Home.Subscriptions.help' => '자세히 알아보기',
    'Home.Updates.title' => '제품 업데이트',
    'Home.Updates.version' => '%%name%% %%version%%',
    'Home.Updates.patch' => '%%version%% 업데이트 #%%patch%%',
    'Home.Updates.manageComponents' => '구성 요소 추가 또는 제거',
    'Home.Updates.lastUpdated' => '마지막 업데이트 시간: %%lastUpdateDate%%',
    'Home.Updates.checkUpdates' => '업데이트 확인',
    'Home.Updates.enableAutoupdate' => '자동 업데이트 허용',
    'Home.Updates.lastChecked' => '마지막 확인: %%lastCheckDate%%',
    'Home.Updates.newVersionAvailable' => '%%availableVersion%% 이용 가능',
    'Home.Updates.installNewVersion' => '지금 설치',
    'Home.Updates.patchAvailable' => '보조 업데이트 이용 가능',
    'Home.Updates.patchAvailableVersion' => '%%currentVersion%% 보조 업데이트를 사용할 수 있습니다',
    'Home.Updates.installPatch' => '지금 업데이트',
    'Home.Updates.pumUpdates' => '{total, select, 1 {{package} 업데이트} other {{package} 업데이트를}} 이용할 수 있습니다',
    'Home.Updates.pumPackage' => '%%name%% %%availableVersion%%',
    'Home.Updates.pumPackages' => '{total, plural, other {패키지 #개}}',
    'Home.Updates.installUpdates' => '{total, select, 1 {지금 업데이트} other {전부 업데이트}}',
    'Home.Promo.Customize.title' => '대시보드를 나에게 맞춰보세요!',
    'Home.Promo.Customize.content' => '새로운 사용자 맞춤형 대시보드로 손끝에서 가장 좋아하는 기능을 바로바로 사용해 보세요',
    'Home.Promo.Customize.action' => '사용자 지정',
    'Home.Promo.SwitchToPuv.title' => 'Plesk의 인터페이스 보기 설정에 대해 아시나요?',
    'Home.Promo.SwitchToPuv.content' => '서비스 요금제를 사용하는 고객에게 호스팅 서비스를 제공하지 않을 경우 웹사이트, 웹사이트의 파일, 데이터베이스, 이메일 계정, 웹 응용 프로그램을 더욱 편리하게 관리하도록 해주는 인터페이스를 사용하여 보십시오.',
    'Home.Promo.SwitchToPuv.action' => '지금 사용해 보십시오.',
    'Home.Status.error' => '오류',
    'Home.Status.warning' => '경고',
    'Home.Status.info' => '정보',

    'HostingSettings.title' => '호스팅 설정',
    'HostingSettings.updateSuccess' => '설정이 업데이트되었습니다.',
    'HostingSettings.emptyLogin' => '사용자 이름을 지정해야 합니다.',
    'HostingSettings.emptyPassword' => '암호를 지정해야 합니다.',
    'HostingSettings.ipV6OnlyNotSupported' => 'FTP 서버가 IPv6을 지원하지 않습니다. IPv4 주소를 하나 이상 할당하십시오. 그렇지 않으면 사용자가 FTP를 통해 서버에 파일을 업로드할 수 없습니다.',
    'HostingSettings.domainSettingsSection.sectionTitle' => '도메인 설정',
    'HostingSettings.domainSettingsSection.domainName' => '도메인 이름',
    'HostingSettings.domainSettingsSection.description' => '예: example.com ',

    'HostingSettings.submitPopover.title' => '%%website%% 콘텐츠 제거',
    'HostingSettings.submitPopover.descriptionMainDomain' => '"웹 사이트" 호스팅 유형을 "%%type%%"으로 전환하면 다음 디렉터리를 포함하여 일체의 웹 사이트 콘텐츠가 제거됩니다:',
    'HostingSettings.submitPopover.descriptionSubDomain' => '웹 사이트의 호스팅 유형을 변경하시겠습니까?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => '더 많은 설정을 이용하려면 시스템 사용자 자격 증명을 입력한 후 "웹 공간 만들기"를 누르십시오.',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => '더 많은 설정을 이용하려면 "다음" 버튼을 눌러 호스팅을 생성하십시오.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => '호스팅 유형',
    'HostingSettings.domainSettingsSection.hostingType.title' => '유형',
    'HostingSettings.domainSettingsSection.hostingType.website' => '웹 사이트',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => '전달',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => '웹 호스팅 없음',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => '이 도메인 이름으로 된 사서함을 원하는 경우 도메인의 DNS 영역을 사용하세요',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => '웹사이트 홈 디렉터리의 경로',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => '기본 도메인',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => '방문자를 SEO 보호 HTTP 301 리디렉션을 통해 이곳으로 리디렉션합니다.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => '방문자 전달 대상',
    'HostingSettings.domainSettingsSection.forwardingType.title' => '전달 유형',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => '영구적으로 이동됨(코드 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => '웹 사이트 방문자를 다른 사이트로 리디렉션하고 이들에게 대상 주소를 표시합니다. 이러한 리디렉션은 사이트의 검색 순위를 유지합니다',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => '일시적으로 이동됨(코드 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => '검색 엔진이 이 임시 사이트를 인덱싱하는 것을 원하지 않는 경우 웹 사이트 방문자를 임시 사이트 사본으로 리디렉션합니다.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => '프레임 전달',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => '웹 사이트 방문자를 다른 사이트로 리디렉션하지만 방문자가 리디렉션 사실을 알지 못하도록 방문자에게 대상 주소를 표시하지 않습니다.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => '기본 도메인',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => '없음',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => '문서 루트',
    'HostingSettings.domainSettingsSection.documentRootHint' => '이 웹 사이트에 웹 응용 프로그램이 설치되어 있어서 문서 루트를 변경할 수 없습니다.',
    'HostingSettings.domainSettingsSection.save' => '저장',
    'HostingSettings.domainSettingsSection.sameSsl.title' => '호환성 모드',
    'HostingSettings.domainSettingsSection.sameSsl.enabled' => '레거시 옵션 "SSL/TLS 콘텐츠와 SSL/TLS가 아닌 콘텐츠 구분"에 대한 호환성 모드로 웹 사이트 실행',
    'HostingSettings.domainSettingsSection.sameSsl.hint' => '업그레이드 전에 더는 사용되지 않는 "SSL/TLS 콘텐츠와 SSL/TLS가 아닌 콘텐츠 구분" 옵션을 사용했기 때문에 해당 웹사이트가 호환성 모드에서 작동하고 있으며, Plesk 인터페이스로 관리할 수 없습니다. Plesk 11부터는 웹사이트가 HTTP 및 HTTPS 연결을 통해 접근 가능한 콘텐츠를 같은 디렉터리에 저장합니다. 모든 데이터를 \'httpsdocs/\' 디렉터리에서 \'httpdocs/\'로 옮긴 후 호환성 모드를 비활성화하는 것을 권장합니다. 또한, 이 경우 \'httpsdocs/\' 디렉터리에 설치된 앱에 인터넷을 통해 접근할 수 있게 됩니다. 호환성 모드를 다시 활성화할 수 없다는 점에 주의하여 주십시오.',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => '이 설정을 변경하시겠습니까?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => '이 설정을 변경하는 것은 서버의 보안 정책과 상충하며, 성능을 저해하거나 서버를 공격에 취약하게 만들 수 있습니다.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => '변경',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => '되돌리기',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => '보안 기본 설정이 적용되었습니다',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => '보안을 개선하려면 보안 기본 설정을 적용하십시오. 특정 권한은 구독자가 이러한 설정을 변경하는 것을 허용한다는 점 유의하십시오.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => '보안 기본 설정 적용',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => '보안 호스팅 설정에 대해 알아보기',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'SSL/TLS 지원',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => '활성화',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => '웹 사이트 및 방문자의 브라우저 간 연결을 암호화합니다.',
    'HostingSettings.domainSettingsSection.security.certificate' => '인증서',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'HTTPS를 활성화하려면 도메인의 리포지토리에 SSL/TLS 인증서를 업로드한 후 이곳에서 선택하십시오.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => '방문자를 SEO 보호 HTTP 301 리디렉션을 통해 HTTP에서 HTTPS로 리디렉션',
    'HostingSettings.domainSettingsSection.security.noCertificates' => '리포지토리에 SSL/TLS 인증서가 없습니다. 인증서를 추가하려면 %%link%%(으)로 이동하십시오.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => '이 페이지',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (기타 리포지토리)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => '선택되지 않음',
    'HostingSettings.domainSettingsSection.webScripting.title' => '웹 스크립팅',
    'HostingSettings.domainSettingsSection.webScripting.description' => '프로그래밍 및 스크립팅 언어 중에서 웹 서버가 해석해야 하는 항목을 지정합니다.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'cgi-bin 디렉터리의 위치 %%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => '*.htm, *.html 파일에 SSI 사용',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Microsoft ASP.NET 버전',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => '사용자 지정 오류 문서',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'cgi-bin 디렉터리의 위치',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => '이 도메인의 문서 루트',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => '웹 공간의 루트 디렉터리',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => '이 도메인의 이전 스타일 루트',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => '사용자 지정 오류 문서',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => '추가 쓰기/수정 권한',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => '웹 배포 게시',
    'HostingSettings.domainSettingsSection.webStatistics.title' => '웹 통계',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => '도구',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'FTP 사용자 이름과 암호로 웹 통계에 대한 액세스 보호',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => '비활성화됨',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => '웹 공간 설정',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'IP 주소',
    'HostingSettings.webspaceSettingsSection.quota.title' => '디스크 공간 할당량',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => '활성화',
    'HostingSettings.webspaceSettingsSection.quota.description' => '구독 설정(해당하는 경우)에서 지정된 디스크 공간 할당량을 초과할 경우 웹 사이트의 파일에 대한 작업을 금지합니다.',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => '서버 파일 시스템의 구성으로 인해 하드 디스크 할당량이 지원되지 않습니다.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => '시스템 사용자 자격 증명',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'FTP 또는 파일 관리자로 웹 사이트의 파일 및 폴더를 관리합니다. 권한이 있는 경우 SSH를 통해 서버에 액세스합니다.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'FTP 또는 파일 관리자로 웹 사이트의 파일 및 폴더를 관리합니다. 권한이 있는 경우 원격 데스크톱를 통해 서버에 액세스합니다.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => '사용자 이름',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => '암호',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => '이곳에서 새로운 비밀번호를 지정하면 시스템 사용자의 비밀번호도 변경됩니다.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'SSH 액세스',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => '원격 데스크톱 액세스',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => '활성화',
    'HostingSettings.webspaceSettingsSection.shell.description' => "시스템 사용자 자격 증명을 사용하여 서버에 액세스합니다.",
    'HostingSettings.webspaceSettingsSection.shell.type' => '유형',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => '비활성화됨',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => '{count, plural, other {도메인 #개}}에 적용',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => '다음 설정은 {count, plural, other {{name} 웹 공간에 있는 #개의 도메인}}에 공통 적용됩니다:',

    'OdbcAdd.title' => 'ODBC DSN 추가',
    'OdbcAdd.nameLabel' => '연결 이름',
    'OdbcAdd.descriptionLabel' => '연결 설명',
    'OdbcAdd.driver' => '드라이버',
    'OdbcAdd.submit' => 'ODBC DSN 생성',

    'OdbcEdit.title' => 'ODBC 연결 설정',
    'OdbcEdit.saveSuccess' => '연결 설정이 저장되었습니다.',
    'OdbcEdit.test' => '연결을 테스트합니다',
    'OdbcEdit.connectSuccess' => '연결 성공.',

    'OdbcEdit.excel.driver.label' => '드라이버',
    'OdbcEdit.excel.dbq.label' => '데이터베이스 파일 경로',
    'OdbcEdit.excel.defaultdir.label' => '기본 데이터 디렉터리',
    'OdbcEdit.excel.fil.label' => '데이터베이스 버전',
    'OdbcEdit.excel.maxbuffersize.label' => '최대 버퍼 크기',
    'OdbcEdit.excel.pagetimeout.label' => '페이지 시간초과',

    'OdbcEdit.access.driver.label' => '드라이버',
    'OdbcEdit.access.dbq.label' => '데이터베이스 파일 경로',
    'OdbcEdit.access.uid.label' => '로그인 ID',
    'OdbcEdit.access.pwd.label' => '암호',
    'OdbcEdit.access.pagetimeout.label' => '페이지 시간초과',
    'OdbcEdit.access.pagetimeout.description' => '버퍼에 사용되지 않는 페이지가 유지되는 시간(1/10초). 이 옵션은 Microsoft Access 드라이버를 사용하는 모든 데이터 소스에 적용됩니다.',
    'OdbcEdit.access.maxbuffersize.label' => '최대 버퍼 크기',
    'OdbcEdit.access.maxbuffersize.description' => '256KB 한계에 맞춘 내부 버퍼 크기(KB).',
    'OdbcEdit.access.readonly.label' => '읽기 전용',
    'OdbcEdit.access.readonly.description' => '업데이트를 금지하도록 데이터베이스를 읽기 전용으로 지정합니다.',
    'OdbcEdit.access.exclusive.label' => '배타적',
    'OdbcEdit.access.exclusive.description' => '공유 업데이트를 금지하도록 데이터베이스를 전용으로 지정합니다.',
    'OdbcEdit.access.safetransactions.label' => '안전한 트랜잭션',
    'OdbcEdit.access.safetransactions.description' => '0(기본 설정)으로 설정하면 모든 트랜잭션이 즉시 커밋됩니다. 1로 설정하면 커밋 작업 시에만 모든 트랜잭션이 디스크에 저장되지만 성능이 다소 저하됩니다.',
    'OdbcEdit.access.threads.label' => '스레드',
    'OdbcEdit.access.threads.description' => '사용할 엔진의 백그라운드 스레드 수.',
    'OdbcEdit.access.maxscanrows.label' => '최대 스캔 열',
    'OdbcEdit.access.maxscanrows.description' => '기존 데이터에 따라 열의 데이터 형식을 설정할 때 검사할 행의 수.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => '트랜잭션을 벗어난 변경 사항을 데이터베이스에 기록하는 방법을 지정합니다.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'MS Access 드라이버가 명시적 사용자 정의 트랜잭션을 비동기로 수행할지 여부를 지정합니다.',

    'OdbcEdit.mssql.driver.label' => '드라이버',
    'OdbcEdit.mssql.server.label' => '서버',
    'OdbcEdit.mssql.uid.label' => '로그인 ID',
    'OdbcEdit.mssql.pwd.label' => '암호',
    'OdbcEdit.mssql.database.label' => '기본 데이터베이스',
    'OdbcEdit.mssql.app.label' => '응용 프로그램 이름',
    'OdbcEdit.mssql.wsid.label' => '워크스테이션 ID',
    'OdbcEdit.mssql.language.label' => '기본 언어',
    'OdbcEdit.mssql.oemtoansi.label' => '확장 문자를 OEM 값으로 변환',

    'OdbcEdit.mysql.driver.label' => 'MySQL ODBC 드라이버',
    'OdbcEdit.mysql.server.label' => '서버',
    'OdbcEdit.mysql.server.description' => 'MariaDB/MySQL 서버의 호스트 이름',
    'OdbcEdit.mysql.database.label' => '기본 데이터베이스',
    'OdbcEdit.mysql.user.label' => '사용자 이름',
    'OdbcEdit.mysql.user.description' => 'MariaDB/MySQL에 연결하는 데 사용할 사용자 이름',
    'OdbcEdit.mysql.password.label' => '암호',
    'OdbcEdit.mysql.password.description' => '서버의 사용자 계정 암호',
    'OdbcEdit.mysql.port.label' => '포트',
    'OdbcEdit.mysql.port.description' => '서버가 로컬 호스트가 아닌 경우 사용할 TCP/IP 포트',
    'OdbcEdit.mysql.socket.label' => '소켓',
    'OdbcEdit.mysql.socket.description' => '서버가 로컬 호스트인 경우 연결할 Windows 명명된 파이프',
    'OdbcEdit.mysql.option.label' => '옵션',
    'OdbcEdit.mysql.option.description' => 'MyODBC의 작동 방법을 지정하는 옵션. <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">문서</a>를 참조하십시오.',

    'ProtectedDirectoryList.add' => '보호된 디렉터리 추가',
    'ProtectedDirectoryList.addTooltip' => '보호된 디렉터리를 만듭니다.',
    'ProtectedDirectoryList.name' => '이름',
    'ProtectedDirectoryList.realmTitle' => '보호된 영역의 제목',
    'ProtectedDirectoryList.noSelectionText' => '제거할 항목을 1개 이상 선택하십시오.',
    'ProtectedDirectoryList.edit' => '편집',
    'ProtectedDirectoryList.remove' => '보호 제거',
    'ProtectedDirectoryList.removeTooltip' => '선택한 디렉터리에서 보호를 제거합니다.',
    'ProtectedDirectoryList.removeConfirmation' => '이 작업으로 인해 {count, plural, =1 {{name} 디렉터리} other {#개의 선택된 디렉터리}}에서 보호가 제거됩니다. 인터넷 사용자에게 {count, plural, =1 {해당 디렉터리} other {해당 디렉터리}} 액세스가 자유롭게 허용됩니다.',
    'ProtectedDirectoryList.removeSuccess' => '선택한 디렉터리가 제거되었습니다.',

    'ProtectedDirectoryAdd.title' => '보호된 디렉터리를 만듭니다',
    'ProtectedDirectoryAdd.submit' => '생성',
    'ProtectedDirectoryAdd.success' => '보호된 디렉터리%%path%%이(가) 만들어졌습니다',

    'ProtectedDirectoryEdit.title' => '보호된 디렉터리 설정',
    'ProtectedDirectoryEdit.success' => '보호된 디렉터리 설정이 변경되었습니다',

    'ProtectedDirectoryUserAdd.title' => '보호된 디렉터리 사용자 생성',
    'ProtectedDirectoryUserAdd.subtitle' => '%%directory%% 디렉터리',
    'ProtectedDirectoryUserAdd.loginLabel' => '사용자 이름',
    'ProtectedDirectoryUserAdd.passwordLabel' => '암호',
    'ProtectedDirectoryUserAdd.submit' => '생성',
    'ProtectedDirectoryUserAdd.success' => '보호된 디렉터리 사용자 %%login%%을(를) 생성했습니다.',

    'ProtectedDirectoryUserPassword.title' => '보호된 디렉터리 사용자 에 대한 암호',
    'ProtectedDirectoryUserPassword.subtitle' => '%%login%% 사용자',
    'ProtectedDirectoryUserPassword.passwordLabel' => '암호',
    'ProtectedDirectoryUserPassword.submit' => '저장',
    'ProtectedDirectoryUserPassword.success' => '사용자의 자격 증명이 저장되었습니다.',

    'SummaryReport.Layout.title' => '보고서 레이아웃 속성',
    'SummaryReport.Layout.success' => '%%name%%의 보고서 레이아웃이 업데이트되었습니다.',

    'SummaryReport.Layout.Add.title' => '보고서 레이아웃 만들기',
    'SummaryReport.Layout.Add.success' => '%%name%%의 보고서 레이아웃이 만들어졌습니다.',

    'SummaryReport.Report.buttonLayouts' => '레이아웃',
    'SummaryReport.Report.buttonSchedule' => '예약',
    'SummaryReport.Report.buttonProperties' => '속성',
    'SummaryReport.Report.buttonTrafficHistory' => '트래픽 기록',
    'SummaryReport.Report.buttonPrint' => '인쇄',
    'SummaryReport.Report.buttonSend' => '이메일로 보내기',
    'SummaryReport.Report.successSent' => '보고서가 다음에게 발송됨 %%email%%',

    'SummaryReport.Schedule.Properties.title' => '%%name%%의 배달 일정',
    'SummaryReport.Schedule.Properties.success' => '보고서 배달 일정이 업데이트되었습니다.',

    'SummaryReport.Schedule.Add.title' => '%%name%%의 배달 일정 생성',
    'SummaryReport.Schedule.Add.success' => '보고서 배달 일정이 만들어졌습니다.',

    'VirtualDirectory.errNotExist' => '이 가상 디렉터리는 존재하지 않는 실제 폴더에 연결되어 있습니다.',
    'VirtualDirectory.errNoPermissions' => '이 디렉터리의 내용을 볼 수 있는 권한이 없습니다.',
    'VirtualDirectory.buttonProperties' => '디렉터리 속성',
    'VirtualDirectory.buttonPropertiesHint' => '가상 디렉터리 속성을 보고 변경합니다.',
    'VirtualDirectory.buttonPermissions' => '디렉터리 액세스 권한',
    'VirtualDirectory.buttonPermissionsHint' => '디렉터리 액세스 권한을 설정합니다.',
    'VirtualDirectory.buttonAspDotNet' => 'ASP.NET',
    'VirtualDirectory.buttonAspDotNetHint' => 'ASP.NET 설정을 구성합니다.',
    'VirtualDirectory.buttonPhp' => 'PHP',
    'VirtualDirectory.buttonPhpHint' => 'PHP 설정을 구성합니다.',
    'VirtualDirectory.tabBrowse' => '디렉터리',
    'VirtualDirectory.tabBrowseHint' => '사이트 %%site%% 아래의 실제/가상 파일 및 디렉터리에 작업합니다.',
    'VirtualDirectory.tabMimeTypes' => 'MIME 유형',
    'VirtualDirectory.tabMimeTypesHint' => '등록된 MIME 유형을 관리합니다.',
    'VirtualDirectory.tabErrorDocs' => '오류 문서',
    'VirtualDirectory.tabErrorDocsHint' => '오류 문서를 관리합니다.',
    'VirtualDirectory.tabProtection' => '보호',
    'VirtualDirectory.tabProtectionHint' => '암호 보호를 이용하여 디렉터리에 대한 액세스를 제한합니다.',

    'VirtualDirectory.errorDocType.default' => '기본값',
    'VirtualDirectory.errorDocType.file' => '파일',
    'VirtualDirectory.errorDocType.url' => 'URL',

    'VirtualDirectory.CreateDirectory.title' => '디렉터리 만들기',
    'VirtualDirectory.CreateDirectory.name' => '디렉터리 이름',
    'VirtualDirectory.CreateDirectory.success' => '%%name%% 디렉터리가 생성되었습니다.',
    'VirtualDirectory.CreateDirectory.errExists' => '%%name%% 디렉터리는 이미 존재합니다.',

    'VirtualDirectory.CreateVirtualDirectory.title' => '가상 디렉터리 만들기',
    'VirtualDirectory.CreateVirtualDirectory.success' => '%%name%% 디렉터리가 생성되었습니다.',

    'VirtualDirectory.EditVirtualDirectory.title' => '가상 디렉터리 속성',
    'VirtualDirectory.EditVirtualDirectory.success' => '가상 디렉터리가 편집되었습니다.',
    'VirtualDirectory.EditVirtualDirectory.close' => '닫기',

    'VirtualDirectory.MimeTypeList.add' => 'MIME 유형 추가',
    'VirtualDirectory.MimeTypeList.edit' => 'MIME 유형 편집',
    'VirtualDirectory.MimeTypeList.addHint' => '새 MIME 유형을 등록합니다.',
    'VirtualDirectory.MimeTypeList.columnExtension' => '확장명',
    'VirtualDirectory.MimeTypeList.columnContent' => '내용',
    'VirtualDirectory.MimeTypeList.noSelectionText' => '제거할 항목을 1개 이상 선택하십시오.',
    'VirtualDirectory.MimeTypeList.removeConfirmation' => '{count, plural, =1 {선택한 MIME 유형을} other {선택한 MIME 유형 #개를}} 제거할까요?',
    'VirtualDirectory.MimeTypeList.removeSuccess' => '선택한 MIME 유형이 제거되었습니다.',

    'VirtualDirectory.CreateMimeType.title' => 'MIME 유형 추가',
    'VirtualDirectory.CreateMimeType.success' => '새로운 MIME 유형이 등록되었습니다.',

    'VirtualDirectory.EditMimeType.title' => 'MIME 유형 편집',
    'VirtualDirectory.EditMimeType.success' => 'MIME 유형이 수정되었습니다.',

    'VirtualDirectory.ErrorDocList.columnCode' => '오류',
    'VirtualDirectory.ErrorDocList.columnName' => '설명',
    'VirtualDirectory.ErrorDocList.columnType' => '유형',
    'VirtualDirectory.ErrorDocList.columnLocation' => '위치',
    'VirtualDirectory.ErrorDocList.edit' => '편집',

    'VirtualDirectory.EditErrorDoc.title' => '오류 문서 편집',
    'VirtualDirectory.EditErrorDoc.success' => '오류 문서가 편집되었습니다.',

    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.error' => '오류',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.type' => '유형',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.location' => '위치',

    'VirtualDirectory.Protection.notSupported' => '이 디렉터리의 이름이 245글자를 초과하거나 지원하지 않는 글자를 포함하고 있어 해당 디렉터리에 대한 디렉터리 보호가 지원되지 않습니다.',
    'VirtualDirectory.Protection.NoProtectionView.title' => '가상 디렉터리 보호가 비활성화되었습니다',
    'VirtualDirectory.Protection.NoProtectionView.protect' => '보호',
    'VirtualDirectory.Protection.NoProtectionView.successProtection' => '%%path%% 디렉터리가 보호되었습니다.',
    'VirtualDirectory.Protection.tools' => '도구',
    'VirtualDirectory.Protection.removeProtection' => '보호 제거',
    'VirtualDirectory.Protection.removeProtectionTooltip' => '디렉터리에 해당하는 URL을 모두 액세스 가능하게 만듭니다.',
    'VirtualDirectory.Protection.removeProtectionConfirmation' => '가상 디렉터리의 보호를 제거하시겠습니까? 보호 기능을 제거하면 보호된 디렉터리 사용자 및 디렉터리 보호 설정이 모두 제거됩니다.',
    'VirtualDirectory.Protection.settings' => '설정',
    'VirtualDirectory.Protection.settingsTooltip' => '디렉터리 위치를 보고 보호된 영역에 대한 제목을 지정합니다.',

    'VirtualDirectory.AspDotNet.title' => 'ASP.NET 설정 구성',

    'VirtualDirectory.Php.title' => 'PHP 버전',
    'VirtualDirectory.Php.version' => '버전',
    'VirtualDirectory.Php.success' => 'PHP 버전이 업데이트되었습니다.',


    'MassMailPage.sendEmail' => '대량 이메일 보내기',
    'MassMailPage.selectAtLeastOneTemplate' => '하나 이상의 템플릿을 선택합니다',
    'MassMailPage.confirmRemoval' => '정말로 선택한 {count, select, 1 {템플릿} other {템플릿}}을 제거하시겠습니까?',
    'MassMailPage.remove' => '제거',
    'MassMailPage.filters' => '필터',
    'MassMailPage.name' => '템플릿 이름',
    'MassMailPage.sender' => '발신자',
    'MassMailPage.recipients' => '수신자',
    'MassMailPage.subject' => '제목',
    'MassMailPage.created' => '생성 날짜',
    'MassMailPage.send' => '보내기',
    'MassMailPage.recipientsNone' => '없음',
    'MassMailPage.recipientsAdmins' => '관리자',
    'MassMailPage.recipientsResellers' => '모든 리셀러',
    'MassMailPage.recipientsResellersSelected' => '선택한 리셀러',
    'MassMailPage.recipientsResellersExcept' => '선택 리셀러를 제외한 모든 리셀러',
    'MassMailPage.recipientsClients' => '모든 고객',
    'MassMailPage.recipientsClientsSelected' => '선택한 고객',
    'MassMailPage.recipientsClientsExcept' => '선택 고객을 제외한 모든 고객',
    'MassMailPage.templatesRemoved' => '템플릿 {count, select, 1 {개} other {개}} 제거함.',
    'MassMailPage.emptyViewTitle' => '대량 이메일 메시지 템플릿 없음',
    'MassMailPage.addNew' => '템플릿 만들기',
    'CreateMassMailTemplatePage.templateCreated' => '템플릿을 만들었습니다.',
    'EditMassMailTemplatePage.templateUpdated' => '템플릿을 업데이트했습니다.',
    'SendMassMailPage.emailSent' => '이메일을 보냈습니다.',
    'SendMassMailPage.fieldIsRequired' => '필드는 비워둘 수 없습니다',
    'SendMassMailPage.saveAsTemplate' => '작성된 메시지를 새 탬플릿에 저장합니다',
    'SendMassMailPage.newTemplateName' => '새로운 템플릿 이름',
    'SendMassMailPage.selectedTemplate' => '선택한 템플릿',
    'SendMassMailPage.send' => '보내기',
    'VirtualHostTemplatePage.name' => '이름',
    'VirtualHostTemplatePage.sizeInBytes' => '크기',
    'VirtualHostTemplatePage.modified' => '수정 날짜',
    'VirtualHostTemplatePage.permissions' => '권한',
    'VirtualHostTemplatePage.user' => '사용자',
    'VirtualHostTemplatePage.group' => '그룹',
    'VirtualHostTemplatePage.uploadTemplate' => '업로드',
    'VirtualHostTemplatePage.succesfullyUploaded' => '템플릿을 업로드했습니다.',
    'VirtualHostTemplatePage.root' => '가상 템플릿',
    'VirtualHostTemplatePage.emptyViewTitle' => '템플릿에 파일 없음',
    'VirtualHostTemplatePage.total' => '{breadcrumbs} 디렉터리 내 항목의 총 개수: {total}',
    'VirtualHostTemplatePage.resetTemplate' => '기본값으로 되돌리기',
    'VirtualHostTemplatePage.successfullyReset' => '템플릿이 기본값으로 변경되었습니다.',

    'TrafficUsageByDomain.List.service' => '서비스',
    'TrafficUsageByDomain.List.usage' => '사용 중',
    'TrafficUsageByDomain.List.incoming' => '위치',
    'TrafficUsageByDomain.List.outgoing' => '출력',
    'TrafficUsageByDomain.List.percentOfAll' => '전체의 %',

    'TrafficUsageByDomains.Viewer.List.domainName' => '도메인 이름',
    'TrafficUsageByDomains.Viewer.List.clientName' => "소유자 이름",
    'TrafficUsageByDomains.Viewer.List.totalUsage' => '사용 중',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimit' => '제한',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitRemaining' => '사용 가능함',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitUsagePercent' => '사용 중(%)',
    'TrafficUsageByDomains.Viewer.Filters.ownOnly' => '내 도메인만',
    'TrafficUsageByDomains.Viewer.Filters.resellerOnly' => '리셀러 도메인만',
    'TrafficUsageByDomains.Viewer.Filters.clientName' => '소유자 이름',

    'TrafficUsageByReseller.emptyView' => '리셀러에 고객이 없습니다',
    'TrafficUsageByReseller.TotalUsage.usageByResellerDomains' => '%%resellerDomainsLink%%: %%usage%%',
    'TrafficUsageByReseller.TotalUsage.resellerDomains' => "리셀러 자체 도메인",
    'TrafficUsageByReseller.TotalUsage.usageByCustomerDomains' => "리셀러 고객의 도메인: %%usage%%",

    'InfoAndStatistics.Main.title' => '정보 및 통계',
    'InfoAndStatistics.Main.overview' => '개요',
    'InfoAndStatistics.Main.domains' => '도메인',
    'InfoAndStatistics.Main.trafficUsage' => '트래픽 사용량',
    'InfoAndStatistics.Main.reports' => '보고서',
    'InfoAndStatistics.Main.serverSettings' => '서버 설정',
    'InfoAndStatistics.TrafficUsage.customers' => '고객',
    'InfoAndStatistics.TrafficUsage.resellers' => '리셀러',
    'InfoAndStatistics.TrafficUsage.domains' => '도메인',

    'ConfigureMailClient.title' => '메일 클라이언트를 선택하세요',
    'ConfigureMailClient.description' => '%%email%%을(를) 자동으로 설정합니다',
    'ConfigureMailClient.thunderbird' => 'Thunderbird',
    'ConfigureMailClient.manual' => '수동',
    'ConfigureMailClient.Common.email' => '이메일:',
    'ConfigureMailClient.Common.start' => '시작',
    'ConfigureMailClient.Common.finish' => '마침',
    'ConfigureMailClient.Common.next' => '다음',
    'ConfigureMailClient.Common.prev' => '이전',
    'ConfigureMailClient.Common.back' => '뒤로',
    'ConfigureMailClient.Common.manualLink' => '메일 계정을 추가하는 데 문제가 있습니까? 직접 설정을 시도해 보십시오.',
    'ConfigureMailClient.Thunderbird.title' => '메일 계정 설정하기',
    'ConfigureMailClient.Thunderbird.description' => 'Mozilla Thunderbird에 메일 계정을 추가하려면 지시 사항을 따르십시오.',
    'ConfigureMailClient.Thunderbird.step1.title' => 'Thunderbird 열기',
    'ConfigureMailClient.Thunderbird.step1.description' => '컴퓨터에서 Thunderbird를 연 다음 Thunderbird 메인 메뉴에서 \'계정 설정\'을 클릭하십시오.',
    'ConfigureMailClient.Thunderbird.step2.title' => '계정 추가하기',
    'ConfigureMailClient.Thunderbird.step2.description' => '\'계정 활동\'을 클릭하고 \'메일 계정 추가\'를 클릭하십시오.',
    'ConfigureMailClient.Thunderbird.step3.title' => '정보 입력하기',
    'ConfigureMailClient.Thunderbird.step3.description' => '보내는 메시지에 표시되기를 원하는 이름을 입력하십시오. 또한 이메일 주소와 비밀번호를 입력한 후 \'계속\'을 클릭하십시오.',
    'ConfigureMailClient.Thunderbird.step4.title' => '끝났습니다!',
    'ConfigureMailClient.Thunderbird.step4.description' => '이제 Thunderbird가 자동으로 메일 계정 추가를 시도합니다.',

    'ConfigureMailClient.Outlook.title' => '메일 계정 설정하기',
    'ConfigureMailClient.Outlook.warning' => 'Outlook 2019 또는 그 이후 버전에 메일 계정을 자동으로 추가할 수 없습니다.',
    'ConfigureMailClient.Outlook.warningTooltip' => '메일 계정을 자동으로 추가하기 위해 autodiscover를 사용합니다. Outlook 2019 및 그 이후 버전은 autodiscover 요청에 Plesk 및 Plesk Premium Email 확장 프로그램에서 지원하지 않는 Microsoft 프록시 서버를 사용합니다.',
    'ConfigureMailClient.Outlook.description' => 'Microsoft Office Outlook 2016에 메일 계정을 추가하려면 지시 사항을 따르십시오.',
    'ConfigureMailClient.Outlook.step1.title' => '새로운 계정 추가하기',
    'ConfigureMailClient.Outlook.step1.description' => '컴퓨터에서 Outlook 2016을 열고 \'파일\' 탭으로 이동하십시오.',
    'ConfigureMailClient.Outlook.step2.title' => '새로운 계정 추가하기',
    'ConfigureMailClient.Outlook.step2.description' => '\'계정 추가하기\'를 클릭하십시오.',
    'ConfigureMailClient.Outlook.step3.title' => '이메일 주소 입력하기',
    'ConfigureMailClient.Outlook.step3.description' => '이메일 주소를 입력하십시오.',
    'ConfigureMailClient.Outlook.step4.title' => '비밀번호 입력하기',
    'ConfigureMailClient.Outlook.step4.description' => '메일 계정 비밀번호를 입력하고 \'계속\'을 클릭하십시오.',
    'ConfigureMailClient.Outlook.step5.title' => '끝났습니다!',
    'ConfigureMailClient.Outlook.step5.description' => '\'OK\'를 클릭해 계정 설정을 마무리하십시오.',

    'ConfigureMailClient.Gmail.title' => '메일 계정 설정하기',
    'ConfigureMailClient.Gmail.description' => '모바일 기기에서 Gmail 앱에 메일 계정을 추가하려면 지시 사항을 따르십시오.',
    'ConfigureMailClient.Gmail.step1.title' => '새로운 계정 추가하기',
    'ConfigureMailClient.Gmail.step1.description1' => 'Android 폰에서 Gmail 앱을 여십시오. 오른쪽 상단 코너의 프로필 사진을 누르십시오.',
    'ConfigureMailClient.Gmail.step1.description2' => '\'계정 하나 더 추가하기\'를 누르십시오.',
    'ConfigureMailClient.Gmail.step1.description3' => '\'기타\'를 누르십시오.',
    'ConfigureMailClient.Gmail.step2.title' => '이메일 주소 입력하기',
    'ConfigureMailClient.Gmail.step2.description' => '이메일 주소를 입력하고 \'다음\'을 누르십시오.',
    'ConfigureMailClient.Gmail.step3.title' => '계정 유형 선택하기',
    'ConfigureMailClient.Gmail.step3.description' => '다운로드한 이베일 메시지의 사본을 서버에 보관하려면 \'개인(IMAP)\'을 누르십시오. 서버에서 다운로드한 이메일 메시지를 지우려면 \'개인(POP3)\'을 누르십시오.',
    'ConfigureMailClient.Gmail.step4.title' => '비밀번호 입력하기',
    'ConfigureMailClient.Gmail.step4.description' => '메일 계정의 비밀번호를 입력하고 \'다음\'을 누르십시오.',
    'ConfigureMailClient.Gmail.step5.title' => '메일 제거 설정',
    'ConfigureMailClient.Gmail.step5.description' => '앱에서 이메일을 삭제하면 서버에서도 메일이 삭제되도록 할지를 선택한 후 \'다음\'을 누르십시오.',
    'ConfigureMailClient.Gmail.step6.title' => '계정 옵션',
    'ConfigureMailClient.Gmail.step6.description1' => '앱이 자동으로 발송 서버 설정을 가져옵니다.',
    'ConfigureMailClient.Gmail.step6.description2' => '원한다면 기본 계정 설정을 변경한 후 \'다음\'을 누르십시오.',
    'ConfigureMailClient.Gmail.step7.title' => '끝났습니다!',
    'ConfigureMailClient.Gmail.step7.description1' => '(선택 사항) 발송하는 메시지에 표시되기를 원하는 이름을 입력하십시오.',
    'ConfigureMailClient.Gmail.step7.description2' => '\'다음\'을 눌러 계정 설정을 마무리하십시오.',

    'ConfigureMailClient.Ios.title' => '메일 계정 설정하기',
    'ConfigureMailClient.Ios.description' => 'iOS 기기에서 QR 코드를 스캔하거나 아래의 링크를 열어 자동으로 메일 계정을 iOS Mail 앱에 추가하십시오.',
    'ConfigureMailClient.Ios.link'  =>  'iOS Mail에 계정 추가하기',

    'ConfigureMailClient.Manual.title' => '메일 계정 직접 설정하기',
    'ConfigureMailClient.Manual.description' => '메일 클라이언트에 %%email%% 메일을 추가할 때 이 값을 사용하십시오.',
    'ConfigureMailClient.Manual.username' => '메일 서버 사용자 이름:',
    'ConfigureMailClient.Manual.outgoingServer' => '발송 메일 서버(인증 필요):',
    'ConfigureMailClient.Manual.incomingServer' => '수신 메일 서버:',
    'ConfigureMailClient.Manual.supportedIncomingProtocols' => '지원되는 수신 메일 프로토콜:',
    'ConfigureMailClient.Manual.supportedOutgoingProtocols' => '지원되는 송신 메일 프로토콜:',


    'Databases.Page.title' => '%%database%%에 대한 데이터베이스',
    'Databases.Page.databaseTab' => '데이터베이스',
    'Databases.Page.userTab' => '사용자 관리',
    'Databases.Page.serversLink' => '데이터베이스 서버',
    'Databases.Page.backupLink' => '백업 관리자',

    'Databases.List.add' => '데이터베이스 추가',
    'Databases.List.find' => '데이터베이스 찾기...',
    'Databases.List.databaseColumn' => '데이터베이스',
    'Databases.List.relatedToColumn' => '관련성',
    'Databases.List.relatedToDomains' => '%%domains%%에 관련됨',
    'Databases.List.noRelatedDomains' => '이 데이터베이스를 웹사이트에 할당하기',
    'Databases.List.noDomainRelations' => '관련 웹사이트 업음',
    'Databases.List.changeRelatedDomain' => '변경',
    'Databases.List.connectionInfo' => '연결 정보',
    'Databases.List.downloadDump' => '덤프 내보내기',
    'Databases.List.uploadDump' => '덤프 가져오기',
    'Databases.List.copy' => '데이터베이스 복사',
    'Databases.List.checkDatabase' => '검사 및 복구',
    'Databases.List.assignToSubscription' => '구독으로 이동',
    'Databases.List.assignToSubscription_powerUser' => '웹 공간으로 이동',
    'Databases.List.remove' => '제거',
    'Databases.List.removeConfirmation' => '%%name%% 데이터베이스를 제거하시겠습니까?',
    'Databases.List.removeButtonDisabledHint' => '설치된 앱 애플리케이션에서 사용 중이기 때문에 데이터베이스를 제거할 수 없습니다.',
    'Databases.List.databaseRemoved' => '데이터베이스를 제거했습니다.',
    'Databases.List.downloadMsSqlClient' => '로컬 SQL 클라이언트 다운로드',
    'Databases.List.downloadMsSqlClientHint' => '로컬 SQL 클라이언트 다운로드',
    'Databases.List.webadmin' => '웹 관리',
    'Databases.List.webadminHint' => '데이터베이스 웹 관리를 통해 이 서버에 접근합니다.',
    'Databases.List.dumpSubscriptionIsTurnedOff' => '덤프를 %%action%% 수 없음: 구독이 중단되었습니다.',
    'Databases.List.dumpExport' => '내보낼',
    'Databases.List.dumpImport' => '가져올',

    'Databases.DatabaseSummary.host' => '호스트',
    'Databases.DatabaseSummary.serverUnavailable' => '서버를 사용할 수 없습니다.',
    'Databases.DatabaseSummary.user' => '사용자',
    'Databases.DatabaseSummary.users' => '사용자',
    'Databases.DatabaseSummary.noUser' => '데이터베이스 사용자 없음',
    'Databases.DatabaseSummary.seeAll' => '모두 보기',
    'Databases.DatabaseSummary.createUser' => '사용자 생성하기',
    'Databases.DatabaseSummary.calculatingSize' => '크기 계산 중...',
    'Databases.DatabaseSummary.tablesCount' => '표',
    'Databases.DatabaseSummary.size' => '크기',

    'Databases.InPlaceSelect.editButtonHint' => '편집',
    'Databases.InPlaceSelect.saveButtonHint' => '저장',
    'Databases.InPlaceSelect.closeButtonHint' => '취소',

    'Databases.ConnectionInfo.title' => '연결 정보',
    'Databases.ConnectionInfo.description' => '데이터베이스 %%database%% 관련',
    'Databases.ConnectionInfo.hint' => '이 데이터베이스 연결 세부 정보를 웹 애플리케이션 설치 등에 사용할 수 있습니다.',
    'Databases.ConnectionInfo.host' => '호스트',
    'Databases.ConnectionInfo.databaseName' => '데이터베이스 이름',
    'Databases.ConnectionInfo.user' => '사용자 이름',
    'Databases.ConnectionInfo.password' => '암호',
    'Databases.ConnectionInfo.noDefaultUser' => '기본 사용자 없음',

    'Databases.Add.title' => '데이터베이스 추가',
    'Databases.Add.name' => '데이터베이스 이름',
    'Databases.Add.server' => '데이터베이스 서버',
    'Databases.Add.versionCut' => 'v%%version%%',
    'Databases.Add.relatedDomain' => '관련 사이트',
    'Databases.Add.noDomainRelations' => '관련 사이트 없음',
    'Databases.Add.userSection' => '사용자',
    'Databases.Add.userSectionDescription' => '기본 데이터베이스 사용자를 생성합니다. Plesk가 이 사용자 대신 데이터베이스에 액세스합니다. 데이터베이스 사용자가 데이터베이스에 할당되어 있지 않으면 액세스가 불가능합니다.',
    'Databases.Add.createUser' => '데이터베이스 사용자 생성',
    'Databases.Add.username' => '데이터베이스 사용자 이름',
    'Databases.Add.password' => '암호',
    'Databases.Add.passwordConfirmation' => '암호 확인',
    'Databases.Add.allDbAccess' => '사용자는 선택한 구독에 존재하는 모든 데이터베이스에 대한 액세스 권한을 가집니다.',
    'Databases.Add.aclRadio' => '액세스 제어',
    'Databases.Add.aclLocalhost' => '로컬 연결만 허용',
    'Databases.Add.aclAny' => '모든 호스트로부터 원격 연결 허용',
    'Databases.Add.aclCustom' => '다음으로부터 원격 연결 허용',
    'Databases.Add.aclExample' => "thomas.loc.gov \n%.loc.gov \nx.y.% \n144.155.166.177 \n144.155.166.% \n144.155.166.0/255.255.255.0 \n\n지정된 호스트는 이 사용자를 대신하여 데이터베이스에 액세스가 허용되었습니다.",
    'Databases.Add.remoteAccess' => '원격 액세스',
    'Databases.Add.remoteAccessDenied' => '시스템 방화벽 규칙 사용',
    'Databases.Add.remoteAccessAllowed' => '다음으로부터 원격 연결 허용',
    'Databases.Add.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\n지정된 IP 주소는 방화벽 규칙을 통한 데이터베이스 액세스가 허용되었습니다. 이 목록의 변경은 호스팅 공급자에 의해 사전 조정됩니다.",
    'Databases.Add.remoteAccessHint' => '호스팅 공급자에게 연락하고 위에서 지정한 옵션이 MariaDB/MySQL에 대한 수신 액세스에 현재 지정된 방화벽 규칙을 준수하는지 확인하십시오.',
    'Databases.Add.example' => "예:\n%%example%%",
    'Databases.Add.denied' => '시스템 방화벽 규칙 사용',
    'Databases.Add.allowed' => '다음으로부터 원격 연결 허용',
    'Databases.Add.databaseCreated' => '%%name%% 데이터베이스가 만들어졌습니다.',
    'Databases.Add.create' => '데이터베이스 생성',

    'Databases.Clone.title' => '데이터베이스 복사',
    'Databases.Clone.clone' => '확인',
    'Databases.Clone.warning' => '경고: 테이블 이름이 일치할 경우, 소스의 테이블이 목적지의 테이블을 대체하게 됩니다.',
    'Databases.Clone.formDescription' => '데이터베이스 내용을 새 데이터베이스 또는 기존 데이터베이스에 복사합니다. 기존 데이터베이스에 복사하는 경우, 소스 데이터베이스의 테이블이 대상 데이터베이스의 테이블 목록에 추가됩니다.',
    'Databases.Clone.copyData' => '전체 복사본 만들기',
    'Databases.Clone.copyDataHint' => '선택할 경우 구조와 데이터를 포함한 전체 데이터베이스의 모든 내용이 복사됩니다. 선택 해제할 경우 테이블의 구조만 복사됩니다.',
    'Databases.Clone.copyHint' => '%%databaseName%% 데이터베이스를 복사하게 됩니다',
    'Databases.Clone.server' => '대상 데이터베이스 서버',
    'Databases.Clone.versionCut' => 'v%%version%%',
    'Databases.Clone.externalServer' => '기타...',
    'Databases.Clone.database' => '대상 데이터베이스',
    'Databases.Clone.newDatabase' => '이름이 있는 데이터베이스 만들기',
    'Databases.Clone.newDatabaseName' => '새 데이터베이스 이름',
    'Databases.Clone.existingDatabaseName' => '기존 데이터베이스 이름',
    'Databases.Clone.existingDatabase' => '기존 데이터베이스에 복사',
    'Databases.Clone.externalDbHost' => '호스트 이름 또는 IP 주소',
    'Databases.Clone.externalDbLogin' => '사용자 이름',
    'Databases.Clone.externalDbPassword' => '암호',
    'Databases.Clone.subscription' => '대상 구독',
    'Databases.Clone.subscription_powerUser' => '대상 웹 공간',
    'Databases.Clone.cloneInProgress' => '데이터베이스 %%source%%를 데이터베이스 %%destination%%에 복제하는 중입니다. 이메일(%%email%%)로 진행 상황이 통보됩니다.',
    'Databases.Clone.unableToClone' => '"%%source%%" 데이터베이스를 복사할 수 없습니다.',
    'Databases.Clone.unableToCreateExternalDatabase' => '지정된 서버에서 "%%destination%%" 데이터베이스를 만들 수 없습니다.',
    'Databases.Clone.databaseCloned' => '"%%source%%" 데이터베이스가 복사 되었습니다.',
    'Databases.Clone.emailSubjSuccess' => '"%%sourceDatabase%%" 데이터베이스가 복사되었습니다.',
    'Databases.Clone.emailSubjFailure' => '"%%sourceDatabase%%" 데이터베이스 복사에 실패했습니다.',
    'Databases.Clone.emailBodySuccess' => '%%sourceDatabase%% 데이터베이스(%%sourceHost%%)가 %%destDatabase%% 데이터베이스(%%destHost%%)에 복사되었습니다.',
    'Databases.Clone.emailBodyFailure' => '%%sourceDatabase%% 데이터베이스(%%sourceHost%%)를 %%destDatabase%% 데이터베이스(%%destHost%%)에 복사할 수 없습니다. 복사에 실패했습니다.',
    'Databases.Clone.localServer' => '로컬 서버',

    "Databases.Import.confirm" => '덤프 가져오기',
    'Databases.Import.recreateDatabase' => '데이터베이스 다시 생성',
    'Databases.Import.rootDirectory' => '루트 디렉토리',
    'Databases.Import.uploadFromFile' => '로컬 컴퓨터에서 덤프 업로드하기',
    'Databases.Import.uploadFromWebspace' => '호스팅 서버에 저장된 덤프 가져오기',
    'Databases.Import.uploadHint' => '%%databaseName%%에 덤프를 가져오게 됩니다',
    'Databases.Import.uploadPopupTitle' => '데이터베이스 덤프 가져오기',
    'Databases.Import.uploading' => '가져오는 중…',
    'Databases.Import.waitMessage' => '기다려 주십시오…',

    "Databases.Export.confirm" => '덤프 내보내기',
    'Databases.Export.downloadDumpAutomatically' => '덤프 생성 후 자동으로 다운로드',
    'Databases.Export.downloadDumpName' => '덤프 파일 이름',
    'Databases.Export.downloadHint' => '%%database%%의 덤프를 생성하고 다운로드하려고 합니다',
    'Databases.Export.downloadPopupTitle' => '덤프 내보내기',
    'Databases.Export.downloadRelativePath' => '다음 디렉토리에 덤프 저장',
    'Databases.Export.rootDirectory' => '루트 디렉토리',
    'Databases.Export.waitMessage' => '기다려 주십시오…',

    'Databases.MoveToSubscription.title' => '다른 구독으로 데이터베이스 이동',
    'Databases.MoveToSubscription.title_powerUser' => '다른 웹 공간으로 데이터베이스 이동',
    'Databases.MoveToSubscription.description' => '%%name%% 데이터베이스를 옮기게 됩니다',
    'Databases.MoveToSubscription.hint' => '선택한 데이터베이스를 선택한 구독으로 옮깁니다. 데이터베이스 사용자 역시 다른 데이터베이스 접근 권한을 가지고 있지 않은 한 옮기게 됩니다. 참고: 이동 후, 이동 전 데이터베이스에 접근 권한을 가지고 있던 사용자들은 Plesk에서 링크를 통해 데이터베이스에 접근할 수 없게 됩니다.',
    'Databases.MoveToSubscription.subscriptionName' => '구독으로 이동',
    'Databases.MoveToSubscription.subscriptionName_powerUser' => '웹 공간으로 이동',
    'Databases.MoveToSubscription.save' => '데이터베이스 옮기기',

];