<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => '其他密钥属性',
    'additional-key-info.update' => '检索其它的密钥',
    'additional-key-info.updateDescription' => '检索并安装其他密钥。',
    'additional-key-info.download' => '下载许可证',
    'additional-key-info.downloadDescription' => '下载当前许可证密钥。',
    'additional-key-info.install' => '安装许可证',
    'additional-key-info.installDescription' => '安装当前的许可证密钥。',
    'additional-key-info.revert' => '恢复许可证',
    'additional-key-info.revertDescription' => '恢复到之前安装的许可证密钥。',
    'additional-key-info.revertNotAvailableDescription' => '尚未安装密钥。',
    'additional-key-info.installSuccess' => '许可证秘钥安装已开始。',

    'additional-key-revert.title' => '其他密钥回滚',
    'additional-key-revert.success' => '其他密钥已回滚。',

    'additional-key-upload.title' => '安装许可证密钥',
    'additional-key-upload.success' => '新附加许可证已上传。',

    'additional-keys.title' => '其他许可证密钥',

    'change-subscriptions-owner.title' => '正在重新分配选定的订阅',
    'change-subscriptions-owner.success' => '订阅所有权已更改',

    'customers.hint' => '您可在此管理主机服务客户的帐户，包括创建帐户和服务订阅，管理现有客户，以及移除帐户。若要管理客户的网站、邮件或任何其它服务，请点击列表右边的链接进入 客户面板 进行操作。',

    'customer-domains.hint' => '在此处您可以创建并管理网站。',

    'customer-subscriptions.hint' => '在此处您可以管理客户的订阅。',

    'domains.hint' => '您可在此查看系统中注册的所有域名信息，以及管理主机服务。若要为自己或主机客户添加域名，请点击“添加域名”。创建域名时会提示您创建新客户和订阅，也可以选择现有的客户和订阅。',

    'database-servers.title' => '数据库服务器',

    'database-server-create.title' => '新建数据库服务器',

    'database-server-properties.title' => '数据库服务器',

    'database-server-upgrade.drawerTitle' => 'MariaDB 升级',
    'database-server-upgrade.drawerTitle.completed' => '升级完成',
    'database-server-upgrade.drawerSubTitle.line1' => '升级进行期间无法关闭 drawer。',
    'database-server-upgrade.drawerSubTitle.line2' => '如果在升级过程中出现问题，请参阅 %%troubleshootingArticle%%。',
    'database-server-upgrade.drawerSubTitle.completed' => 'MariaDB 数据库服务器已升级到版本 %%releaseVersion%%。如遇到任何问题，请按照 %%troubleshootingArticle%% 中的说明进行操作。',
    'database-server-upgrade.upToDate' => '您已经安装 LTS 版本。',
    'database-server-upgrade.troubleshootingArticle' => '该 KB 文章',
    'database-server-upgrade.troubleshootingArticleDescription' => '使用 %%troubleshootingArticle%% 来排除 MariaDB 升级问题。',

    'database-server-upgrade.chooseReleaseStep.infoBlock.par1' => '将本地 MariaDB 数据库服务器升级到当前的长期支持（LTS）版本。',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par2' => '我们强烈建议您在升级前备份服务器，并在网站的非高峰时段开始升级。',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par3' => 'MariaDB 升级期间，Plesk 服务器和托管网站将不可用。MariaDB 升级通常不会出错，大约需要 10 分钟，但仍会影响整个服务器。',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par4' => '注意：如果您运行的是 MariaDB 5.5，Plesk 会先将其升级到 MariaDB 10.5。升级完成后，再次启动此向导以升级到当前的 MariaDB LTS 版本。',
    'database-server-upgrade.chooseReleaseStep.currentVersionTitle' => '当前版本',
    'database-server-upgrade.chooseReleaseStep.currentMariaDBVersion' => 'MariaDB %%version%%',
    'database-server-upgrade.chooseReleaseStep.selectVersion' => '选择要升级的版本',
    'database-server-upgrade.chooseReleaseStep.noMajorReleases' => '没有主要发行版本',
    'database-server-upgrade.chooseReleaseStep.releaseNotes' => '发行说明',
    'database-server-upgrade.chooseReleaseStep.releaseDate' => '发行日期：%%date%%',
    'database-server-upgrade.chooseReleaseStep.endOfLifeDate' => '使用寿命终止日期：%%date%%',
    'database-server-upgrade.chooseReleaseStep.notDetected' => '只有操作系统供应商或 MariaDB 供应商提供的 MariaDB 分支才能升级。',

    'database-server-upgrade.preUpgradeCheckProgressStep.title' => '升级前检查',
    'database-server-upgrade.preUpgradeCheckProgressStep.configChecker' => '解析 MariaDB 配置文件',
    'database-server-upgrade.preUpgradeCheckProgressStep.mysqlChecker' => '使用 mysqlcheck 分析数据库',
    'database-server-upgrade.preUpgradeCheckProgressStep.packageManagerChecker' => '正在分析程序包管理器配置',
    'database-server-upgrade.preUpgradeCheckProgressStep.systemCompatibilityChecker' => '正在检查系统兼容性',
    'database-server-upgrade.preUpgradeCheckProgressStep.webSocketChecker' => '检查 WebSocket',

    'database-server-upgrade.preUpgradeCheckStep.shouldBeConfirmed' => '要继续升级，请选择所有复选框。有必要确保您同意升级所做的配置更改，并能访问恢复选项。',
    'database-server-upgrade.preUpgradeCheckStep.removedSystemVariables' => '为了与新版本兼容，以下变量将被移除：',
    'database-server-upgrade.preUpgradeCheckStep.removedConfigFiles' => '以下配置文件将被移除，因为它们是即将升级的 mariadb-server 程序包的一部分：',
    'database-server-upgrade.preUpgradeCheckStep.fromFiles' => '{variable} 从 {count, plural, other {#文件：{files}}}',
    'database-server-upgrade.preUpgradeCheckStep.accessToolsSection' => '访问恢复选项（服务器命令行控制台和 Repair Kit）',
    'database-server-upgrade.preUpgradeCheckStep.sshAccess' => '我确认我可以通过 SSH 访问服务器',
    'database-server-upgrade.preUpgradeCheckStep.sshAccessDescription' => '使用 SSH 客户端或在新的浏览器选项卡中打开 %%sshTerminalExtension%% （在升级完成之前不要关闭 SSH Terminal 扩展窗口）。如果升级失败，拥有 SSH 访问权限将有助于恢复。',
    'database-server-upgrade.preUpgradeCheckStep.sshTerminalExtension' => 'SSH Terminal 扩展',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccess' => '我确认我有访问 Repair Kit 的权限',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccessDescription' => '在新的浏览器选项卡中打开 %%repairKit%% ，并使用管理员凭据登录。在升级完成之前，请不要关闭 Repair Kit 扩展窗口。',
    'database-server-upgrade.preUpgradeCheckStep.repairKit' => 'Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.dumpSection' => '备份数据库',
    'database-server-upgrade.preUpgradeCheckStep.withDump' => '升级前备份服务器上的所有数据库',
    'database-server-upgrade.preUpgradeCheckStep.withDumpDescription' => 'Plesk 会将数据库备份存储在 %%path%% 目录中。',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailable' => 'Plesk 中的 WebSocket 不可用',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailableDescription' => '如果没有 WebSocket，您将无法看到升级过程的实时输出。',

    'database-server-upgrade.submitPopover.title' => '为了防止潜在的数据丢失，我们强烈建议您在继续之前创建主机数据库的转储。是否继续而不创建转储？',

    'database-server-databases.title' => '数据库',

    'database-server-change-password.title' => '管理员密码',

    'home.title' => '首页',

    'license.title' => '许可证信息',

    'primary-key-info.title' => 'Plesk 许可证密钥',
    'primary-key-info.update' => '检索密钥',
    'primary-key-info.updateDescription' => '检索订购的许可证密钥并进行安装。',
    'primary-key-info.upload' => '安装许可证',
    'primary-key-info.uploadDescription' => '上传并安装新的许可证。',
    'primary-key-info.revert' => '恢复许可证',
    'primary-key-info.revertDescription' => '恢复到之前安装的许可证密钥。',
    'primary-key-info.expireTitle' => '您的 Plesk 许可证已到期',
    'primary-key-info.header' => '因此，某些关键服务已无法使用。%%warning%%',
    'primary-key-info.headWarning' => '您的网站可能面临风险！',
    'primary-key-info.softwareUpdatesTitle' => '软件更新',
    'primary-key-info.softwareUpdates' => '%%title%% 已禁用。您的系统可能容易受到威胁。',
    'primary-key-info.websiteBackupsTitle' => '网站备份',
    'primary-key-info.websiteBackups' => '%%title%% 不再可用。您面临数据丢失的风险。',
    'primary-key-info.sslCertificatesTitle' => 'SSL/TLS 证书',
    'primary-key-info.sslCertificates' => '%%title%% 将不会自动续订。这可能会损害安全性和信任度。',
    'primary-key-info.monitoringTitle' => '监控',
    'primary-key-info.monitoring' => '%%title%% 不可用。超负载和性能问题可能会被忽视。',
    'primary-key-info.fileDbManagementTitle' => '文件和数据库管理',
    'primary-key-info.fileDbManagement' => '%%title%% 已禁用。您无法有效地管理文件和数据库。',
    'primary-key-info.technicalSupportTitle' => '技术支持',
    'primary-key-info.technicalSupport' => '%%title%% 不可用。无法获得必要的服务器问题协助可能会导致长时间宕机。',
    'primary-key-info.renewLicense' => '要恢复这些服务，请立即购买新的 Plesk 许可证。',
    'primary-key-info.footer' => '如有任何问题或需要帮助， ',
    'primary-key-info.supportLink' => '请联系 Plesk 支持',

    'primary-key-revert.title' => '许可证密钥回滚',
    'primary-key-revert.success' => 'Plesk 密钥已回滚。',

    'primary-key-upload.title' => '安装许可证密钥',
    'primary-key-upload.success' => '新的 Plesk 密钥已被上传。',

    'resellers.hint' => '您可在此管理代理商，即代理主机服务以及托管自己的网站的客户。您可创建帐户及其服务订阅，管理现有代理商，以及移除帐户。',

    'reseller-customers.hint' => '在此处您可以设置并管理客户。',

    'reseller-domains.hint' => '在此处您可以创建并管理网站。',

    'reseller-subscriptions.hint' => '您可以在此管理代理商的订阅。',

    'subscriptions.hint' => '客户可通过订阅主机方案获取主机服务。您可在此管理此类订阅以及您自行创建用于托管自己网站的订阅。若要管理订阅的网站、邮件或任何其它服务，请点击列表右边的链接进入订阅者的“客户面板”进行操作。',

    'server-mail-settings.title' => '设置',
    'server-mail-spam-filter.title' => '垃圾邮件过滤',
    'server-mail-antivirus.title' => '防病毒程序',
    'server-mail-black-list.title' => '黑名单',
    'server-mail-white-list.title' => '白名单',
    'server-mail-queue.title' => '邮件队列',
    'server-mail-statistics.title' => '统计',
    'server-mail-smarthost.title' => 'Smarthost',

    'server-spam-filter.settings' => '设置',
    'server-spam-filter.black-list' => '黑名单',
    'server-spam-filter.white-list' => '白名单',

    'firewall.title' => '防火墙管理',
    'firewall-general.title' => '常用',
    'firewall-general.toggleStatus' => '防火墙保护',
    'firewall-general.buttonDefault' => '重设为默认值',
    'firewall-general.buttonPanic' => '应急模式',
    'firewall-general.confirmationDefault' => '将防火墙设置重置为默认的设置？',
    'firewall-general.confirmationPanic' => '打开恐慌模式？用户将无法访问他们的域名，一些网络服务可能会停止工作。',
    'firewall-general.successDefault' => '防火墙设置已被重置为默认值。',
    'firewall-general.successPanic' => '恐慌模式已启用。',
    'firewall-general.info' => '出于安全原因，防火墙阻止了除明确允许的之外所有连接。您可以通过创建某个规则来允许某个连接。更多信息，请参阅相关文档。',
    'firewall-general.interfaces' => '网络接口',
    'firewall-icmp.title' => 'ICMP 协议',
    'firewall-rules.title' => '防火墙规则',

    'dns.title' => 'DNS设置',
    'dns-records.title' => '区域记录模板',
    'dns-soa-record.title' => '区域设置模板',

    'php-handler.title' => ' %%name%% 的设置',
    'php-handler.extensions.title' => '扩展',
    'php-handler.extensions.description' => '这些 PHP 扩展设置仅针对该处理程序。',
    'php-handler.extensions.descriptionShared' => '这些设置通用于以下 PHP 处理程序：%%handlers%%。该设置应用到使用这些处理程序的所有网站。',
    'php-handler.extensions.buttonManage' => '管理 PECL 程序包',
    'php-handler.extensions.manage.title' => '管理 PECL 程序包',
    'php-handler.extensions.manage.risks' => 'PHP扩展由第三方PECL程序包提供。您安装它们的风险将自行承担。',
    'php-handler.extensions.manage.description' => '安装、升级和卸载 PECL 程序包。这些更改将应用于在%%handlers%%上运行的所有网站。',
    'php-handler.extensions.manage.notFound' => '为什么所需的程序包不在列表上？',
    'php-handler.extensions.manage.limitations' => '由控制面板提供商和操作系统供应商提供的PHP扩展没有在列表中显示。',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.refresh' => "刷新",
    'ServerInformation.sectionGeneral' => "常用",
    'ServerInformation.cpu' => "CPU",
    'ServerInformation.version' => "版本",
    'ServerInformation.os' => "操作系统",
    'ServerInformation.key' => "Plesk 许可证密钥",
    'ServerInformation.uptime' => "正常运行时间",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} other {#天}} {hours, plural, other {#小时}} {minutes, plural, other {#分钟}}}",
    'ServerInformation.sectionCpu' => "CPU 使用",
    'ServerInformation.la1min' => "过去 1 分钟",
    'ServerInformation.la5min' => "过去 5 分钟",
    'ServerInformation.la15min' => "过去 15 分钟",
    'ServerInformation.sectionMemory' => "内存使用量",
    'ServerInformation.memoryHardware' => "硬件",
    'ServerInformation.memoryTotalNoKernel' => "总计（排除内核）",
    'ServerInformation.memoryTotal' => "共计",
    'ServerInformation.memoryUsed' => "已使用",
    'ServerInformation.memoryFree' => "可用",
    'ServerInformation.memoryShared' => "共享",
    'ServerInformation.memoryBuffer' => "缓冲区",
    'ServerInformation.memoryCached' => "已缓存",
    'ServerInformation.memoryAvailable' => "可用",
    'ServerInformation.memoryUsage' => "使用",
    'ServerInformation.sectionSwap' => "交换空间使用情况",
    'ServerInformation.sectionVirtualMemory' => "虚拟内存使用量",
    'ServerInformation.swapTotal' => "共计",
    'ServerInformation.swapUsed' => "已使用",
    'ServerInformation.swapFree' => "可用",
    'ServerInformation.swapUsage' => "使用",
    'ServerInformation.sectionHarddisk' => "硬盘使用",
    'ServerInformation.harddiskDirectory' => "文件系统",
    'ServerInformation.harddiskProtectedDir' => "重要目录",
    'ServerInformation.harddiskTotal' => "共计",
    'ServerInformation.harddiskUsed' => "已使用",
    'ServerInformation.harddiskAvailable' => "可用",
    'ServerInformation.harddiskCapacity' => "使用",
    'ServerInformation.sectionDomains' => "域名",
    'ServerInformation.activeDomains' => "活动",
    'ServerInformation.inactiveDomains' => "不活动",
    'ServerInformation.problemDomains' => "问题",
    'ServerInformation.refreshed' => "信息已刷新。",

    'ServerAbout.copyright' => '© 2026 WebPros International GmbH。保留所有权利。',
    'ServerAbout.linkLicenseManagement' => '转到许可证信息',
    'ServerAbout.panelVersion' => '版本',
    'ServerAbout.installedPatchVersion' => '更新 #%%patch%%',
    'ServerAbout.licenseKey' => '许可证密钥',
    'ServerAbout.productDescription' => 'Plesk 是实现应用、网站和主机业务的运行、自动化和增长的领导 WebOps 平台。',
    'ServerAbout.readEula' => '阅读 %%link%%。',
    'ServerAbout.linkEula' => '最终用户许可协议',
    'ServerAbout.visitForum' => '访问 %%link%%',
    'ServerAbout.linkForum' => 'Plesk 论坛',
    'ServerAbout.followUs' => '关注我们',
    'ServerAbout.visitSite' => '可访问 %%link%% 了解更多',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => '在 %%link%% 中找到灵感',
    'ServerAbout.linkBlog' => 'Plesk 博客',
    'ServerAbout.ip2locationCopyright' => 'Plesk 为 %%link%% 使用 IP2Location LITE 数据库。',
    'ServerAbout.linkGeolocation' => 'IP地理定位',

    'ServerAbout.darkThemePromoTitle' => '恭喜！',
    'ServerAbout.darkThemePromoDescription' => '您找到了一只神奇猫咪。',
    'ServerAbout.darkThemePromoButton' => '呼嗖！到黑暗面来吧',
    'ServerAbout.darkThemeTourDescription' => '切换该选项以启用或禁用您界面的深色模式主题。',
    'ServerAbout.darkThemeTourButton' => '明白了',

    'ts-sessions.title' => '终端服务器会话',
    'ts-sessions-properties.title' => '会话属性',

    'BandwidthLimiting.bandwidthThrottling' => '您不能控制带宽节流，因为 QoS 尚未安装。',
    'BandwidthLimiting.virtualHostingRequired' => '带宽限制仅适用于具有 web 主机的域名。',
    'BandwidthLimiting.bandwidthLabel' => '带宽最大使用量',
    'BandwidthLimiting.bandwidthHint' => '带宽使用限制仅适用于通过HTTP协议传输的数据。',
    'BandwidthLimiting.maxConnectionLabel' => '最大连接数',
    'BandwidthLimiting.maxConnectionHint' => '如果您限制带宽，则建议您也限制此网站的同时连接数。如果网站请求频率较高，则Web服务器进程会增加服务器负载。',
    'BandwidthLimiting.kbps' => 'KB/s',
    'BandwidthLimiting.success' => '带宽限制设置已被更改。',
    'BandwidthLimiting.unlimited' => '无限',

    'ip-address-domains.title' => '使用%%type%% IP地址%%ipAddress%%的网站',
    'ip-address-domains.site' => '网站',
    'ip-address-domains.setAsDefault' => '设为默认值',
    'ip-address-domains.type-SHARED' => '共享',
    'ip-address-domains.type-EXCLUSIVE' => '独立',

    'HotlinkProtection.virtualHostingRequired' => '盗链防护只能用于带有 web 主机的域名。',
    'HotlinkProtection.enabledLabel' => '启用盗链防护',
    'HotlinkProtection.extensionsLabel' => '受保护的文件扩展名',
    'HotlinkProtection.friendsLabel' => '友好网站地址',
    'HotlinkProtection.success' => '盗链防护设置已更改。',

    'Odbc.add' => '添加 ODBC DSN',
    'Odbc.resourceUsage' => '允许创建 %%allowed%%，已创建 %%used%%。',
    'Odbc.limitExceeded' => '已超出 ODBC DSN 连接限制。',
    'Odbc.unlimited' => '无限',
    'Odbc.addTooltip' => '添加ODBC数据源。',
    'Odbc.status' => '状态',
    'Odbc.name' => '连接名',
    'Odbc.driver' => '驱动程序',
    'Odbc.description' => '连接描述',
    'Odbc.hostname' => '主机名',
    'Odbc.statusSystem' => '这是系统 DSN。',
    'Odbc.statusConfigured' => 'DSN 已配置。',
    'Odbc.statusNotConfigured' => 'DSN 尚未配置。',
    'Odbc.noSelectionText' => '选择要移除的一个或多个项目。',
    'Odbc.removeConfirmation' => '是否移除{count, plural, =1 {{name} 连接} other {#选定的连接}}？',
    'Odbc.removeSuccess' => '选定的连接已被移除。',

    'DomainAliasSettings.title' => '域名别名设置',
    'DomainAliasSettings.updateSuccess' => '域名别名 %%name%% 的属性已更改。%%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => '网站设置将在%%restartInterval%% 分钟后被应用。',

    'Home.Backup.offStatus' => '此备份无效。无法从此文件恢复数据。',
    'Home.Backup.task-failedStatus' => '备份任务失败。',
    'Home.Backup.activeSchedule' => '计划：%%schedule%%',
    'Home.Backup.activeSchedules' => '计划：%%schedules%%',
    'Home.Backup.noSchedule' => "未设置备份计划",
    'Home.Backup.period_hourly' => '按小时 %%schedule%%',
    'Home.Backup.period_daily' => '每天 %%schedule%%',
    'Home.Backup.period_weekly' => '每周 %%schedule%%',
    'Home.Backup.period_monthly' => '每月 %%schedule%%',
    'Home.Backup.create' => '创建备份',
    'Home.Backup.schedule' => '计划',
    'Home.ChangeLog.seeHistory' => '查看更改历史记录',
    'Home.CustomButtons.add' => '添加自定义按钮',
    'Home.CustomButtons.noButtons' => '尚无自定义按钮',
    'Home.Customization.title' => 'Dashboard',
    'Home.Customization.description' => '选择您想要查看的选项',
    'Home.Customization.pleskSection' => 'Plesk',
    'Home.Customization.serverSection' => '服务器',
    'Home.Customization.securitySection' => '安全',
    'Home.Customization.backup' => '上一次服务器备份',
    'Home.Customization.ipBan' => 'IP 地址禁止',
    'Home.Customization.mailQueue' => '邮件队列',
    'Home.Customization.mySubscriptions' => '我的订阅',
    'Home.Customization.overusedSubscriptions' => '超出使用的订阅',
    'Home.Customization.serverInfo' => '服务器信息',
    'Home.Customization.updates' => 'Plesk 更新',
    'Home.Customization.promo' => '广告',
    'Home.Customization.changeLog' => '新功能',
    'Home.Customization.customButtons' => '自定义按钮',
    'Home.Customization.drag' => '拖动以移动面板',
    'Home.EmptyView.title' => '通过选择要查看的选项，充分利用您的 dashboard。',
    'Home.EmptyView.titleLocked' => 'dashboard 已被您的服务提供商锁定。',
    'Home.EmptyView.customize' => '自定义',
    'Home.Extension.title' => '扩展名',
    'Home.IpBan.banned' => '禁止',
    'Home.IpBan.trusted' => '信任',
    'Home.IpBan.more' => '查看更多',
    'Home.MailQueue.total' => '共计',
    'Home.MailQueue.deferred' => '延迟',
    'Home.MailQueue.held' => '暂停',
    'Home.MailQueue.more' => '查看更多',
    'Home.MailQueue.clean' => '清除邮件队列',
    'Home.MailQueue.checkLogs' => '检查日志',
    'Home.MailQueue.repair' => '修理',
    'Home.MailQueue.cleanConfirmQuestion' => '要清除邮件队列吗？',
    'Home.MailQueue.cleanConfirmYes' => '是',
    'Home.MailQueue.cleanConfirmNo' => '否',
    'Home.MailQueue.queueCleaned' => '已成功清除邮件队列。',
    'Home.OverusedSubscriptions.empty' => '未找到超出使用的订阅',
    'Home.OverusedSubscriptions.usage' => '%%formattedValue%% 的 %%formattedUsed%%',
    'Home.OverusedSubscriptions.more' => '查看所有的超出使用：[%%total%%]',
    'Home.OverusedSubscriptions.list' => '在列表中打开',
    'Home.ServerInfo.hostname' => '主机名',
    'Home.ServerInfo.copyHostname' => '复制主机名',
    'Home.ServerInfo.ipAddress' => 'IP 地址',
    'Home.ServerInfo.copyIpAddress' => '复制 IP 地址',
    'Home.ServerInfo.publicIpAddress' => '公共 IP 地址',
    'Home.ServerInfo.copyPublicIpAddress' => '复制公共 IP 地址',
    'Home.ServerInfo.os' => '操作系统',
    'Home.ServerInfo.copyOs' => '复制操作系统',
    'Home.ServerInfo.uptime' => '正常运行时间',
    'Home.ServerInfo.uptimeValue' => "{days, plural, =0 {} other {#天}} {hours, plural, other {#小时}} {minutes, plural, other {#分钟}}}",
    'Home.ServerInfo.more' => '查看更多',
    'Home.Subscriptions.add' => '新增',
    'Home.Subscriptions.empty' => '创建订阅能够让您在服务器上的一个独立空间中托管多个网站。%%link%%',
    'Home.Subscriptions.help' => '了解更多',
    'Home.Updates.title' => '产品更新',
    'Home.Updates.version' => '%%name%% %%version%%',
    'Home.Updates.patch' => '%%version%% 更新 #%%patch%%',
    'Home.Updates.manageComponents' => '添加或移除组件',
    'Home.Updates.lastUpdated' => '上一次更新日期：%%lastUpdateDate%%',
    'Home.Updates.checkUpdates' => '检查更新',
    'Home.Updates.enableAutoupdate' => '允许自动更新',
    'Home.Updates.lastChecked' => '最近一次检查：%%lastCheckDate%%',
    'Home.Updates.newVersionAvailable' => '%%availableVersion%% 可用',
    'Home.Updates.installNewVersion' => '现在安装',
    'Home.Updates.patchAvailable' => '小版本更新可用',
    'Home.Updates.patchAvailableVersion' => '%%currentVersion%% 小版本更新可用',
    'Home.Updates.installPatch' => '现在更新',
    'Home.Updates.pumUpdates' => '{total, select, 1 {{package}} other {{package} 更新}}可用',
    'Home.Updates.pumPackage' => '%%name%% %%availableVersion%%',
    'Home.Updates.pumPackages' => '{total, plural, other {# 个程序包}}',
    'Home.Updates.installUpdates' => '{total, select, 1 {现在更新} other {更新全部}}',
    'Home.Promo.close' => '关闭此区',
    'Home.Promo.viewSlide' => '查看幻灯片 %%slideNumber%%',
    'Home.Promo.Customize.title' => '制作属于您自己的 dashboard！',
    'Home.Promo.Customize.content' => '有了全新的可自定义 dashboard，您最喜爱的功能触手可及',
    'Home.Promo.Customize.action' => '自定义',
    'Home.Promo.SwitchToPuv.title' => '您知道 Plesk 中的界面视图吗？',
    'Home.Promo.SwitchToPuv.content' => '如果您不使用服务方案向客户提供主机服务，您可能需要尝试更方便管理网站的界面，即其文件、数据库、电子邮件帐户和 web 应用程序。',
    'Home.Promo.SwitchToPuv.action' => '即刻试用',
    'Home.Status.error' => '错误',
    'Home.Status.warning' => '警告',
    'Home.Status.info' => '信息',

    'HostingSettings.title' => '主机设置',
    'HostingSettings.updateSuccess' => '设置已更新。',
    'HostingSettings.emptyLogin' => '请指定用户名。',
    'HostingSettings.emptyPassword' => '请指定密码。',
    'HostingSettings.ipV6OnlyNotSupported' => 'FTP 服务器不支持 IPv6。至少分配一个 IPv4 地址，不然用户将无法通过 FTP 上传文件到服务器。',
    'HostingSettings.domainSettingsSection.sectionTitle' => '域名设置',
    'HostingSettings.domainSettingsSection.domainName' => '域名',
    'HostingSettings.domainSettingsSection.description' => '例如，example.com ',

    'HostingSettings.submitPopover.title' => '移除 %%website%% 内容',
    'HostingSettings.submitPopover.descriptionMainDomain' => '将“网站”主机类型切换为“%%type%%”将永久移除整个网站的内容，包括以下目录：',
    'HostingSettings.submitPopover.descriptionSubDomain' => '您要更改网站的主机类型吗？',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => '要访问更多设置，请输入系统用户验证凭据，然后单击“创建主机空间”。',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => '要访问更多设置，请单击“下一步”以创建主机。',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => '主机类型',
    'HostingSettings.domainSettingsSection.hostingType.title' => '类型',
    'HostingSettings.domainSettingsSection.hostingType.website' => '网站',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => '转发',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => '无主机',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => '使用域名的 DNS 区域在此域名下拥有邮箱',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => '进入网站主目录的路径',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => '偏好域名',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => '访客将通过 SEO 友好的 HTTP301 重定向被重新定向到这里。',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => '将访客转发到',
    'HostingSettings.domainSettingsSection.forwardingType.title' => '转发类型',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => '永久移动（代码 301）',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => '将网站访客重定向到另一个网站，并向他们显示目标地址。这样的重定向将保持网站的搜索排名',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => '暂时移动（代码 302）',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => '当您不想让搜索引擎索引此临时网站时，可重定向访问者到临时网站副本。',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => '帧转发',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => '重定向网站访客到另一网站，但不向访客显示目标地址，让访客不知道被重定向。',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => '偏好域名',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => '无',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => '文档根目录',
    'HostingSettings.domainSettingsSection.documentRootHint' => '因web应用程序安装到此网站上，无法更改文档根目录。',
    'HostingSettings.domainSettingsSection.save' => '保存',
    'HostingSettings.domainSettingsSection.sameSsl.title' => '兼容模式',
    'HostingSettings.domainSettingsSection.sameSsl.enabled' => '在继承选项 “分离 SSL/TLS 与非 SSL/TLS 内容”的兼容模式下运行网站',
    'HostingSettings.domainSettingsSection.sameSsl.hint' => '此网站在兼容模式下运行，您无法使用 Plesk 界面对其进行管理。这是因为您在升级之前使用了已弃用的“分离 SSL/TLS 与非 SSL/TLS 内容”选项。从 Plesk 11 开始，网站将通过 HTTP 和 HTTPS 连接提供的内容存储在同一目录中。我们建议您将所有数据从“httpsdocs/”目录移至“httpdocs/”，然后关闭兼容模式。这也将使安装在“httpsdocs/”目录中的应用程序可以通过互联网访问。请注意，您将无法再次打开兼容模式。',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => '更改此设置？',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => '更改此设置与服务器的安全策略相矛盾，可能会降低性能或使服务器易受攻击。',
    'HostingSettings.domainSettingsSection.security.buttonChange' => '更改',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => '还原',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => '已应用安全设置预设',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => '为提高安全性，请应用安全设置预设。请注意，某些权限允许订户修改这些设置。',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => '应用安全预设',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => '了解安全主机设置',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'SSL/TLS 支持',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => '启用',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => '加密网站和访客浏览器之间的连接。',
    'HostingSettings.domainSettingsSection.security.certificate' => '证书',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => '要启用 HTTPS，请将 SSL/TLS 证书上传到域名的证书库，然后在此处选择它。',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => '通过 SEO 友好的 301 重定向将访客从 HTTP 重新定向到 HTTPS',
    'HostingSettings.domainSettingsSection.security.noCertificates' => '在您的 repository 中没有 SSL/TLS 证书。要添加证书请进入 %%link%%。',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => '此页面',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%%（其他库）',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => '未选定',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Web 脚本',
    'HostingSettings.domainSettingsSection.webScripting.description' => '选择哪些编程和脚本语言必须由 web 服务器解释。',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'cgi-bin目录位于%%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => '将 SSI 用于 *.htm、*.html 文件',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Microsoft ASP.NET 版本',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => '自定义错误文档',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'cgi-bin目录位于',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => '此域名的文档根目录',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => '主机空间的根目录',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => '该域名旧式的根目录',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => '自定义错误文档',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => '其他写入/修改权限',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Web Deploy 发布',
    'HostingSettings.domainSettingsSection.webStatistics.title' => '网站统计',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => '工具',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => '使用您的 FTP 用户名和密码对您的网站统计访问权限加以保护',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => '禁用',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => '主机空间设置',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'IP 地址',
    'HostingSettings.webspaceSettingsSection.quota.title' => '磁盘空间配额',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => '启用',
    'HostingSettings.webspaceSettingsSection.quota.description' => '如果超过订阅设置中设定的磁盘空间配额（如有），则禁止对网站的文件进行操作。',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => '由于服务器的文件系统配置，不支持硬盘配额。',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => '系统用户验证凭据',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => '通过 FTP 或文件管理器管理网站的文件和文件夹。如果允许，通过 SSH 访问服务器。',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => '通过 FTP 或文件管理器管理网站的文件和文件夹。如果允许，通过远程桌面访问服务器。',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => '用户名',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => '密码',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => '在此处指定一个新密码以更改系统用户的密码。',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'SSH 访问',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => '远程桌面访问',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => '启用',
    'HostingSettings.webspaceSettingsSection.shell.description' => "使用系统用户凭据访问服务器。",
    'HostingSettings.webspaceSettingsSection.shell.type' => '类型',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => '禁用',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => '对{count, plural, other {#域名}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => '以下设置对所有{count, plural, other {# {name}主机空间中的域名}}来说是共有的：',

    'OdbcAdd.title' => '添加 ODBC DSN',
    'OdbcAdd.nameLabel' => '连接名',
    'OdbcAdd.descriptionLabel' => '连接描述',
    'OdbcAdd.driver' => '驱动程序',
    'OdbcAdd.submit' => '创建 ODBC DSN',

    'OdbcEdit.title' => 'ODBC连接配置',
    'OdbcEdit.saveSuccess' => '已保存连接设置。',
    'OdbcEdit.test' => '测试连接',
    'OdbcEdit.connectSuccess' => '连接成功。',

    'OdbcEdit.excel.driver.label' => '驱动程序',
    'OdbcEdit.excel.dbq.label' => '数据库文件路径',
    'OdbcEdit.excel.defaultdir.label' => '默认数据路径',
    'OdbcEdit.excel.fil.label' => '数据库版本',
    'OdbcEdit.excel.maxbuffersize.label' => '缓冲区最大值',
    'OdbcEdit.excel.pagetimeout.label' => '页面超时',

    'OdbcEdit.access.driver.label' => '驱动程序',
    'OdbcEdit.access.dbq.label' => '数据库文件路径',
    'OdbcEdit.access.uid.label' => '登录 ID',
    'OdbcEdit.access.pwd.label' => '密码',
    'OdbcEdit.access.pagetimeout.label' => '页面超时',
    'OdbcEdit.access.pagetimeout.description' => '未使用页面在缓存中保留的时段以 0.1 秒计。该选项适用于所有使用 Microsoft Access 驱动程序的数据源。',
    'OdbcEdit.access.maxbuffersize.label' => '缓冲区最大值',
    'OdbcEdit.access.maxbuffersize.description' => '内部缓冲区的大小，以 KB 计，按 256 KB 的单位排列。',
    'OdbcEdit.access.readonly.label' => '只读',
    'OdbcEdit.access.readonly.description' => '将数据库指定为只读状态以禁止任何升级。',
    'OdbcEdit.access.exclusive.label' => '独占',
    'OdbcEdit.access.exclusive.description' => '将数据库指定为独占状态以禁止共享更新。',
    'OdbcEdit.access.safetransactions.label' => '安全交易',
    'OdbcEdit.access.safetransactions.description' => '如果是默认值 0，所有的事务会立即 commit。如果是 1，所有的事务会通过一次 commit 操作保存到硬盘，但是性能将会略微下降。',
    'OdbcEdit.access.threads.label' => '线程',
    'OdbcEdit.access.threads.description' => '引擎要使用的后台线程数量。',
    'OdbcEdit.access.maxscanrows.label' => '最大扫描行数',
    'OdbcEdit.access.maxscanrows.description' => '根据现有数据设置列的数据类型时，要扫描的行数。',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => '指定事务外部更改如何写入数据库中。',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => '指定 MS Access 驱动程序是否显式同步执行用户定义的事务。',

    'OdbcEdit.mssql.driver.label' => '驱动程序',
    'OdbcEdit.mssql.server.label' => '服务器',
    'OdbcEdit.mssql.uid.label' => '登录 ID',
    'OdbcEdit.mssql.pwd.label' => '密码',
    'OdbcEdit.mssql.database.label' => '默认数据库',
    'OdbcEdit.mssql.app.label' => '应用程序名称',
    'OdbcEdit.mssql.wsid.label' => '工作站ID',
    'OdbcEdit.mssql.language.label' => '默认语言',
    'OdbcEdit.mssql.oemtoansi.label' => '此参数指定了是否将扩展字符转换为OEM值',

    'OdbcEdit.mysql.driver.label' => 'MySQL ODBC驱动程序',
    'OdbcEdit.mysql.server.label' => '服务器',
    'OdbcEdit.mysql.server.description' => 'MariaDB/MySQL服务器的主机名',
    'OdbcEdit.mysql.database.label' => '默认数据库',
    'OdbcEdit.mysql.user.label' => '用户名',
    'OdbcEdit.mysql.user.description' => '用于连接到MariaDB/MySQL的用户名',
    'OdbcEdit.mysql.password.label' => '密码',
    'OdbcEdit.mysql.password.description' => '服务器上的用户帐户密码',
    'OdbcEdit.mysql.port.label' => '端口',
    'OdbcEdit.mysql.port.description' => '如果服务器不是本地主机，则使用TCP/IP端口',
    'OdbcEdit.mysql.socket.label' => '套接字',
    'OdbcEdit.mysql.socket.description' => '如果服务器是本地主机，Windows将使用命名管道来连接',
    'OdbcEdit.mysql.option.label' => '选项',
    'OdbcEdit.mysql.option.description' => '指定 MyODBC 如何工作的选项。请参见<a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">文档</a>',

    'ProtectedDirectoryList.add' => '添加受保护目录',
    'ProtectedDirectoryList.addTooltip' => '创建受保护目录。',
    'ProtectedDirectoryList.name' => '名称',
    'ProtectedDirectoryList.realmTitle' => '受保护区的标题',
    'ProtectedDirectoryList.noSelectionText' => '选择要移除的一个或多个项目。',
    'ProtectedDirectoryList.edit' => '编辑',
    'ProtectedDirectoryList.remove' => '移除受保护内容',
    'ProtectedDirectoryList.removeTooltip' => '移除所选目录的保护机制。',
    'ProtectedDirectoryList.removeConfirmation' => '此操作将导致移除对{count, plural, =1 {{name} 目录} other {# 选定目录}}的保护。{count, plural, =1 {该目录} other {这些目录}}将可供互联网用户自由访问。',
    'ProtectedDirectoryList.removeSuccess' => '选定目录已被移除。',

    'ProtectedDirectoryAdd.title' => '创建受保护目录',
    'ProtectedDirectoryAdd.submit' => '创建',
    'ProtectedDirectoryAdd.success' => '成功创建受保护目录%%path%%。',

    'ProtectedDirectoryEdit.title' => '受保护URL的设置',
    'ProtectedDirectoryEdit.success' => '已更改受保护目录设置',

    'ProtectedDirectoryUserAdd.title' => '创建受保护的目录用户',
    'ProtectedDirectoryUserAdd.subtitle' => '目录 %%directory%%',
    'ProtectedDirectoryUserAdd.loginLabel' => '用户名',
    'ProtectedDirectoryUserAdd.passwordLabel' => '密码',
    'ProtectedDirectoryUserAdd.submit' => '创建',
    'ProtectedDirectoryUserAdd.success' => '已创建受保护的目录用户 %%login%%。',

    'ProtectedDirectoryUserPassword.title' => '受保护的目录用户密码',
    'ProtectedDirectoryUserPassword.subtitle' => '用户 %%login%%',
    'ProtectedDirectoryUserPassword.passwordLabel' => '密码',
    'ProtectedDirectoryUserPassword.submit' => '保存',
    'ProtectedDirectoryUserPassword.success' => '已保存用户凭证。',

    'SummaryReport.Layout.title' => '报告布局属性',
    'SummaryReport.Layout.success' => '报告布局 %%name%% 已更新。',

    'SummaryReport.Layout.Add.title' => '创建报告布局',
    'SummaryReport.Layout.Add.success' => '报告布局 %%name%% 已创建。',

    'SummaryReport.Report.buttonLayouts' => '布局',
    'SummaryReport.Report.buttonSchedule' => '计划',
    'SummaryReport.Report.buttonProperties' => '属性',
    'SummaryReport.Report.buttonTrafficHistory' => '流量历史',
    'SummaryReport.Report.buttonPrint' => '打印',
    'SummaryReport.Report.buttonSend' => '通过电子邮件发送',
    'SummaryReport.Report.successSent' => '报告已发送给%%email%%',

    'SummaryReport.Schedule.Properties.title' => '%%name%% 的发送计划',
    'SummaryReport.Schedule.Properties.success' => '报告发送计划已更新。',

    'SummaryReport.Schedule.Add.title' => '创建 %%name%% 的发送计划',
    'SummaryReport.Schedule.Add.success' => '已创建报告发送计划。',

    'VirtualDirectory.errNotExist' => '该虚拟目录链接到不存在的物理文件夹。',
    'VirtualDirectory.errNoPermissions' => '您不具有浏览此目录内容的权限。',
    'VirtualDirectory.tabBrowse' => '目录',
    'VirtualDirectory.tabBrowseHint' => '处理网站%%site%%上的物理和虚拟文件及目录。',
    'VirtualDirectory.tabMimeTypes' => 'MIME类型',
    'VirtualDirectory.tabMimeTypesHint' => '管理已注册的 MIME 类型。',
    'VirtualDirectory.tabErrorDocs' => '错误文档',
    'VirtualDirectory.tabErrorDocsHint' => '管理错误文档。',
    'VirtualDirectory.tabProtection' => '保护',
    'VirtualDirectory.tabProtectionHint' => '使用密码保护限制目录访问。',

    'VirtualDirectory.errorDocType.default' => '默认',
    'VirtualDirectory.errorDocType.file' => '文件',
    'VirtualDirectory.errorDocType.url' => 'URL',

    'VirtualDirectory.Sidebar.buttonProperties' => '目录属性',
    'VirtualDirectory.Sidebar.buttonPropertiesHint' => '查看和更改虚拟目录属性。',
    'VirtualDirectory.Sidebar.buttonPermissions' => '目录访问权限',
    'VirtualDirectory.Sidebar.buttonPermissionsHint' => '设置目录访问权限。',
    'VirtualDirectory.Sidebar.buttonAspDotNet' => 'ASP.NET',
    'VirtualDirectory.Sidebar.buttonAspDotNetHint' => '配置 ASP.NET 设置。',
    'VirtualDirectory.Sidebar.buttonPhp' => 'PHP',
    'VirtualDirectory.Sidebar.buttonPhpHint' => '配置 PHP 设置。',

    'VirtualDirectory.CreateDirectory.title' => '创建目录',
    'VirtualDirectory.CreateDirectory.name' => '目录名称',
    'VirtualDirectory.CreateDirectory.success' => '%%name%% 目录已创建。',
    'VirtualDirectory.CreateDirectory.errExists' => '%%name%% 目录已存在。',

    'VirtualDirectory.CreateVirtualDirectory.title' => '创建虚拟目录',
    'VirtualDirectory.CreateVirtualDirectory.success' => '%%name%% 目录已创建。',

    'VirtualDirectory.EditVirtualDirectory.title' => '虚拟目录属性',
    'VirtualDirectory.EditVirtualDirectory.success' => '已编辑虚拟目录。',
    'VirtualDirectory.EditVirtualDirectory.close' => '关闭',

    'VirtualDirectory.MimeTypeList.add' => '添加MIME类型',
    'VirtualDirectory.MimeTypeList.edit' => '编辑 MIME 类型',
    'VirtualDirectory.MimeTypeList.addHint' => '注册新MIME类型。',
    'VirtualDirectory.MimeTypeList.columnExtension' => '扩展名',
    'VirtualDirectory.MimeTypeList.columnContent' => '内容',
    'VirtualDirectory.MimeTypeList.noSelectionText' => '选择要移除的一个或多个项目。',
    'VirtualDirectory.MimeTypeList.removeConfirmation' => '要移除 {count, plural, =1 {所选 MIME 类型} other {# 所选 MIME 类型}}吗？',
    'VirtualDirectory.MimeTypeList.removeSuccess' => '所选 MIME 类型已移除。',

    'VirtualDirectory.CreateMimeType.title' => '添加MIME类型',
    'VirtualDirectory.CreateMimeType.success' => '新的 MIME 类型已注册。',

    'VirtualDirectory.EditMimeType.title' => '编辑 MIME 类型',
    'VirtualDirectory.EditMimeType.success' => 'MIME 类型已编辑。',

    'VirtualDirectory.ErrorDocList.columnCode' => '错误',
    'VirtualDirectory.ErrorDocList.columnName' => '描述',
    'VirtualDirectory.ErrorDocList.columnType' => '类型',
    'VirtualDirectory.ErrorDocList.columnLocation' => '位置',
    'VirtualDirectory.ErrorDocList.edit' => '编辑',

    'VirtualDirectory.EditErrorDoc.title' => '编辑错误文档',
    'VirtualDirectory.EditErrorDoc.success' => '已编辑错误文档。',

    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.error' => '错误',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.type' => '类型',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.location' => '位置',

    'VirtualDirectory.Protection.notSupported' => '此目录不支持目录保护，因为其名称超过 245 个字符或包含不支持的字符。',
    'VirtualDirectory.Protection.NoProtectionView.title' => '虚拟目录保护已禁用',
    'VirtualDirectory.Protection.NoProtectionView.protect' => '保护',
    'VirtualDirectory.Protection.NoProtectionView.successProtection' => '目录 %%path%% 已受保护。',
    'VirtualDirectory.Protection.tools' => '工具',
    'VirtualDirectory.Protection.removeProtection' => '移除保护',
    'VirtualDirectory.Protection.removeProtectionTooltip' => '指定所有人都可以访问目录对应的 URL。',
    'VirtualDirectory.Protection.removeProtectionConfirmation' => '要移除虚拟目录保护吗？此操作也会移除所有受保护的目录用户和目录保护设置。',
    'VirtualDirectory.Protection.settings' => '设置',
    'VirtualDirectory.Protection.settingsTooltip' => '查看目录位置，并指定受保护区标题。',

    'VirtualDirectory.AspDotNet.title' => '配置 ASP.NET 设置',

    'VirtualDirectory.Php.title' => 'PHP 版本',
    'VirtualDirectory.Php.version' => '版本',
    'VirtualDirectory.Php.success' => 'PHP 版本已更新。',


    'MassMailPage.sendEmail' => '群发邮件',
    'MassMailPage.selectAtLeastOneTemplate' => '至少选择一个模板。',
    'MassMailPage.confirmRemoval' => '您确定要移除所选的 {count, select, 1 {模板} other {模板}}吗？',
    'MassMailPage.remove' => '移除',
    'MassMailPage.filters' => '过滤器',
    'MassMailPage.name' => '模板名称',
    'MassMailPage.sender' => '发件人',
    'MassMailPage.recipients' => '收件人',
    'MassMailPage.subject' => '主题',
    'MassMailPage.created' => '创建日期',
    'MassMailPage.send' => '发送',
    'MassMailPage.recipientsNone' => '无',
    'MassMailPage.recipientsAdmins' => '管理员',
    'MassMailPage.recipientsResellers' => '所有代理商',
    'MassMailPage.recipientsResellersSelected' => '所选代理商',
    'MassMailPage.recipientsResellersExcept' => '排除所选之外的其他代理商',
    'MassMailPage.recipientsClients' => '所有客户',
    'MassMailPage.recipientsClientsSelected' => '所选客户',
    'MassMailPage.recipientsClientsExcept' => '除选中之外的所有客户',
    'MassMailPage.templatesRemoved' => '移除 {count, select, 1 {模板} other {模板}}。',
    'MassMailPage.emptyViewTitle' => '无群发电子邮件模板',
    'MassMailPage.addNew' => '创建模板',
    'CreateMassMailTemplatePage.templateCreated' => '模板已创建。',
    'EditMassMailTemplatePage.templateUpdated' => '模板已更新。',
    'SendMassMailPage.emailSent' => '电子邮件已发送。',
    'SendMassMailPage.fieldIsRequired' => '字段不得为空',
    'SendMassMailPage.saveAsTemplate' => '将已撰写的信息保存到新模板中',
    'SendMassMailPage.newTemplateName' => '新模板名称',
    'SendMassMailPage.selectedTemplate' => '所选模板',
    'SendMassMailPage.send' => '发送',
    'VirtualHostTemplatePage.name' => '名称',
    'VirtualHostTemplatePage.sizeInBytes' => '大小',
    'VirtualHostTemplatePage.modified' => '修改日期',
    'VirtualHostTemplatePage.permissions' => '权限',
    'VirtualHostTemplatePage.user' => '用户',
    'VirtualHostTemplatePage.group' => '群组',
    'VirtualHostTemplatePage.uploadTemplate' => '上传',
    'VirtualHostTemplatePage.succesfullyUploaded' => '模板已上传。',
    'VirtualHostTemplatePage.root' => '虚拟模板',
    'VirtualHostTemplatePage.emptyViewTitle' => '模板中没有文件',
    'VirtualHostTemplatePage.total' => '目录中的项目总数 {breadcrumbs}：{total}',
    'VirtualHostTemplatePage.resetTemplate' => '恢复默认',
    'VirtualHostTemplatePage.successfullyReset' => '模板已更改为默认。',

    'TrafficUsageByDomain.List.service' => '服务',
    'TrafficUsageByDomain.List.usage' => '已使用',
    'TrafficUsageByDomain.List.incoming' => '流入',
    'TrafficUsageByDomain.List.outgoing' => '流出',
    'TrafficUsageByDomain.List.percentOfAll' => '%（占总量比例）',

    'TrafficUsageByDomains.Viewer.List.domainName' => '域名',
    'TrafficUsageByDomains.Viewer.List.clientName' => "所有者名称",
    'TrafficUsageByDomains.Viewer.List.totalUsage' => '已使用',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimit' => '限制',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitRemaining' => '可用',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitUsagePercent' => '已使用（%）',
    'TrafficUsageByDomains.Viewer.Filters.ownOnly' => '仅限我的域名',
    'TrafficUsageByDomains.Viewer.Filters.resellerOnly' => '仅限代理商域名',
    'TrafficUsageByDomains.Viewer.Filters.clientName' => '所有者名称',

    'TrafficUsageByReseller.emptyView' => '代理商没有客户',
    'TrafficUsageByReseller.TotalUsage.usageByResellerDomains' => '%%resellerDomainsLink%%：%%usage%%',
    'TrafficUsageByReseller.TotalUsage.resellerDomains' => "代理商自己的域名",
    'TrafficUsageByReseller.TotalUsage.usageByCustomerDomains' => "代理商客户的域名：%%usage%%",

    'InfoAndStatistics.Main.title' => '信息和统计',
    'InfoAndStatistics.Main.overview' => '概要',
    'InfoAndStatistics.Main.domains' => '域名',
    'InfoAndStatistics.Main.trafficUsage' => '流量使用情况',
    'InfoAndStatistics.Main.reports' => '报告',
    'InfoAndStatistics.Main.serverSettings' => '服务器设置',
    'InfoAndStatistics.TrafficUsage.customers' => '客户',
    'InfoAndStatistics.TrafficUsage.resellers' => '代理商',
    'InfoAndStatistics.TrafficUsage.domains' => '域名',

    'ConfigureMailClient.title' => '选择您的邮件客户端',
    'ConfigureMailClient.description' => '自动设置 %%email%%',
    'ConfigureMailClient.thunderbird' => 'Thunderbird',
    'ConfigureMailClient.manual' => '手动',
    'ConfigureMailClient.Common.email' => '电子邮件：',
    'ConfigureMailClient.Common.start' => '启动',
    'ConfigureMailClient.Common.finish' => '完成',
    'ConfigureMailClient.Common.next' => '下一页',
    'ConfigureMailClient.Common.prev' => '上一页',
    'ConfigureMailClient.Common.back' => '返回',
    'ConfigureMailClient.Common.manualLink' => '添加邮件帐户时遇到困难？请尝试手动设置。',
    'ConfigureMailClient.Thunderbird.title' => '设置您的邮件帐户',
    'ConfigureMailClient.Thunderbird.description' => '按照说明将您的邮件帐户添加到 Mozilla Thunderbird。',
    'ConfigureMailClient.Thunderbird.step1.title' => '打开 Thunderbird',
    'ConfigureMailClient.Thunderbird.step1.description' => '在您的电脑上打开 Thunderbird，然后单击 Thunderbird 主菜单中的“帐户设置”。',
    'ConfigureMailClient.Thunderbird.step2.title' => '添加您的帐户',
    'ConfigureMailClient.Thunderbird.step2.description' => '单击“帐户操作”，然后单击“添加邮件帐户”。',
    'ConfigureMailClient.Thunderbird.step3.title' => '输入您的信息',
    'ConfigureMailClient.Thunderbird.step3.description' => '如果您希望您的姓名出现在发送的任何信息中，请输入姓名。此外，请输入您的电子邮件地址和密码，然后单击“继续”。',
    'ConfigureMailClient.Thunderbird.step4.title' => '全部完成！',
    'ConfigureMailClient.Thunderbird.step4.description' => 'Thunderbird 现在会尝试自动添加您的邮件帐户。',

    'ConfigureMailClient.Outlook.title' => '设置您的邮件帐户',
    'ConfigureMailClient.Outlook.warning' => '我们无法将您的邮件帐户自动添加到 Outlook 2019 或更高版本。',
    'ConfigureMailClient.Outlook.warningTooltip' => '我们使用 autodiscover 自动添加邮件帐户。Outlook 2019 及更高版本使用 Microsoft 代理服务器来处理 autodiscover 请求，而 Plesk 和 Plesk Premium Email 扩展不支持这种方式。',
    'ConfigureMailClient.Outlook.description' => '按照说明将邮件帐户添加到 Microsoft Office Outlook 2016。',
    'ConfigureMailClient.Outlook.step1.title' => '添加新帐户',
    'ConfigureMailClient.Outlook.step1.description' => '在您的电脑上打开 Outlook 2016，然后转到“文件”选项卡。',
    'ConfigureMailClient.Outlook.step2.title' => '添加新帐户',
    'ConfigureMailClient.Outlook.step2.description' => '单击“添加帐户”。',
    'ConfigureMailClient.Outlook.step3.title' => '输入您的电子邮件地址',
    'ConfigureMailClient.Outlook.step3.description' => '输入您的电子邮件地址。',
    'ConfigureMailClient.Outlook.step4.title' => '输入您的密码',
    'ConfigureMailClient.Outlook.step4.description' => '输入您的邮件帐户密码，然后单击“连接”。',
    'ConfigureMailClient.Outlook.step5.title' => '全部完成！',
    'ConfigureMailClient.Outlook.step5.description' => '单击“确定”完成帐户设置。',

    'ConfigureMailClient.Outlook365.title' => '设置您的邮件帐户',
    'ConfigureMailClient.Outlook365.warning' => '我们无法将您的邮件帐户自动添加到 Outlook 2019 或更高版本。',
    'ConfigureMailClient.Outlook365.warningTooltip' => '我们使用 autodiscover 自动添加邮件帐户。Outlook 2019 及更高版本使用 Microsoft 代理服务器来处理 autodiscover 请求，而 Plesk 和 Plesk Premium Email 扩展不支持这种方式。',
    'ConfigureMailClient.Outlook365.description' => '按照说明将您的邮件帐户添加到 Microsoft Outlook 365。',
    'ConfigureMailClient.Outlook365.step1.title' => '添加新帐户',
    'ConfigureMailClient.Outlook365.step1.description' => '在电脑上打开 Outlook 365。如果您尚未在 Outlook 365 中配置邮件帐户，请在向导页面输入您的地址。',
    'ConfigureMailClient.Outlook365.step2.title' => '添加新帐户',
    'ConfigureMailClient.Outlook365.step2.description' => '选择 IMAP 作为电子邮件提供商。输入您的密码，使用推荐设置，然后点击“继续”。',
    'ConfigureMailClient.Outlook365.step3.title' => '输入您的电子邮件地址',
    'ConfigureMailClient.Outlook365.step3.description' => '确认同步您的 IMAP 帐户，等待设置完成。',
    'ConfigureMailClient.Outlook365.step4.title' => '添加更多帐户',
    'ConfigureMailClient.Outlook365.step4.description' => '要添加更多邮件帐户到 Outlook 365 ，请点击“添加帐户”。',
    'ConfigureMailClient.Outlook365.step5.title' => '全部完成！',
    'ConfigureMailClient.Outlook365.step5.description' => '重复上述步骤以添加新帐户。',

    'ConfigureMailClient.Gmail.title' => '设置您的邮件帐户',
    'ConfigureMailClient.Gmail.description' => '按照说明将您的邮件帐户添加到移动设备上的 Gmail 应用程序。',
    'ConfigureMailClient.Gmail.step1.title' => '添加新帐户',
    'ConfigureMailClient.Gmail.step1.description1' => '打开 Android 手机上的 Gmail 应用程序。点击右上角的个人资料照片。',
    'ConfigureMailClient.Gmail.step1.description2' => '点击“添加另一个帐户”。',
    'ConfigureMailClient.Gmail.step1.description3' => '点击“其他”。',
    'ConfigureMailClient.Gmail.step2.title' => '输入您的电子邮件地址',
    'ConfigureMailClient.Gmail.step2.description' => '输入您的电子邮件地址，然后点击“下一步”。',
    'ConfigureMailClient.Gmail.step3.title' => '选择帐户类型',
    'ConfigureMailClient.Gmail.step3.description' => '要在服务器上保留下载的电子邮件副本，请点击“个人（IMAP）”。要从服务器上删除下载的电子邮件信息，请点击“个人（POP3）”。',
    'ConfigureMailClient.Gmail.step4.title' => '输入您的密码',
    'ConfigureMailClient.Gmail.step4.description' => '输入邮件帐户密码，然后点击“下一步”。',
    'ConfigureMailClient.Gmail.step5.title' => '邮件移除设置',
    'ConfigureMailClient.Gmail.step5.description' => '选择在应用程序中删除电子邮件是否也会从服务器中删除，然后点击“下一步”。',
    'ConfigureMailClient.Gmail.step6.title' => '帐户选项',
    'ConfigureMailClient.Gmail.step6.description1' => '应用程序将自动获取发送服务器设置。',
    'ConfigureMailClient.Gmail.step6.description2' => '如果需要，可更改默认帐户选项，然后点击“下一步”。',
    'ConfigureMailClient.Gmail.step7.title' => '全部完成！',
    'ConfigureMailClient.Gmail.step7.description1' => '（可选）输入您想在所发送的任何邮件中显示的姓名。',
    'ConfigureMailClient.Gmail.step7.description2' => '点击“下一步”完成帐户设置。',

    'ConfigureMailClient.Ios.title' => '设置您的邮件帐户',
    'ConfigureMailClient.Ios.description' => '在 iOS 设备上扫描二维码或打开下面的链接，即可自动将邮件帐户添加到 iOS Mail 应用程序。',
    'ConfigureMailClient.Ios.link'  =>  '添加帐户到 iOS Mail',

    'ConfigureMailClient.Manual.title' => '手动设置您的邮件帐户',
    'ConfigureMailClient.Manual.description' => '将 %%email%% 添加到您的邮件客户端时，请使用这些值。',
    'ConfigureMailClient.Manual.username' => '邮件服务器用户名：',
    'ConfigureMailClient.Manual.outgoingServer' => '传出邮件服务器（需要验证）：',
    'ConfigureMailClient.Manual.incomingServer' => '传入邮件服务器：',
    'ConfigureMailClient.Manual.supportedIncomingProtocols' => '支持的传入邮件协议：',
    'ConfigureMailClient.Manual.supportedOutgoingProtocols' => '支持的传出邮件协议：',


    'Databases.Page.title' => '%%database%% 的数据库',
    'Databases.Page.databaseTab' => '数据库',
    'Databases.Page.userTab' => '用户管理',
    'Databases.Page.serversLink' => '数据库服务器',
    'Databases.Page.backupLink' => '备份管理器',

    'Databases.List.add' => '添加数据库',
    'Databases.List.find' => '查找数据库……',
    'Databases.List.databaseColumn' => '数据库',
    'Databases.List.relatedToColumn' => '相关',
    'Databases.List.relatedToDomains' => '与 %%domains%% 相关',
    'Databases.List.noRelatedDomains' => '分配该数据库给一个网站',
    'Databases.List.noDomainRelations' => '无相关网站',
    'Databases.List.openWebAdmin' => 'phpMyAdmin',
    'Databases.List.changeRelatedDomain' => '更改',
    'Databases.List.connectionInfo' => '连接信息',
    'Databases.List.downloadDump' => '导出转储',
    'Databases.List.uploadDump' => '导入转储',
    'Databases.List.copy' => '复制数据库',
    'Databases.List.checkDatabase' => '检查并修复',
    'Databases.List.assignToSubscription' => '移动到订阅',
    'Databases.List.assignToSubscription_powerUser' => '移动到主机空间',
    'Databases.List.remove' => '移除',
    'Databases.List.removeConfirmation' => '要移除 %%name%% 数据库吗？',
    'Databases.List.removeButtonDisabledHint' => '无法移除数据库，因为已安装的 web 应用程序正在使用此数据库。',
    'Databases.List.databaseRemoved' => '数据库已被移除。',
    'Databases.List.downloadMsSqlClient' => '下载一个本地的SQL客户端',
    'Databases.List.downloadMsSqlClientHint' => '下载一个本地的SQL客户端',
    'Databases.List.webadmin' => 'web Admin',
    'Databases.List.webadminHint' => '通过数据库 Web Admin 访问此服务器。',
    'Databases.List.dumpSubscriptionIsTurnedOff' => '无法 %%action%% 转储：该订阅已被挂起。',
    'Databases.List.dumpExport' => '导出',
    'Databases.List.dumpImport' => '导入',
    'Databases.List.copyDatabaseName' => '复制数据库名称',
    'Databases.List.copySuccess' => '%%name%% 已被复制到剪切板',

    'Databases.DatabaseSummary.host' => '主机',
    'Databases.DatabaseSummary.serverUnavailable' => '该服务器不可用。',
    'Databases.DatabaseSummary.user' => '用户',
    'Databases.DatabaseSummary.users' => '用户',
    'Databases.DatabaseSummary.noUser' => '无数据库用户',
    'Databases.DatabaseSummary.seeAll' => '查看全部',
    'Databases.DatabaseSummary.createUser' => '创建用户',
    'Databases.DatabaseSummary.calculatingSize' => '正在计算大小...',
    'Databases.DatabaseSummary.tablesCount' => '表格',
    'Databases.DatabaseSummary.size' => '大小',

    'Databases.InPlaceSelect.editButtonHint' => '编辑',
    'Databases.InPlaceSelect.saveButtonHint' => '保存',
    'Databases.InPlaceSelect.closeButtonHint' => '取消',
    'Databases.InPlaceSelect.selectWebsiteAriaLabel' => '选择网站',

    'Databases.ConnectionInfo.title' => '连接信息',
    'Databases.ConnectionInfo.description' => '用于数据库 %%database%%',
    'Databases.ConnectionInfo.hint' => '例如，您可以在安装 web 应用程序时使用这些数据库的连接详情。',
    'Databases.ConnectionInfo.host' => '主机',
    'Databases.ConnectionInfo.copyHost' => '复制主机到剪贴板',
    'Databases.ConnectionInfo.databaseName' => '数据库名称',
    'Databases.ConnectionInfo.copyDatabaseName' => '复制数据库名称到剪切板',
    'Databases.ConnectionInfo.user' => '用户名',
    'Databases.ConnectionInfo.copyUser' => '复制用户名到剪切板',
    'Databases.ConnectionInfo.password' => '密码',
    'Databases.ConnectionInfo.noDefaultUser' => '无默认的用户',

    'Databases.Add.title' => '添加数据库',
    'Databases.Add.name' => '数据库名称',
    'Databases.Add.server' => '数据库服务器',
    'Databases.Add.versionCut' => 'v%%version%%',
    'Databases.Add.relatedDomain' => '相关网站',
    'Databases.Add.noDomainRelations' => '无相关网站',
    'Databases.Add.userSection' => '用户',
    'Databases.Add.userSectionDescription' => '创建一个默认的数据库用户。Plesk 将会代表该用户访问数据库。如果数据库没有分配数据库用户，将无法访问该数据库。',
    'Databases.Add.createUser' => '创建数据库用户',
    'Databases.Add.username' => '数据库用户名',
    'Databases.Add.password' => '密码',
    'Databases.Add.passwordConfirmation' => '确认密码',
    'Databases.Add.allDbAccess' => '用户有访问所选订阅内所有数据库的权限',
    'Databases.Add.aclRadio' => '访问控制',
    'Databases.Add.aclLocalhost' => '仅允许本地连接',
    'Databases.Add.aclAny' => '允许来自任何主机的远程连接',
    'Databases.Add.aclCustom' => '允许远程连接来自',
    'Databases.Add.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\n允许指定的主机代表该用户访问数据库。",
    'Databases.Add.aclHostsLabel' => '在此处输入允许访问的远程主机的名称或 IP 地址',
    'Databases.Add.remoteAccess' => '远程访问',
    'Databases.Add.remoteAccessDenied' => '使用系统防火墙规则',
    'Databases.Add.remoteAccessAllowed' => '允许远程连接来自',
    'Databases.Add.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\n允许指定的主机通过防火墙规则访问数据库。在该列表中的修改将被您的主机提供商预先修改。",
    'Databases.Add.remoteAccessHint' => '请联系您的主机提供商确认您上述指定的选项符合传入连接 MariaDB/MySQL 的当前防火墙规则。',
    'Databases.Add.example' => "例如：\n%%example%%",
    'Databases.Add.denied' => '使用系统防火墙规则',
    'Databases.Add.allowed' => '允许远程连接来自',
    'Databases.Add.databaseCreated' => '已创建数据库  %%name%%。',
    'Databases.Add.create' => '创建数据库',

    'Databases.Clone.title' => '复制数据库',
    'Databases.Clone.clone' => '确定',
    'Databases.Clone.warning' => '警告：如果表格名称相同，源数据库的表格将会替换目的数据库中的表格。',
    'Databases.Clone.formDescription' => '复制数据库内容到新的或现有的数据库。当复制到现有的数据库时，源数据库的表格会被添加到目的数据库中的表格列表里。',
    'Databases.Clone.copyData' => '创建一个完整的副本',
    'Databases.Clone.copyDataHint' => '如果选定该选项，将会复制整个数据库（包括结构和数据）。如果清空选项，将只会复制表格的结构。',
    'Databases.Clone.copyHint' => '您将复制数据库 %%databaseName%%',
    'Databases.Clone.server' => '目的数据库服务器',
    'Databases.Clone.versionCut' => 'v%%version%%',
    'Databases.Clone.externalServer' => '其他...',
    'Databases.Clone.database' => '目的数据库',
    'Databases.Clone.newDatabase' => '创建新数据库（名称）',
    'Databases.Clone.newDatabaseName' => '新建数据库名称',
    'Databases.Clone.existingDatabaseName' => '现有数据库名称',
    'Databases.Clone.existingDatabase' => '复制到现有的数据库',
    'Databases.Clone.externalDbHost' => '主机名或 IP 地址',
    'Databases.Clone.externalDbLogin' => '用户名',
    'Databases.Clone.externalDbPassword' => '密码',
    'Databases.Clone.subscription' => '目的订阅',
    'Databases.Clone.subscription_powerUser' => '目的主机空间',
    'Databases.Clone.cloneInProgress' => '克隆数据库 %%source%% 到数据库 %%destination%%.将会通过邮件通知您其进程(%%email%%)。',
    'Databases.Clone.unableToClone' => '无法复制数据库 "%%source%%"。',
    'Databases.Clone.unableToCreateExternalDatabase' => '无法在指定的服务器上创建数据库 "%%destination%%"。',
    'Databases.Clone.databaseCloned' => '数据库 "%%source%%" 已复制。',
    'Databases.Clone.emailSubjSuccess' => '数据库 "%%sourceDatabase%%" 已复制。',
    'Databases.Clone.emailSubjFailure' => '复制数据库 "%%sourceDatabase%%" 失败。',
    'Databases.Clone.emailBodySuccess' => '数据库 "%%sourceDatabase%%" (%%sourceHost%%) 已复制到数据库 "%%destDatabase%%" (%%destHost%%)。',
    'Databases.Clone.emailBodyFailure' => '无法复制数据库 "%%sourceDatabase%%" (%%sourceHost%%) 到数据库 "%%destDatabase%%" (%%destHost%%)。复制失败。',
    'Databases.Clone.localServer' => '本地服务器',

    "Databases.Import.confirm" => '导入转储',
    'Databases.Import.recreateDatabase' => '重新创建数据库',
    'Databases.Import.rootDirectory' => '根目录',
    'Databases.Import.uploadFromFile' => '从本地计算机上传转储',
    'Databases.Import.uploadFromWebspace' => '导入存储在主机服务器上的转储',
    'Databases.Import.uploadHint' => '您将导入转储到 %%databaseName%%',
    'Databases.Import.uploadPopupTitle' => '导入数据库转储',
    'Databases.Import.uploading' => '正在导入...',
    'Databases.Import.waitMessage' => '请稍候...',

    "Databases.Export.confirm" => '导出转储',
    'Databases.Export.downloadDumpAutomatically' => '创建后自动下载转储',
    'Databases.Export.downloadDumpName' => '转储文件名',
    'Databases.Export.downloadHint' => '您将要创建 %%database%% 的转储并下载它',
    'Databases.Export.downloadPopupTitle' => '导出转储',
    'Databases.Export.downloadRelativePath' => '保存转储到下面的目录',
    'Databases.Export.rootDirectory' => '根目录',
    'Databases.Export.waitMessage' => '请稍候...',

    'MoveDatabasePage.title' => '移动数据库到其它订阅',
    'MoveDatabasePage.title_powerUser' => '移动数据库到其它主机空间',
    'MoveDatabasePage.description' => '您将移动数据库 %%name%%',
    'MoveDatabasePage.hint' => '所选数据库将被移动到选定的订阅。数据库用户也将被移动，除非它们有访问其它数据库的权限。请注意：移动后，在移动前可访问数据库的用户将无法通过 Plesk 中的链接访问数据库。',
    'MoveDatabasePage.subscriptionName' => '移动到订阅',
    'MoveDatabasePage.subscriptionName_powerUser' => '移动到主机空间',
    'MoveDatabasePage.save' => '移动',

    'WebProsAccountPage.descriptionHead' => '通过一次安全登录即可访问所有 WebPros 服务和您的 Plesk 服务器。',
    'WebProsAccountPage.descriptionBody' => '您的 WebPros Account 可连接至 Dashboard、Monitoring、Support Portal、Plesk University 及 KA Partner Central——简化整个 WebPros 生态系统的管理流程。',
    'WebProsAccountPage.buttonLogin' => '使用 WebPros Account 进行身份验证',
    'WebProsAccountPage.buttonSkip' => '跳过直至下次登录',
];
