<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'action-log.logFiles' => "Arquivos de log",
    'action-log.fromDate' => "De:",
    'action-log.toDate' => "Para:",
    'action-log.clearLog' => "Limpar Log",
    'action-log.downloadLog' => "Transferência",
    'action-log.loggedActions' => "Acções gravadas no log",
    'action-log.storeLogsInDb' => "Gravar registos na base de dados",
    'action-log.storeNumber' => "Entradas",
    'action-log.dontRemoveRecs' => "Não remover registos",
    'action-log.confirmCleanLog' => "Tem a certeza que deseja eliminar os registos do log de acção seleccionados?",
    'action-log.incorrectDate' => "Dados especificados inválidos",
    'action-log.incorrectNumPeriods' => "Período de rotação inválido",
    'action-log.incorrectNumRecords' => "Número de registos especificados inválido.",
    'action-log.yes' => "Sim",
    'action-log.no' => "Não",
    'action-log.mixed' => "(misto)",
    'action-log.period' => "Período",
    'action-log.invalidDatePeriod' => "O período da data não é válido",
    'action-log.submitDone' => "As alterações nas configurações de registo de ações foram guardadas.",
    'action-log.clearDone' => "O registo de ações foi limpo.",
    'action-log.periodDay' => "dias",
    'action-log.periodWeek' => "semanas",
    'action-log.periodMonth' => "meses",

    'admin-info.adminInfoSection' => 'Informações para o administrador',
    'admin-info.description-admin' => 'Descrição do administrador',
    'admin-info.description-reseller' => 'Descrição do revendedor',
    'admin-info.description-owner' => 'Descrição do proprietário',
    'admin-info.description' => 'Descrição',
    'admin-info.descriptionSuccess' => 'A descrição foi atualizada',
    'admin-info.longDescription' => 'A descrição especificada é muito longa. Não pode ser maior que %%max%% símbolos.',
    'admin-info.add' => 'Adicionar descrição',
    'admin-info.edit' => 'Editar',
    'admin-info.remove' => 'Eliminar',
    'admin-info.confirmOnRemove' => 'Deseja realmente remover esta descrição?',
    'admin-info.popupTitle-customer' => '%%descriptionType%% do cliente %%name%%',
    'admin-info.popupTitle-reseller' => '%%descriptionType%% do revendedor %%name%%',
    'admin-info.popupTitle-subscription' => '%%descriptionType%% da assinatura %%name%%',
    'admin-info.popupTitle-site' => '%%descriptionType%% de %%name%%',
    'admin-info.popupHint-admin' => 'Esta descrição é visível apenas ao administrador.',
    'admin-info.popupHint-reseller' => 'Esta descrição é visível ao revendedor e ao administrador.',
    'admin-info.popupHint-owner' => 'Esta descrição é visível ao seu autor ou ao fornecedor do alojamento do autor.',
    'admin-info.customerDescriptionHint' => 'Os clientes não podem ver esta descrição.',
    'admin-info.subscriptionDescriptionHint' => "Esta descrição é visível apenas ao fornecedor do alojamento. (Administrador ou revendedor do Plesk).",

    'apache-settings.formGeneralHint' => 'Aqui, pode especificar as configurações do servidor web do Apache para esta página web. Por exemplo, a configuração personalizada do Apache é útil quando quiser utilizar um novo tipo de ficheiros de índice na sua página web, ou associar um determinado tipo MIME a determinadas extensões de nome de ficheiro. O valor Predefinido significa que o Apache irá utilizar a diretiva correspondente da configuração de servidor. Se o Apache está a correr com nginx como servidor front-end, você também pode especificar as configurações de nginx nesta página.',
    'apache-settings.general' => 'Configurações de Apache comum',
    'apache-settings.example' => "Por exemplo:\n%%example%%",
    'apache-settings.settingOn' => 'Ligado',
    'apache-settings.settingOff' => 'Desligado (Predefinido)',
    'apache-settings.settingDefault' => 'Predefinido',
    'apache-settings.settingCustom' => 'Insira o valor personalizado',
    'apache-settings.mimeTypes' => 'Tipos MIME',
    'apache-settings.mimeTypesExample' => "text/plain .txt\nimage/jpeg .jpeg",
    'apache-settings.mimeTypesFullDescription' => 'Tipos MIME associam extensões de ficheiros a tipos de ficheiros. Tipicamente, isso é utilizado para criar uma extensão personalizada de ficheiro para tipos comuns de ficheiros.',
    'apache-settings.handlers' => 'Processadores',
    'apache-settings.handlersExample' => "php-script .php\ncgi-script .cgi",
    'apache-settings.handlersFullDescription' => "Manipuladores Apache definem a forma como o servidor web processa ficheiros com determinadas extensões quando pedidos. Por exemplo, a cadeia 'php-script .script' significa que o Apache irá lidar com os ficheiros .script como se fossem scripts de php.",
    'apache-settings.deny' => 'Negar acesso ao site',
    'apache-settings.allow' => 'Exceto',
    'apache-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nOs hosts e redes especificados não têm a permissão de acesso ao site. Utilize '*' para negar todas as ligações.",
    'apache-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nOs hosts e redes especificados têm a permissão de acesso ao site.",
    'apache-settings.directoryIndex' => 'Ficheiros de Índice',
    'apache-settings.directoryIndexExample' => "index.htm index.php index.pl",
    'apache-settings.directoryIndexFullDescription' => "Apache irá procurar ficheiros específicos quando a página de índice do site for pedida.",
    'apache-settings.expires' => 'Validade',
    'apache-settings.expiresStaticOnly' => 'resposta com cabeçalho Caduca apenas para ficheiros estáticos',
    'apache-settings.expiresFullDescription' => 'O servidor de rede adicionará os cabeçalhos de resposta "Caduca" às páginas de rede.O carimbo de data/hora de caducidade é obtido adicionando o tempo especificado acima à hora de pedido de uma página de rede.',
    'apache-settings.expiresStaticOnlyDescription' => 'O cabeçalho "Caduca" apenas será adicionado aos ficheiros estáticos.Os ficheiros que são tratados como estáticos são controlados pelas opções "Processamento inteligente de ficheiros estáticos" e "Gerir ficheiros estáticos diretamente pelo nginx".',
    'apache-settings.expiresUnitDays' => 'dias',
    'apache-settings.expiresUnitHours' => 'horas',
    'apache-settings.expiresUnitMinutes' => 'minutos',
    'apache-settings.expiresUnitSeconds' => 'segundos',
    'apache-settings.expiresSize' => 'Período de validade',
    'apache-settings.expiresUnitSize' => 'Unidades do período de validade',
    'apache-settings.nginxCacheTimeoutSize' => 'Tempo limite da cache',
    'apache-settings.nginxCacheTimeoutUnitSize' => 'Unidades do tempo limite da cache',
    'apache-settings.headers' => 'Cabeçalhos adicionais',
    'apache-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000\nX-Frame-Options: DENY",
    'apache-settings.headersFullDescription' => "O servidor web adicionará os cabeçalhos de resposta HTTP especificados.",
    'apache-settings.restrictFollowSymLinks' => 'Restringe o acesso a links simbólicos',
    'apache-settings.restrictFollowSymLinksDescription' => "Selecione esta opção para proibir que utilizadores usem a instrução FollowSymLink em .htaccess e melhorem a segurança do servidor.",
    'apache-settings.nginx' => 'configurações nginx',
    'apache-settings.nginxProxyMode' => 'Modo Proxy',
    'apache-settings.nginxProxyModeDescription' => 'Pedidos de proxy Nginx para Apache. Desligue para parar de utilizar o Apache.',
    'apache-settings.nginxHttp3Enabled' => 'Suporte para HTTP/3',
    'apache-settings.nginxHttp3EnabledDescription' => 'Funcionalidade experimental. Em casos raros, pode afetar a disponibilidade do website.',
    'apache-settings.nginxTransparentMode' => 'Processamento inteligente de ficheiros estáticos',
    'apache-settings.nginxTransparentModeDescription' => 'Se desligado, Apache processará todas as requisições para ficheiros estáticos. nginx só passará requisições e respostas sem alteração. Desligue essa opção apenas para resolução de problemas.',
    'apache-settings.nginxServeStatic' => 'Servir ficheiros estáticos diretamente pelo nginx',
    'apache-settings.nginxStaticExtensionsLabel' => 'Especifique as extensões dos ficheiros ',
    'apache-settings.nginxStaticExtensions' => 'Especifique extensões de ficheiros separados por espaços ou pelo símbolo "|". Requisições para estes ficheiros serão manipulados por nginx e nunca alcançarão Apache. Cuidado: As regras de reescrita do Apache não serão aplicadas.',
    'apache-settings.nginxServePhp' => 'Processar PHP pelo nginx',
    'apache-settings.nginxServePhpDescription' => 'Ficheiros PHP (.php) serão manipulados por nginx  e PHP-FPM. Se desligado, os ficheiros PHP serão processados por Apache.',
    'apache-settings.nginxClientMaxBodySize' => 'Tamanho máximo permitido para o corpo do pedido de HTTP',
    'apache-settings.nginxClientMaxBodySizeDescription' => 'Os pedidos com corpo acima do limite serão eliminados com HTTP 413 Payload Too Large (configura o valor da diretiva nginx "client_max_body_size").',
    'apache-settings.nginxClientMaxBodySizeDisabled' => 'A opção é desativada globalmente através de um valor vazio/zero da diretiva "clientMaxBodySize" em panel.ini',
    'apache-settings.nginxCacheEnabled' => 'Ativar a cache do nginx',
    'apache-settings.nginxCacheEnabledDescription' => 'A cache pode reduzir o tempo de resposta do website e a carga do servidor, mas deve ser utilizado com cuidado.',
    'apache-settings.nginxCacheSize' => 'Tamanho da memória cache',
    'apache-settings.nginxCacheSizeGb' => 'GB',
    'apache-settings.nginxCacheSizeMb' => 'MB',
    'apache-settings.nginxCacheSizeKb' => 'KB',
    'apache-settings.nginxCacheSizeBytes' => 'B',
    'apache-settings.nginxCacheTimeout' => 'Tempo limite da cache',
    'apache-settings.nginxCacheTimeoutDays' => 'dias',
    'apache-settings.nginxCacheTimeoutHours' => 'horas',
    'apache-settings.nginxCacheTimeoutMinutes' => 'minutos',
    'apache-settings.nginxCacheTimeoutSeconds' => 'segundos',
    'apache-settings.nginxCacheKey' => 'Chave da cache',
    'apache-settings.nginxCacheCookies' => 'Pedidos de cache com cookies',
    'apache-settings.nginxCacheBypassLocations' => 'Desativar armazenamento em cache para locais',
    'apache-settings.nginxCacheBypass' => 'Ignorar cache quando',
    'apache-settings.nginxCacheBypassHeaderNocache' => 'Os cabeçalhos nocache HTTP são recebidos no pedido',
    'apache-settings.nginxCacheBypassHeaderAuth' => 'Os cabeçalhos de autorização HTTP são recebidos no pedido',
    'apache-settings.nginxCacheBypassGetNocache' => 'O parâmetro GET nocache é recebido no pedido',
    'apache-settings.nginxCacheUseStale' => 'Devolver registos obsoletos em cache',
    'apache-settings.nginxCacheUseStale5xx' => 'Upstream devolve o erro do servidor 5xx',
    'apache-settings.nginxCacheUseStale4xx' => 'Upstream devolve o erro do cliente 4xx',
    'apache-settings.nginxCacheUseStaleUpdating' => 'A cache está a ser atualizada',
    'apache-settings.additional' => 'Diretivas adicionais de Apache',
    'apache-settings.additionalSettingsDescription' => 'Se não encontrar determinadas configurações, adicione-as nos campos abaixo. Estas configurações anularão as diretivas de Apache do servidor. As diretivas do primeiro campo são utilizadas quando um visitante acede ao site via HTTP. O segundo campo contém as diretivas para HTTPS. Geralmente, deve-se adicionar suas diretivas em ambos os campos. Utilize a mesma sintaxe usada para httpd.include. Por exemplo, se quiser definir uma página personalizada de erro, adicione a linha: ErrorDocument 401 /my_error_page.html',
    'apache-settings.additionalSettings' => 'Diretivas adicionais para HTTP',
    'apache-settings.additionalSslSettings' => 'Diretivas adicionais para HTTPS',
    'apache-settings.additionalSettingsError' => 'Configuração inválida de Apache: %%error%%',
    'apache-settings.rollbackFailed' => 'Impossível utilizar o ficheiro atual de configuração Apache e voltar à versão anterior do ficheiro, porque ambos têm uma configuração inválida.',
    'apache-settings.additionalNginx' => 'Diretivas adicionais de nginx',
    'apache-settings.additionalNginxSettingsDescription' => 'Aqui, pode especificar as configurações para o servidor proxy reverso com nginx que é executado à frente ao Apache. As suas diretivas anularão a configuração de nginx do servidor. Por exemplo, pode querer alterar o tempo de ócio da ligação ou fazer pacotes de requisições com gzip. Utilize a mesma sintaxe usada para nginx.conf. Por exemplo, se quiser fazer um pacote com todas as requisições de proxy com gzip, adicione a linha: \'gzip_proxied any;\'.',
    'apache-settings.additionalNginxSettings' => 'Diretivas adicionais de nginx',
    'apache-settings.additionalNginxSettingsError' => 'Configuração inválida de nginx: %%error%%',
    'apache-settings.nginxRollbackFailed' => 'Impossível utilizar o ficheiro atual de configuração nginx e voltar à versão anterior do ficheiro, porque ambos têm uma configuração inválida.',
    'apache-settings.clearCache' => 'Limpe a cache',
    'apache-settings.clearCacheHint' => 'Limpar cache nginx para %%website%%',
    'apache-settings.cacheHasClearedSuccessfuly' => 'A cache foi limpa com sucesso',

    'backup.backup-password-protection.securitySettingsSection' => 'Definições de segurança da cópia de segurança',
    'backup.backup-password-protection.backupPasswordFromFtpSettings' => 'Obter palavra-passe a partir de configurações de armazenamento remoto',
    'backup.backup-password-protection.backupPasswordManualInput' => 'Insira a senha manualmente',
    'backup.backup-password-protection.providePasswordCheckbox' => 'Fornecer senha',
    'backup.backup-password-protection.backupPassword' => 'Senha',
    'backup.backup-password-protection.inputPasswordType' => 'Tipo de senha',
    'backup.backup-password-protection.confirmBackupPassword' => 'Repetir a senha',
    'backup.backup-password-protection.backupPasswordHint' => 'Se tiver esquecido a sua senha, não selecione essa opção. Note que neste caso alguns dados sensíveis não serão devidamente repostos. Por exemplo, senhas de utilizadores serão substituídas por senhas aleatórias, informações sobre aplicações APS já instaladas serão perdidas, etc.',
    'backup.backup-password-protection.backupPasswordFtpHint' => 'Se utilizou a proteção de senha para esta cópia de segurança, insira a senha nos campos abaixo. Note que se fornecer uma senha incorreta, o Plesk não irá repor a cópia de segurança. Ao invés disso, a cópia de segurança será copiada para armazenamento local.',

    'backup.conflict-database.dbMappingLegend' => 'Mapeamento dos servidores da base de dados',
    'backup.conflict-database.serverType' => 'Tipo de servidor',
    'backup.conflict-database.hostName' => 'Nome de Host',
    'backup.conflict-database.port' => 'Porta',
    'backup.conflict-database.destinationDbServer' => 'Servidor da base de dados de destino',
    'backup.conflict-database.mysql' => 'MariaDB/MySQL',
    'backup.conflict-database.postgresql' => 'PostgreSQL',
    'backup.conflict-database.mssql' => 'MSSQL',
    'backup.conflict-database.migrationDbServerNotFind' => 'A base de dados não pode ser reposta: Não existe um servidor de base de dados apropriado.',

    'backup.conflict-ip.buttonUploadMappingFile' => 'Carregar Ficheiro de Mapeamento de IP',
    'backup.conflict-ip.ipMappingLegend' => 'Mapeamento de IP',
    'backup.conflict-ip.buttonSaveCurrentMapping' => 'Salvar o Mapeamento IP Atual para um Ficheiro',
    'backup.conflict-ip.ipAddressNotFound' => 'Não estão disponíveis endereços IP livres deste tipo.',
    'backup.conflict-ip.sharedIp' => 'partilhado',
    'backup.conflict-ip.dedicatedIp' => 'dedicado',
    'backup.conflict-ip.fileNotFound' => 'O ficheiro não deve estar vazio.',
    'backup.conflict-ip.invalidIpToMap' => 'Um valor inválido para um antigo endereço de IP: %%ip%%',
    'backup.conflict-ip.invalidMappingValue' => 'Um valor inválido para um novo endereço de IP: %%ip%%',
    'backup.conflict-ip.ipNotFound' => 'O endereço de IP %%ip%% não foi encontrado na base de dados.',
    'backup.conflict-ip.uploadIpMappingFileLegend' => 'Efetuar carregamento de um ficheiro de mapeamento de IP',
    'backup.conflict-ip.ipMappingFileHint' => 'Um ficheiro de mapeamento de IP é um ficheiro de texto simples. Cada linha deste ficheiro contém o mapeamento de ip no formato: <old IP address> <new IP address>',
    'backup.conflict-ip.oldIp' => 'Antigos endereços IP',
    'backup.conflict-ip.newIp' => 'Novos endereços IP',

    'backup.copy-to-server.ignoreBackupSign' => 'Carregar ficheiros de cópia de segurança sem uma assinatura válida.',
    'backup.copy-to-server.wrongPassword' => 'A senha especificada está incorreta. Durante o restauro da cópia de segurança, o Plesk solicitará que insira novamente a senha.',
    'backup.copy-to-server.corruptedSignatureUploaded' => 'O ficheiro de cópia de segurança carregado %%fileName%% foi alterado, danificado, criado noutro servidor ou numa versão mais antiga do Plesk que não suporta a assinatura de cópias de segurança.Antes de restaurar os dados a partir deste ficheiro de cópia de segurança, certifique-se de que pode confiar na origem deste ficheiro.',
    'backup.copy-to-server.corruptedSignatureNotUploadedUser' => 'Não foi possível efetuar o carregamento do ficheiro de cópia de segurança %%fileName%%. O ficheiro contém dados alterados ou corrompidos, ou foi criado num outro servidor ou numa versão antiga do Plesk. Para repor os dados deste ficheiro, contacte o seu fornecedor de serviços.',
    'backup.copy-to-server.corruptedSignatureNotUploadedAdmin' => 'Impossível enviar o ficheiro de cópia de segurança %%fileName%%. O arquivo foi modificado, corrompido, criado em outro servidor ou em uma versão antiga do Plesk que não suporta backups. Se o arquivo for confiável, selecione a opção "Enviar ficheiros de cópias de segurança sem assinaturas válidas" e repita o procedimento.',
    'backup.copy-to-server.unableToMoveToLocalRepository' => "Impossível mover o cópia de segurança selecionado %%fileName%% ao armazenamento do servidor. Erro: %%error%%.",
    'backup.copy-to-server.missedPartsWarning' => "As seguintes partes da cópia de segurança incremental não foram copiadas:%%endl%%%%missedParts%%%%endl%%Copie as partes em falta.",

    'backup.ftp-settings.isActive' => 'Utilizar armazenamento FTP(S)',
    'backup.ftp-settings.host' => 'IP ou nome do servidor de FTP',
    'backup.ftp-settings.directory' => 'Diretório para armazenamento de ficheiros de cópia de segurança',
    'backup.ftp-settings.directoryHint' => 'Por exemplo, /myfolder/mybackups/',
    'backup.ftp-settings.ftpLogin' => 'Nome de utilizador de FTP',
    'backup.ftp-settings.ftpPassword' => 'Senha de FTP',
    'backup.ftp-settings.usePassiveMode' => 'Utilizar modo passivo',
    'backup.ftp-settings.useFtps' => 'Utilizar FTPS',
    'backup.ftp-settings.errorHostIsLocal' => 'A utilização do servidor de FTP local do Plesk como um armazenamento remoto é proibida. Por favor, introduza uma localização remota.',
    'backup.ftp-settings.warningHostIsLocal' => 'As configurações de armazenamento FTP (S) foram realizadas para armazenar cópias de segurança no servidor onde os ficheiros de subscrição estão localizados. Tal configuração não é recomendada devido ao risco de perda de dados e sobreutilização de espaço do disco.',
    'backup.ftp-settings.enterFtpLogin' => 'Introduza um nome de utilizador correto.',
    'backup.ftp-settings.enterFtpPassword' => 'Introduza uma palavra-passe correta.',

    'backup.remote-settings.isActive' => 'Utilizar armazenamento',
    'backup.remote-settings.initError' => 'Impossível inicializar a página de configurações %%extName%%: %%error%%',

    'backup.remote-storages.backupSecuritySettings' => 'Configurações de segurança de cópia de segurança',

    'backup.restore.detailsSection' => 'Detalhes',
    'backup.restore.contentInfoSection' => 'Conteúdo da cópia de segurança',
    'backup.restore.restorationOptionsSection' => 'Opções de reposição',
    'backup.restore.emailNotification' => 'Quando o restauro estiver concluido, enviar uma notificação para',
    'backup.restore.comments' => 'Comentários',
    'backup.restore.creationDate' => 'Data de criação',
    'backup.restore.systemNotes' => 'Notas de sistema',
    'backup.restore.ownerAdmin' => 'Criado pelo administrador.',
    'backup.restore.ownerReseller' => 'Criado por um revendedor.',
    'backup.restore.ownerCustomer' => 'Criado por um cliente.',
    'backup.restore.ownerServiceUser' => 'Criado por um utilizador adicional.',
    'backup.restore.partOfParentBackup' => 'Parte do %%type%% da cópia de segurança.',
    'backup.restore.server' => 'servidor',
    'backup.restore.reseller' => 'revendedor',
    'backup.restore.client' => 'cliente',
    'backup.restore.incremental' => 'Incremental.',
    'backup.restore.multiVolume' => 'Múltiplos volumes.',
    'backup.restore.backupSize' => 'Tamanho da cópia de segurança',
    'backup.restore.backupSizeFirstIncremental' => '%%this%% (esta adição) + %%base%% (cópia de segurança inicial) = %%total%%',
    'backup.restore.backupSizeIncremental' => '%%this%% (esta adição) + %%prev%% (adições anteriores) + %%base%% (cópia de segurança inicial) = %%total%%',
    'backup.restore.download' => 'Transferência',
    'backup.restore.downloadHint' => 'Efetuar a transferência do ficheiro de cópia de segurança para o seu computador local.',
    'backup.restore.downloadDisabled' => 'O download dos ficheiros de backup está temporariamente indisponível. Tente novamente mais tarde ou contacte o seu fornecedor de serviços.',
    'backup.restore.copy' => 'Copiar para armazenamento do servidor',
    'backup.restore.copyHint' => 'Copiar os ficheiros de cópia de segurança selecionados para armazenamento do servidor.',
    'backup.restore.contentInfo' => 'A cópia de segurança contém',
    'backup.restore.restoreButton' => 'repor',
    'backup.restore.mail' => 'E-mail',
    'backup.restore.domainConfiguration' => 'Configuração de domínio',
    'backup.restore.virtualHost' => 'Conteúdo do alojamento virtual',
    'backup.restore.database' => 'Bases de dados',
    'backup.restore.serverConfiguration' => 'Configurações do servidor',
    'backup.restore.serverConfigurationLicense' => 'Chave de licença',
    'backup.restore.serverPersonalConfiguration' => 'Configuração das contas de administrador',
    'backup.restore.serverPersonalDomains' => 'Domínios do administrador',
    'backup.restore.serverPersonalClients' => 'Clientes do administrador',
    'backup.restore.resellers' => 'Revendedores',
    'backup.restore.resellerPersonalConfiguration' => 'Configuração da conta de revendedor',
    'backup.restore.resellerPersonalDomains' => 'Domínios do revendedor',
    'backup.restore.resellerPersonalClients' => 'Clientes do revendedor',
    'backup.restore.clientPersonalConfiguration' => 'Configuração da conta do cliente',
    'backup.restore.clientPersonalDomains' => 'Domínios do cliente',
    'backup.restore.restoreModifiedSection' => 'Repor o ficheiro de cópia de segurança, apesar da assinatura corrompida.',
    'backup.restore.restoreModifiedDump' => 'repor esta cópia de segurança apesar de não ter uma assinatura válida',
    'backup.restore.resolutionPolicy' => 'Politica de resolução',
    'backup.restore.resolutionPolicyDescription' => 'Os conflitos de data ocorrem quando o objeto reposto já existe no sistema com data de modificação mais recente ou quando o objeto reposto não está presente no sistema.',
    'backup.restore.backupRestoreFtpWrongPassword' => 'A senha especificada está incorreta. O ficheiro de cópia de segurança será copiado para o armazenamento local do servidor.',
    'backup.restore.backupRestoreLocalWrongPassword' => 'Impossível repor a cópia de segurança. A senha especificada está incorreta.',
    'backup.restore.serverContentAndConfiguration' => 'Configuração do servidor e conteúdo',
    'backup.restore.serverConfigurationOnly' => 'Configuração do servidor',
    'backup.restore.resellerContentAndConfiguration' => 'Configuração da conta de revendedor e conteúdo',
    'backup.restore.resellerConfigurationOnly' => 'Configuração da conta de revendedor',
    'backup.restore.clientContentAndConfiguration' => 'Configuração da conta do cliente e conteúdo',
    'backup.restore.clientConfigurationOnly' => 'Configuração da conta do cliente',
    'backup.restore.domainContentAndConfiguration' => 'Configuração de domínio e conteúdo',
    'backup.restore.domainConfigurationOnly' => 'Configuração de domínio',
    'backup.restore.restoreType' => 'O que deseja repor?',
    'backup.restore.restoreTypeFull' => 'Todos os objetos (sistema completo)',
    'backup.restore.restoreTypeGranular' => 'Objetos selecionados',
    'backup.restore.restoreObjectType' => 'Tipo de objeto a ser reposto',
    'backup.restore.restoreObjectTypeSubscriptions' => 'Assinatura',
    'backup.restore.restoreObjectTypeCustomers' => 'Cliente',
    'backup.restore.restoreObjectTypeResellers' => 'Revendedor',
    'backup.restore.restoreObjectTypeMailUsers' => 'Conta de correio',
    'backup.restore.restoreObjectTypeDatabases' => 'Base de dados',
    'backup.restore.restoreObjectTypeCertificates' => 'Certificados SSL/TLS',
    'backup.restore.restoreObjectTypeSites' => 'Sites web',
    'backup.restore.restoreObjectTypeDnsZones' => 'Zona DNS',
    'backup.restore.restoreObjectTypeMailLists' => 'Listas de envio',
    'backup.restore.restoreObjectTypeWebContent' => 'Ficheiros de domínios',
    'backup.restore.restoreObjects' => '%%objectType%%',
    'backup.restore.restoreObjectsWebContent' => 'Ficheiros selecionados',
    'backup.restore.restoreSubscriptionLookup' => 'Assinatura',
    'backup.restore.restoreComponents' => 'Componentes a repor',
    'backup.restore.errorLog' => 'Registo de erros',
    'backup.restore.backupDetailsLogDoesntExist' => 'O registo da cópia de segurança não está disponível.',
    'backup.restore.dumpFailedSection' => 'Registo de erros',
    'backup.restore.dumpFailed' => 'Não é possível restaurar dados: O ficheiro de cópia de segurança é inválido.',
    'backup.restore.granularNotSupported' => 'Pode selecionar objetos a repor apenas quando estiver a restaurar a partir de cópias de segurança criadas no Plesk 12.0 ou superior.',
    'backup.restore.fullNotSupportedInResellerPowerUser' => 'O restauro de todos os dados das cópias de segurança não é suportado no painel Utilizador Avançado de revendedor Selecione os objetos a serem repostos. Pode mudar o seu painel de interface em %%interfaceLink%%',
    'backup.restore.interfaceLink' => 'Preferências da Interface',
    'backup.restore.contentRestoreType' => 'repor',
    'backup.restore.contentRestoreTypeSettingsOnly' => 'Somente configuração de objetos selecionados',
    'backup.restore.contentRestoreTypeFull' => 'Configuração e conteúdo os objetos selecionados',
    'backup.restore.errorWrongFormat' => 'A cópia de segurança não pode ser restaurada porque o seu ficheiro de configuração está danificado.',
    'backup.restore.errorContentError' => 'Nem todos os dados da cópia de segurança podem ser restaurados, pois a cópia de segurança contém erros de conteúdo.',
    'backup.restore.warningSignError' => 'Não é possível validar a assinatura da cópia de segurança. O ficheiro da cópia de segurança pode ter sido modificado, danificado, criado noutro servidor ou numa versão antiga do Plesk.',
    'backup.restore.warningSignErrorNotAdmin' => 'Esta cópia de segurança apenas pode ser recuperada pelo administrador Plesk.',
    'backup.restore.warningPartial' => "As seguintes partes da cópia de segurança incremental não foram encontradas:%%endl%%%%missedParts%%%%endl%%É possível que não sejam restaurados todos os ficheiros. Carregue as partes em falta e volte a tentar o restauro.",
    'backup.restore.errorPackedInvalid' => 'Não é possível restaurar a cópia de segurança. Os ficheiros da cópia de segurança podem ter sido modificados, danificados, criados numa versão anterior do Plesk ou poderão estar em falta.',
    'backup.restore.warningDeprecatedBackupVersion' => 'A cópia de segurança que está a tentar recuperar foi criada numa versão não suportada do Plesk e não pode ser recuperada. Use a extensão Plesk Migrator para transferir os seus dados a partir de versões antigas do Plesk.',
    'backup.restore.encryptionKeyError' => 'Palavras-passe de uma ou mais contas nesta cópia de segurança não puderam ser restauradas e serão repostas. Provavelmente, esta cópia de segurança foi criada e encriptada num servidor Plesk diferente com a sua própria chave de encriptação.',
    'backup.restore.errorCorruptedContent' => 'Não foi possível encontrar os seguintes ficheiros ou foram corrompidos: ',
    'backup.restore.statusSection' => 'Estado da cópia de segurança',
    'backup.restore.statusDetails' => 'Informações de estado',
    'backup.restore.restoreBlocked' => 'A cópia de segurança não pode ser recuperada.',
    'backup.restore.restoreBlockedDescription' => 'A cópia de segurança do tipo %%backupType%% não pode ser recuperada agora. Para a recuperar, entre como proprietário da cópia de segurança e clique neste nome de cópia de segurança no Gestor de Cópias de Segurança.',

    'backup.schedule.scheduleSection' => 'Agendar',
    'backup.schedule.backupEnable' => 'Ativar esta tarefa de cópia de segurança',
    'backup.schedule.backupPeriod' => 'Executar esta tarefa de cópia de segurança',
    'backup.schedule.on' => 'ligado',
    'backup.schedule.at' => 'em',
    'backup.schedule.every' => 'a cada',
    'backup.schedule.hours' => '{period, plural, one {hora} other {horas}}',
    'backup.schedule.retainHours' => 'horas',
    'backup.schedule.useIncremental' => 'Utilizar cópia de segurança incremental',
    'backup.schedule.useIncrementalDisableHint' => 'O conteúdo selecionado para cópia de segurança só permite a criação de uma cópia de segurança completa.',
    'backup.schedule.fullBackupPeriod' => 'Efetuar cópia de segurança completa',
    'backup.schedule.hourly' => 'Intervalo de horas',
    'backup.schedule.daily' => 'Diariamente',
    'backup.schedule.weekly' => 'Semanalmente',
    'backup.schedule.monthly' => 'Mensalmente',
    'backup.schedule.yearly' => 'Anual',
    'backup.schedule.days' => 'dias',
    'backup.schedule.weeks' => 'semanas',
    'backup.schedule.months' => 'meses',
    'backup.schedule.years' => 'anos',
    'backup.schedule.backupTimeDescription' => 'Fuso horário: %%timezone%%.',
    'backup.schedule.systemTimeZone' => 'Fuso horário do sistema padrão',
    'backup.schedule.first' => 'primeiro',
    'backup.schedule.last' => 'último',
    'backup.schedule.dayOfMonth' => 'dia',
    'backup.schedule.email' => 'Se ocorrerem erros durante a execução desta tarefa de cópia de segurança, enviar e-mail de notificação para',
    'backup.schedule.invalidFields' => 'Alguns campos estão vazios ou contêm valores inválidos: %%fields%%.',
    'backup.schedule.maxDumpFiles' => 'Número máximo de ficheiros de cópias de seguranças completas a armazenar (incluindo cópias de segurança programadas e manuais)',
    'backup.schedule.retainDumpFilesFor' => 'Manter cópia de segurança completa para',
    'backup.schedule.maxDumpFilesUnlimitedDescription' => 'Deixe este campo em branco se não pretende remover automaticamente cópias de segurança completas.',
    'backup.schedule.maxDumpFilesLimitedDescription' => 'O limite especificado pelo fornecedor de alojamento para o armazenamento do servidor é %%max%%.O seu limite para o mesmo deve ser menor ou igual a %%max%%.',
    'backup.schedule.retainLimitedDescription' => 'O limite especificado pelo fornecedor de alojamento para o armazenamento no servidor é {max, plural, one {# cópia de segurança completa} other {# cópias de segurança completas}} (incluindo todas as cópias de segurança agendadas e manuais).',
    'backup.schedule.backupToCloudIsNotAllowed' => 'O armazenamento de cópias de segurança agendadas de subscrição em armazenamento em nuvem é uma funcionalidade premium que pode ser adquirida na loja online do Plesk.',
    'backup.schedule.backupHourlyWarning' => 'Ativar as cópias de segurança de intervalo de horas poderá resultar num aumento do consumo dos recursos do servidor.',
    'backup.schedule.titleHourly' => 'Definições da cópia de segurança de intervalo de horas',
    'backup.schedule.titleDaily' => 'Definições da cópia de segurança diária',
    'backup.schedule.titleWeekly' => 'Definições da cópia de segurança semanal',
    'backup.schedule.titleMonthly' => 'Definições da cópia de segurança mensal',
    'backup.schedule.titleCustom' => 'Definições da cópia de segurança personalizada',

    'backup.secure-backup.hint' => 'Pode utilizar uma palavra-passe para encriptar as palavras-passe de utilizadores contidas na base de dados Plesk numa cópia de segurança. Tenha em atenção que restaurar uma cópia de segurança protegida por palavra-passe sem fornecer a palavra-passe fará com que o Plesk gere as palavras-passe dos utilizadores aleatoriamente.',
    'backup.secure-backup.hintAdmin' => 'Pode encriptar palavras-passe da base de dados Plesk contidas em cópias de segurança com a chave de encriptação Plesk ou com uma palavra-passe. A chave é única para cada instalação Plesk. As cópias de segurança encriptadas com a chave só podem ser restauradas na instalação Plesk em que foram criadas e não podem ser restauradas noutra instalação Plesk. Tenha em atenção que o Plesk não protege todos os dados sensíveis numa cópia de segurança. Recomendamos que armazene as cópias de segurança em armazenamento remoto na cloud e ative a encriptação da cópia de segurança no lado do armazenamento na cloud.',
    'backup.secure-backup.usePasswordProtection' => 'Utilizar proteção por palavra-passe (recomendado)',
    'backup.secure-backup.backupPasswordSource' => 'Tipo de senha',
    'backup.secure-backup.pleskKey' => 'Chave de encriptação da Plesk',
    'backup.secure-backup.userPassword' => 'Palavra-passe especificada',
    'backup.secure-backup.password' => 'Senha',
    'backup.secure-backup.passwordConfirmation' => 'Repetir a senha',

    'backup.subform.settingsSection' => 'Definições de cópia de segurança',
    'backup.subform.prefix' => 'Adicionar um prefixo ao nome da cópia de segurança',
    'backup.subform.comment' => 'Comentários',
    'backup.subform.splitSize' => 'Criar cópia de segurança com múltiplos volumes, tamanho do volume (MB)',
    'backup.subform.repository' => 'Armazenar em',
    'backup.subform.repositoryDescription' => 'As configurações de armazenamento FTP (S) não estão especificadas. %%configure%%',
    'backup.subform.localAndSpecialRepositoryBackup' => 'Tanto o armazenamento do servidor quanto o %%name%%',
    'backup.subform.remoteRepositoryOption' => 'Armazenamento remoto',
    'backup.subform.remoteRepository' => 'armazenamento remoto',
    'backup.subform.remoteRepositoryText' => 'Selecione o armazenamento remoto na nuvem',
    'backup.subform.configureRemoteRepositories' => 'Pode <a href="%%url%%">configurar o armazenamento remoto</a> para guardar as suas cópias de segurança na nuvem.',
    'backup.subform.configureFtpRepository' => 'Pode <a href="%%url%%">configurar o armazenamento em FTP</a> para guardar as suas cópias de segurança off-site.',
    'backup.subform.configureRemoteDesc' => '%%link%% para manter as suas cópias de segurança na nuvem.',
    'backup.subform.configureRemoteLink' => 'Configurar armazenamento remoto',
    'backup.subform.configureFtpDesc' => '%%link%% para manter as suas cópias de segurança off-site.',
    'backup.subform.configureFtpLink' => 'Configurar armazenamento em FTP',
    'backup.subform.repositoryConfigure' => 'Configurar',
    'backup.subform.email' => 'Ao terminar o processo de cópia de segurança, enviar e-mail de notificação para',
    'backup.subform.contentSection' => 'Conteúdo da cópia de segurança',
    'backup.subform.domainConfiguration' => 'Configuração',
    'backup.subform.domainConfigurationVhost' => 'Ficheiros e bases de dados do utilizador',
    'backup.subform.domainConfigurationFile' => 'Ficheiros do utilizador',
    'backup.subform.domainConfigurationDatabase' => 'Bases de dados',
    'backup.subform.domainConfigurationMail' => 'Mensagens de e-mail',
    'backup.subform.content' => 'Cópia de segurança',
    'backup.subform.backupAll' => 'Toda a configuração e conteúdo',
    'backup.subform.backupConfiguration' => 'Apenas configuração',
    'backup.subform.backupVhost' => 'Toda a configuração e conteúdo exceto mensagens de e-mail',
    'backup.subform.backupMailFile' => 'Toda a configuração e conteúdo exceto bases de dados do utilizador',
    'backup.subform.backupMailDatabase' => 'Toda a configuração e conteúdo exceto ficheiros do utilizador',
    'backup.subform.backupMail' => 'Apenas configuração e mensagens de e-mail',
    'backup.subform.backupDatabase' => 'Apenas configuração e bases de dados do utilizador',
    'backup.subform.backupFile' => 'Apenas configuração e ficheiros do utilizador',
    'backup.subform.mssqlNativeBackup' => 'Usar funcionalidade de cópia de segurança nativa MS SQL, se possível',
    'backup.subform.mssqlNativeBackupAdmin' => 'Usar funcionalidade de cópia de segurança nativa MS SQL (Para bases de dados remotas, certifique-se de que define as configurações do backup do servidor remoto MS SQL em Ferramentas e Configurações> Servidores da Base de Dados)',
    'backup.subform.localRepository' => 'Armazenamento de servidor',
    'backup.subform.localRepositoryPath' => 'Armazenamento de servidor em %%path%%',
    'backup.subform.backupNodeRepository' => '',
    'backup.subform.ftpRepository' => 'Armazenamento FTP(S) %%uri%% <a href="%%link%%">Alterar definições</a>',
    'backup.subform.ftpRepositoryText' => 'Armazenamento FTP(S) em %%uri%%',
    'backup.subform.type' => 'Tipo',
    'backup.subform.typeFullBackup' => 'Completo',
    'backup.subform.typeIncremental' => 'Incremental',
    'backup.subform.typeIncrementalDescription' => 'Os dados da cópia de segurança de alojamento de rede e de correio que foram alterados desde a última cópia de segurança (as base de dados são sempre copiados por inteiro)',
    'backup.subform.incrementalNotAvailable' => 'Para criar cópias de segurança incrementais, crie primeiro uma cópia de segurança completa.',
    'backup.subform.excludeLogs' => 'Eliminar ficheiros de registo',
    'backup.subform.excludeFiles' => 'Eliminar ficheiros específicos da cópia de segurança',
    'backup.subform.excludeFilesDescription' => 'Apenas pode excluir ficheiros em espaços de rede. Especifique o caminho ou caminhos relativos à raiz do espaço de rede, separando os ficheiros individuais com vírgulas. A utilização do símbolo de máscara é permitida (por ex.  /somedir/log*).',

    'backup.upload.uploadHint' => 'Aqui pode carregar os ficheiros de cópia de segurança para o armazenamento do Plesk. O tamanho máximo do ficheiro é limitado a dois gigabytes.',
    'backup.upload.backupFile' => 'Ficheiro de Cópia de segurança',
    'backup.upload.removeLink' => 'Eliminar',
    'backup.upload.addFileLink' => 'Efetuar carregamento de mais ficheiros',
    'backup.upload.backupSecuritySettings' => 'Definições de segurança da cópia de segurança',
    'backup.upload.signatureHint' => 'O Plesk verifica se a estrutura e assinatura dos ficheiros de cópia de segurança são válidas. Ficheiros alterados, corrompidos ou criados noutro servidor são suspeitos. A opção abaixo permite que restaure os dados desses ficheiros. Selecione esta opção apenas se confiar na origem da cópia de segurança, porque o carregamento desse ficheiro pode comprometer a segurança e interromper a operação do servidor. Observação: Ficheiros de cópia de segurança criados em versões do Plesk anteriores à 11.5 são considerados suspeitos por não terem assinaturas. Certifique-se que restaura estes ficheiros caso confie na sua origem.',
    'backup.upload.ignoreSign' => 'Carregar ficheiros de cópia de segurança sem uma assinatura válida.',
    'backup.upload.passwordHint' => 'Se utilizou a proteção de senha para esta cópia de segurança, insira a senha nos campos abaixo. Note que se fornecer uma senha incorreta, o Plesk o avisará, mas carregará a cópia de segurança para o servidor de qualquer forma. Durante o restauro da cópia de segurança será solicitado que insira novamente a senha.',
    'backup.upload.alreadyExistsWarning' => 'O ficheiro de cópia de segurança %%fileName%% já existe no local de armazenamento do servidor.',
    'backup.upload.incorrectPasswordWarning' => 'A senha especificada está incorreta. Durante o restauro da cópia de segurança, o Plesk solicitará que insira novamente a senha.',
    'backup.upload.deprecatedDumpError' => 'A cópia de segurança que está a tentar transferir foi criada numa versão não suportada do Plesk e não pode ser importada. Use a extensão Plesk Migrator para transferir os seus dados a partir de versões antigas do Plesk.',
    'backup.upload.mailFormatWarning' => 'O ficheiro de cópia de segurança %%fileName%% foi carregado com sucesso para armazenamento. Importante: O ficheiro de cópia de segurança %%fileName%% contém um conteúdo de e-mail que não será reposto porque seu formato (Plesk 8.3 - 8.6) não é suportado. Para poder repor este conteúdo de e-mail, faça a cópia de segurança usando a ferramenta Plesk Backup, selecione a opção Efetuar cópia de segurança do conteúdo de caixas de e-mail, e selecione a opção com restauro de ficheiro de restauro para qualquer servidor de e-mail.',
    'backup.upload.corruptedSignatureAdminWarning' => 'O ficheiro de cópia de segurança %%fileName%% carregado foi alterado, corrompido, criado noutro servidor ou numa versão antiga do Plesk que não suporta a assinatura de cópias de segurança. Antes de repor os dados deste ficheiro de cópia de segurança, certifique-se que pode confiar na origem deste ficheiro.',
    'backup.upload.corruptedSignatureAdminError' => '"Não foi possível efetuar o carregamento do ficheiro de cópia de segurança %%fileName%%. O ficheiro foi alterado, corrompido, criado noutro servidor ou numa versão antiga do Plesk que não suporta a assinatura de cópias de segurança. Se confiar nesta cópia de segurança, selecione a opção "Efetuar carregamento de ficheiros de cópia de segurança sem assinaturas válidas" e repita o processo de carregamento."',
    'backup.upload.corruptedSignatureUserWarning' => 'O ficheiro de cópia de segurança carregado (%%fileName%%) contém dados alterados ou corrompidos, ou foi criado noutro servidor ou numa versão antiga do Plesk.',
    'backup.upload.corruptedSignatureUserError' => 'Não foi possível efetuar o carregamento do ficheiro de cópia de segurança %%fileName%%. O ficheiro contém dados alterados ou corrompidos, ou foi criado noutro servidor ou numa versão antiga do Plesk. Para repor os dados deste ficheiro, contacte o seu fornecedor de serviços.',
    'backup.upload.uploadError' => 'Não foi possível carregar %%fileName%% no armazenamento do servidor: %%error%%',
    'backup.upload.fileNotSelected' => 'Nenhum ficheiro selecionado para carregamento. Selecionar pelo menos um ficheiro.',
    'backup.upload.missedPartsWarning' => "As seguintes partes da cópia de segurança incremental não foram carregadas:%%endl%%%%missedParts%%%%endl%%Carregue as partes em falta.",
    'backup.upload.unknownType' => 'Tipo de objeto desconhecido',
    'backup.upload.storageLink' => 'outro armazenamento',
    'backup.upload.anotherStorage' => 'A saída foi carregada em %%storageLink%%.',
    'backup.upload.resellerNotFound' => 'Revendedor %%name%% não encontrado. Crie-o em primeiro lugar para recuperar a saída carregada.',
    'backup.upload.clientNotFound' => 'Cliente %%name%% não encontrado. Crie-o em primeiro lugar para recuperar a saída carregada.',
    'backup.upload.domainNotFound' => 'Domínio %%name%% não encontrado. Crie-o em primeiro lugar para recuperar a saída carregada.',

    'backup.web-content-dynamic.addButtonTitle' => 'Adicionar Ficheiros',
    'backup.web-content-dynamic.noItems' => 'Nenhum ficheiro selecionado.',
    'backup.web-content-dynamic.hint' => 'Use as caixas de seleção para selecionar ficheiros e pastas.',
    'backup.web-content-dynamic.title' => 'Selecionar ficheiros',
    'backup.web-content-dynamic.columnName' => 'Nome',
    'backup.web-content-dynamic.columnChangeDate' => 'Alterado',
    'backup.web-content-dynamic.columnSize' => 'Dimensão',
    'backup.web-content-dynamic.columnPermissions' => 'Autorizações',
    'backup.web-content-dynamic.columnUser' => 'Utilizador',
    'backup.web-content-dynamic.columnGroup' => 'Grupo',
    'backup.web-content-dynamic.waitButtonTitle' => 'Por favor aguarde',
    'backup.web-content-dynamic.loadingTitle' => 'Por favor aguarde. A carregar...',

    'backup.invalidFields' => 'Alguns campos estão vazios ou contêm valores inválidos.',
    'backup.notEnoughDiskSpace' => 'O espaço em disco em %%path%% é insuficiente para fazer a cópia de segurança da criação. São necessários pelo menos %%required%% GB de espaço livre (%%available%% GB disponíveis)',

    'change-subscriptions-owner.ownerSection' => 'Novo proprietário',
    'change-subscriptions-owner.subscriptionsSection' => 'Subscrições selecionadas',
    'change-subscriptions-owner.owner' => 'Proprietário',
    'change-subscriptions-owner.subscriptionName' => 'Assinatura',
    'change-subscriptions-owner.ownerName' => 'Proprietário',
    'change-subscriptions-owner.currentIpAddress' => 'Endereço IP atual',
    'change-subscriptions-owner.newIpAddress' => 'Novos endereços IP',
    'change-subscriptions-owner.noIpAddress' => 'Nenhum endereço IP disponível',
    'change-subscriptions-owner.submit' => 'Reatribuir',
    'change-subscriptions-owner.warningCustom' => "A subscrição será desassociada do seu atual plano de serviços e tornar-se-á 'Personalizada'.",
    'change-subscriptions-owner.warningEmptyPool' => "O repositório de IP do fornecedor do novo proprietário está vazio. O fornecedor deve ter pelo menos um endereço IP no repositório.",

    'cgroups-settings.cgroupsSettingsTab' => 'RAM, CPU, E/S disco',
    'cgroups-settings.cgroupsSettingsTabDescription' => 'Definir limites ao consumo de recursos do sistema através de uma assinatura. O Plesk utiliza um recurso kernel Linux chamado controlo de grupos (cgroups) para garantir que os limites não são excedidos.',
    'cgroups-settings.cpuSettings' => 'CPU',
    'cgroups-settings.cpuSettingsDescription' => 'Limitar assinaturas individuais para a quantidade especificada de em utilização da CPU.',
    'cgroups-settings.cpuPeriodLimit' => 'Período para verificar a utilização da CPU',
    'cgroups-settings.percentUsageDescription' => 'A quantidade total de tempo de CPU é igual a %%total%%%%units%% para o seu servidor',
    'cgroups-settings.ramSettings' => 'RAM',
    'cgroups-settings.ramSettingsDescription' => 'Limitar assinaturas individuais para a quantidade especificada de utilização da RAM. Note que, se uma assinatura exceder tal limite, o processo que consome mais será interrompido.',
    'cgroups-settings.ramPeriodLimit' => 'Período para verificar a utilização da RAM',
    'cgroups-settings.diskSettings' => 'E/S disco',
    'cgroups-settings.diskReadSettings' => 'Leitura de disco',
    'cgroups-settings.diskReadSettingsDescription' => 'Permitir que as assinaturas individuais utilizem a largura de banda para leitura do disco unicamente dentro do limite especificado.',
    'cgroups-settings.diskReadPeriodLimit' => 'Período para verificar a utilização da leitura no disco',
    'cgroups-settings.diskWriteSettings' => 'Gravar no disco',
    'cgroups-settings.diskWriteSettingsDescription' => 'Permitir que as assinaturas individuais utilizem a largura de banda para gravação do disco unicamente dentro do limite especificado.',
    'cgroups-settings.diskWritePeriodLimit' => 'Período para verificar a utilização da gravação no disco',
    'cgroups-settings.limit' => 'Limite',
    'cgroups-settings.threshold' => 'Notificar quando excedido',
    'cgroups-settings.limitNotificationEnabled' => 'Notificação ativada',
    'cgroups-settings.periodFiveMinutes' => '5 minutos',
    'cgroups-settings.periodHour' => '1 hora',
    'cgroups-settings.periodDay' => '1 dia (24 horas)',
    'cgroups-settings.mb' => 'MB',
    'cgroups-settings.mbs' => 'MB/Seg',

    'custom-button.privateLabel' => 'Apresentar unicamente a mim',
    'custom-button.textLabel' => 'Etiqueta do botão',
    'custom-button.tooltipLabel' => 'Texto de conselho de ferramenta',
    'custom-button.iconLabel' => 'Imagem de fundo',
    'custom-button.priorityLabel' => 'Prioridade',
    'custom-button.urlLabel' => 'URL',
    'custom-button.urlParamsLabel' => 'Adicionar parâmetros para URL',
    'custom-button.placeLabel' => 'Localização',
    'custom-button.internalLabel' => 'Abrir a URL no Plesk',
    'custom-button.internalDescription' => 'Defina se deseja abrir o URL numa página Plesk ou numa nova janela do navegador.',
    'custom-button.noFrameLabel' => 'Não utilizar enquadramentos',
    'custom-button.noFrameDescription' => 'Se adicionar uma tecla personalizada que leve para uma extensão do Plesk ou uma aplicação no Painel de Cliente, pode definir de que forma esta extensão/aplicação deve ser apresentada: num quadro ou como parte do GUI do Plesk.',
    'custom-button.urlParamLabel_dom_id' => 'Incluir o ID da assinatura, o ID do domínio e o ID do nome alternativo do domínio',
    'custom-button.urlParamLabel_dom_name' => 'Incluir o nome de domínio principal',
    'custom-button.urlParamLabel_ftp_user' => 'Incluir o utilizador FTP',
    'custom-button.urlParamLabel_ftp_pass' => 'Incluir a palavra-passe FTP',
    'custom-button.urlParamLabel_cl_id' => 'Incluir ID do cliente',
    'custom-button.urlParamLabel_cname' => 'Incluir o nome da empresa do cliente',
    'custom-button.urlParamLabel_pname' => 'Incluir o nome de contacto do cliente',
    'custom-button.urlParamLabel_email' => 'Incluir e-mail do cliente',
    'custom-button.buttonPlace_navigation' => 'Acesso comum',
    'custom-button.buttonPlace_admin' => 'Página inicial do administrador',
    'custom-button.buttonPlace_admin-settings' => 'Página de ferramentas e configurações do administrador',
    'custom-button.buttonPlace_reseller' => "Página inicial do revendedor",
    'custom-button.buttonPlace_reseller-settings' => 'Página de ferramentas e configurações do revendedor',
    'custom-button.buttonPlace_client' => 'Página inicial do cliente',
    'custom-button.buttonPlace_domain' => "Página de Sites Web & Domínios da Assinatura",
    'custom-button.buttonPlace_domain_powerUser' => "Página de Sites Web & Domínios do espaço na rede",
    'custom-button.buttonPlace_domain-properties' => 'Ferramentas do website',
    'custom-button.fileNotUploaded' => 'O ficheiro não pode ser carregado.',

    'database-server-change-password.adminPassword' => 'Senha do administrador',
    'database-server-change-password.success' => 'A palavra-passe do administrador foi atualizada com sucesso.',

    'database-server-create.general' => 'Geral',
    'database-server-create.type' => 'Tipo de servidor de base de dados',
    'database-server-create.unixSocket' => '(conexão local)',
    'database-server-create.host' => 'Nome de Host ou endereço IP',
    'database-server-create.port' => 'Número da porta',
    'database-server-create.portDescription' => 'Deixe em branco para o numero de porta predefinido',
    'database-server-create.version' => 'Versão do servidor da base de dados',
    'database-server-create.default' => 'Utilizar este servidor como predefinido para %%type%%',
    'database-server-create.externalConnections' => 'Permitir que o servidor MariaDB/MySQL local aceite ligações externas',
    'database-server-create.externalConnectionsDescription' => 'A alteração desta configuração resultará na reinicialização do servidor MariaDB/MySQL local. Para ativar o acesso remoto a outros servidores MariaDB/MySQL registados no Plesk, altere a sua configuração manualmente.',
    'database-server-create.authentication' => 'Autenticação',
    'database-server-create.authenticationAddDescription' => 'Especificar as credenciais do administrador da base de dados a ser utilizada pelo Plesk para aceder ao servidor da base de dados. Uma conta de administrador com estas credenciais deve existir no servidor da base de dados.',
    'database-server-create.authenticationEditDescription' => 'Aqui pode alterar as credenciais que o Plesk utiliza para aceder ao servidor da base de dados. Estas credenciais devem corresponder às credenciais do administrador da base de dados. Por exemplo, depois de alterar as credenciais do administrador no servidor da base de dados, é também necessário alterá-las no Plesk.',
    'database-server-create.authenticationChangeDescription' => 'Aqui pode alterar as credenciais que o Plesk utiliza para aceder ao servidor da base de dados. Caso altere o nome de utilizador ou a senha abaixo, a conta do utilizador da base de dados com direitos de administrador será atualizada no servidor da base de dados e no Plesk.',
    'database-server-create.adminLogin' => 'Nome de utilizador',
    'database-server-create.adminPassword' => 'Senha',
    'database-server-create.createSuccess' => 'O servidor da base de dados foi criado com sucesso.',
    'database-server-create.createError' => 'O servidor da base de dados foi criado com erro: %%error%%',
    'database-server-create.updateSuccess' => 'O servidor da base de dados foi atualizado com sucesso.',
    'database-server-create.updateError' => 'O servidor da base de dados foi atualizado com erro: %%error%%.',
    'database-server-create.backupSettings' => 'Backup',
    'database-server-create.backupTempDir' => 'Diretório temporário',
    'database-server-create.backupTempDirDescription' => 'O caminho até à pasta física no servidor remoto onde se encontra o servidor MS SQL. O servidor MS SQL deve ser capaz de aceder a esta pasta para ler e escrever ficheiros temporários de cópias de segurança. Por exemplo, C:\\DirectoryPath',
    'database-server-create.backupNetworkTempDir' => 'Directório temporário da rede',
    'database-server-create.backupNetworkTempDirDescription' => 'O caminho para a partilha de rede mapeou para a pasta física especificado acima. Plesk irá aceder à pasta partilhada para descarregar e carregar ficheiros de cópias de segurança. Por exemplo, \\\\ServerName\\DirectoryPath',
    'database-server-create.backupNetworkUser' => 'Nome de utilizador',
    'database-server-create.backupNetworkUserDescription' => 'O nome de utilizador de um utilizador da rede no servidor remoto. Por exemplo, ServerName\UserName. O utilizador deve ter acesso à pasta partilhada especificada acima.',
    'database-server-create.backupNetworkPassword' => 'Senha',

    'domain.connection-info.title' => 'Informações da ligação',
    'domain.connection-info.systemUserCredentials' => 'Credenciais de sistema do utilizador',
    'domain.connection-info.systemUserCredentialsHint' => 'O acesso através de FTP está sempre ativo; acesso através do SSH ou do Remote Desktop — apenas se %%details%%.',
    'domain.connection-info.systemUserCredentialsHintDetails' => 'a permissão foi concedida',
    'domain.connection-info.systemUserRemoveAccessEnabled' => 'O seu acesso através do SSH ou do Remote Desktop está ativo e não pode gerir o seu estado.',
    'domain.connection-info.systemUserRemoveAccessDisabled' => 'O seu acesso através do SSH ou do Remote Desktop está desativado e não pode gerir o seu estado.',
    'domain.connection-info.ipAddress' => 'Endereço IP',
    'domain.connection-info.copyIpAddressTooltip' => 'Copiar endereço IP para a área de transferência',
    'domain.connection-info.username' => 'Nome de utilizador',
    'domain.connection-info.copyUsernameTooltip' => 'Copiar nome do utilizador para a área de transferência',
    'domain.connection-info.password' => 'Senha',
    'domain.connection-info.changeSystemUserPasswordTitle' => 'Alteração de palavra-passe de utilizador do sistema',
    'domain.connection-info.changePasswordTooltip' => 'Alterar senha',
    'domain.connection-info.newPassword' => 'Nova palavra-passe',
    'domain.connection-info.manageAccess' => 'Gerir o acesso',
    'domain.connection-info.additionalFtpAccounts' => 'Contas FTP adicionais',
    'domain.connection-info.database' => 'Base de dados',
    'domain.connection-info.databaseHint' => '1 de %%number%% bases de dados que pertencem à subscrição.',
    'domain.connection-info.databaseNotCreatedHint' => 'A base de dados não foi criada.',
    'domain.connection-info.databaseType.mysql' => 'MySQL',
    'domain.connection-info.databaseType.mssql' => 'Servidor MS SQL',
    'domain.connection-info.databaseType.postgresql' => 'PostgreSQL',
    'domain.connection-info.databaseType.mariadb' => 'MariaDB',
    'domain.connection-info.databaseType.percona' => 'Percona',
    'domain.connection-info.databaseHost' => 'Sistema anfitrião',
    'domain.connection-info.databaseHostValue' => '%%value%% (%%fork%%)',
    'domain.connection-info.databaseName' => 'Nome da base de dados',
    'domain.connection-info.addDatabase' => 'Adicionar base de dados',
    'domain.connection-info.manageDatabases' => 'Gerir bases de dados',
    'domain.connection-info.phpMyAdmin' => 'phpMyAdmin',
    'domain.connection-info.changeDatabaseUserPasswordTitle' => 'Alteração da palavra-passe do utilizador de base de dados',
    'domain.connection-info.changeDatabaseUserPasswordNotice' => 'Não se esqueça de atualizar a palavra-passe nos ficheiros de configuração da sua aplicação após alterá-la aqui.',
    'domain.connection-info.buttonSave' => 'Gravar',
    'domain.connection-info.buttonSaving' => 'A guardar...',
    'domain.connection-info.buttonCancel' => 'Cancelar',
    'domain.connection-info.copyHostTooltip' => 'Copiar nome do anfitrião para a área de transferência',
    'domain.connection-info.copyDatabaseNameTooltip' => 'Copiar nome da base de dados para a área de transferência',
    'domain.connection-info.copyDatabaseUserTooltip' => 'Copiar utilizador da base de dados para a área de transferência',

    'domain.move.title' => 'Mover domínio %%name%%',
    'domain.move.hint' => 'O domínio será movido para uma nova assinatura com o seu conteúdo, ficheiros de configuração, ficheiros de registo e aplicações APS.',
    'domain.move.hintMain' => 'O domínio será movido para uma nova assinatura com o seu conteúdo, ficheiros de configuração, ficheiros de registo, bases de dados, utilizadores de bases de dados, utilizadores FTP adicionais, tarefas agendadas, utilizadores smb e aplicações APS.',
    'domain.move.hintSubdomains' => 'O(s) subdomínio(s) %%subdomains%% será movido junto com o domínio principal.',
    'domain.move.hintAliases' => 'O(s) pseudónimo(s) do domínio %%aliases%% será movido junto com o domínio principal.',
    'domain.move.hintSubdomainsAndAliases' => 'O(s) subdomínio(s) %%subdomains%% e o(s) pseudónimo(s) de domínio %%aliases%% serão movidos em conjunto com o domínio principal.',
    'domain.move.labelDatabases' => 'Depois de ter movido o domínio, abra o separador "Bases de dados" para mover as bases de dados associadas.',
    'domain.move.hintDatabases' => 'Se necessário, mova as bases de dados separadamente.',

    'domain.move.Form.submitButton' => 'Mover',
    'domain.move.Form.cancelButton' => 'Cancelar',

    'domain.move.selectTarget' => 'Assinaturas disponíveis',
    'domain.move.nothingFound' => 'Nada encontrado',
    'domain.move.targetIsRequred' => 'Selecione a assinatura para onde mover o domínio.',
    'domain.move.selectNewSubscription' => 'Criar uma nova assinatura',
    'domain.move.ipv4Address' => 'Endereço IPv4',
    'domain.move.ipv4AddressHint' => 'O endereço IP no qual o site está hospedado é um endereço de rede do site anfitrião virtual.',
    'domain.move.ipv6Address' => 'Endereço IPv6',
    'domain.move.ipv6AddressHint' => 'O endereço IP no qual o site está hospedado é um endereço de rede do site anfitrião virtual.',
    'domain.move.ipAddressIsNotSelected' => 'Pelo menos um endereço IP deve ser selecionado.',
    'domain.move.username' => 'Nome de utilizador',
    'domain.move.usernameHint' => 'A conta de utilizador do sistema associada à Internet. Utilizado para aceder aos ficheiros alojados por via FTP e SSH.',
    'domain.move.usernameIsRequred' => 'Deve fornecer um nome de utilizador.',
    'domain.move.password' => 'Palavra-passe',
    'domain.move.passwordIsRequred' => 'Deve fornecer uma palavra-passe.',
    'domain.move.noAvailableSubscriptions' => 'Nenhuma assinatura disponível',
    'domain.move.noWebHosting' => 'Nesta altura, não será criado qualquer utilizador do sistema porque o domínio não possui alojamento de rede.',

    'domain.rename.title' => 'Mudar nome do domínio',
    'domain.rename.titleAlias' => 'Mudar nome alternativo do domínio',
    'domain.rename.hint' => 'Está a mudar o nome do domínio %%domainName%%',
    'domain.rename.hintAlias' => 'Está a mudar o nome alternativo do domínio %%domainName%%',
    'domain.rename.name' => 'Novo nome do domínio',
    'domain.rename.nameAlias' => 'Novo nome alternativo do domínio',
    'domain.rename.domainNameIsRequired' => 'Este campo necessário está vazio. É necessário especificar um valor.',
    'domain.rename.submitButton' => 'Alterar',
    'domain.rename.submitButtonProgress' => 'A mudar',
    'domain.rename.successMessage' => 'O nome do domínio %%oldName%% foi alterado para %%newName%%.',
    'domain.rename.successMessageAlias' => 'O nome alternativo do domínio %%oldName%% foi alterado para %%newName%%.',

    'domain.rename.Form.cancelButton' => 'Cancelar',

    'domain.outgoing-messages.hint' => 'Aqui pode mudar o limite de envio de mensagens para este domínio. Não será possível enviar mais mensagens que o limite especificado.',
    'domain.outgoing-messages.domainOutgoingMessagesSubscriptionDefault' => 'Padrão (%%domainOutgoingMessages%% mensagens por hora)',
    'domain.outgoing-messages.domainOutgoingMessagesSpecificHint' => 'mensagens por hora',
    'domain.outgoing-messages.domainOutgoingMessages' => 'Limite para o envio de mensagens',
    'domain.outgoing-messages.domainOutgoingMessagesCustomLimit' => 'Valor personalizado para este domínio',

    'domain.tech-domain-name.title' => 'Selecione o seu nome de domínio',
    'domain.tech-domain-name.techDomainTitle' => 'Nome de domínio temporário',
    'domain.tech-domain-name.customDomainTitle' => 'Nome de domínio registado',
    'domain.tech-domain-name.techDomainText' => 'Ainda não possuo um nome de domínio registado',
    'domain.tech-domain-name.customDomainText' => 'Já possuo um nome de domínio registado',
    'domain.tech-domain-name.techDomain' => 'O seu nome de domínio temporário',
    'domain.tech-domain-name.customDomain' => 'Nome de domínio registado',
    'domain.tech-domain-name.domainName' => 'Nome de domínio',
    'domain.tech-domain-name.techDomainDesc' => 'Os nomes de domínio temporários são usados para aceder ao seu site antes de registar e comprar um nome de domínio. São fornecidos gratuitamente, mediante as seguintes condições:',
    'domain.tech-domain-name.techDomainRandom' => 'Os nomes são gerados aleatoriamente',
    'domain.tech-domain-name.techDomainDns' => 'São abrigados na zona DNS .plesk.page',
    'domain.tech-domain-name.techDomainSwitch' => 'Pode passar para um nome de domínio registado a qualquer altura mudando o nome do seu domínio nas definições do domínio.',
    'domain.tech-domain-name.error' => 'Ocorreu um erro inesperado.',
    'domain.tech-domain-name.errorNoIpAddress' => 'Tem de selecionar o endereço IP.',
    'domain.tech-domain-name.generating' => 'A gerar...',

    'get-password.label' => 'Repor a palavra-passe',
    'get-password.text' => 'Introduza o seu endereço de e-mail ou o nome de utilizador registado no Plesk e enviar-lhe-emos um e-mail de redefinição de palavra-passe.',
    'get-password.emailLabel' => 'Endereço de e-mail',
    'get-password.loginLabel' => 'Nome de utilizador',
    'get-password.send' => 'Enviar',
    'get-password.cancel' => 'Cancelar',
    'get-password.errorInvalidEmail' => 'O endereço de email não foi reconhecido. Verifique e tente novamente.',
    'get-password.messageSend' => "O e-mail para redefinir a palavra-passe foi enviado para o endereço de e-mail associado.\nSe não receber o e-mail, contacte o seu administrador do Plesk.",
    'get-password.rateLimitReached' => "Demasiadas tentativas de repor a palavra-passe. Volte a tentar mais tarde.",
    'iis-settings.formGeneralHint' => 'Aqui você pode especificar as configurações de servidor web de IIS para seu site web, alterando os valores predefinidos. Por exemplo, a configuração personalizada do IIS é útil quando quiser utilizar um novo tipo de ficheiros de índice na sua página web, ou associar um determinado tipo MIME a determinadas extensões de nome de ficheiro. Os valores predefinidos são definidos por seu fornecedor.',
    'iis-settings.formGeneralHint_powerUser' => 'Aqui você pode especificar as configurações do servidor web do IIS para este site web. Por exemplo, a configuração personalizada do IIS é útil quando quiser utilizar um novo tipo de ficheiros de índice na sua página web, ou associar um determinado tipo MIME a determinadas extensões de nome de ficheiro. Valores predefinidos significam que o IIS irá utilizar as diretivas correspondentes da sua configuração predefinida.',
    'iis-settings.virtualDirectoryLoadError' => 'Impossível conseguir as propriedades do diretório virtual específico: %%errorMessage%%',
    'iis-settings.general' => 'Configurações comuns',
    'iis-settings.example' => "Por exemplo:\n%%example%%",
    'iis-settings.settingOn' => 'Ligado',
    'iis-settings.settingOff' => 'Desligado (Predefinido)',
    'iis-settings.settingDefault' => 'Predefinido',
    'iis-settings.settingCustom' => 'Insira o valor personalizado',
    'iis-settings.mimeTypes' => 'Tipos MIME',
    'iis-settings.mimeTypesExample' => "text/plain .mytxt\nimage/jpeg .myjpeg",
    'iis-settings.mimeTypesFullDescription' => 'Tipos MIME associam extensões de ficheiros a tipos de ficheiros. Tipicamente, isso é utilizado para criar uma extensão personalizada de ficheiro para tipos comuns de ficheiros.',
    'iis-settings.documents' => 'Documentos predefinidos',
    'iis-settings.documentsOff' => 'Desativado',
    'iis-settings.documentsCustom' => 'Inserir valores',
    'iis-settings.documentsExample' => "Index.html\nIndex.htm\nIndex.cfm",
    'iis-settings.documentsFullDescription' => 'Quando os browsers não facultam o nome de um documento dentro do seu site, IIS irá procurar os documentos predefinidos especificados e servirá o primeiro que encontrar. Se não especificar os documentos predefinidos, mas ligar o browsing de Diretório, será apresentada no browser a listagem de diretórios em vez da página de índice.',
    'iis-settings.expires' => 'Validade',
    'iis-settings.expiresFullDescription' => 'O servidor de rede adicionará os cabeçalhos de resposta "Caduca" às páginas de rede.O carimbo de data/hora de caducidade é obtido adicionando o tempo especificado acima à hora de pedido de uma página de rede.',
    'iis-settings.expiresUnitDays' => 'dias',
    'iis-settings.expiresUnitHours' => 'horas',
    'iis-settings.expiresUnitMinutes' => 'minutos',
    'iis-settings.expiresUnitSeconds' => 'segundos',
    'iis-settings.headers' => 'Cabeçalhos adicionais',
    'iis-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000; includeSubdomains;\nX-Frame-Options: DENY",
    'iis-settings.headersFullDescription' => 'O servidor web adicionará os cabeçalhos de resposta HTTP especificados.',
    'iis-settings.directoryBrowsing' => 'Browsing do Diretório',
    'iis-settings.directoryBrowsingDescription' => 'Permite que utilizadores vejam a listagem de diretórios do site nos browsers, por exemplo, quando a página de índice predefinida não estiver disponível.',
    'iis-settings.securityTabDirectory' => 'Configurações de segurança de diretório',
    'iis-settings.allowAnonymous' => 'Acesso anónimo',
    'iis-settings.allowAnonymousDescription' => 'O acesso anónimo permite a utilizadores aceder ao conteúdo público do seu site. O conteúdo protegido por senha do seu site e o conteúdo protegido num nível de sistema de ficheiros não estarão disponíveis a utilizadores anónimos.',
    'iis-settings.allowWindows' => 'Autenticação do Windows',
    'iis-settings.allowWindowsDescription' => 'A autenticação do Windows (antiga NTLM) protege o conteúdo do seu site num nível de sistema de ficheiros.',
    'iis-settings.requireSsl' => 'Exigir SSL/TLS',
    'iis-settings.requireSslDescription' => 'Se o suporte a SSL/TLS foi ativado para seu site, esta opção forçará os clientes web (browsers) a utilizar apenas ligações seguras de HTTPS.',
    'iis-settings.securityTabIpDeny' => 'Configurações de restrição de acesso',
    'iis-settings.deny' => 'Negar acesso ao site',
    'iis-settings.denyOff' => 'Predefinição',
    'iis-settings.denyCustom' => 'Insira o valor personalizado',
    'iis-settings.allow' => 'Exceto',
    'iis-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nOs hosts e redes especificados não têm a permissão de aceder ao site. Utilize '*' para negar todas as ligações.",
    'iis-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nOs hosts e redes especificados têm a permissão de acesso ao site.",
    'iis-settings.dynamicIpSecurity' => 'Evitar ataques DoS por restrição dinâmica de IP IIS',
    'iis-settings.isDenyByConcurrentRequests' => 'Negar endereços IP com base no número de solicitações simultâneas de um único endereço IP',
    'iis-settings.maxConcurrentRequests' => 'Número máximo de solicitações simultâneas',
    'iis-settings.isDenyByRequestRate' => 'Negar endereços IP com base no número de solicitações num período de tempo.',
    'iis-settings.maxRequests' => 'Número máximo de solicitações',
    'iis-settings.requestInterval' => 'Período de tempo (em milissegundos)',

    'ip-addresses-selector.ipAddress' => 'Endereço IP',
    'ip-addresses-selector.ipv4Address' => 'Endereço IPv4',
    'ip-addresses-selector.ipv4AddressHint' => "O endereço IP no qual o website está alojado é um endereço de rede do anfitrião virtual do website.",
    'ip-addresses-selector.ipv6Address' => 'Endereço IPv6',
    'ip-addresses-selector.ipv6AddressHint' => "O endereço IP no qual o website está alojado é um endereço de rede do anfitrião virtual do website.",
    'ip-addresses-selector.noIpAddressHint' => 'Nenhum',
    'ip-addresses-selector.shared' => 'partilhado',
    'ip-addresses-selector.exclusive' => 'dedicado',
    'ip-addresses-selector.ipV6OnlyNotSupported' => 'O servidor de FTP não suporta IPv6. Alocar pelo menos um endereço IPv4, caso contrário, o utilizador não conseguirá carregar ficheiros para o servidor via FTP.',

    'license-key-revert.description' => 'A chave de licença com as seguintes propriedades será reposta:',
    'license-key-revert.submitButton' => 'Reverter',

    'license-key-upload.description' => 'Instale a sua chave de licença introduzindo um código de ativação.',
    'license-key-upload.descriptionWithFileUpload' => 'Instale a chave de licença inserindo um código de ativação ou enviando um ficheiro da chave de licença.',
    'license-key-upload.type' => 'Escolha uma das seguintes:',
    'license-key-upload.code' => 'Insira o código de ativação',
    'license-key-upload.codeDescription' => 'Cole o código de ativação que recebeu.',
    'license-key-upload.file' => 'Carregar um ficheiro da chave de licença.',
    'license-key-upload.fileDescription' => 'Especifique o caminho para o ficheiro que contém a chave de licença.',
    'license-key-upload.submitButton' => 'Instalar',

    'log-rotation.customLogsDescription' => 'Note que os seus registos personalizados não são rodados.',
    'log-rotation.logRotation' => 'Rotação de Registo',
    'log-rotation.logRotationCondition' => 'Condição de rotação de registo',
    'log-rotation.logRotationBySize' => 'Por tamanho',
    'log-rotation.logRotationByTime' => 'Por tempo',
    'log-rotation.logRotationDaily' => 'Diariamente',
    'log-rotation.logRotationWeekly' => 'Semanalmente',
    'log-rotation.logRotationMonthly' => 'Mensalmente',
    'log-rotation.logRotationSizeDescription' => 'Valor do tamanho deve situar-se entre %%min%% e %%max%% kB.',
    'log-rotation.maximumNumberOfFiles' => 'Número máximo de ficheiros de log',
    'log-rotation.compress' => 'Comprimir ficheiros de registo',
    'log-rotation.sendLogToEmail' => 'Depois de o Plesk recuperar os dados dos ficheiros de registo da web e dos servidores FTP, envie um e-mail com os ficheiros de registo para este endereço.',
    'log-rotation.kb' => 'KB',
    'log-rotation.logRotationPeriodGreater' => 'O período não pode ser maior do que todo o limite do servidor %%max%%.',

    'login.loginLabel' => 'Nome de utilizador',
    'login.passwdLabel' => 'Palavra-passe',
    'login.loginButtonLabel' => 'Login',
    'login.enterUsername' => 'Introduza o seu nome de utilizador.',
    'login.enterPassword' => 'Introduza a sua palavra-passe.',
    'login.whatUsernamePassword' => 'Que nome de utilizador e password pretende utilizar?',
    'login.forgotPasswordLabel' => 'Esqueceu-se da sua palavra-passe?',
    'login.cookies' => 'Política de cookies no Plesk',
    'login.avoidSSLWarningsMsg' => 'Para evitar receber avisos de SSL ao iniciar sessão, utilize %%link%%',
    'login.digitalOceanMsg' => 'Novo no Plesk no DigitalOcean? Para iniciar sessão, utilize "root" e a password introduzida quando criou esta droplet. %%link%%',
    'login.amazonLightsailMsg' => 'Novo no Plesk no Lightsail? Para iniciar sessão no Plesk, aceda ao servidor através de SSH e utilize o comando "plesk login". %%link%%',
    'login.readGuide' => 'Leia o guia completo.',
    'login.mobileApplicationMessage' => 'Para uma melhor experiência, recomendamos que instale a aplicação %%name%%.',
    'login.mobileApplicationInstall' => 'Instalar Agora',
    'login.mobileApplicationHide' => 'Não, obrigado',

    'force-reset-password.saveButton' => 'Gravar',
    'force-reset-password.title' => 'Alterar a sua palavra-passe?',
    'force-reset-password.passwordLabel' => 'Nova palavra-passe',

    'panel-access.title' => 'Personalizar o URL do Plesk',
    'panel-access.hint' => 'Escolha URLs personalizados para iniciar a sessão no Plesk. Tal não retira a possibilidade de início de sessão no Plesk através da porta %%httpsPort%%. %%link%%',
    'panel-access.details' => 'Mais informações',
    'panel-access.proxyEnabled' => 'Todos os domínios e subdomínios que resolvem para o endereço IP do servidor, mas não são utilizados para alojamento',
    'panel-access.proxyDomain' => 'O domínio ou subdomínio especificado que resolve para o endereço IP do servidor, mas não é utilizado para alojamento',
    'panel-access.proxyDisabled' => 'Nenhum URL personalizado. Apenas https://<server-IP-or-hostname>:%%httpsPort%%',

    'panel-access.Form.submitButton' => 'Gravar',
    'panel-access.Form.cancelButton' => 'Cancelar',

    'panel-access.domainNameIsRequired' => 'Deve fornecer um nome de domínio.',
    'panel-access.successMessage' => 'Foi aplicada a forma selecionada de início de sessão.',
    'panel-access.notSupported' => 'O seu Plesk não suporta a forma selecionada para início de sessão.',
    'panel-access.notViaDomainName' => 'Para aplicar esta forma de início de sessão, escolha a primeira opção ("Todos os domínios e subdomínios..."), inicie sessão no Plesk por https://%%domainName%% e escolha a segunda opção.',
    'panel-access.notViaPort' => 'Para aplicar esta forma de início de sessão, inicie sessão no Plesk através de https://<server-IP-or-hostname>:%%httpsPort%%.',

    'php-settings.performance' => 'Configurações de desempenho e segurança',
    'php-settings.performanceSettingsNote' => 'Estes valores não podem ser alterados por domínio através dos ficheiros .htaccess, php.ini ou .user.ini, a menos que o domínio pertença a uma subscrição que tenha a permissão “Gestão das configurações de desempenho de host”.',
    'php-settings.settings' => 'Configurações comuns',
    'php-settings.fastCgiSettings' => 'Configurações FastCGI',
    'php-settings.fpmSettings' => 'Definições PHP-FPM',
    'php-settings.enableFastcgi' => 'Ativar configurações FastCGI',
    'php-settings.plainTextEditing' => 'Diretivas adicionais',
    'php-settings.placeAdditionalCustomizationDirectivesHere' => 'Pode definir quaisquer parâmetros do PHP introduzindo-os no campo seguinte.As diretrizes serão incluídas na configuração do PHP.Utilize a mesma sintaxe que utilizaria com o php.ini.Por exemplo, para carregar automaticamente a extensão mSQL, adicione a linha:extension=msql.so.',
    'php-settings.placeAdditionalCustomizationDirectivesHereAddonPlan' => 'Se não encontrar determinados parâmetros de PHP, adicione-os nos campos abaixo. Estas diretivas adicionais serão fundidas com as diretivas do principal plano de serviço. Utilize a mesma sintaxe usada para php.ini. Por favor, se quiser carregar automaticamente a extensão mSQL, adicione a linha: extension=msql.so.',
    'php-settings.placeFpmAdditionalCustomizationDirectivesHere' => 'Pode definir quaisquer parâmetros do PHP introduzindo-os no campo seguinte.As diretrizes serão incluídas na configuração do PHP.Utilize a mesma sintaxe que utilizaria com o php.ini.Por exemplo, para carregar automaticamente a extensão mSQL, adicione a linha:extension=msql.so.Para personalizar as configurações do pool PHP-FPM, adicione o separador [php-fpm-pool-settings] e introduza as configurações desejadas abaixo.',
    'php-settings.additionalConfigurationDirectives' => 'Diretivas adicionais de configuração',
    'php-settings.defaultValue' => 'Predefinido',
    'php-settings.predefinedValue' => 'Selecione o valor',
    'php-settings.customValue' => 'Insira o valor personalizado',
    'php-settings.phpSettingDescription_memory_limit' => 'A quantidade máxima de memória em bytes na qual é permitida a alocação de um script.',
    'php-settings.phpSettingDescription_max_execution_time' => 'O tempo máximo em segundos no qual é permitido que um script seja executado antes do término.',
    'php-settings.phpSettingDescription_max_input_time' => 'O tempo máximo em segundos no qual é permitido que um script analise os dados de entrada.',
    'php-settings.phpSettingDescription_post_max_size' => 'O tamanho máximo em bytes dos dados que podem ser enviados com o método POST. Tipicamente, deve ser maior que upload_max_filesize e menor que memory_limit.',
    'php-settings.phpSettingDescription_upload_max_filesize' => 'O tamanho máximo em bytes de um ficheiro carregado.',
    'php-settings.phpSettingDescription_safe_mode' => 'O modo de segurança PHP coloca uma série de restrições sobre a execução de scripts, principalmente por razões de segurança.',
    'php-settings.phpSettingDescription_safe_mode_include_dir' => 'Os ficheiros no diretório definido podem ser acedidos por scripts PHP quando a diretiva safe_mode está em vigor. O diretório também deve estar em include_path.',
    'php-settings.phpSettingDescription_safe_mode_exec_dir' => 'Os programas no diretório definido podem ser executados por scripts PHP quando a diretiva safe_mode está em vigor.',
    'php-settings.phpSettingDescription_include_path' => 'A lista de diretórios onde scripts procuram por ficheiros (semelhante à variável PATH do sistema). Para separar diretórios, utilize dois pontos (:) no Linux ou ponto e vírgula (;) no Windows.',
    'php-settings.phpSettingDescription_sessionsave_path' => 'O diretório para armazenar ficheiros de sessão PHP.',
    'php-settings.phpSettingDescription_mailforce_extra_parameters' => 'Parâmetros adicionais para a função de correio().',
    'php-settings.phpSettingDescription_register_globals' => 'Registar o conteúdo das variáveis EGPCS (Environment, GET, POST, Cookie, Server) como variáveis globais.',
    'php-settings.phpSettingDescription_open_basedir' => 'Os ficheiros nos diretórios especificados podem ser acedidos por scripts PHP. Para separar diretórios, utilize dois pontos (:) no Linux ou ponto e vírgula (;) no Windows.',
    'php-settings.phpSettingDescription_error_reporting' => 'O nível de relatório de erro.',
    'php-settings.phpSettingDescription_display_errors' => 'Determina se os erros devem ser apresentados como uma parte da produção.',
    'php-settings.phpSettingDescription_log_errors' => 'Ativar o registo de erros PHP.',
    'php-settings.phpSettingDescription_allow_url_fopen' => 'Permite que as funções do ficheiro PHP recuperem dados de locais remotos via FTP ou HTTP.',
    'php-settings.phpSettingDescription_file_uploads' => 'Permite o carregamento de ficheiros via HTTP.',
    'php-settings.phpSettingDescription_short_open_tag' => 'Permite o formulário curto da tag aberta de PHP.',
    'php-settings.phpSettingDescription_magic_quotes_gpc' => 'Define o estado magic_quotes para operações GPC (Get/Post/Cookie). Quando magic_quotes está ativado, todas aspas simples, aspas duplas, barras invertidas, e carateres especiais NULL são escapados automaticamente com uma barra invertida.',
    'php-settings.phpSettingDescription_disable_functions' => 'Esta diretiva permite que desativar determinadas funções.Ele assume uma lista delimitada por vírgulas de nomes de funções',
    'php-settings.phpSupport' => 'Suporte para PHP',
    'php-settings.phpRunAs' => 'executar PHP como',
    'php-settings.phpVersion' => 'Versão de PHP',
    'php-settings.phpHandlerOutdated' => '(Desatualizado)',
    'php-settings.phpHandlerDeprecated' => '(Descontinuado)',
    'php-settings.phpServedByApache' => 'servido por Apache',
    'php-settings.phpServedByNginx' => 'servido por nginx',
    'php-settings.phpSettingsPhpVersion' => 'Sua versão do PHP é %%version%%.',
    'php-settings.phpSettingsPhpDisabled' => 'O PHP está desativado.',
    'php-settings.phpHandlerTypeHint' => 'Abaixo encontram-se os detalhes da configuração do PHP do site. É possível alterar a configuração do PHP se o fornecedor de hospedagem conceder a permissão correspondente.',
    'php-settings.fpmDedicatedHandlerHint' => 'Utilizar este handler aumenta a estabilidade de um website, mas também provoca o consumo adicional de memória.',
    'php-settings.phpHandlerChangeHint' => 'Alterou as definições do processador de PHP. Se guardar estas alterações, os scripts PHP no seu website podem parar durante %%interval%% segundos devido à configuração do seu servidor.',
    'php-settings.phpHandlerOutdatedHint' => 'Para verificar se está disponível uma nova versão PHP, %%link%% e examine a categoria "Alojamento na Rede" dos componentes do produto.',
    'php-settings.phpHandlerOutdatedHintLink' => 'abra o Plesk Installer',
    'php-settings.phpHandlerTypeHelpLink' => 'Aprender como escolher as melhores configurações de PHP',
    'php-settings.phpHandlerTypeNotAvailableHint' => 'O suporte a PHP não pode ser ativado porque a configuração atual de alojamento não inclui qualquer versão do PHP disponível para este domínio.',
    'php-settings.phpHandlersNotAvailableHint' => 'O suporte a PHP não pode ser ativado porque a configuração atual do Plesk não inclui qualquer versão do PHP disponível.',
    'php-settings.phpHandlerTypeNotAvailableHelpLink' => 'Descubra como ativar outras versões do PHP.',
    'php-settings.phpSupportEditable' => '(versão do PHP %%version%%, executar PHP como %%handler%%) %%link%%',
    'php-settings.phpSupportReadonly' => '(versão: %%version%%; manipulador: %%handler%%) %%link%%',
    'php-settings.phpSupportReadonlyNotRegistered' => '(não registado) %%link%%',
    'php-settings.showPhpInfo' => 'Ver a página phpinfo()',
    'php-settings.phpSettingsFormError' => 'Impossível recuperar as configurações do PHP porque os dados necessários estão ausentes.',
    'php-settings.phpSettingsFormBrokenPhpHandler' => 'Não foi possível obter as definições de PHP porque esta versão de PHP não está instalada. Para continuar, instale a versão de PHP selecionada ou selecione outra para o domínio.',
    'php-settings.showPhpInfoTitle' => 'Ver phpinfo()',
    'php-settings.showPhpInfoDescription' => 'Algumas das suas configurações PHP foram alteradas, mas as alterações ainda não foram guardadas. Para ver os novos valores na página phpinfo(), aplicar primeiro as alterações. Caso contrário, verá os valores atuais.',
    'php-settings.showPhpInfoButton' => 'Ver phpinfo()',
    'php-settings.onState' => 'Ligado',
    'php-settings.offState' => 'Desligada',
    'php-settings.description' => 'Esta página exibe a configuração do PHP para o site. Estas configurações são específicas para o site e não afetam outros sites da assinatura. É possível alterar a configuração do PHP se o fornecedor de hospedagem conceder a permissão correspondente. A configuração personalizada do PHP pode ser utilizada, por exemplo, para limitar o consumo de recursos do sistema por parte de scripts do PHP ou para atender aos requisitos de uma determinada aplicação da web. Ao definir um parâmetro para o valor Padrão, o PHP utilizará este valor a partir das configurações PHP em todo o servidor.',
    'php-settings.availableVariables' => 'Você pode utilizar os seguintes marcadores de posição nos valores de parâmetro:',
    'php-settings.variableDocroot' => '{DOCROOT} para o diretório raiz do documento deste site. O valor atual é %%DOCROOT%%. %%HTTPS_DOCROOT%%',
    'php-settings.variableDocrootHttpsSame' => 'O diretório raiz de documentos HTTPS é o mesmo que para http.',
    'php-settings.variableDocrootHttpsDifferent' => 'O diretório raiz de documentos HTTPS é %%DOCROOT%%.',
    'php-settings.variableWebspaceRoot' => '{WEBSPACEROOT} para o diretório raiz do documento do site primário da assinatura.',
    'php-settings.variableTmp' => '{TMP} para o diretório que aloja ficheiros temporários.',
    'php-settings.note' => 'Nota: as definições abaixo podem ser substituídas por parâmetros especificados nos ficheiros .htaccess, php.ini ou .user.ini.',
    'php-settings.showHelp' => 'Mostrar ajuda',
    'php-settings.select-ariaLabel' => 'selecionar valor',
    'php-settings.tuxCarePhpPromo' => 'As páginas web com versões de PHP desatualizadas podem tornar-se vetores de ataque. Proteja-as já com %%link%%',
    'php-settings.tuxCarePhpLink' => 'Assistência de ciclo de vida prolongado da TuxCare para PHP.',
    'php-settings.phpHandlerLabel' => 'PHP Handler',
    'php-settings.phpHandlerIdLabel' => 'Correr PHP como',

    'pmm.agent.sync.check' => 'Migration & Transfer Agent está a verificar atualizações.',
    'pmm.agent.sync.updating' => 'A sincronizar e descarregar o Migration & Transfer Agent',
    'pmm.agent.sync.done' => 'Migration & Transfer Agent foi sincronizado com sucesso.',
    'pmm.agent.sync.downloadLink' => 'Clique para descarregar o ficheiro do Migration & Transfer Agent que deve ser instalado no host de destino antes do início da migração.',
    'pmm.agent.sync.error' => 'Migration & Transfer Agent falhou em obter atualizações. Por favor tente de novo mais tarde.',

    'restore-password.title' => 'Alterar a sua palavra-passe?',
    'restore-password.passwordLabel' => 'Nova palavra-passe',
    'restore-password.buttonRestore' => 'Guardar',
    'restore-password.buttonCancel' => 'Cancelar',
    'restore-password.isEmpty' => 'O campo obrigatório está vazio. É necessário especificar um valor.',
    'restore-password.errorInvalidSecret' => 'Código secreto inválido',
    'restore-password.errorNotFoundSecret' => 'Peça um novo código secreto',
    'restore-password.restoreSuccess' => 'A sua palavra-passe foi atualizada. Utilize a nova palavra-passe para iniciar sessão no Plesk ou no seu endereço de e-mail.',

    'scheduler.settings.schedulerNotification' => 'Notificação da Agenda de Tarefas',
    'scheduler.settings.notificationOff' => "Desligado",
    'scheduler.settings.notificationDefault' => "Enviar para o e-mail predefinido (%%email%%)",
    'scheduler.settings.notificationCustom' => "Enviar para o e-mail especificado",
    'scheduler.settings.crontabSecureShell' => 'Shell de crontab',
    'scheduler.settings.schedulerTimezoneSelector' => 'Apresentar tarefas agendadas com um fuso horário',
    'scheduler.settings.schedulerTimezoneSelectorDefaultWithLabel' => 'Utilizar o fuso horário predefinido do sistema (%%timezone%%)',
    'scheduler.settings.schedulerTimezoneSelectorDefault' => 'Utilizar o fuso horário predefinido do sistema',
    'scheduler.settings.schedulerTimezoneSelectorCustom' => 'Utilizar o fuso horário indicado por mim',

    'scheduler.task.active' => 'Ativo',
    'scheduler.task.subscription' => 'Assinatura',
    'scheduler.task.subscription_powerUser' => 'Espaço na rede',
    'scheduler.task.type' => 'TIpo de tarefa',
    'scheduler.task.typeCommand' => 'Executar um comando',
    'scheduler.task.typeUrl' => 'Obter um URL',
    'scheduler.task.typeScript' => 'Executar script PHP',
    'scheduler.task.command' => 'Comando',
    'scheduler.task.arguments' => 'com argumentos',
    'scheduler.task.url' => 'URL',
    'scheduler.task.urlDescription' => 'Especifique um URL absoluto, por exemplo, http://example.com. Se o código do estado da resposta for 2xx ou 3xx, a tarefa é considerada como tendo sido executada corretamente.',
    'scheduler.task.script' => 'Caminho do script',
    'scheduler.task.scriptRelativePathDescription' => 'Exemplo: %%path%%',
    'scheduler.task.scriptAbsolutePathDescription' => 'Indique o caminho completo para o script. Exemplo: %%path%%',
    'scheduler.task.scriptPhpVersion' => 'Utilizar Versão do PHP',
    'scheduler.task.scriptPathPopupTitle' => 'Caminho do script',
    'scheduler.task.chooseFile' => 'Escolha o ficheiro',
    'scheduler.task.run' => 'Executar',
    'scheduler.task.on' => 'ligado',
    'scheduler.task.at' => 'em',
    'scheduler.task.sysUser' => 'Utilizador do sistema',
    'scheduler.task.hourly' => 'Hora a hora',
    'scheduler.task.daily' => 'Diariamente',
    'scheduler.task.weekly' => 'Semanalmente',
    'scheduler.task.monthly' => 'Mensalmente',
    'scheduler.task.yearly' => 'Anual',
    'scheduler.task.cronStyle' => 'Estilo de cron',
    'scheduler.task.cronStyleHint' => 'Utilize o formato crontab UNIX "minuto, hora, dia do mês, mês, dia da semana". Por exemplo "0 22 * * 1-5". O Plesk irá utilizar o fuso horário predefinido do sistema para executar a tarefa.',
    'scheduler.task.cronStyleWinHint' => 'Utilize o formato "minuto, hora, dia do mês, mês, dia da semana", por exemplo "0 22 * * 6,7". O Plesk irá utilizar o fuso horário predefinido do sistema para executar a tarefa.',
    'scheduler.task.notify' => 'Avisar',
    'scheduler.task.notifyIgnore' => 'Não notificar',
    'scheduler.task.notifyErrors' => 'Apenas erros',
    'scheduler.task.notifyAlways' => 'A cada ocorrência',
    'scheduler.task.notifyErrorsHint' => 'As notificações contêm a sequência de erro padrão do comando. Se a sequência estiver vazia, a notificação não será enviada.',
    'scheduler.task.notifyErrorsHintWin' => 'As notificações contêm o resultado do comando e são apenas enviadas caso o código de saída seja diferente de zero.',
    'scheduler.task.notifyAlwaysHint' => 'As notificações contêm o resultado do comando. Se o resultado estiver vazio, a notificação não será enviada.',
    'scheduler.task.notifyAlwaysHintWin' => 'As notificações contêm o resultado do comando e são enviadas independentemente do código de saída do comando.',
    'scheduler.task.emailType' => 'Enviar notificações a',
    'scheduler.task.emailTypeDefault' => 'Utilizador de sistema predefinido (%%email%%)',
    'scheduler.task.emailTypeOwner' => 'Proprietário da subscrição (%%email%%)',
    'scheduler.task.emailTypeOwnerAdmin' => 'Administrador (%%email%%)',
    'scheduler.task.emailTypeCustom' => 'Outros utilizadores',
    'scheduler.task.emailTypeCustomDescription' => 'Pode indicar vários endereços separados por vírgulas.',
    'scheduler.task.minute' => 'minuto',
    'scheduler.task.shortMinute' => 'min',
    'scheduler.task.dayOfMonth' => 'dia',
    'scheduler.task.description' => 'Descrição',
    'scheduler.task.scheduleTimezoneHint' => 'O fuso horário para a tarefa em execução é %%timezone%%',
    'scheduler.task.runTaskNow' => 'Executar Agora',
    'scheduler.task.runningTask' => 'A executar a tarefa "%%task%%"...',

    'server-settings.submitDone' => "As configurações do servidor foram alteradas.",
    'server-settings.systemSettings' => "Preferências do sistema",
    'server-settings.fullHostName' => "Nome de host completo (hostname)",
    'server-settings.trafficStatisticsPeriod' => "Reter estatísticas de tráfego e Web por",
    'server-settings.trafficStatisticsPeriodUnit' => "meses",
    'server-settings.diskSpaceUsageCalculation' => "Incluir o cálculo do uso de espaço em disco",
    'server-settings.includeLogs' => "ficheiros de registro",
    'server-settings.includeLogsAndStats' => "ficheiros de registro e relatórios de estatísticas",
    'server-settings.includeMysqlDatabases' => "Bases de dados do MariaDB/MySQL",
    'server-settings.includeMssqlDatabases' => "Bases de dados do Microsoft SQL",
    'server-settings.includePgsqlDatabases' => "bases de dados PostgreSQL",
    'server-settings.includeDatabases' => "bases de dados",
    'server-settings.includeRemoteDatabases' => "bases de dados remotas",
    'server-settings.includeMailboxes' => "caixas de correio",
    'server-settings.includeMailLists' => "listas de envio",
    'server-settings.includeDomainDumps' => "backup de arquivos do domínio",
    'server-settings.includeAdminDumps' => "ficheiros de backup criados pelo administrador",
    'server-settings.calculatingDiskSpaceUsage' => "Contar ao calcular a utilização de espaço no disco",
    'server-settings.typeByte' => "tamanho do arquivo",
    'server-settings.typeBlock' => "quantidade de utilização de espaço no disco",
    'server-settings.trafficCalculation' => "Incluir cálculo de tráfego",
    'server-settings.inboundAndOutbound' => "Tráfego de entrada e saída",
    'server-settings.onlyInbound' => "Somente tráfego de entrada",
    'server-settings.onlyOutbound' => "Somente tráfego de saída",
    'server-settings.forbidCreateDnsSubZone' => "Não permitir que os utilizadores criem sub-zonas DNS nas super-zonas DNS de outros utilizadores",
    'server-settings.webDeployIncludePassword' => "Incluir a palavra-passe de utilizador no ficheiro com as configurações de publicação pelo Web Deploy",
    'server-settings.forbidSysUserRename' => "Os clientes podem alterar o nome do seu utilizador do sistema",
    'server-settings.alwaysAllowSysUserRename' => "sempre",
    'server-settings.ifPermissionIsGrantedAllowSysUserRename' => "apenas se for concedida a autorização de Gestão de Alojamento",
    'server-settings.neverAllowSysUserRename' => "nunca",
    'server-settings.forbidSubscriptionRename' => "Proibir os clientes e revendedores de modificar o nome principal do domínio",
    'server-settings.preferredDomain' => "Domínio preferencial para websites",
    'server-settings.preferredDomainNone' => "nenhum",
    'server-settings.preferredDomainToLanding' => "domain.tld",
    'server-settings.preferredDomainToWww' => "www.domain.tld",
    'server-settings.ipLogging' => "Registo de IP",
    'server-settings.disableIpLogging' => "Desativar o registo de IP em IIS, FTP e registos de correio",
    'server-settings.disableIpLoggingDescription' => "Caso sejam selecionados, IIS e MailEnable já não escrevem endereços de IP nos ficheiros de registo",
    'server-settings.anonymizeIps' => "Anonimizar endereços IP",
    'server-settings.logrotateAnonymizeIps' => "Anonimiza os endereços IP durante a rotação de registos e recolhe de estatísticas da web",
    'server-settings.logrotateAnonymizeIpsDescription' => 'O script pós-rotação substitui o último octeto de endereços IPv4 em ficheiros de registo rotacionados com "0" antes do arquivo. Nos endereços IPv6, o script substitui a última secção do endereço (dois octetos depois da última vírgula) por "0000" (no formato completo) ou "0" (no formato curto)',
    'server-settings.logrotate' => "Rotação de registo",
    'server-settings.logrotateForce' => "Forçar a rotação de registo diário para todos os domínios",
    'server-settings.allowToStoreLogs' => "Permitir armazenar ficheiros de registo do site para",
    'server-settings.logrotatePeriod' => "dias",
    'server-settings.configureUpdatePolicy' => "Configurar política de atualização",

    'service-plan.mail.outgoing-messages.outgoingMessagesDefault' => 'Valor padrão limitado pelo (%%default%% mensagens por hora)',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificPlan' => 'Valor personalizado para o plano',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificSubscription' => 'Valor personalizado para a assinatura',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificHint' => 'mensagens',
    'service-plan.mail.outgoing-messages.mboxOutgoingMessages' => 'Mensagens enviadas a partir de uma caixa de mensagens (por hora)',
    'service-plan.mail.outgoing-messages.domainOutgoingMessages' => 'Mensagens enviadas a partir de um domínio (por hora)',
    'service-plan.mail.outgoing-messages.subscriptionOutgoingMessages' => 'Mensagens enviadas a partir de uma assinatura (por hora)',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimit' => 'A percentagem de mensagens acima do limite por hora que deve ser enviada na hora seguinte.',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimitDescription' => '" Se o limite de mensagens enviadas a partir de uma caixa de mensagens for de 100 por hora e a percentagem for de 10%, então o utilizador pode enviar 110 mensagens por hora; 100 serão enviadas durante uma hora, e as outras 10 serão colocadas na fila e programadas para envio na hora seguinte."',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmail' => 'Política de utilização de envio de e-mails',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailDefault' => 'Configurações padrão de limites do servidor (o Sendmail é permitido)',
    'service-plan.mail.outgoing-messages.outgoingMessagesNotEnableSendmailDefault' => 'Configurações padrão de limites do servidor (o Sendmail não é permitido)',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomPlan' => 'Configurações personalizadas para o plano',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomSubscription' => 'Configurações personalizadas para a assinatura',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomLabel' => 'Autorizar a utilização de envio de e-mail para scripts e utilizadores nesta subscrição',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomHint' => 'Os scripts e utilizadores poderão enviar mensagens de e-mail (em nome do utilizador da assinatura do sistema) usando o Sendmail mesmo que excedam os limites para a caixa de mensagens e domínio. O número máximo de mensagens que podem ser enviadas através do Sendmail será definido pelo limite para uma assinatura inteira.',

    'setup.hint' => 'Bem-vindo ao Plesk, um painel de controlo que o ajuda a gerir o seu servidor.O Plesk fornece um ambiente pronto a codificar e oferece um conjunto de extensões poderosas para o ajudar a desenvolver websites e aplicações.Conclua o processo de configuração para começar a utilizar o Plesk (só demorará um minuto).',
    'setup.contactInfoSection' => 'Informação de contacto',
    'setup.contactInfoSectionHint' => 'Introduza o seu nome e endereço de e-mail para se identificar como o proprietário do servidor e para receber avisos importantes relativos ao servidor. Se for administrador de um servidor empresarial, não introduza o seu nome ou endereço de e-mail pessoal. Utilize a sua função e endereço de e-mail empresarial para evitar possíveis violações da legislação de proteção de dados.',
    'setup.contactName' => 'O seu nome de contacto',
    'setup.emptyContactName' => 'Por favor, introduza um nome para contacto.',
    'setup.contactNameTooLong' => 'Nome de contacto é muito longo (máximo de %max% símbolos são permitidos).',
    'setup.email' => 'E-mail',
    'setup.emptyEmail' => 'Forneça um endereço de email.',
    'setup.passwordSection' => 'Palavra-passe',
    'setup.passwordSectionHint' => 'Da próxima vez que entrar no Plesk, use o nome de utilizador \'admin\' e a palavra-passe inserida abaixo.',
    'setup.password' => 'Palavra-passe',
    'setup.licenseSection' => 'Licença',
    'setup.licenseSectionHint' => 'Deve instalar uma licença para começar a utilizar o Plesk.',
    'setup.licenseType' => 'Selecione o seu tipo de licença',
    'setup.licenseTypePaid' => 'Prosseguir com uma licença paga',
    'setup.activationCodeLabel' => 'Insira aqui o seu código de ativação',
    'setup.onlineStoreLink' => 'Loja online',
    'setup.licenseTypeTrial' => 'Prosseguir com uma licença de avaliação completa',
    'setup.activationCodeHint' => 'Se já adquiriu uma licença Plesk, cole o código de ativação que recebeu aqui. Caso contrário, poderá adquirir uma nova licença na nossa %%onlineStoreLink%%.',
    'setup.privacyPolicyLink' => 'Política de Privacidade da WebPros',
    'setup.trialLicenseAgreement' => 'Para emitir uma licença de teste, a WebPros International GmbH utilizará e processará as informações fornecidas nos seus sistemas internos, de acordo com a %%privacyPolicyLink%%.',
    'setup.eulaAgreementLabel' => 'Confirmo que li e aceitei o %%link%% Acordo de Licença do Utilizador Final',
    'setup.eula' => 'Acordo de Licença do Utilizador Final',
    'setup.invalidEulaAgreementValue' => 'Deve aceitar o Acordo de Licença do Utilizador Final',
    'setup.sendButton' => 'Entrar no Plesk >>',
    'setup.resetPasswordOnFirstLogin' => 'Reiniciar a palavra-passe de administrador ao iniciar sessão na próxima vez',

    'spam-filter.add.titleBlack' => 'Adicionar endereços à Lista Negra',
    'spam-filter.add.titleWhite' => 'Adicionar endereços à Lista Branca',
    'spam-filter.add.fileDescription' => 'Envie um ficheiro de texto com codificação UTF-8 (por exemplo, um ficheiro *.txt ou *.csv).',
    'spam-filter.add.listDescription' => 'Regras de formatação: <ul><li>Separe endereços individuais por ponto e vírgulas, vírgulas, ou caracteres de nova linha, espaço forçado ou tabulação.</li><li>Não utilize caracteres não-ASCII à esquerda do sinal de @.</li><li>Pode usar os caracteres universais "*" e "?" (por exemplo, <nobr>*@domain.com,</nobr> <nobr>user?@*.com</nobr>).</li><li>Não utilize caracteres universais em partes não-ASCII dos nomes de domínio.</li></ul>',
    'spam-filter.add.fromFile' => 'Do ficheiro',
    'spam-filter.add.fromList' => 'Da lista',
    'spam-filter.add.success' => 'Foram adicionados endereços',

    'ssl-certificate.add.name' => 'Nome do certificado',
    'ssl-certificate.add.longName' => 'O nome do certificado especificado é demasiado longo (é permitido um  %max% de símbolos).',
    'ssl-certificate.add.certificateNameUsed' => 'Um certificado com o nome %%name%% já existe.',
    'ssl-certificate.add.certificateAdded' => 'O certificado SSL/TLS foi emitido. Para o ativar, atribua o certificado para proteger um domínio, e-mail ou webmail.',
    'ssl-certificate.add.certificateUpdated' => 'O certificado SSL/TLS foi atualizado com sucesso.',
    'ssl-certificate.add.settings' => 'Configurações',
    'ssl-certificate.add.settingsHint' => 'Use este formulário para gerar uma solicitação de certificado, comprar um certificado do seu fornecedor ou gerar um certificado auto-assinado.',
    'ssl-certificate.add.settingsHint2' => 'Uma solicitação é um ficheiro CSR que contém as informações sobre o domínio que especificou no formulário. Pode enviar a solicitação a uma autoridade de certificação desejada para que esta possa lhe emitir um certificado. Carregará então o certificado usando um dos formulários de carregamento abaixo.',
    'ssl-certificate.add.settingsHint3' => 'Um certificado auto-assinado é um certificado de identidade assinado pelo seu próprio criador. Se usar um destes certificados, isso significa que a verificação da identidade do seu site será realizada por si. Embora os certificados auto-assinados permitam o uso de SSL/TLS, eles são mais suspeitos e considerados menos seguros.',
    'ssl-certificate.add.bits' => 'Bits',
    'ssl-certificate.add.country' => 'País',
    'ssl-certificate.add.state' => 'Estado ou província',
    'ssl-certificate.add.longState' => 'O nome da província ou estado especificado é demasiado longo.',
    'ssl-certificate.add.city' => 'Localidade (cidade)',
    'ssl-certificate.add.longCity' => 'O nome da cidade especificado é demasiado longo.',
    'ssl-certificate.add.shortCity' => 'O nome da cidade especificado é demasiado curto.',
    'ssl-certificate.add.companyName' => 'Nome da organização (empresa)',
    'ssl-certificate.add.longCompanyName' => 'O nome da empresa especificado é demasiado longo.',
    'ssl-certificate.add.companyUnitName' => 'Nome do departamento/divisão da organização',
    'ssl-certificate.add.longCompanyUnitName' => 'O nome do departamento da organização especificado é demasiado longo (é permitido um  %max% de símbolos).',
    'ssl-certificate.add.domainName' => 'Nome do domínio',
    'ssl-certificate.add.email' => 'E-mail',
    'ssl-certificate.add.request' => 'Solicitar',
    'ssl-certificate.add.buyCertificate' => 'Adquirir Certificados SSL/TLS',
    'ssl-certificate.add.selfSigned' => 'Auto-Assinado',
    'ssl-certificate.add.invalidCertificateParams' => 'Alguns campos estão vazios ou contêm valores inadequados. Os valores devem ser limitados a 64 caracteres. Se estiver a utilizar um nome de domínio internacionalizado, certifique-se que cada parte do nome de domínio entre pontos não excede os 63 símbolos quando transformados para o formato ASCII. Verifique os campos:',
    'ssl-certificate.add.unableCreateCsr' => 'Não foi possível criar um CSR: %%error%%',
    'ssl-certificate.add.unableCreateSelfSigned' => 'Não foi possível criar um certificado auto-assinado: %%error%%',
    'ssl-certificate.add.unableCreateUpload' => 'Não foi possível configurar os dados do certificado: %%error%%',
    'ssl-certificate.add.unableSaveCertificate' => 'Não foi possível guardar o certificado no banco de dados: %%error%%',
    'ssl-certificate.add.uploadFiles' => 'Efetuar o carregamento dos ficheiros do certificado',
    'ssl-certificate.add.uploadFilesHint' => 'Use este formulário para carregar os componentes de um certificado como ficheiros constituintes.',
    'ssl-certificate.add.csr' => 'CSR',
    'ssl-certificate.add.privateKey' => "Chave privada (*.key)",
    'ssl-certificate.add.certificate' => "Certificado (*.crt)",
    'ssl-certificate.add.caCertificate' => "Certificado CA (*-ca.crt)",
    'ssl-certificate.add.sendFiles' => "Carregar certificado",
    'ssl-certificate.add.fileNotUploaded' => 'Não foi possível efetuar o carregamento do ficheiro de certificado: %%name%%.',
    'ssl-certificate.add.unableSetPrivateKey' => 'Não foi possível configurar a chave privada: %%error%%',
    'ssl-certificate.add.unableSetCertificate' => 'Não foi possível configurar o certificado: %%error%%',
    'ssl-certificate.add.unableSetCaCertificate' => 'Não foi possível configurar o certificado CA: %%error%%',
    'ssl-certificate.add.unableCheckCaCertificate' => 'Não foi possível verificar se o certificado CA assina o certificado: %%error%%',
    'ssl-certificate.add.removeCaCertificate' => 'Eliminar',
    'ssl-certificate.add.removeCaCertificateConfirmation' => 'Deseja mesmo remover o certificado CA?',
    'ssl-certificate.add.unableRemoveCaCertificate' => 'Não foi possível limpar o certificado CA: %%error%%',
    'ssl-certificate.add.caCertificateRemoved' => 'A parte CA do certificado foi removida.',
    'ssl-certificate.add.rename' => 'Renomear',
    'ssl-certificate.add.unableRenameCertificate' => 'Não foi possível renomear o certificado: %%error%%',
    'ssl-certificate.add.certificateRenamed' => 'O certificado foi renomeado para %%name%%.',
    'ssl-certificate.add.uploadText' => "Efetuar o carregamento do certificado como texto",
    'ssl-certificate.add.uploadTextHint' => 'Use este formulário para carregar os componentes de um certificado como texto. Copie o conteúdo de um ficheiro e o cole no campo correspondente.',
    'ssl-certificate.add.sendText' => "Carregar certificado",
    'ssl-certificate.add.componentIsMissing' => 'O componente está em falta.',

    'ssl-certificate.find-private-key.findPrivateKey' => 'Carregar o certificado aqui',
    'ssl-certificate.find-private-key.formGeneralHint' => 'Se criou um pedido de assinatura de certificado neste servidor e recebeu o ficheiro do certificado, carregue-o aqui. Se desejar carregar um certificado e um conjunto de chaves privadas geradas noutro servidor, ou gerar um certificado auto-assinado, clique em <b>Adicionar Certificado SSL/TLS</b>.',
    'ssl-certificate.find-private-key.formCertificateAddingHint' => 'Depois de adicionar um certificado SSL/TLS a um domínio é preciso ativar o suporte de SSL/TLS e selecionar este certificado nas configurações de alojamento de websites: <b>Websites & Domínios</b>> <b>Configurações de Alojamento </b> deste domínio> <b>Segurança</b>.',
    'ssl-certificate.find-private-key.uploadCertificate' => 'Certificado (*.crt)',
    'ssl-certificate.find-private-key.sendFile' => 'Carregar certificado',
    'ssl-certificate.find-private-key.fileNotUploaded' => 'Não foi possível efetuar o carregamento do ficheiro do certificado.',
    'ssl-certificate.find-private-key.invalidCertificateFormat' => 'Formato inválido do certificado.',
    'ssl-certificate.find-private-key.unableFindPrivateKey' => 'Impossível encontrar a chave privada apropriada ao certificado.',

    'ssl-certificate.secure.certificate' => 'Selecionar certificado',
    'ssl-certificate.secure.serverPool' => 'Pool de servidores',
    'ssl-certificate.secure.certificateName' => '%%certificateName%% (%%repositoryName%%)',

    'system-time.date' => "Data",
    'system-time.dateAndTime' => "Data e hora",
    'system-time.daylight' => "Ajustar automaticamente o relógio para as alterações à hora de verão",
    'system-time.dayMonthYear' => "Dia-Mês-Ano",
    'system-time.domainNameOrIp' => "Nome do domínio ou IP",
    'system-time.hoursMinutesSeconds' => "Horas:Minutos:Segundos",
    'system-time.networkTime' => "Hora da rede",
    'system-time.submitDone' => "As configurações de hora do sistema foram modificadas.",
    'system-time.synchronizedSystemTime' => "Sincronizar hora do sistema",
    'system-time.title' => "Data e hora do sistema",
    'system-time.timezone' => "Fuso Horário",
    'system-time.time' => "Hora",
    'system-time.updateSystemTime' => "Actualizar a hora do sistema",
    'system-time.yourTimezone' => "O seu Fuso Horário",

    'web-app-firewall.pageHint' => 'A firewall da aplicação web protege as aplicações web de ataques verificando e filtrando os pedidos HTTP recebidos com base em regras definidas pelo utilizador.',
    'web-app-firewall.webSitePageHint' => 'Aqui, poderá configurar a firewall para aplicações (ModSecurity).',
    'web-app-firewall.ruleEngine' => 'Modo da firewall para aplicações web',
    'web-app-firewall.ruleEngineOn' => 'Ligada',
    'web-app-firewall.ruleEngineOnDescription' => 'Cada nova solicitação HTTP e respetiva resposta são verificadas de acordo com um conjunto de regras. Se a verificação for bem-sucedida, a solicitação HTTP é enviada para o conteúdo do website. Se a verificação falhar, o evento é registado e a resposta HTTP é fornecida com um código de erro.',
    'web-app-firewall.ruleEngineOff' => 'Desligado',
    'web-app-firewall.ruleEngineOffDescription' => 'Novas solicitações HTTP e respetivas respostas não são verificadas',
    'web-app-firewall.ruleEngineDetectionOnly' => 'Unicamente detetar',
    'web-app-firewall.ruleEngineDetectionOnlyDescription' => 'Cada nova solicitação HTTP e respetiva resposta são verificadas de acordo com um conjunto de regras. Se a verificação for bem-sucedida, a solicitação HTTP é enviada para o conteúdo do website. Se a verificação falhar, o evento é registado e o ModSecurity não realiza outras ações. Outros serviços (por exemplo, o Fail2ban) continuam a conseguir realizar as suas próprias ações relativamente a solicitações HTTP que tenham falhado a verificação.',
    'web-app-firewall.ruleSetsSection' => 'Conjuntos de regras',
    'web-app-firewall.ruleSetsSectionHint' => 'Selecione o conjunto de regras (um pacote de ficheiros contendo regras de segurança) a utilizar para verificar os pedidos HTTP recebidos.',
    'web-app-firewall.ruleSet' => 'Conjunto de regras',
    'web-app-firewall.ruleSetCrs' => 'OWASP (gratuito)',
    'web-app-firewall.ruleSetCrsDescription' => 'O OWASP ModSecurity Core Rule Set é muito restritivo e pode bloquear algumas funções (por exemplo, partilha de ficheiros, webmail) e alguns funcionalidades de aplicações de rede (por exemplo, plugins do WordPress).',
    'web-app-firewall.ruleSetCrsConfirmTitle' => 'Aplicar alterações?',
    'web-app-firewall.ruleSetCrsConfirmDescription' => 'As regras do OWASP podem ser demasiado restritivas e podem bloquear algumas funções, como partilha de ficheiros e algumas aplicações web.',
    'web-app-firewall.ruleSetTortix' => 'Atomic Standard (gratuito, pode ser atualizado para Atomic Advanced)',
    'web-app-firewall.ruleSetTortixDescription' => 'Uma versão inicial do ModSecurity Rules da Atomicorp. Fornece proteção básica e é atualizado mensalmente.',
    'web-app-firewall.ruleSetTortixHowTo' => 'Para atualizar este conjunto de regras para o Atomic Advanced:',
    'web-app-firewall.ruleSetTortixBuy' => 'Adquira %%linkPleskStore%% no site do Plesk e %%linkDocumentation%%.',
    'web-app-firewall.ruleSetTortixLinkPleskStoreLabel' => 'Advanced ModSecurity Rules por Atomicorp',
    'web-app-firewall.ruleSetTortixLinkDocumentationLabel' => 'instale a chave de licença adicional adquirida',
    'web-app-firewall.ruleSetTortixSelect' => 'Selecione este conjunto de regras, que mudará o seu nome para "Atomic Advanced (adquirido do Plesk)"',
    'web-app-firewall.ruleSetTortixPro' => 'Atomic Advanced (adquirido do Plesk)',
    'web-app-firewall.ruleSetTortixProDescription' => 'O Advanced ModSecurity Rules da Atomicorp inclui regras Atomic Standard, além de diversas funcionalidades avançadas.',
    'web-app-firewall.ruleSetAtomic' => 'Atomic Advanced (adquirido da Atomicorp)',
    'web-app-firewall.ruleSetAtomicDescription' => 'O Advanced ModSecurity Rules da Atomicorp inclui regras Atomic Standard, além de diversas funcionalidades avançadas.',
    'web-app-firewall.ruleSetAtomicInstall' => 'Mude para outra conta Atomicorp.',
    'web-app-firewall.ruleSetAtomicInstalled' => 'O conjunto de regras está ativado.',
    'web-app-firewall.ruleSetAtomicHowTo' => 'Se já possui a conta Atomicorp com as regras Atomic Advanced adquiridas, insira as credenciais da conta abaixo para ativar este conjunto de regras.',
    'web-app-firewall.ruleSetAtomicSwitchHowTo' => 'Se já possui a conta Atomicorp com as regras Atomic Advanced adquiridas, introduza as credenciais da conta em baixo para mudar a conta.',
    'web-app-firewall.ruleSetAtomicLogin' => 'Nome de utilizador',
    'web-app-firewall.ruleSetAtomicPassword' => 'Senha',
    'web-app-firewall.ruleSetComodo' => 'Comodo (assinatura gratuita)',
    'web-app-firewall.ruleSetComodoDescription' => 'ModSecurity Rules gratuito da Comodo. Fornecem proteção básica.',
    'web-app-firewall.ruleSetComodoInstall' => 'Mude para outra conta Comodo.',
    'web-app-firewall.ruleSetComodoInstalled' => 'O conjunto de regras está ativado.',
    'web-app-firewall.ruleSetComodoHowTo' => 'Para ativar este conjunto de regras:',
    'web-app-firewall.ruleSetComodoSwitchHowTo' => 'Para mudar para outra conta:',
    'web-app-firewall.ruleSetComodoRegister' => 'Registe-se no site da Comodo.',
    'web-app-firewall.ruleSetComodoCredentials' => 'Introduza o seu nome de utilizador e palavra-passe desse website.',
    'web-app-firewall.ruleSetComodoLogin' => 'Nome de utilizador',
    'web-app-firewall.ruleSetComodoPassword' => 'Senha',
    'web-app-firewall.ruleSetComodoFree' => 'Comodo (gratuito)',
    'web-app-firewall.ruleSetComodoFreeDescription' => 'ModSecurity Rules gratuito da Comodo. Fornecem proteção básica.',
    'web-app-firewall.ruleSetCustom' => 'Conjunto de regras personalizado',
    'web-app-firewall.ruleSetCustomDescription' => 'Carregar um conjunto personalizado de regras de firewall de aplicação web. Formatos suportados: zip, tar.gz, tgz, tar.bz2, conf.',
    'web-app-firewall.ruleSetCustomUpload' => 'Selecione outro ficheiro',
    'web-app-firewall.ruleSetError' => 'Falha na instalação do conjunto de regras do ModSecurity: %%error%%',
    'web-app-firewall.ruleSetOWASPMissingError' => 'O conjunto de regras OWASP está em falta. Reinstale o ModSecurity utilizando o instalador do Plesk.',
    'web-app-firewall.ruleSetCustomMissingError' => 'O conjunto de regras personalizado está em falta. Reinstale o conjunto de regras.',
    'web-app-firewall.ruleSetAuthError' => 'O nome de utilizador ou a senha especificada não é válida.',
    'web-app-firewall.ruleSetInvalid' => 'A regra selecionada não pode ser executada em %%webServer%%.',
    'web-app-firewall.ruleSetSelectedInvalid' => 'A regra selecionada não pode ser executada no webserver selecionado.',
    'web-app-firewall.webServer' => 'Executar regras em',
    'web-app-firewall.webServerHint' => 'Selecione a combinação desejada de servidor web e versão ModSecurity para ver os conjuntos de regras compatíveis.',
    'web-app-firewall.webServerApache' => 'Apache (ModSecurity 2.9)',
    'web-app-firewall.webServerNginx' => 'Nginx (ModSecurity 3.0)',
    'web-app-firewall.webServerIis' => 'IIS (ModSecurity 2.9)',
    'web-app-firewall.nginxNotRunning' => 'Reverse Proxy Server (nginx) está desativado e não pode ser utilizado para processar pedidos. Selecione <a href="%%serverUrl%%">outro servidor web</a> ou active o reverse proxy server na <a href="%%servicesUrl%%">página de Gestão de Serviços</a>.',
    'web-app-firewall.nginxIsIncompatible' => 'Selecionar uma versão de ModSecurity pode resultar em algumas definições perderem a validade (por exemplo, não pode utilizar expressões normais para desativar regras de segurança com o ModSecurity 3). Depois de aplicar as alterações, certifique-se de que as suas definições funcionam da forma esperada. Como alternativa, pode repor as definições que desativam as regras de segurança nos seus valores predefinidos.',
    'web-app-firewall.nginxResetCustomizations' => 'Reponha nos seus valors predefinidos as definições de servidor e domínios que desativam regras de segurança.',
    'web-app-firewall.ruleSetUpdate' => 'Atualizar os conjuntos de regras',
    'web-app-firewall.ruleSetUpdateDaily' => 'Diariamente',
    'web-app-firewall.ruleSetUpdateWeekly' => 'Semanalmente',
    'web-app-firewall.ruleSetUpdateMonthly' => 'Mensalmente',
    'web-app-firewall.currentRuleSet' => 'Conjunto de regras',
    'web-app-firewall.currentRuleSetValue' => '%%ruleSet%% %%changeRuleSetLink%%',
    'web-app-firewall.currentRuleSetRunningOn' => '%%ruleSet%% em execução em %%webServer%%',
    'web-app-firewall.changeRuleSetLink' => 'Mudar Conjunto de Regras',
    'web-app-firewall.ruleSetRollbackFailed' => 'Não é possível utilizar o conjunto de regras do ModSecurity atual e reverter para a versão anterior porque contêm uma configuração inválida.',
    'web-app-firewall.configurationSection' => 'Configuração',
    'web-app-firewall.configurationSectionHint' => 'Configure a firewall da sua aplicação web utilizando um conjunto de parâmetros predefinidos ou as suas próprias instruções personalizadas do ModSecurity.',
    'web-app-firewall.configPreset' => 'Conjunto de valores predefinidos',
    'web-app-firewall.configPresetFast' => 'Rápido',
    'web-app-firewall.configPresetFastDescription' => 'A URI da solicitação HTTP e partes do cabeçalho serão analisadas.',
    'web-app-firewall.configPresetTradeOff' => 'Equilibrado',
    'web-app-firewall.configPresetTradeOffDescription' => 'A URI da solicitação HTTP, cabeçalhos e os dados POST da solicitação serão analisados.',
    'web-app-firewall.configPresetThrough' => 'Completo',
    'web-app-firewall.configPresetThroughDescription' => 'Os cabeçalhos completos da solicitação HTTP, os dados POST da solicitação e o conteúdo do corpo da resposta HTTP serão analisados.',
    'web-app-firewall.configCustom' => 'Instruções personalizadas',
    'web-app-firewall.configCustomDescription' => "Insira uma instrução do ModSecurity aqui. Ela cancelará as instruções previamente especificadas (conjuntos de regras, regras específicas, o conjunto predefinido de valores, etc.).\nPor exemplo: SecDebugLogLevel 6",
    'web-app-firewall.configCustomError' => 'Configuração do ModSecurity inválida: %%error%%',
    'web-app-firewall.configRollbackFailed' => 'Não é possível utilizar o ficheiro de configuração do ModSecurity atual e reverter para a versão anterior do ficheiro porque contêm uma configuração inválida.',
    'web-app-firewall.rulesSection' => 'Desativar as regras de segurança',
    'web-app-firewall.rulesSectionHint' => 'Aqui pode desativar as regras de segurança. É conveniente descobrir a regra de segurança que é restritiva demais para alguns websites. Para desativar as regras de segurança, especifique os seus IDs (por exemplo, 340003 ou 340005-340007), as tags (por exemplo, CVE-2011-4898), ou as expressões regulares usadas em mensagens de regras (por exemplo, XSS).',
    'web-app-firewall.rulesSectionNginxHint' => 'Aqui pode desativar as regras de segurança. É conveniente descobrir a regra de segurança que é restritiva demais para alguns websites. Para desativar as regras de segurança, especifique os seus IDs (por exemplo, 340003 ou 340005-340007), as tags (por exemplo, CVE-2011-4898), ou mensagens de regras (por exemplo, Foi encontrado Utilizador-Agente associado a scanner de segurança).',
    'web-app-firewall.filterById' => 'IDs de regras de segurança',
    'web-app-firewall.filterByIdInvalid' => 'Os seguintes valores não são válidos: %%values%%. A ID da regra deve consistir em dígitos ou um intervalo de dígitos, tais como 913100, 913105-913107.',
    'web-app-firewall.filterByIdInvalidRanges' => 'Os seguintes intervalos selecionados não são válidos: %%ranges%%.',
    'web-app-firewall.filterByTag' => 'Tags',
    'web-app-firewall.filterByTagActive' => 'Ativo:',
    'web-app-firewall.filterByTagDeactivated' => 'Desativado:',
    'web-app-firewall.filterByTagInvalid' => 'Os seguintes valores selecionados não são válidos: %%values%%.',
    'web-app-firewall.filterByRegexp' => 'Expressões regulares em mensagens de erro',
    'web-app-firewall.filterByRegexpInvalid' => 'Os seguintes valores não são válidos: %%values%%. Não devem conter caracteres \', ".',
    'web-app-firewall.filterByRegexpNginx' => 'Mensagens de regras',
    'web-app-firewall.filterByRegexpNginxHint' => 'São suportados apenas resultados precisos.',
    'web-app-firewall.filterByRegexpNginxInvalid' => 'Os seguintes valores não são válidos: %%values%%. A mensagem de regra deve consistir em letras, números, espaços ou carateres -:;.,!?#&$%*()/.',
    'web-app-firewall.auditLogSection' => 'Registo de Verificação do ModSecurity',
    'web-app-firewall.auditLogHint1' => 'O ficheiro de registo de verificação ModSecurity é a informação mais útil no sistema. Quando o ModSecurity deteta a ocorrência de qualquer evento, ele gera uma entrada no ficheiro de registo.',
    'web-app-firewall.auditLogHint2' => 'Um site pode parar de funcionar conforme esperado depois de mudar o modo da firewall da aplicação para Ligado, Desligada ou Unicamente detetar. Neste caso, analise o registo de verificação do ModSecurity para descobrir o que está a acontecer. Pode desativar regras de segurança restritivas demais ou ajustar o site.',
    'web-app-firewall.auditLogHint3' => 'Para entender porque uma solicitação HTTP não pode ser cumprida para um site:',
    'web-app-firewall.auditLogPoint1' => 'Clique no link Ficheiro de Registos do Modsecurity em baixo e abra o registo de verificação numa nova janela do navegador.',
    'web-app-firewall.auditLogPoint2' => 'Use Pesquisar (Ctrl + F, na maioria dos navegadores) para encontrar eventos para o website (o nome de domínio) que estiver com problemas. Por exemplo, seu_dominio.tld. O navegador irá destacar as entradas assim HOST: seu_dominio.tld.',
    'web-app-firewall.auditLogPoint3' => 'Em três linhas acima da entrada destacada, encontre um string assim: --eece5138-B--. Os oito símbolos entre hífenes (no nosso exemplo, eece5138) são o ID do evento acionado pela solicitação de HTTP.',
    'web-app-firewall.auditLogPoint4' => 'Continue a procurar outras entradas com a mesma ID de evento. Procure uma entrada com a letra H depois da ID do evento (no nosso exemplo, eece5138-H--). Esta entrada contém a ID e a descrição da regra de segurança acionada enquanto verificava o pedido de HTTP. A ID da regra de segurança é um número inteiro entre aspas, com a id do prefixo entre parêntesis retos (por exemplo: [id "340003"]).',
    'web-app-firewall.auditLogPoint5' => 'Procure uma ID de regra de segurança no evento utilizando uma substring (por exemplo: [id "3).',
    'web-app-firewall.auditLogPoint6' => 'Desative a regra de segurança com este ID na secção de regras de segurança abaixo: insira o ID da regra de segurança (apenas dígitos) no campo de IDs de Regras de Segurança e clique em OK.',
    'web-app-firewall.auditLogViewLink' => 'Ficheiro de Registo do ModSecurity',
    'web-app-firewall.auditLogListLink' => 'Histórico de Registos',
    'web-app-firewall.errorLogSection' => 'Registo de erros',
    'web-app-firewall.errorLogSectionHint' => 'Um site pode parar de funcionar conforme esperado depois de mudar o modo da firewall da aplicação para Ligado, Desligada ou Unicamente detetar. Neste caso, analise o registo de verificação para descobrir o que está a acontecer. Pode desativar regras de segurança restritivas demais ou ajustar o site.',
    'web-app-firewall.errorLogViewLink' => 'Ficheiro de Registo de Erros',
    'web-app-firewall.notificationStateEnabled' => 'As notificações da interface do utilizador Plesk sobre atualizações do conjunto de regras estão ativadas. %%notificationLink%%',
    'web-app-firewall.notificationStateDisabled' => 'As notificações da interface do utilizador Plesk sobre atualizações do conjunto de regras estão desativadas. %%notificationLink%%',
    'web-app-firewall.notificationLink' => 'Faça a respetiva gestão na página de notificações',
    'web-app-firewall.tradeoffAndThoroughModeWarning' => 'Selecionar as opções "Equilibrado" ou "Completo" poderão fazer com que os website WordPress não funcionem corretamente, entre outros efeitos secundários indesejados, devido ao seguinte <a href="https://github.com/SpiderLabs/ModSecurity/issues/562" target="_blank">problema de ModSecurity</a>.',
    'web-app-firewall.fileNotUploaded' => 'O ficheiro não pode ser carregado.',

    'web-server-settings.selectUnitSize' => 'Selecione o tamanho da unidade',
    'web-server-settings.inputSize' => 'Insira tamanho',

    'ProtectedDirectory.pathLabel' => 'Nome do diretório',
    'ProtectedDirectory.realmLabel' => 'Título da área protegida',
    'ProtectedDirectory.locationLabel' => 'Localização do directório',
    'ProtectedDirectory.isNonSslLabel' => 'Não-SSL/TLS',
    'ProtectedDirectory.isCgiBinLabel' => 'cgi-bin',

    'SummaryReport.Layout.name' => 'Nome do relatório',
    'SummaryReport.Layout.isDefault' => 'Utilizar como relatório predefinido',
    'SummaryReport.Layout.sections' => 'Secções',
    'SummaryReport.Layout.general' => 'Geral',
    'SummaryReport.Layout.resellers' => 'Revendedores',
    'SummaryReport.Layout.clients' => 'Clientes',
    'SummaryReport.Layout.personalClients' => 'Clientes pessoais',
    'SummaryReport.Layout.domains' => 'Domínios',
    'SummaryReport.Layout.personalDomains' => 'Domínios directos',
    'SummaryReport.Layout.type.full' => 'Completo',
    'SummaryReport.Layout.type.summary' => 'Resumo',

    'SummaryReport.Schedule.enable' => 'Ativar',
    'SummaryReport.Schedule.period' => 'Frequência da entrega',
    'SummaryReport.Schedule.daily' => 'Diariamente',
    'SummaryReport.Schedule.weekly' => 'Semanalmente',
    'SummaryReport.Schedule.monthly' => 'Mensalmente',
    'SummaryReport.Schedule.email' => 'Entregue',
    'SummaryReport.Schedule.isEmpty' => 'Introduza um endereço de e-mail válido.',

    'MassMailForm.name' => 'Nome do modelo',
    'MassMailForm.fromEmail' => 'De (endereço de email)',
    'MassMailForm.sendToAdmins' => 'Enviar para o administrador Plesk',
    'MassMailForm.sendToResellers' => 'Enviar para revendedores',
    'MassMailForm.sendToClients' => 'Enviar para clientes',
    'MassMailForm.subject' => 'Assunto',
    'MassMailForm.body' => 'Texto da mensagem',
    'MassMailForm.bodyDescription' => '
Poderá utilizar a <name>variável no texto da mensagem (mas não no cabeçalho). Será substituído pelo nome de contacto do cliente ou do revendedor.',
    'MassMailForm.sendToResellersMode' => 'Enviar para',
    'MassMailForm.sendToResellersModeAll' => 'Todos os revendedores',
    'MassMailForm.sendToResellersModeSelect' => 'Revendedores seleccionados',
    'MassMailForm.sendToResellersModeExcept' => 'Todos menos revendedores selecionados',
    'MassMailForm.sendToClientsMode' => 'Enviar para',
    'MassMailForm.sendToClientsModeAll' => 'Todos os clientes',
    'MassMailForm.sendToClientsModeSelect' => 'Clientes selecionados',
    'MassMailForm.sendToClientsModeExcept' => 'Todos menos clientes selecionados',

    'VirtualDirectory.DirectorySection.title' => 'Diretório Virtual',
    'VirtualDirectory.DirectorySection.name' => 'Nome',
    'VirtualDirectory.DirectorySection.accessSource' => 'Acesso à fonte do Script',
    'VirtualDirectory.DirectorySection.accessRead' => 'Autorização de leitura',
    'VirtualDirectory.DirectorySection.accessWrite' => 'Autorização de escrita',
    'VirtualDirectory.DirectorySection.enableDirBrowsing' => 'Browsing do Diretório',
    'VirtualDirectory.DirectorySection.log' => 'Log das visitas',
    'VirtualDirectory.Path.path' => 'Caminho',
    'VirtualDirectory.Path.autoPathLabel' => 'Criar um diretório físico com o mesmo nome do diretório virtual',
    'VirtualDirectory.ApplicationSettingsSection.title' => 'Configurações da Aplicação',
    'VirtualDirectory.ApplicationSettingsSection.appCreate' => 'Criar aplicação',
    'VirtualDirectory.ApplicationSettingsSection.aspEnableParentPaths' => 'Permitir a utilização de caminhos parentais',
    'VirtualDirectory.ApplicationSettingsSection.aspExecuteInMTA' => 'Permitir correr a aplicação em modo MTA (multi-threaded apartment)',
    'VirtualDirectory.ScriptExecuteField.scriptExecute' => 'Permissões de Execução',
    'VirtualDirectory.SecuritySection.title' => 'Segurança do Directório',
    'VirtualDirectory.SecuritySection.authAnonymous' => 'Ativa a autenticação anónima',
    'VirtualDirectory.SecuritySection.authNTLM' => 'Ativa a autenticação pelo Windows',
    'VirtualDirectory.SecuritySection.requireSSL' => 'Exigir SSL/TLS',
    'VirtualDirectory.scriptExecuteOption.none' => 'Nenhum',
    'VirtualDirectory.scriptExecuteOption.script' => 'Só Scripts',
    'VirtualDirectory.scriptExecuteOption.scriptExecute' => 'Scripts e Executáveis',
    'VirtualDirectory.AspSection.title' => 'Definições de ASP',
    'VirtualDirectory.AspSection.aspBufferingLimit' => 'Tamanho máximo da buffer de ASP (KB)',
    'VirtualDirectory.AspSection.aspMaxRequestEntityAllowed' => 'Tamanho máximo do corpo de um pedido em ASP (KB)',
    'VirtualDirectory.AspSection.aspEnableServerDebug' => 'Permitir o debugging do script pelo lado do servidor de ASP',
    'VirtualDirectory.AspSection.aspEnableClientDebug' => 'Permitir o debugging do script pelo lado do cliente de ASP',
    'VirtualDirectory.AspSection.definedByIis' => 'Definido pelo IIS',
    'VirtualDirectory.AspSection.definedByIisWithSize' => 'Definido pelo IIS (%%size%% KB)',
    'VirtualDirectory.AspSection.definedByParent' => 'Definido pelo directório pai',
    'VirtualDirectory.AspSection.definedByParentWithSize' => 'Definido pelo directório pai (%%size%% KB)',
    'VirtualDirectory.AspSection.kbytes' => 'KB',
    'VirtualDirectory.CheckboxField.true' => 'Sim',
    'VirtualDirectory.CheckboxField.false' => 'Não',
    'VirtualDirectory.DocumentsSection.title' => 'Documentos',
    'VirtualDirectory.DocumentsSection.enableDefaultDoc' => 'Utilizar os documentos predefinidos',
    'VirtualDirectory.DefaultDocsField.defaultDocs' => 'Ordem de procura dos documentos predefinida',
    'VirtualDirectory.DefaultDocsField.remove' => 'Eliminar',
    'VirtualDirectory.NewDefaultDoc.add' => 'Adicionar',
    'VirtualDirectory.NewDefaultDoc.addTooltip' => 'Clique para adicionar um ficheiro à lista.',
    'VirtualDirectory.NewDefaultDoc.requiredWarning' => 'Introduza o nome do ficheiro a adicionar à lista.',
    'VirtualDirectory.PhysicalDirectoryConflictDialog.description' => 'Já existe um diretório físico com esse nome. Se continuar, este ficará inacessível. Deseja avançar?',
    'VirtualDirectory.PhysicalDirectoryConflictDialog.proceed' => 'Avançar',

    'VirtualDirectoryMimeType.extension' => 'Extensão',
    'VirtualDirectoryMimeType.content' => 'Conteúdo',
    'VirtualDirectoryMimeType.custom' => 'Personalizado',
];
