<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Dodatkowe właściwości klucza',
    'additional-key-info.update' => 'Pobierz dodatkowy klucz',
    'additional-key-info.updateDescription' => 'Pobierz dodatkowe klucze i zainstaluj je.',
    'additional-key-info.download' => 'Pobierz klucz',
    'additional-key-info.downloadDescription' => 'Kliknij, aby pobrać aktualny klucz licencyjny.',
    'additional-key-info.install' => 'Zainstaluj klucz',
    'additional-key-info.installDescription' => 'Zainstaluj aktualny klucz licencyjny.',
    'additional-key-info.revert' => 'Przywróć klucz',
    'additional-key-info.revertDescription' => 'Przywróć poprzednio zainstalowany klucz licencyjny.',
    'additional-key-info.revertNotAvailableDescription' => 'Nie znaleziono żadnego starego klucza.',
    'additional-key-info.installSuccess' => 'Rozpoczęto instalację klucza licencyjnego.',

    'additional-key-revert.title' => 'Dodatkowe cofanie klucza',
    'additional-key-revert.success' => 'Dodatkowy klucz został wycofany.',

    'additional-key-upload.title' => 'Zainstaluj klucz licencyjny',
    'additional-key-upload.success' => 'Nowy klucz dodatkowy został załadowany.',

    'additional-keys.title' => 'Dodatkowe klucze licencji',

    'change-subscriptions-owner.title' => 'Zmiana przypisania wybranych subskrypcji',
    'change-subscriptions-owner.success' => 'Zmieniono właściciela domeny',

    'customers.hint' => 'Tutaj możesz zarządzać serwerem, konfigurować panel, usługi systemowe i zasoby: tutaj możesz tworzyć konta wraz z subskrypcjami usług, zarządzać istniejącymi klientami oraz usuwać konta. Aby administrować stronami WWW, pocztą lub innymi usługami dostępnymi dla klienta, idź do Panelu klienta, klikając link w prawej kolumnie listy.',

    'customer-domains.hint' => 'Tutaj należy konfigurować serwisy WWW oraz zarządzać nimi.',

    'customer-subscriptions.hint' => 'Tutaj możesz zarządzać subskrypcjami klienta.',

    'domains.hint' => 'Tutaj możesz zobaczyć informacje o wszystkich nazwach domen zarejestrowanych w systemie i możesz przejść do zarządzania usługami hostingowymi. Aby dodać domenę dla siebie lub do klientów hostingu, kliknij Dodaj domenę. Otrzymasz podpowiedź utworzenia nowego klienta oraz subskrypcji podczas tworzenia domeny lub wybrania istniejącej.',

    'database-servers.title' => 'Serwery baz danych',

    'database-server-create.title' => 'Nowy serwer baz danych',

    'database-server-properties.title' => 'Serwer bazy danych',

    'database-server-upgrade.drawerTitle' => 'Aktualizacja MariaDB',
    'database-server-upgrade.drawerTitle.completed' => 'Aktualizacja zakończona',
    'database-server-upgrade.drawerSubTitle.line1' => 'Nie można zamknąć tego okna podczas aktualizacji.',
    'database-server-upgrade.drawerSubTitle.line2' => 'Jeśli podczas aktualizacji wystąpią problemy, wykorzystaj %%troubleshootingArticle%%.',
    'database-server-upgrade.drawerSubTitle.completed' => 'Serwer bazy danych MariaDB został zaktualizowany do wersji %%releaseVersion%%. Jeśli napotkasz jakiekolwiek problemy, postępuj zgodnie z instrukcjami, które zawiera %%troubleshootingArticle%%.',
    'database-server-upgrade.upToDate' => 'Masz już zainstalowaną wersję LTS.',
    'database-server-upgrade.troubleshootingArticle' => 'ten artykuł z bazy wiedzy',
    'database-server-upgrade.troubleshootingArticleDescription' => 'Wykorzystaj %%troubleshootingArticle%%, aby rozwiązać problemy z aktualizacją MariaDB.',

    'database-server-upgrade.chooseReleaseStep.infoBlock.par1' => 'Zaktualizuj lokalny serwer bazy danych MariaDB do aktualnej wersji z długoterminowym wsparciem (LTS).',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par2' => 'Zdecydowanie zalecamy utworzenie kopii zapasowej serwera przed aktualizacją i rozpoczęcie aktualizacji poza godzinami szczytu działania witryn internetowych.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par3' => 'Podczas aktualizacji MariaDB serwer Plesk i hostowane strony internetowe będą niedostępne. Aktualizacja MariaDB jest zwykle bezbłędna i zajmuje około 10 minut, ale nadal może mieć wpływ na cały serwer.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par4' => 'Uwaga: jeśli korzystasz z MariaDB 5.5, Plesk najpierw zaktualizuje ją do MariaDB 10.5. Po zakończeniu aktualizacji uruchom ponownie tego kreatora, aby zaktualizować MariaDB do bieżącej wersji LTS.',
    'database-server-upgrade.chooseReleaseStep.currentVersionTitle' => 'Obecna wersja',
    'database-server-upgrade.chooseReleaseStep.currentMariaDBVersion' => 'MariaDB %%version%%',
    'database-server-upgrade.chooseReleaseStep.selectVersion' => 'Wybierz wersję, do której chcesz dokonać aktualizacji',
    'database-server-upgrade.chooseReleaseStep.noMajorReleases' => 'Nie ma żadnych większych wydań',
    'database-server-upgrade.chooseReleaseStep.releaseNotes' => 'Informacje o wydaniu',
    'database-server-upgrade.chooseReleaseStep.releaseDate' => 'Data wydania: %%date%%',
    'database-server-upgrade.chooseReleaseStep.endOfLifeDate' => 'Data końca życia: %%date%%',
    'database-server-upgrade.chooseReleaseStep.notDetected' => 'Aktualizować można wyłącznie wersje MariaDB dostarczane przez dostawców systemów operacyjnych lub dostawców MariaDB.',

    'database-server-upgrade.preUpgradeCheckProgressStep.title' => 'Kontrole przed aktualizacją',
    'database-server-upgrade.preUpgradeCheckProgressStep.configChecker' => 'Analizowanie plików konfiguracyjnych MariaDB',
    'database-server-upgrade.preUpgradeCheckProgressStep.mysqlChecker' => 'Analiza baz danych za pomocą mysqlcheck',
    'database-server-upgrade.preUpgradeCheckProgressStep.packageManagerChecker' => 'Analizowanie konfiguracji menedżera pakietów',
    'database-server-upgrade.preUpgradeCheckProgressStep.systemCompatibilityChecker' => 'Sprawdzanie kompatybilności systemu',
    'database-server-upgrade.preUpgradeCheckProgressStep.webSocketChecker' => 'Sprawdzanie protokołu WebSocket',

    'database-server-upgrade.preUpgradeCheckStep.shouldBeConfirmed' => 'Aby kontynuować aktualizację, zaznacz wszystkie pola wyboru. Konieczne jest upewnienie się, że zgadzasz się ze zmianami konfiguracji, jakie spowoduje aktualizacja i że masz dostęp do opcji odzyskiwania.',
    'database-server-upgrade.preUpgradeCheckStep.removedSystemVariables' => 'Następujące zmienne zostaną usunięte w celu zapewnienia zgodności z nową wersją:',
    'database-server-upgrade.preUpgradeCheckStep.removedConfigFiles' => 'Poniższe pliki konfiguracyjne zostaną usunięte, ponieważ są częścią pakietu mariadb-server, który zostanie uaktualniony:',
    'database-server-upgrade.preUpgradeCheckStep.fromFiles' => '{variable} z {count, plural, one {pliku: {files}} few {# plików: {files}} many {# plików: {files}} other {# plików: {files}}}',
    'database-server-upgrade.preUpgradeCheckStep.accessToolsSection' => 'Dostęp do opcji odzyskiwania (konsola wiersza poleceń serwera i Zestaw Naprawczy)',
    'database-server-upgrade.preUpgradeCheckStep.sshAccess' => 'Potwierdzam, że mam dostęp SSH do serwera',
    'database-server-upgrade.preUpgradeCheckStep.sshAccessDescription' => 'Użyj klienta SSH lub otwórz %%sshTerminalExtension%% w nowej karcie przeglądarki (nie zamykaj okna rozszerzenia SSH Terminal do czasu zakończenia aktualizacji). Jeśli aktualizacja się nie powiedzie, dostęp do SSH pomoże w odzyskaniu danych.',
    'database-server-upgrade.preUpgradeCheckStep.sshTerminalExtension' => 'Rozszerzenie terminala SSH',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccess' => 'Potwierdzam, że mam dostęp do Zestawu Naprawczego',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccessDescription' => 'Otwórz %%repairKit%% w nowej karcie przeglądarki i zaloguj się przy użyciu danych administratora. Nie zamykaj karty Repair Kit, dopóki aktualizacja nie będzie ukończona.',
    'database-server-upgrade.preUpgradeCheckStep.repairKit' => 'Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.dumpSection' => 'Stwórz kopie zapasowe baz danych',
    'database-server-upgrade.preUpgradeCheckStep.withDump' => 'Przed aktualizacją wykonaj kopię zapasową wszystkich baz danych hostowanych na serwerze',
    'database-server-upgrade.preUpgradeCheckStep.withDumpDescription' => 'Plesk będzie przechowywać kopię zapasową baz danych w katalogu %%path%%.',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailable' => 'WebSocket w Plesku nie jest dostępny',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailableDescription' => 'Bez protokołu WebSocket nie będzie można zobaczyć wyników procesu aktualizacji w czasie rzeczywistym.',

    'database-server-upgrade.submitPopover.title' => 'Aby zapobiec potencjalnej utracie danych, zdecydowanie zalecamy utworzenie zrzutu hostowanych baz danych przed kontynuowaniem. Kontynuować bez tworzenia zrzutu?',

    'database-server-databases.title' => 'Bazy danych',

    'database-server-change-password.title' => 'Hasło administratora',

    'home.title' => 'Start',

    'license.title' => 'Informacje na temat licencji',

    'primary-key-info.title' => 'Klucz licencji Plesk',
    'primary-key-info.update' => 'Odzyskaj klucze',
    'primary-key-info.updateDescription' => 'Pobierz i zainstaluj zamówiony klucz licencji.',
    'primary-key-info.upload' => 'Zainstaluj klucz',
    'primary-key-info.uploadDescription' => 'Kliknij, aby wgrać i zainstalować nowy klucz licencji.',
    'primary-key-info.revert' => 'Przywróć klucz',
    'primary-key-info.revertDescription' => 'Przywróć poprzednio zainstalowany klucz licencyjny.',
    'primary-key-info.expireTitle' => 'Twoja licencja Plesk wygasła',
    'primary-key-info.header' => 'Z tego powodu niektóre krytyczne usługi stały się niedostępne. %%warning%%',
    'primary-key-info.headWarning' => 'Twoje strony internetowe mogą być zagrożone!',
    'primary-key-info.softwareUpdatesTitle' => 'Aktualizacje oprogramowania',
    'primary-key-info.softwareUpdates' => '%%title%% są wyłączone. Twój system może być podatny na zagrożenia.',
    'primary-key-info.websiteBackupsTitle' => 'Kopie zapasowe witryny',
    'primary-key-info.websiteBackups' => '%%title%% nie są już dostępne. Grozi Ci utrata danych.',
    'primary-key-info.sslCertificatesTitle' => 'Ceryfikaty SSL/TLS',
    'primary-key-info.sslCertificates' => '%%title%% nie zostaną odnowione automatycznie. Może to zagrozić bezpieczeństwu i zaufaniu.',
    'primary-key-info.monitoringTitle' => 'Monitoring',
    'primary-key-info.monitoring' => '%%title%% jest niedostępny. Przeciążenia i problemy z wydajnością mogą pozostać niezauważone.',
    'primary-key-info.fileDbManagementTitle' => 'Zarządzanie plikami i bazami danych',
    'primary-key-info.fileDbManagement' => '%%title%% jest wyłączone. Nie da się efektywnie zarządzać plikami i bazami danych.',
    'primary-key-info.technicalSupportTitle' => 'Wsparcie techniczne',
    'primary-key-info.technicalSupport' => '%%title%% jest niedostępne. Utrata dostępu do niezbędnej pomocy w przypadku problemów z serwerem może prowadzić do przedłużających się przestojów.',
    'primary-key-info.renewLicense' => 'Aby przywrócić te usługi, kup teraz nową licencję Plesk.',
    'primary-key-info.footer' => 'W przypadku jakichkolwiek pytań lub pomocy, ',
    'primary-key-info.supportLink' => 'skontaktuj się z obsługą Pleska',

    'primary-key-revert.title' => 'Przywrócenie klucza',
    'primary-key-revert.success' => 'Klucz Pleska został wycofany.',

    'primary-key-upload.title' => 'Zainstaluj klucz licencyjny',
    'primary-key-upload.success' => 'Nowy klucz Plesk został załadowany.',

    'resellers.hint' => 'Tutaj możesz zarządzać kontami sprzedawców – twoich klientów, którzy sprzedają usługi hostingowe i hostują swoje własne strony WWW. Tutaj możesz tworzyć konta wraz z subskrypcjami usług, zarządzać istniejącymi sprzedawcami oraz usuwać konta.',

    'reseller-customers.hint' => 'Tutaj konfigurujesz klientów i zarządzasz nimi.',

    'reseller-domains.hint' => 'Tutaj należy konfigurować serwisy WWW oraz zarządzać nimi.',

    'reseller-subscriptions.hint' => 'Tutaj możesz zarządzać subskrypcjami sprzedawcy.',

    'subscriptions.hint' => 'Klienci otrzymują od ciebie usługi hostingowe poprzez subskrypcję planów hostingowych. Tutaj możesz zarządzać tymi subskrypcjami, jak i tymi, które stworzysz, aby hostować swoje własne strony WWW. Aby administrować serwisy, pocztę lub inne usługi dostępne w tej subskrypcji, przejdź do Panelu klienta subskrybenta, klikając link w prawej kolumnie listy.',

    'server-mail-settings.title' => 'Ustawienia',
    'server-mail-spam-filter.title' => 'Filtrowanie spamu',
    'server-mail-antivirus.title' => 'Antywirus',
    'server-mail-black-list.title' => 'Czarna lista',
    'server-mail-white-list.title' => 'Biała lista',
    'server-mail-queue.title' => 'Kolejka poczty',
    'server-mail-statistics.title' => 'Statystyki',
    'server-mail-smarthost.title' => 'Inteligentny host',

    'server-spam-filter.settings' => 'Ustawienia',
    'server-spam-filter.black-list' => 'Czarna lista',
    'server-spam-filter.white-list' => 'Biała lista',

    'firewall.title' => 'Zarządzanie Zaporą Ogniową',
    'firewall-general.title' => 'Ogólny',
    'firewall-general.toggleStatus' => 'Ochrona firewall',
    'firewall-general.buttonDefault' => 'Przywróć ustawienia domyślne',
    'firewall-general.buttonPanic' => 'Tryb Paniki',
    'firewall-general.confirmationDefault' => 'Czy na pewno chcesz przywrócić domyślne ustawienia zapory ogniowej?',
    'firewall-general.confirmationPanic' => 'Włączyć tryb paniki? Użytkownicy nie będą mogli uzyskać dostępu do swoich domen, a niektóre usługi sieciowe mogą przestać działać.',
    'firewall-general.successDefault' => 'Ustawienia zapory zostały zresetowane do wartości domyślnych.',
    'firewall-general.successPanic' => 'Włączono tryb paniki.',
    'firewall-general.info' => 'Ze względów bezpieczeństwa zapora blokuje wszystkie połączenia z wyjątkiem tych wyraźnie dozwolonych. Możesz zezwolić na połączenie, tworząc regułę. Więcej informacji można znaleźć w dokumentacji',
    'firewall-general.interfaces' => 'Interfejsy sieciowe',
    'firewall-icmp.title' => 'Protokołów ICMP',
    'firewall-rules.title' => 'Reguły zapory ogniowej',

    'dns.title' => 'Ustawienia DNS',
    'dns-records.title' => 'Szablon rekordów strefy',
    'dns-soa-record.title' => 'Szablon ustawień strefy',

    'php-handler.title' => 'Ustawienia dla %%name%%',
    'php-handler.extensions.title' => 'Rozszerzenia',
    'php-handler.extensions.description' => 'Te ustawienia rozszerzeń PHP są tylko dla tego uchwytu.',
    'php-handler.extensions.descriptionShared' => 'Te ustawienia są wspólne dla następujących uchwytów PHP: %%handlers%%. Ustawienia mają zastosowanie do wszystkich serwisów WWW, które używają tych uchwytów.',
    'php-handler.extensions.buttonManage' => 'Zarządzaj pakietami PECL',
    'php-handler.extensions.manage.title' => 'Zarządzaj pakietami PECL',
    'php-handler.extensions.manage.risks' => 'Rozszerzenia PHP są dostarczane przez pakiety PECL innych firm. Instalujesz je na własne ryzyko.',
    'php-handler.extensions.manage.description' => 'Instaluj, aktualizuj i odinstaluj pakiety PECL. Zmiany zostaną zastosowane do wszystkich witryn działających na %%handlers%%.',
    'php-handler.extensions.manage.notFound' => 'Dlaczego żądanego pakietu nie ma na liście?',
    'php-handler.extensions.manage.limitations' => 'Rozszerzenia PHP dostarczane przez dostawcę panelu sterowania i dostawców systemu operacyjnego nie są wyświetlane na liście.',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.refresh' => "Odśwież",
    'ServerInformation.sectionGeneral' => "Ogólny",
    'ServerInformation.cpu' => "CPU",
    'ServerInformation.version' => "Wersja",
    'ServerInformation.os' => "System operacyjny",
    'ServerInformation.key' => "Klucz licencji Plesk",
    'ServerInformation.uptime' => "Czas działania",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} one {# dzień} few {# dni} many {# dni} other {# dni}} {hours, plural, one {# godzina} few {# godziny} many {# godzin} other {# godzin}} {minutes, plural, one {# minuta} few {# minuty} many {# minut} other {# minut}}",
    'ServerInformation.sectionCpu' => "Użycie CPU",
    'ServerInformation.la1min' => "Ostatnia 1 minuta",
    'ServerInformation.la5min' => "Ostatnie 5 minut",
    'ServerInformation.la15min' => "Ostatnie 15 minut",
    'ServerInformation.sectionMemory' => "Użycie pamięci",
    'ServerInformation.memoryHardware' => "Sprzęt",
    'ServerInformation.memoryTotalNoKernel' => "Razem (bez jądra)",
    'ServerInformation.memoryTotal' => "Suma",
    'ServerInformation.memoryUsed' => "Zużyto",
    'ServerInformation.memoryFree' => "Pusty",
    'ServerInformation.memoryShared' => "Współdzielony",
    'ServerInformation.memoryBuffer' => "Bufor",
    'ServerInformation.memoryCached' => "W pamięci podręcznej",
    'ServerInformation.memoryAvailable' => "Dostępne",
    'ServerInformation.memoryUsage' => "Użycie",
    'ServerInformation.sectionSwap' => "Użycie swapu",
    'ServerInformation.sectionVirtualMemory' => "Użycie Pamięci Wirtualnej",
    'ServerInformation.swapTotal' => "Suma",
    'ServerInformation.swapUsed' => "Zużyto",
    'ServerInformation.swapFree' => "Pusty",
    'ServerInformation.swapUsage' => "Użycie",
    'ServerInformation.sectionHarddisk' => "Użycie dysku",
    'ServerInformation.harddiskDirectory' => "System plików",
    'ServerInformation.harddiskProtectedDir' => "Ważne katalogi",
    'ServerInformation.harddiskTotal' => "Suma",
    'ServerInformation.harddiskUsed' => "Zużyto",
    'ServerInformation.harddiskAvailable' => "Dostępne",
    'ServerInformation.harddiskCapacity' => "Pojemność",
    'ServerInformation.sectionDomains' => "Domeny",
    'ServerInformation.activeDomains' => "Aktywna",
    'ServerInformation.inactiveDomains' => "Nieaktywna",
    'ServerInformation.problemDomains' => "Problemy",
    'ServerInformation.refreshed' => "Dane odświeżone.",

    'ServerAbout.copyright' => '© 2026 WebPros International GmbH. Wszelkie prawa zastrzeżone.',
    'ServerAbout.linkLicenseManagement' => 'Przejdź do informacje na temat licencji',
    'ServerAbout.panelVersion' => 'Wersja',
    'ServerAbout.installedPatchVersion' => 'Zaktualizuj #%%patch%%',
    'ServerAbout.licenseKey' => 'Klucz licencji',
    'ServerAbout.productDescription' => 'Plesk jest wiodącą platformą WebOps do uruchamiania, automatyzacji i rozwoju aplikacji, stron www i hostingu firm.',
    'ServerAbout.readEula' => 'Przeczytaj %%link%%.',
    'ServerAbout.linkEula' => 'Umowa licencyjna użytkownika końcowego',
    'ServerAbout.visitForum' => 'Odwiedź %%link%%',
    'ServerAbout.linkForum' => 'Forum Plesk',
    'ServerAbout.followUs' => 'Śledź nas',
    'ServerAbout.visitSite' => 'Dowiedz się więcej tu: %%link%%',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => 'Znajdź inspiracje tu %%link%%',
    'ServerAbout.linkBlog' => 'Blog Plesk',
    'ServerAbout.ip2locationCopyright' => 'Plesk używa bazy danych IP2Location LITE dla %%link%%.',
    'ServerAbout.linkGeolocation' => 'geolokalizacji IP',

    'ServerAbout.darkThemePromoTitle' => 'Gratulacje!',
    'ServerAbout.darkThemePromoDescription' => 'Znalazłeś magicznego kotka.',
    'ServerAbout.darkThemePromoButton' => 'Abrakadabra! Przejdź na ciemną stronę',
    'ServerAbout.darkThemeTourDescription' => 'Przełącz tę opcję, aby włączyć lub wyłączyć ciemny motyw interfejsu.',
    'ServerAbout.darkThemeTourButton' => 'Rozumiem',

    'ts-sessions.title' => 'Sesje serwera terminali',
    'ts-sessions-properties.title' => 'Właściwości sesji ',

    'BandwidthLimiting.bandwidthThrottling' => 'Nie możesz kontrolować ograniczeń łącza ponieważ QoS nie jest zainstalowany.',
    'BandwidthLimiting.virtualHostingRequired' => 'Ograniczenie przepustowości jest dostępne tylko dla domen z hostingiem.',
    'BandwidthLimiting.bandwidthLabel' => 'Ogranicz prędkość połączenia do',
    'BandwidthLimiting.bandwidthHint' => 'Limit wykorzystania przepustowości dotyczy tylko danych przesyłanych przez protokół HTTP.',
    'BandwidthLimiting.maxConnectionLabel' => 'Liczba połączeń ograniczona do',
    'BandwidthLimiting.maxConnectionHint' => 'W przypadku ograniczenia przepustowości zalecamy również ograniczenie liczby jednoczesnych połączeń z witryną. W przeciwnym razie, w przypadku częstych zapytań do witryny, procesy serwera WWW zwiększą obciążenie serwera.',
    'BandwidthLimiting.kbps' => 'KB/s',
    'BandwidthLimiting.success' => 'Ustawienia ograniczenia przepustowości zostały zmienione.',
    'BandwidthLimiting.unlimited' => 'Nieograniczone',

    'ip-address-domains.title' => 'Serwisy używające adresu IP %%type%% - %%ipAddress%%',
    'ip-address-domains.site' => 'Strona',
    'ip-address-domains.setAsDefault' => 'Ustaw jako domyślny',
    'ip-address-domains.type-SHARED' => 'współdzielony',
    'ip-address-domains.type-EXCLUSIVE' => 'dedykowany',

    'HotlinkProtection.virtualHostingRequired' => 'Ochrona przed hotlinkowaniem jest dostępna tylko dla domen z hostingiem.',
    'HotlinkProtection.enabledLabel' => 'Włącz ochronę przed hotlinkowaniem',
    'HotlinkProtection.extensionsLabel' => 'Rozszerzenia plików chronionych',
    'HotlinkProtection.friendsLabel' => 'Przyjazne domeny',
    'HotlinkProtection.success' => 'Ustawienia ochrony przed hotlinkowaniem zostały zmienione.',

    'Odbc.add' => 'Dodaj ODBC DSN',
    'Odbc.resourceUsage' => '%%used%% utworzony / %%allowed%% dozwolony.',
    'Odbc.limitExceeded' => 'Przekroczono limit połączenia ODBC DSN.',
    'Odbc.unlimited' => 'Nieograniczone',
    'Odbc.addTooltip' => 'Dodaj źródło danych ODBC.',
    'Odbc.status' => 'Status',
    'Odbc.name' => 'Nazwa połączenia',
    'Odbc.driver' => 'Sterownik',
    'Odbc.description' => 'Opis połączenia',
    'Odbc.hostname' => 'Nazwa hosta',
    'Odbc.statusSystem' => 'To jest DSN systemowy.',
    'Odbc.statusConfigured' => 'DSN jest skonfigurowany.',
    'Odbc.statusNotConfigured' => 'DSN jest nieskonfigurowany.',
    'Odbc.noSelectionText' => 'Wybierz jeden lub więcej elementów do usunięcia.',
    'Odbc.removeConfirmation' => 'Usunąć {count, plural, =1 {połączenie {name}} other {# wybrane połączenia}}?',
    'Odbc.removeSuccess' => 'Wybrane połączenia zostały usunięte.',

    'DomainAliasSettings.title' => 'Ustawienia aliasu domeny',
    'DomainAliasSettings.updateSuccess' => 'Właściwości aliasu domeny %%name%% zostały zmienione. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'Ustawienia strony będą zastosowane za %%restartInterval%% minut.',

    'Home.Backup.offStatus' => 'To nie jest prawidłowa kopia zapasowa. Nie można przywrócić danych z tego pliku.',
    'Home.Backup.task-failedStatus' => 'Zadanie kopii zapasowej nie powiodło się.',
    'Home.Backup.activeSchedule' => 'Zaplanuj: %%schedule%%',
    'Home.Backup.activeSchedules' => 'Zaplanowane: %%schedules%%',
    'Home.Backup.noSchedule' => "Harmonogram tworzenia kopii zapasowych nie jest ustawiony",
    'Home.Backup.period_hourly' => 'Godzinowy %%schedule%%',
    'Home.Backup.period_daily' => 'Dzienny %%schedule%%',
    'Home.Backup.period_weekly' => 'Tygodniowy %%schedule%%',
    'Home.Backup.period_monthly' => 'Miesięczny %%schedule%%',
    'Home.Backup.create' => 'Utwórz kopię zapasową',
    'Home.Backup.schedule' => 'Plan zajęć',
    'Home.ChangeLog.seeHistory' => 'Zobacz historię zmian',
    'Home.CustomButtons.add' => 'Dodaj dowolny przycisk',
    'Home.CustomButtons.noButtons' => 'Brak własnych przycisków',
    'Home.Customization.title' => 'Dashboard',
    'Home.Customization.description' => 'Wybierz, które opcje chcesz zobaczyć',
    'Home.Customization.pleskSection' => 'Plesk',
    'Home.Customization.serverSection' => 'Serwer',
    'Home.Customization.securitySection' => 'Bezpieczeństwo',
    'Home.Customization.backup' => 'Ostatnia kopia zapasowa serwera',
    'Home.Customization.ipBan' => 'Blokowanie adresu IP',
    'Home.Customization.mailQueue' => 'Kolejka poczty',
    'Home.Customization.mySubscriptions' => 'Moje subskrypcje',
    'Home.Customization.overusedSubscriptions' => 'Subskrypcje z nadużyciem',
    'Home.Customization.serverInfo' => 'Informacje o serwerze',
    'Home.Customization.updates' => 'Aktualizacje Plesk',
    'Home.Customization.promo' => 'Promocja',
    'Home.Customization.changeLog' => 'Co nowego',
    'Home.Customization.customButtons' => 'Własne przyciski',
    'Home.Customization.drag' => 'Przeciągnij, aby przenieść panel',
    'Home.EmptyView.title' => 'Wykorzystaj w pełni swój pulpit główny, wybierając opcje, które mają być widoczne.',
    'Home.EmptyView.titleLocked' => 'Pulpit główny jest zablokowany przez usługodawcę.',
    'Home.EmptyView.customize' => 'Dostosuj',
    'Home.Extension.title' => 'Rozszerzenie',
    'Home.IpBan.banned' => 'Zabronione',
    'Home.IpBan.trusted' => 'Zaufane',
    'Home.IpBan.more' => 'Pokaż więcej',
    'Home.MailQueue.total' => 'Suma',
    'Home.MailQueue.deferred' => 'Odroczone',
    'Home.MailQueue.held' => 'Wstrzymane',
    'Home.MailQueue.more' => 'Pokaż więcej',
    'Home.MailQueue.clean' => 'Wyczyść kolejkę poczty',
    'Home.MailQueue.checkLogs' => 'Sprawdź logi',
    'Home.MailQueue.repair' => 'Naprawa',
    'Home.MailQueue.cleanConfirmQuestion' => 'Wyczyścić kolejkę poczty?',
    'Home.MailQueue.cleanConfirmYes' => 'Tak',
    'Home.MailQueue.cleanConfirmNo' => 'Nie',
    'Home.MailQueue.queueCleaned' => 'Wyszyszczono kolejkę maili.',
    'Home.OverusedSubscriptions.empty' => 'Nie znaleziono subskrypcji z nadużyciem',
    'Home.OverusedSubscriptions.usage' => '%%formattedUsed%% z %%formattedValue%%',
    'Home.OverusedSubscriptions.more' => 'Zobacz wszystkie z nadużyciem: [%%total%%]',
    'Home.OverusedSubscriptions.list' => 'Otwórz na liście',
    'Home.ServerInfo.hostname' => 'Nazwa hosta',
    'Home.ServerInfo.copyHostname' => 'Kopiuj nazwę hosta',
    'Home.ServerInfo.ipAddress' => 'Adres IP',
    'Home.ServerInfo.copyIpAddress' => 'Skopiuj adres IP',
    'Home.ServerInfo.publicIpAddress' => 'Publiczny adres IP',
    'Home.ServerInfo.copyPublicIpAddress' => 'Skopiuj publiczny adres IP',
    'Home.ServerInfo.os' => 'OS',
    'Home.ServerInfo.copyOs' => 'Skopiuj system operacyjny',
    'Home.ServerInfo.uptime' => 'Czas działania',
    'Home.ServerInfo.uptimeValue' => "{days, plural, =0 {} one {# dzień} few {# dni} many {# dni} other {# dni}} {hours, plural, one {# godzina} few {# godziny} many {# godzin} other {# godzin}} {minutes, plural, one {# minuta} few {# minuty} many {# minut} other {# minut}}",
    'Home.ServerInfo.more' => 'Pokaż więcej',
    'Home.Subscriptions.add' => 'Dodaj nowy',
    'Home.Subscriptions.empty' => 'Twórz subskrypcje, aby hostować wiele witryn internetowych w izolowanej przestrzeni na serwerze. %%link%%',
    'Home.Subscriptions.help' => 'Dowiedz się więcej',
    'Home.Updates.title' => 'Aktualizacje produktów',
    'Home.Updates.version' => '%%name%% %%version%%',
    'Home.Updates.patch' => '%%version%% Aktualizacja #%%patch%%',
    'Home.Updates.manageComponents' => 'Dodaj lub usuń komponenty',
    'Home.Updates.lastUpdated' => 'Ostatnio zaktualizowano w dniu %%lastUpdateDate%%',
    'Home.Updates.checkUpdates' => 'Sprawdź aktualizacje',
    'Home.Updates.enableAutoupdate' => 'Zezwalaj na automatyczne aktualizacje',
    'Home.Updates.lastChecked' => 'Ostatnio sprawdzone w dniu %%lastCheckDate%%',
    'Home.Updates.newVersionAvailable' => '%%availableVersion%% jest dostępna',
    'Home.Updates.installNewVersion' => 'Zainstaluj teraz',
    'Home.Updates.patchAvailable' => 'Dostępne są drobne aktualizacje',
    'Home.Updates.patchAvailableVersion' => 'Dostępne są drobne aktualizacje dla %%currentVersion%%',
    'Home.Updates.installPatch' => 'Aktualizuj teraz',
    'Home.Updates.pumUpdates' => '{total, select, 1 {Aktualizacja dla {package} jest dostępna} other {Aktualizacje dla {package} są dostępne}}',
    'Home.Updates.pumPackage' => '%%name%% %%availableVersion%%',
    'Home.Updates.pumPackages' => '{total, plural, one {# paczka} few {# paczki} many {# paczek} other {# paczek}}',
    'Home.Updates.installUpdates' => '{total, select, 1 {Zaktualizuj teraz} other {Zaktualizuj wszystko}}',
    'Home.Promo.close' => 'Zamknij blok',
    'Home.Promo.viewSlide' => 'Wyświetl slajd %%slideNumber%%',
    'Home.Promo.Customize.title' => 'Stwórz swój własny pulpit główny!',
    'Home.Promo.Customize.content' => 'Twoje ulubione funkcje w zasięgu ręki dzięki nowemu, konfigurowalnemu pulpitowi głównemu',
    'Home.Promo.Customize.action' => 'Dostosuj',
    'Home.Promo.SwitchToPuv.title' => 'Czy znasz widoki interfejsu w Plesku?',
    'Home.Promo.SwitchToPuv.content' => 'Jeśli nie świadczysz usług hostingowych swoim klientom, korzystając z planów usług, możesz wypróbować interfejs, który jest wygodniejszy do zarządzania witrynami internetowymi, ich plikami, bazami danych, kontami e-mail i aplikacjami internetowymi.',
    'Home.Promo.SwitchToPuv.action' => 'Spróbuj teraz',
    'Home.Status.error' => 'Błąd',
    'Home.Status.warning' => 'Ostrzeżenie',
    'Home.Status.info' => 'Informacja',

    'HostingSettings.title' => 'Ustawienia hostingu',
    'HostingSettings.updateSuccess' => 'Zaktualizowano ustawienia.',
    'HostingSettings.emptyLogin' => 'Musisz podać nazwę użytkownika.',
    'HostingSettings.emptyPassword' => 'Musisz podać hasło.',
    'HostingSettings.ipV6OnlyNotSupported' => 'Serwer FTP nie obsługuje IPv6. Przydziel co najmniej jeden adres IPv4, ponieważ użytkownik nie będzie mógł wgrywać plików na serwer poprzez FTP.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Ustawienia domeny',
    'HostingSettings.domainSettingsSection.domainName' => 'Nazwa domeny',
    'HostingSettings.domainSettingsSection.description' => 'Na przykład example.com ',

    'HostingSettings.submitPopover.title' => 'Usuń zawartość %%website%%',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'Zmiana typu hostingu dla "Witryny" na "%%type%%" spowoduje trwałe usunięcie całej zawartości witryny, w tym następujących katalogów:',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Czy chcesz zmienić typ hostingu dla swojego serwisu WWW?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'Aby uzyskać dostęp do większej liczby ustawień, wprowadź poświadczenia użytkownika systemu, a następnie kliknij "Utwórz przestrzeń".',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'Aby uzyskać dostęp do większej liczby ustawień, kliknij "Dalej", aby utworzyć hosting.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Typ hostingu',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Typ',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Strona WWW',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Przekierowanie',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'Brak hostingu',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Użyj strefy DNS domeny, aby mieć skrzynki pocztowe pod tą nazwą domeny',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'Ścieżka do katalogu głównego serwisu WWW',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Preferowana domena',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Odwiedzający zostaną przekierowani tutaj za pośrednictwem przyjaznego dla SEO przekierowania HTTP 301.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Przekieruj odwiedzających do',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Typ przekierowania',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Przeniesiony na stałe (kod 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Przekieruj odwiedzających witrynę do innej witryny i pokaż im adres docelowy. Takie przekierowanie utrzyma ranking wyszukiwania witryny',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Przeniesiony tymczasowo (kod 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Przekieruj odwiedzających serwis WWW na tymczasową kopię serwisu, jeśli nie chcesz, żeby wyszukiwarki indeksowały ten tymczasowy serwis.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Przekierowanie przez ramkę',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Przekieruj odwiedzających stronę na inną stronę, ale nie pokazuj im adresu docelowego tak, żeby nie wiedzieli o przekierowaniu.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Preferowana domena',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'Żaden',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Root dokumentu',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'Nie można zmienić roota dokumentu, ponieważ na tej stronie zainstalowane są aplikacje.',
    'HostingSettings.domainSettingsSection.save' => 'Zapisz',
    'HostingSettings.domainSettingsSection.sameSsl.title' => 'Tryb zgodności',
    'HostingSettings.domainSettingsSection.sameSsl.enabled' => 'Uruchom serwis WWW w trybie kompatybilności, aby skorzystać z archiwalnej opcji "Rozdziel treści SSL/TLS od nie-SSL/TLS"',
    'HostingSettings.domainSettingsSection.sameSsl.hint' => 'Ta strona internetowa działa w trybie zgodności i nie można nią zarządzać za pomocą interfejsu Plesk. Dzieje się tak, ponieważ przed aktualizacją użyłeś przestarzałej opcji „Oddziel zawartość SSL/TLS i inną niż SSL/TLS”. Począwszy od Plesk 11 strona internetowa przechowuje swoją zawartość dostępną poprzez połączenia HTTP i HTTPS w tym samym katalogu. Zalecamy przeniesienie wszystkich danych z katalogu `httpsdocs/` do `httpdocs/`, a następnie wyłączenie trybu zgodności. Dzięki temu aplikacje zainstalowane w katalogu `httpsdocs/` będą dostępne przez Internet. Zwróć uwagę, że nie będzie można ponownie włączyć trybu zgodności.',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Zmienić to ustawienie?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'Zmiana tego ustawienia jest sprzeczna z zasadami bezpieczeństwa serwera i może pogorszyć wydajność lub narazić serwer na ataki.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Zmień',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Odwróć',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'Zabezpieczone ustawienia wstępne są stosowane',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'Aby zwiększyć bezpieczeństwo, zastosuj wstępne ustawienia bezpieczeństwa. Należy pamiętać, że niektóre uprawnienia umożliwiają subskrybentom modyfikowanie tych ustawień.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Zastosuj bezpieczne ustawienia wstępne',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'Dowiedz się o bezpiecznych ustawieniach hostingu',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'Obsługa SSL/TLS',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Włączona',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Szyfruj połączenia między witryną a przeglądarką odwiedzającego.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Certyfikat',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'Aby włączyć HTTPS, prześlij certyfikat SSL/TLS do repozytorium domeny, a następnie wybierz go tutaj.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Przekieruj odwiedzających z HTTP na HTTPS za pomocą przyjaznego dla SEO przekierowania 301',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'W twoim repozytorium nie ma certyfikatów SSL/TLS. Jeśli chcesz dodać certyfikat, idź %%link%%.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'ta strona',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (inne repozytorium)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'Nie zaznaczone',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Skrypty strony',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Wybierz, które języki programowania i skryptów mają być interpretowane przez serwer WWW.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'Katalog cgi-bin jest umieszczony w %%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'Używaj SSI dla plików *.htm, *.html',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Wersja Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Spersonalizowane dokumenty błędów',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'Katalog cgi-bin jest umieszczony w',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'dokument root tej domeny',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'Katalog root Przestrzeni WWW',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'old-style root tej domeny',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Spersonalizowane dokumenty błędów',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Dodatkowe uprawnienia zapisu/modyfikacji',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Publikacja Web Deploy',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Statystyki WWW',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Narzędzie',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'Chroń dostęp do statystyk sieci nazwą użytkownika i hasłem FTP',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Wyłączone',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Ustawienia przestrzeni WWW',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'Adresy IP',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Limit miejsca na dysku',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Włączona',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'Zabroń operacji na plikach witryny, jeśli limit miejsca na dysku ustawiony w ustawieniach subskrypcji (jeśli istnieje) zostanie przekroczony.',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'Przydział dysku twardego nie jest obsługiwany ze względu na konfigurację systemu plików serwera.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'Dane dostępowe użytkownika',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'Zarządzaj plikami i folderami witryny za pośrednictwem FTP lub Menedżera plików. Uzyskaj dostęp do serwera przez SSH, jeśli jest to dozwolone.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'Zarządzaj plikami i folderami witryny za pośrednictwem FTP lub Menedżera plików. Uzyskaj dostęp do serwera za pośrednictwem Pulpitu zdalnego, jeśli jest to dozwolone.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Nazwa użytkownika',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Hasło',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Podaj tutaj nowe hasło, aby zmienić hasło użytkownika systemu.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'Dostęp SSH',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Dostęp do pulpitu zdalnego',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Włączona',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Uzyskaj dostęp do serwera za pomocą poświadczeń użytkownika systemu.",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Typ',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Wyłączony',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => 'Dla {count, plural, other {# domen}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'Następujące ustawienia są wspólne dla wszystkich {count, plural, other {# domen w przestrzeni {name}}}:',

    'OdbcAdd.title' => 'Dodaj ODBC DSN',
    'OdbcAdd.nameLabel' => 'Nazwa połączenia',
    'OdbcAdd.descriptionLabel' => 'Opis połączenia',
    'OdbcAdd.driver' => 'Sterownik',
    'OdbcAdd.submit' => 'Utwórz DSN ODBC',

    'OdbcEdit.title' => 'Skonfiguruj połączenie ODBC',
    'OdbcEdit.saveSuccess' => 'Ustawienia połączenia zostały zapisane.',
    'OdbcEdit.test' => 'Test połączenia',
    'OdbcEdit.connectSuccess' => 'Połączenie udane.',

    'OdbcEdit.excel.driver.label' => 'Sterownik',
    'OdbcEdit.excel.dbq.label' => 'Ścieżka do Pliku Bazy Danych',
    'OdbcEdit.excel.defaultdir.label' => 'Domyślny katalog danych',
    'OdbcEdit.excel.fil.label' => 'Wersja bazy danych',
    'OdbcEdit.excel.maxbuffersize.label' => 'Maksymalny rozmiar bufora',
    'OdbcEdit.excel.pagetimeout.label' => 'Wygaśnięcie strony',

    'OdbcEdit.access.driver.label' => 'Sterownik',
    'OdbcEdit.access.dbq.label' => 'Ścieżka do Pliku Bazy Danych',
    'OdbcEdit.access.uid.label' => 'Login ID',
    'OdbcEdit.access.pwd.label' => 'Hasło',
    'OdbcEdit.access.pagetimeout.label' => 'Wygaśnięcie strony',
    'OdbcEdit.access.pagetimeout.description' => 'Okres czasu, w dziesiątych częściach sekundy, w którym nieużywana strona pozostaje w buforze. Ta opcja odnosi się do wszystkich źródeł, które korzystają ze sterownika Microsoft Access.',
    'OdbcEdit.access.maxbuffersize.label' => 'Maksymalny rozmiar bufora',
    'OdbcEdit.access.maxbuffersize.description' => 'Rozmiar wewnętrznego buforu, w KB, ustawiony jest na 256 KB.',
    'OdbcEdit.access.readonly.label' => 'Tylko do odczytu',
    'OdbcEdit.access.readonly.description' => 'Przełącza bazę danych w tryb tylko do odczytu aby zapobiec jakimkolwiek aktualizacjom.',
    'OdbcEdit.access.exclusive.label' => 'Ekskluzywny',
    'OdbcEdit.access.exclusive.description' => 'Przełącza bazę danych w tryb wyłączony aby zapobiec współdzielonym aktualizacjom.',
    'OdbcEdit.access.safetransactions.label' => 'Bezpieczne transakcje',
    'OdbcEdit.access.safetransactions.description' => 'Jeśli 0, domyślnie, wszystkie transakcje są zatwierdzane natychmiastowo. Jeśli 1, wszystkie transakcje są zapisywane na wyłącznie po wykonaniu operacji commit, ale wydajność jest delikatnie mniejsza.',
    'OdbcEdit.access.threads.label' => 'Wątki',
    'OdbcEdit.access.threads.description' => 'Liczba wątków w tle do wykorzystania przez silnik.',
    'OdbcEdit.access.maxscanrows.label' => 'Maksymalna liczba wierszy do przeskanowania',
    'OdbcEdit.access.maxscanrows.description' => 'Liczba wierszy, które będą skanowane, gdy będzie ustawiany typ danych dla kolumny w już istniejącej bazie danych.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Określa jak zmiany poczynione poza transakcją są zapisywane do bazy danych.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Określa czy sterownik MS Access będzie wykonywał w sposób asynchronicznie jawnie zdefiniowane przez użytkownika transakcje.',

    'OdbcEdit.mssql.driver.label' => 'Sterownik',
    'OdbcEdit.mssql.server.label' => 'Serwer',
    'OdbcEdit.mssql.uid.label' => 'Login ID',
    'OdbcEdit.mssql.pwd.label' => 'Hasło',
    'OdbcEdit.mssql.database.label' => 'Domyślna baza danych',
    'OdbcEdit.mssql.app.label' => 'Nazwa aplikacji',
    'OdbcEdit.mssql.wsid.label' => 'Identyfikator stacji roboczej',
    'OdbcEdit.mssql.language.label' => 'Domyślny język',
    'OdbcEdit.mssql.oemtoansi.label' => 'Ten parametr określa czy konwertować rozszerzone znaki do wartości OEM',

    'OdbcEdit.mysql.driver.label' => 'Sterownik MySQL ODBC',
    'OdbcEdit.mysql.server.label' => 'Serwer',
    'OdbcEdit.mysql.server.description' => 'Nazwa maszyny serwera MariaDB/MySQL',
    'OdbcEdit.mysql.database.label' => 'Domyślna baza danych',
    'OdbcEdit.mysql.user.label' => 'Nazwa użytkownika',
    'OdbcEdit.mysql.user.description' => 'Nazwa użytkownika wykorzystywana podczas połączenia do MariaDB/MySQL',
    'OdbcEdit.mysql.password.label' => 'Hasło',
    'OdbcEdit.mysql.password.description' => 'Hasło do konta użytkownika na serwerze',
    'OdbcEdit.mysql.port.label' => 'Port',
    'OdbcEdit.mysql.port.description' => 'Port TCP/IP używany gdy serwer nie jest lokalną maszyną',
    'OdbcEdit.mysql.socket.label' => 'Gniazdo',
    'OdbcEdit.mysql.socket.description' => 'Nazwany pipe windowsowy w przypadku lokalnych połączeń do serwera',
    'OdbcEdit.mysql.option.label' => 'Opcja',
    'OdbcEdit.mysql.option.description' => 'Opcje określające sposób działania MyODBC. Zobacz <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">dokumentację</a>',

    'ProtectedDirectoryList.add' => 'Dodaj katalog chroniony',
    'ProtectedDirectoryList.addTooltip' => 'Utwórz chroniony katalog.',
    'ProtectedDirectoryList.name' => 'Nazwa',
    'ProtectedDirectoryList.realmTitle' => 'Nagłówek tekstowy',
    'ProtectedDirectoryList.noSelectionText' => 'Wybierz jeden lub więcej elementów do usunięcia.',
    'ProtectedDirectoryList.edit' => 'Edytuj',
    'ProtectedDirectoryList.remove' => 'Usuń zabezpieczenie',
    'ProtectedDirectoryList.removeTooltip' => 'Usuń ochronę z wybranych katalogów.',
    'ProtectedDirectoryList.removeConfirmation' => 'Ta operacja spowoduje usunięcie ochrony z {count, plural, =1 {katalogu {name}} few {# wybranych katalogów} many {# wybranych katalogów} other {# wybranych katalogów}}. {count, plural, =1 {Ten katalog będzie w pełni dostępny} few {Te katalogi będą w pełni dostępne} many {Te katalogi będą w pełni dostępne} other {Te katalogi będą w pełni dostępne}} dla wszystkich użytkowników Internetu.',
    'ProtectedDirectoryList.removeSuccess' => 'Wybrane katalogi zostały usunięte.',

    'ProtectedDirectoryAdd.title' => 'Utwórz chroniony katalog',
    'ProtectedDirectoryAdd.submit' => 'Utwórz',
    'ProtectedDirectoryAdd.success' => 'Chroniony katalog %%path%% został pomyślnie usunięty',

    'ProtectedDirectoryEdit.title' => 'Strona ustawień chronionego katalogu',
    'ProtectedDirectoryEdit.success' => 'Ustawienia chronionego katalogu zostały zmienione',

    'ProtectedDirectoryUserAdd.title' => 'Utwórz użytkownika katalogu chronionego',
    'ProtectedDirectoryUserAdd.subtitle' => 'Katalog %%directory%%',
    'ProtectedDirectoryUserAdd.loginLabel' => 'Nazwa użytkownika',
    'ProtectedDirectoryUserAdd.passwordLabel' => 'Hasło',
    'ProtectedDirectoryUserAdd.submit' => 'Utwórz',
    'ProtectedDirectoryUserAdd.success' => 'Utworzono użytkownika chronionego katalogu %%login%%.',

    'ProtectedDirectoryUserPassword.title' => 'Hasło dla użytkownika chronionego katalogu',
    'ProtectedDirectoryUserPassword.subtitle' => 'Użytkownik %%login%%',
    'ProtectedDirectoryUserPassword.passwordLabel' => 'Hasło',
    'ProtectedDirectoryUserPassword.submit' => 'Zapisz',
    'ProtectedDirectoryUserPassword.success' => 'Dane uwierzytelniające użytkownika zostały zapisane.',

    'SummaryReport.Layout.title' => 'Właściwości layoutu raportu',
    'SummaryReport.Layout.success' => 'Zaktualizowano układ raportu %%name%%.',

    'SummaryReport.Layout.Add.title' => 'Stwórz layout raportu',
    'SummaryReport.Layout.Add.success' => 'Układ raportu %%name%% został utworzony.',

    'SummaryReport.Report.buttonLayouts' => 'Layouty',
    'SummaryReport.Report.buttonSchedule' => 'Plan zajęć',
    'SummaryReport.Report.buttonProperties' => 'Właściwości',
    'SummaryReport.Report.buttonTrafficHistory' => 'Historia transferu',
    'SummaryReport.Report.buttonPrint' => 'Drukuj',
    'SummaryReport.Report.buttonSend' => 'Wyślij e-mailem',
    'SummaryReport.Report.successSent' => 'Raport został wysłany do %%email%%',

    'SummaryReport.Schedule.Properties.title' => 'Harmonogram wysyłki dla %%name%%',
    'SummaryReport.Schedule.Properties.success' => 'Raport Harmonogramu Dostawy został zaktualizowany.',

    'SummaryReport.Schedule.Add.title' => 'Utwórz harmonogramy dostarczania dla %%name%%',
    'SummaryReport.Schedule.Add.success' => 'Utworzony nowy plan dostawy raportu.',

    'VirtualDirectory.errNotExist' => 'Ten katalog wirtualny jest powiązany z folderem fizycznym, który nie istnieje.',
    'VirtualDirectory.errNoPermissions' => 'Nie masz uprawnień do przeglądania zawartości tego katalogu.',
    'VirtualDirectory.tabBrowse' => 'Katalogi',
    'VirtualDirectory.tabBrowseHint' => 'Pracuj z fizycznymi i wirtualnymi plikami i katalogami na stronie %%site%%.',
    'VirtualDirectory.tabMimeTypes' => 'Typy MIME',
    'VirtualDirectory.tabMimeTypesHint' => 'Zarządzaj zarejestrowanymi typami MIME.',
    'VirtualDirectory.tabErrorDocs' => 'Dokumenty błędów',
    'VirtualDirectory.tabErrorDocsHint' => 'Zarządzaj dokumentami błędów.',
    'VirtualDirectory.tabProtection' => 'Ochrona',
    'VirtualDirectory.tabProtectionHint' => 'Ogranicz dostęp do katalogu za pomocą hasła.',

    'VirtualDirectory.errorDocType.default' => 'Domyślny',
    'VirtualDirectory.errorDocType.file' => 'Plik',
    'VirtualDirectory.errorDocType.url' => 'URL',

    'VirtualDirectory.Sidebar.buttonProperties' => 'Właściwości katalogu',
    'VirtualDirectory.Sidebar.buttonPropertiesHint' => 'Zobacz i zmień właściwości wirtualnego katalogu.',
    'VirtualDirectory.Sidebar.buttonPermissions' => 'Uprawnienia dostępu do katalogu',
    'VirtualDirectory.Sidebar.buttonPermissionsHint' => 'Ustaw uprawnienia dostępu do katalogu.',
    'VirtualDirectory.Sidebar.buttonAspDotNet' => 'ASP.NET',
    'VirtualDirectory.Sidebar.buttonAspDotNetHint' => 'Skonfiguruj ustawienia ASP.NET.',
    'VirtualDirectory.Sidebar.buttonPhp' => 'PHP',
    'VirtualDirectory.Sidebar.buttonPhpHint' => 'Skonfiguruj ustawienia PHP.',

    'VirtualDirectory.CreateDirectory.title' => 'Utwórz katalog',
    'VirtualDirectory.CreateDirectory.name' => 'Nazwa katalogu',
    'VirtualDirectory.CreateDirectory.success' => 'Katalog %%name%% został utworzony.',
    'VirtualDirectory.CreateDirectory.errExists' => 'Katalog %%name%% już istnieje.',

    'VirtualDirectory.CreateVirtualDirectory.title' => 'Utwórz wirtualny katalog',
    'VirtualDirectory.CreateVirtualDirectory.success' => 'Katalog %%name%% został utworzony.',

    'VirtualDirectory.EditVirtualDirectory.title' => 'Właściwości wirtualnego katalogu',
    'VirtualDirectory.EditVirtualDirectory.success' => 'Katalog wirtualny został edytowany.',
    'VirtualDirectory.EditVirtualDirectory.close' => 'Zamknij',

    'VirtualDirectory.MimeTypeList.add' => 'Dodaj typ MIME',
    'VirtualDirectory.MimeTypeList.edit' => 'Edytuj typ MIME',
    'VirtualDirectory.MimeTypeList.addHint' => 'Zarejestruj nowy typ MIME.',
    'VirtualDirectory.MimeTypeList.columnExtension' => 'Rozszerzenie',
    'VirtualDirectory.MimeTypeList.columnContent' => 'Zawartość',
    'VirtualDirectory.MimeTypeList.noSelectionText' => 'Wybierz jeden lub więcej elementów do usunięcia.',
    'VirtualDirectory.MimeTypeList.removeConfirmation' => 'Usunąć {count, plural, =1 {wybrany typ MIME} one {# wybrany typ MIME} few {# wybrane typy MIME} many {# wybranych typów MIME} other {# wybranych typów MIME}}?',
    'VirtualDirectory.MimeTypeList.removeSuccess' => 'Wybrane typy MIME zostały usunięte.',

    'VirtualDirectory.CreateMimeType.title' => 'Dodaj typ MIME',
    'VirtualDirectory.CreateMimeType.success' => 'Zarejestrowano nowy typ MIME.',

    'VirtualDirectory.EditMimeType.title' => 'Edytuj typ MIME',
    'VirtualDirectory.EditMimeType.success' => 'Typ MIME został zmieniony.',

    'VirtualDirectory.ErrorDocList.columnCode' => 'Błąd',
    'VirtualDirectory.ErrorDocList.columnName' => 'Opis',
    'VirtualDirectory.ErrorDocList.columnType' => 'Typ',
    'VirtualDirectory.ErrorDocList.columnLocation' => 'Lokalizacja',
    'VirtualDirectory.ErrorDocList.edit' => 'Edytuj',

    'VirtualDirectory.EditErrorDoc.title' => 'Edytuj dokument błędu',
    'VirtualDirectory.EditErrorDoc.success' => 'Dokument błędu został edytowany.',

    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.error' => 'Błąd',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.type' => 'Typ',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.location' => 'Lokalizacja',

    'VirtualDirectory.Protection.notSupported' => 'Ochrona katalogów nie jest obsługiwana dla tego katalogu, ponieważ jego nazwa przekracza 245 znaków lub zawiera nieobsługiwane znaki.',
    'VirtualDirectory.Protection.NoProtectionView.title' => 'Ochrona katalogu www jest wyłączona',
    'VirtualDirectory.Protection.NoProtectionView.protect' => 'Chroń',
    'VirtualDirectory.Protection.NoProtectionView.successProtection' => 'Katalog %%path%% był chroniony.',
    'VirtualDirectory.Protection.tools' => 'Narzędzia',
    'VirtualDirectory.Protection.removeProtection' => 'Usuń zabezpieczenie',
    'VirtualDirectory.Protection.removeProtectionTooltip' => 'Wyłącz ochronę katalogu www.',
    'VirtualDirectory.Protection.removeProtectionConfirmation' => 'Usunąć ochronę z katalogu wirtualnego? Spowoduje to również usunięcie wszystkich chronionych użytkowników katalogu i ustawień ochrony katalogów.',
    'VirtualDirectory.Protection.settings' => 'Ustawienia',
    'VirtualDirectory.Protection.settingsTooltip' => 'Zobacz lokalizację katalogu i podaj tytuł chronionego obszaru.',

    'VirtualDirectory.AspDotNet.title' => 'Skonfiguruj ustawienia ASP.NET',

    'VirtualDirectory.Php.title' => 'Wersja PHP',
    'VirtualDirectory.Php.version' => 'Wersja',
    'VirtualDirectory.Php.success' => 'Wersja PHP została zaktualizowana.',


    'MassMailPage.sendEmail' => 'Masowe wysyłanie E-maili',
    'MassMailPage.selectAtLeastOneTemplate' => 'Wybierz co najmniej jeden szablon',
    'MassMailPage.confirmRemoval' => 'Czy na pewno chcesz usunąć {count, select, 1 {wybrany szablon} other {wybrane szablony}}?',
    'MassMailPage.remove' => 'Usuń',
    'MassMailPage.filters' => 'Filtry',
    'MassMailPage.name' => 'Nazwa szablonu',
    'MassMailPage.sender' => 'Nadawca',
    'MassMailPage.recipients' => 'Odbiorcy',
    'MassMailPage.subject' => 'Temat',
    'MassMailPage.created' => 'Data utworzenia',
    'MassMailPage.send' => 'Wyślij',
    'MassMailPage.recipientsNone' => 'Żaden',
    'MassMailPage.recipientsAdmins' => 'Administrator',
    'MassMailPage.recipientsResellers' => 'Wszyscy sprzedawcy',
    'MassMailPage.recipientsResellersSelected' => 'Wybrani sprzedawcy',
    'MassMailPage.recipientsResellersExcept' => 'Wszyscy sprzedawcy z wyjštkiem zaznaczonych',
    'MassMailPage.recipientsClients' => 'Wszyscy klienci',
    'MassMailPage.recipientsClientsSelected' => 'Wybrani klienci',
    'MassMailPage.recipientsClientsExcept' => 'Wszyscy klienci oprócz zaznaczonych',
    'MassMailPage.templatesRemoved' => 'Usunięto {count, select, 1 {szablon} other {szablony}}.',
    'MassMailPage.emptyViewTitle' => 'Brak szablonów masowych wiadomości e-mail',
    'MassMailPage.addNew' => 'Stwórz szablon',
    'CreateMassMailTemplatePage.templateCreated' => 'Szablon został utworzony.',
    'EditMassMailTemplatePage.templateUpdated' => 'Szablon został zaktualizowany.',
    'SendMassMailPage.emailSent' => 'Wiadomość e-mail została wysłana.',
    'SendMassMailPage.fieldIsRequired' => 'Pole nie może być puste',
    'SendMassMailPage.saveAsTemplate' => 'Zapisz utworzoną wiadomość w nowym szablonie',
    'SendMassMailPage.newTemplateName' => 'Nowa nazwa szablonu',
    'SendMassMailPage.selectedTemplate' => 'Wybrany szablon',
    'SendMassMailPage.send' => 'Wyślij',
    'VirtualHostTemplatePage.name' => 'Nazwa',
    'VirtualHostTemplatePage.sizeInBytes' => 'Rozmiar',
    'VirtualHostTemplatePage.modified' => 'Data modyfikacji',
    'VirtualHostTemplatePage.permissions' => 'Uprawnienia',
    'VirtualHostTemplatePage.user' => 'Użytkownik',
    'VirtualHostTemplatePage.group' => 'Grupa',
    'VirtualHostTemplatePage.uploadTemplate' => 'Wgraj',
    'VirtualHostTemplatePage.succesfullyUploaded' => 'Szablon został przesłany.',
    'VirtualHostTemplatePage.root' => 'Wirtualny szablon',
    'VirtualHostTemplatePage.emptyViewTitle' => 'Brak plików w szablonie',
    'VirtualHostTemplatePage.total' => 'Łączna liczba pozycji w katalogu {breadcrumbs}: {total}',
    'VirtualHostTemplatePage.resetTemplate' => 'Ustaw jako domyślny',
    'VirtualHostTemplatePage.successfullyReset' => 'Szablon został zmieniony na domyślny.',

    'TrafficUsageByDomain.List.service' => 'Usługa',
    'TrafficUsageByDomain.List.usage' => 'Zużyto',
    'TrafficUsageByDomain.List.incoming' => 'Przych',
    'TrafficUsageByDomain.List.outgoing' => 'Wych',
    'TrafficUsageByDomain.List.percentOfAll' => '% ze wszystkich',

    'TrafficUsageByDomains.Viewer.List.domainName' => 'Nazwa domeny',
    'TrafficUsageByDomains.Viewer.List.clientName' => "Nazwa właściciela",
    'TrafficUsageByDomains.Viewer.List.totalUsage' => 'Zużyto',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimit' => 'Limit',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitRemaining' => 'Dostępne',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitUsagePercent' => 'Wykorzystany (w %)',
    'TrafficUsageByDomains.Viewer.Filters.ownOnly' => 'Tylko moje domeny',
    'TrafficUsageByDomains.Viewer.Filters.resellerOnly' => 'Tylko domeny sprzedawcy',
    'TrafficUsageByDomains.Viewer.Filters.clientName' => 'Nazwa właściciela',

    'TrafficUsageByReseller.emptyView' => 'Sprzedawca nie ma klientów',
    'TrafficUsageByReseller.TotalUsage.usageByResellerDomains' => '%%resellerDomainsLink%%: %%usage%%',
    'TrafficUsageByReseller.TotalUsage.resellerDomains' => "Domeny własne sprzedawcy",
    'TrafficUsageByReseller.TotalUsage.usageByCustomerDomains' => "Domeny klientów sprzedawcy: %%usage%%",

    'InfoAndStatistics.Main.title' => 'Informacje i Statystyki',
    'InfoAndStatistics.Main.overview' => 'Opis',
    'InfoAndStatistics.Main.domains' => 'Domeny',
    'InfoAndStatistics.Main.trafficUsage' => 'Użycie transferu',
    'InfoAndStatistics.Main.reports' => 'Raporty',
    'InfoAndStatistics.Main.serverSettings' => 'Ustawienia Serwera',
    'InfoAndStatistics.TrafficUsage.customers' => 'Klienci',
    'InfoAndStatistics.TrafficUsage.resellers' => 'Sprzedawcy',
    'InfoAndStatistics.TrafficUsage.domains' => 'Domeny',

    'ConfigureMailClient.title' => 'Wybierz swojego klienta pocztowego',
    'ConfigureMailClient.description' => 'Aby skonfigurować %%email%% automatycznie',
    'ConfigureMailClient.thunderbird' => 'Thunderbird',
    'ConfigureMailClient.manual' => 'Ręcznie',
    'ConfigureMailClient.Common.email' => 'Email:',
    'ConfigureMailClient.Common.start' => 'Początek',
    'ConfigureMailClient.Common.finish' => 'Zakończ',
    'ConfigureMailClient.Common.next' => 'Dalej',
    'ConfigureMailClient.Common.prev' => 'Wstecz',
    'ConfigureMailClient.Common.back' => 'Wstecz',
    'ConfigureMailClient.Common.manualLink' => 'Problem z dodaniem konta pocztowego? Wypróbuj konfigurację ręczną.',
    'ConfigureMailClient.Thunderbird.title' => 'Konfigurowanie konta pocztowego',
    'ConfigureMailClient.Thunderbird.description' => 'Postępuj zgodnie z instrukcjami, aby dodać konto pocztowe do Mozilla Thunderbird.',
    'ConfigureMailClient.Thunderbird.step1.title' => 'Otwórz Thunderbirda',
    'ConfigureMailClient.Thunderbird.step1.description' => 'Otwórz Thunderbirda na komputerze, a następnie kliknij "Konfiguracja kont" w menu głównym Thunderbirda.',
    'ConfigureMailClient.Thunderbird.step2.title' => 'Dodaj swoje konto',
    'ConfigureMailClient.Thunderbird.step2.description' => 'Kliknij "Operacje", a następnie kliknij "Dodaj konto pocztowe".',
    'ConfigureMailClient.Thunderbird.step3.title' => 'Podaj swoje dane',
    'ConfigureMailClient.Thunderbird.step3.description' => 'Wprowadź swoje imię i nazwisko, ponieważ chcesz, aby pojawiło się w dowolnych wysyłanych wiadomościach. Wprowadź również swój adres e -mail i hasło, a następnie kliknij "Kontynuuj".',
    'ConfigureMailClient.Thunderbird.step4.title' => 'Zakończono!',
    'ConfigureMailClient.Thunderbird.step4.description' => 'Thunderbird spróbuje teraz automatycznie dodać konto poczty.',

    'ConfigureMailClient.Outlook.title' => 'Konfigurowanie konta pocztowego',
    'ConfigureMailClient.Outlook.warning' => 'Nie możemy automatycznie dodać Twojego konta pocztowego do programu Outlook 2019 lub nowszego.',
    'ConfigureMailClient.Outlook.warningTooltip' => 'Używamy funkcji autowykrywania do automatycznego dodawania kont pocztowych. Wersje programu Outlook 2019 i nowsze używają serwerów proxy Microsoft do wykrywania żądań, co nie jest obsługiwane w Plesk i rozszerzeniu Plesk Premium E-mail.',
    'ConfigureMailClient.Outlook.description' => 'Postępuj zgodnie z instrukcjami, aby dodać konto pocztowe do Microsoft Office Outlook 2016.',
    'ConfigureMailClient.Outlook.step1.title' => 'Dodaj nowe konto',
    'ConfigureMailClient.Outlook.step1.description' => 'Otwórz Outlook 2016 na komputerze, a następnie przejdź do karty "Plik".',
    'ConfigureMailClient.Outlook.step2.title' => 'Dodaj nowe konto',
    'ConfigureMailClient.Outlook.step2.description' => 'Kliknij "Dodaj konto".',
    'ConfigureMailClient.Outlook.step3.title' => 'Wprowadź swój adres e-mail',
    'ConfigureMailClient.Outlook.step3.description' => 'Wprowadź swój adres e-mail.',
    'ConfigureMailClient.Outlook.step4.title' => 'Wprowadź hasło',
    'ConfigureMailClient.Outlook.step4.description' => 'Wprowadź hasło do konta pocztowego, a następnie kliknij "Połącz".',
    'ConfigureMailClient.Outlook.step5.title' => 'Zakończono!',
    'ConfigureMailClient.Outlook.step5.description' => 'Kliknij "OK", aby zakończyć konfigurację konta.',

    'ConfigureMailClient.Outlook365.title' => 'Konfigurowanie konta pocztowego',
    'ConfigureMailClient.Outlook365.warning' => 'Nie możemy automatycznie dodać Twojego konta pocztowego do programu Outlook 2019 lub nowszego.',
    'ConfigureMailClient.Outlook365.warningTooltip' => 'Używamy funkcji autowykrywania do automatycznego dodawania kont pocztowych. Wersje programu Outlook 2019 i nowsze używają serwerów proxy Microsoft do wykrywania żądań, co nie jest obsługiwane w Plesk i rozszerzeniu Plesk Premium E-mail.',
    'ConfigureMailClient.Outlook365.description' => 'Postępuj zgodnie z instrukcjami, aby dodać konto pocztowe do Microsoft Outlook 365.',
    'ConfigureMailClient.Outlook365.step1.title' => 'Dodaj nowe konto',
    'ConfigureMailClient.Outlook365.step1.description' => 'Otwórz Outlook 365 na komputerze. Jeśli nie skonfigurowałeś(-aś) już konta pocztowego w Outlook 365, wprowadź swój adres na stronie kreatora.',
    'ConfigureMailClient.Outlook365.step2.title' => 'Dodaj nowe konto',
    'ConfigureMailClient.Outlook365.step2.description' => 'Wybierz IMAP jako dostawcę poczty e-mail. Wprowadź hasło i użyj zalecanych ustawień, a następnie kliknij „Kontynuuj”.',
    'ConfigureMailClient.Outlook365.step3.title' => 'Wprowadź swój adres e-mail',
    'ConfigureMailClient.Outlook365.step3.description' => 'Potwierdź synchronizację konta IMAP i poczekaj na zakończenie konfiguracji.',
    'ConfigureMailClient.Outlook365.step4.title' => 'Dodawanie kolejnych kont',
    'ConfigureMailClient.Outlook365.step4.description' => 'Aby dodać więcej kont pocztowych do Outlook 365, kliknij „Dodaj konto”.',
    'ConfigureMailClient.Outlook365.step5.title' => 'Zakończono!',
    'ConfigureMailClient.Outlook365.step5.description' => 'Powtórz powyższe kroki, aby dodać nowe konto.',

    'ConfigureMailClient.Gmail.title' => 'Konfigurowanie konta pocztowego',
    'ConfigureMailClient.Gmail.description' => 'Postępuj zgodnie z instrukcjami, by dodać konto pocztowe do aplikacji Gmail na urządzeniu mobilnym.',
    'ConfigureMailClient.Gmail.step1.title' => 'Dodaj nowe konto',
    'ConfigureMailClient.Gmail.step1.description1' => 'Otwórz aplikację Gmail na telefonie z Androidem. W prawym górnym rogu dotknij swojego zdjęcia profilowego.',
    'ConfigureMailClient.Gmail.step1.description2' => 'Dotknij "Dodaj nowe konto".',
    'ConfigureMailClient.Gmail.step1.description3' => 'Dotknij "Inne".',
    'ConfigureMailClient.Gmail.step2.title' => 'Wprowadź swój adres e-mail',
    'ConfigureMailClient.Gmail.step2.description' => 'Wprowadź swój adres e -mail, a następnie dotknij "Dalej".',
    'ConfigureMailClient.Gmail.step3.title' => 'Wybierz typ konta',
    'ConfigureMailClient.Gmail.step3.description' => 'Aby przechowywać kopie pobranych wiadomości e -mail na serwerze, dotknij "Osobiste (IMAP)". Aby usunąć pobrane wiadomości e -mail z serwera, dotknij "Osobiste (POP3)".',
    'ConfigureMailClient.Gmail.step4.title' => 'Wprowadź hasło',
    'ConfigureMailClient.Gmail.step4.description' => 'Wprowadź hasło do konta pocztowego, a następnie dotknij "Dalej".',
    'ConfigureMailClient.Gmail.step5.title' => 'Ustawienia usuwania poczty',
    'ConfigureMailClient.Gmail.step5.description' => 'Wybierz, czy usunięcie wiadomości e -mail w aplikacji usunie je również z serwera, a następnie dotknij "Dalej".',
    'ConfigureMailClient.Gmail.step6.title' => 'Opcje konta',
    'ConfigureMailClient.Gmail.step6.description1' => 'Aplikacja automatycznie pobiera ustawienia serwera wychodzącego.',
    'ConfigureMailClient.Gmail.step6.description2' => 'W razie potrzeby zmień domyślne opcje konta, a następnie dotknij "Dalej".',
    'ConfigureMailClient.Gmail.step7.title' => 'Zakończono!',
    'ConfigureMailClient.Gmail.step7.description1' => '(Opcjonalnie) Wprowadź swoje imię, ponieważ chcesz, aby pojawiło się w dowolnych wysyłanych wiadomościach.',
    'ConfigureMailClient.Gmail.step7.description2' => 'Dotknij "Dalej", aby zakończyć konfigurowanie konta.',

    'ConfigureMailClient.Ios.title' => 'Konfigurowanie konta pocztowego',
    'ConfigureMailClient.Ios.description' => 'Zeskanuj kod QR lub otwórz poniższy link na urządzeniu iOS, aby automatycznie dodać konto pocztowe do aplikacji iOS Mail.',
    'ConfigureMailClient.Ios.link'  =>  'Dodaj konto do aplikacji iOS Mail',

    'ConfigureMailClient.Manual.title' => 'Ręczne konfigurowanie konta pocztowego',
    'ConfigureMailClient.Manual.description' => 'Użyj tych wartości podczas dodawania %%email%% do klienta pocztowego.',
    'ConfigureMailClient.Manual.username' => 'Nazwa użytkownika serwera poczty:',
    'ConfigureMailClient.Manual.outgoingServer' => 'Serwer poczty wychodzącej (wymaga uwierzytelnienia):',
    'ConfigureMailClient.Manual.incomingServer' => 'Serwer poczty przychodzącej:',
    'ConfigureMailClient.Manual.supportedIncomingProtocols' => 'Obsługiwane protokoły poczty przychodzącej:',
    'ConfigureMailClient.Manual.supportedOutgoingProtocols' => 'Obsługiwane protokoły poczty wychodzącej:',


    'Databases.Page.title' => 'Bazy danych dla %%database%%',
    'Databases.Page.databaseTab' => 'Bazy danych',
    'Databases.Page.userTab' => 'Zarządzanie użytkownikiem',
    'Databases.Page.serversLink' => 'Serwery baz danych',
    'Databases.Page.backupLink' => 'Menedżer kopii zapasowej',

    'Databases.List.add' => 'Dodaj bazę danych',
    'Databases.List.find' => 'Znajdź bazę danych...',
    'Databases.List.databaseColumn' => 'Baza danych',
    'Databases.List.relatedToColumn' => 'Połączona z',
    'Databases.List.relatedToDomains' => 'Powiazane z %%domains%%',
    'Databases.List.noRelatedDomains' => 'Przypisz tę bazę danych do serwisu',
    'Databases.List.noDomainRelations' => 'Brak powiązanych serwisów',
    'Databases.List.openWebAdmin' => 'phpMyAdmin',
    'Databases.List.changeRelatedDomain' => 'Zmień',
    'Databases.List.connectionInfo' => 'Informacje o połączeniu',
    'Databases.List.downloadDump' => 'Eksportuj zrzut',
    'Databases.List.uploadDump' => 'Importuj zrzut',
    'Databases.List.copy' => 'Skopiuj bazę danych',
    'Databases.List.checkDatabase' => 'Sprawdź i napraw',
    'Databases.List.assignToSubscription' => 'Przenieś do subskrypcji',
    'Databases.List.assignToSubscription_powerUser' => 'Przenieś do przestrzeni WWW',
    'Databases.List.remove' => 'Usuń',
    'Databases.List.removeConfirmation' => 'Usunąć bazę danych %%name%%?',
    'Databases.List.removeButtonDisabledHint' => 'Nie można usunąć bazy danych, ponieważ jest używana przez zainstalowaną aplikację internetową.',
    'Databases.List.databaseRemoved' => 'Baza danych została usunięta.',
    'Databases.List.downloadMsSqlClient' => 'Pobierz lokalnego klienta SQL',
    'Databases.List.downloadMsSqlClientHint' => 'Pobierz lokalnego klienta SQL',
    'Databases.List.webadmin' => 'Web Admin',
    'Databases.List.webadminHint' => 'Uzyskaj dostęp do tego serwera poprzez bazodanowanego Web Admina.',
    'Databases.List.dumpSubscriptionIsTurnedOff' => 'Nie udało się %%action%% zrzutu: subskrypcja jest zawieszona.',
    'Databases.List.dumpExport' => 'wyeksportować',
    'Databases.List.dumpImport' => 'zaimportować',
    'Databases.List.copyDatabaseName' => 'Skopiuj nazwę bazy danych',
    'Databases.List.copySuccess' => 'Nazwa bazy %%name%% została skopiowana do schowka',

    'Databases.DatabaseSummary.host' => 'Host',
    'Databases.DatabaseSummary.serverUnavailable' => 'Serwer jest niedostępny.',
    'Databases.DatabaseSummary.user' => 'Użytkownik',
    'Databases.DatabaseSummary.users' => 'Użytkownicy',
    'Databases.DatabaseSummary.noUser' => 'Brak użytkowników bazy danych',
    'Databases.DatabaseSummary.seeAll' => 'zobacz wszystkich',
    'Databases.DatabaseSummary.createUser' => 'Utwórz użytkownika',
    'Databases.DatabaseSummary.calculatingSize' => 'Kalkulowanie rozmiaru...',
    'Databases.DatabaseSummary.tablesCount' => 'Tabele',
    'Databases.DatabaseSummary.size' => 'Rozmiar',

    'Databases.InPlaceSelect.editButtonHint' => 'Edytuj',
    'Databases.InPlaceSelect.saveButtonHint' => 'Zapisz',
    'Databases.InPlaceSelect.closeButtonHint' => 'Anuluj',
    'Databases.InPlaceSelect.selectWebsiteAriaLabel' => 'wybierz stronę',

    'Databases.ConnectionInfo.title' => 'Informacje o połączeniu',
    'Databases.ConnectionInfo.description' => 'dla bazy danych %%database%%',
    'Databases.ConnectionInfo.hint' => 'Podczas instalowania aplikacji internetowej możesz użyć tych szczegółów połączenia z bazą danych.',
    'Databases.ConnectionInfo.host' => 'Host',
    'Databases.ConnectionInfo.copyHost' => 'Skopiuj hosta do schowka',
    'Databases.ConnectionInfo.databaseName' => 'Nazwa bazy danych',
    'Databases.ConnectionInfo.copyDatabaseName' => 'Skopiuj bazę danych do schowka',
    'Databases.ConnectionInfo.user' => 'Nazwa klienta',
    'Databases.ConnectionInfo.copyUser' => 'Skopiuj nazwę użytkownika do schowka',
    'Databases.ConnectionInfo.password' => 'Hasło',
    'Databases.ConnectionInfo.noDefaultUser' => 'Brak domyślnego użytkownika',

    'Databases.Add.title' => 'Dodaj bazę danych',
    'Databases.Add.name' => 'Nazwa bazy danych',
    'Databases.Add.server' => 'Serwer bazy danych',
    'Databases.Add.versionCut' => 'v%%version%%',
    'Databases.Add.relatedDomain' => 'Powiązany serwis',
    'Databases.Add.noDomainRelations' => 'Brak powiązanych serwisów',
    'Databases.Add.userSection' => 'Użytkownicy',
    'Databases.Add.userSectionDescription' => 'Utwórz domyślnego użytkownika bazy danych. Plesk uzyska dostęp do bazy danych w imieniu tego użytkownika. Jeżeli żaden użytkownik bazy danych nie jest przypisany do bazy danych, nie jest ona dostępna.',
    'Databases.Add.createUser' => 'Utwórz użytkownika bazy danych',
    'Databases.Add.username' => 'Nazwa użytkownika bazy danych',
    'Databases.Add.password' => 'Hasło',
    'Databases.Add.passwordConfirmation' => 'Potwierdź hasło',
    'Databases.Add.allDbAccess' => 'Użytkownik ma dostęp do wszystkich baz danych w obrębie wybranej subskrypcji',
    'Databases.Add.aclRadio' => 'Kontrola dostępu',
    'Databases.Add.aclLocalhost' => 'Zezwalaj tylko na lokalne połaczenia',
    'Databases.Add.aclAny' => 'Zezwalaj na zdalne połączenia od każdego hosta',
    'Databases.Add.aclCustom' => 'Zezwalaj na zdalne połaczenia od',
    'Databases.Add.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nOkreślone hosty mają pozwolenie na dostęp do bazy danych w imieniu tego użytkownika.",
    'Databases.Add.aclHostsLabel' => 'Wprowadź nazwy hostów lub adresy IP zdalnych hostów, które mają tutaj dostęp',
    'Databases.Add.remoteAccess' => 'Zdalny dostęp',
    'Databases.Add.remoteAccessDenied' => 'Użyj reguł zapory ogniowej systemu',
    'Databases.Add.remoteAccessAllowed' => 'Zezwalaj na zdalne połaczenia od',
    'Databases.Add.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nOkreślone adresy IP mogą uzyskać dostęp do serwera bazy danych za pośrednictwem reguły zapory. Twoje zmiany na tej liście będą moderowane przez dostawcę hostingu.",
    'Databases.Add.remoteAccessHint' => 'Skontaktuj się z dostawcą hostingu i upewnij się, że opcja, którą określiłeś powyżej będzie zgodna z obecnymi regułami zapory ogniowej dla przychodzącego dostępu do MariaDB/MySQL.',
    'Databases.Add.example' => "Na przykład:\n%%example%%",
    'Databases.Add.denied' => 'Użyj reguł zapory ogniowej systemu',
    'Databases.Add.allowed' => 'Zezwalaj na zdalne połaczenia od',
    'Databases.Add.databaseCreated' => 'Utworzono bazę danych %%name%%.',
    'Databases.Add.create' => 'Utwórz bazę danych',

    'Databases.Clone.title' => 'Skopiuj bazę danych',
    'Databases.Clone.clone' => 'OK',
    'Databases.Clone.warning' => 'Ostrzeżenie: Jeśli nazwy tabeli pokrywają się, tabela ze źródła zastąpi tę w miejscu docelowym.',
    'Databases.Clone.formDescription' => 'Skopiuj zawartość bazy danych do nowej lub istniejącej bazy danych. Po skopiowaniu do istniejącej bazy danych tabele z źródłowej bazy danych są dodawane do listy tabel w docelowej bazie danych.',
    'Databases.Clone.copyData' => 'Utwórz pełną kopię',
    'Databases.Clone.copyDataHint' => 'Odznaczenie spowoduje, że skopiowana zostanie cała baza danych (w tym struktury i dane). Jeśli zostaną wyczyszczone, tylko struktury tabel zostaną skopiowane.',
    'Databases.Clone.copyHint' => 'Zamierzasz skopiować bazę danych: %%databaseName%%',
    'Databases.Clone.server' => 'Docelowy serwer bazy danych',
    'Databases.Clone.versionCut' => 'v%%version%%',
    'Databases.Clone.externalServer' => 'Inne...',
    'Databases.Clone.database' => 'Docelowa baza danych',
    'Databases.Clone.newDatabase' => 'Utwórz bazę danych z nazwą',
    'Databases.Clone.newDatabaseName' => 'Nowa nazwa bazy danych',
    'Databases.Clone.existingDatabaseName' => 'Istniejąca nazwa bazy danych',
    'Databases.Clone.existingDatabase' => 'Kopiuj do istniejącej bazy danych',
    'Databases.Clone.externalDbHost' => 'Nazwa hosta lub adres IP',
    'Databases.Clone.externalDbLogin' => 'Nazwa użytkownika',
    'Databases.Clone.externalDbPassword' => 'Hasło',
    'Databases.Clone.subscription' => 'Docelowa subskrypcja',
    'Databases.Clone.subscription_powerUser' => 'Docelowa Przestrzeń WWW',
    'Databases.Clone.cloneInProgress' => 'Klonowanie bazy danych %%source%% do bazy danych %%destination%%. Zostaniesz poinformowany o jej postępie e-mailem (%%email%%).',
    'Databases.Clone.unableToClone' => 'Nie można skopiować bazy danych "%%source%%".',
    'Databases.Clone.unableToCreateExternalDatabase' => 'Nie można utworzyć bazy danych "%%destination%%" na określonym serwerze.',
    'Databases.Clone.databaseCloned' => 'Baza danych "%%source%%" została skopiowana.',
    'Databases.Clone.emailSubjSuccess' => 'Baza danych "%%sourceDatabase%%" została skopiowana.',
    'Databases.Clone.emailSubjFailure' => 'Nie można skopiować bazy danych "%%sourceDatabase%%".',
    'Databases.Clone.emailBodySuccess' => 'Baza danych "%%sourceDatabase%%" (%%sourceHost%%) została skopiowana do bazy danych "%%destDatabase%%" (%%destHost%%).',
    'Databases.Clone.emailBodyFailure' => 'Nie udało się skopiować bazy danych "%%sourceDatabase%%" (%%sourceHost%%) do bazy danych "%%destDatabase%%" (%%destHost%%). Kopiowanie nie powiodło się.',
    'Databases.Clone.localServer' => 'serwer lokalny',

    "Databases.Import.confirm" => 'Importuj zrzut',
    'Databases.Import.recreateDatabase' => 'Odtwórz bazę danych',
    'Databases.Import.rootDirectory' => 'Katalog główny',
    'Databases.Import.uploadFromFile' => 'Prześlij zrzut z lokalnego komputera',
    'Databases.Import.uploadFromWebspace' => 'Zaimportuj zrzut zapisany na serwerze hostingowym',
    'Databases.Import.uploadHint' => 'Zamierzasz zaimportować zrzut do %%databaseName%%',
    'Databases.Import.uploadPopupTitle' => 'Importuj zrzut bazy danych',
    'Databases.Import.uploading' => 'Importowanie...',
    'Databases.Import.waitMessage' => 'Proszę czekać...',

    "Databases.Export.confirm" => 'Eksportuj zrzut',
    'Databases.Export.downloadDumpAutomatically' => 'Automatycznie pobierz zrzut po jego utworzeniu',
    'Databases.Export.downloadDumpName' => 'Nazwa pliku zrzutowego',
    'Databases.Export.downloadHint' => 'Zamierzasz utworzyć zrzut bazy %%database%% i pobrać go',
    'Databases.Export.downloadPopupTitle' => 'Eksportuj zrzut',
    'Databases.Export.downloadRelativePath' => 'Zapisz zrzut następującego katalogu',
    'Databases.Export.rootDirectory' => 'Katalog główny',
    'Databases.Export.waitMessage' => 'Proszę czekać...',

    'MoveDatabasePage.title' => 'Przenieś bazy danych do innej subskrypcji',
    'MoveDatabasePage.title_powerUser' => 'Przenieś bazy danych do innej przestrzeni WWW',
    'MoveDatabasePage.description' => 'Zamierzasz przenieść bazę danych %%name%%',
    'MoveDatabasePage.hint' => 'Wybrane bazy danych zostaną przeniesione do wybranej subskrypcji. Użytkownicy bazy danych zostaną również przeniesieni, chyba że mają dostęp do innych baz danych. Uwaga: Po migracji użytkownicy, którzy mieli dostęp do bazy danych przed migracją, nie będą w stanie uzyskać dostępu do bazy danych za pośrednictwem linku w Plesk.',
    'MoveDatabasePage.subscriptionName' => 'Przenieś do subskrypcji',
    'MoveDatabasePage.subscriptionName_powerUser' => 'Przenieś do przestrzeni WWW',
    'MoveDatabasePage.save' => 'Przenieś',

    'WebProsAccountPage.descriptionHead' => 'Uzyskaj dostęp do wszystkich usług WebPros i serwera Plesk za pomocą jednego bezpiecznego loginu.',
    'WebProsAccountPage.descriptionBody' => 'Twoje konto WebPros łączy Cię z Dashboard, Monitoring, Support Portal, Plesk University i KA Partner Central — upraszczając zarządzanie w całym ekosystemie WebPros.',
    'WebProsAccountPage.buttonLogin' => 'Uwierzytelnij się za pomocą konta WebPros',
    'WebProsAccountPage.buttonSkip' => 'Pomiń aż do następnego logowania',
];
