<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: upstream mengirim tajuk terlalu besar saat membaca tajuk respons"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => 'Segera siap.',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Kesalahan Server Internal: Pilihan FollowSymLinks tidak diizinkan di sini"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => 'Segera siap.',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "server mencapai pengaturan max_children"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Gejala</h4><ul><li><p>Situs web yang memiliki penanganan PHP ditetapkan sebagai <strong>aplikasi FPM yang dilayani oleh Apache</strong> atau <strong>aplikasi FPM yang dilayani oleh nginx</strong> di <strong>Domain</strong> &gt; <strong>example.com</strong> &gt; <strong>Pengaturan PHP</strong> pernah mengalami satu dari masalah berikut ini:</p><ul><li><p>memuat dengan lambat</p></li><li><p>tidak dapat diakses (secara permanen atau secara berkala) dengan 50x kesalahan di peramban web:</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily Unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p>Pesan berikut muncul di file log kesalahan PHP-FPM<code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (di mana <em>XX</em> adalah versi PHP yang digunakan situs web):</p><pre>PERINGATAN: server [pool example.com] mencapai pengaturan max_children (*), pertimbangkan untuk menaikkannya</pre><ul><li><p>Pesan di atas biasanya disertai dengan kesalahan ini:</p><pre>tidak dapat membaca apa yang dikatakan anak: Deskriptor file buruk (9)</pre></li></ul></li><li><p>Jika nginx diaktifkan di server, salah satu pesan kesalahan berikut mungkin muncul di file log kesalahan domain <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 sambungan ke unix:///var/www/vhosts/system/example.com/php-fpm.sock gagal (11: Sumber daya tidak tersedia untuk sementara) saat menyambungkan ke upstream, klien: 203.0.113.2, server: example.com, permintaan: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 koneksi upstream ditutup sebelum waktunya saat membaca header respons dari upstream, klien: 203.0.113.2, server: example.com, permintaan: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>PHP-FPM <code>pm.max_children</code> telah tercapai oleh situs web.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Meningkatkan batas the pm.max_children',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Meningkatkan batas <code>pm.max_children</code> untuk domain yang terpengaruh:</p><ol><li><p>Sambungkan ke server Plesk melalui <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Temukan domain yang terpengaruh dengan menggunakan perintah di bawah ini:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Catatan:</strong> Angka di sebelah kiri menunjukkan berapa kali batas <code>pm.max_children</code> telah dicapai oleh situs web.</div><pre style="white-space: pre-wrap;"># grep -r "server mencapai pengaturan max_children" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener">Login ke Plesk</a>.</p></li><li><p>Pergi ke <strong>Domain</strong> &gt; <strong>example.com</strong> &gt; <strong>Pengaturan PHP</strong> &gt; <strong>Pengaturan PHP-FPM</strong>.</p></li><li><p>Meningkatkan nilai <code>pm.max_children</code> untuk domain and terapkan perubahan tersebut. Meningkatkan nilai ini untuk semua domain terdaftar di langkah 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Terlalu banyak file yang dibuka"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx gagal memulai/memuat ulang di server Plesk: Terlalu banyak file yang terbuka</p><h4>Gejala</h4><ul><li><p>Layanan nginx gagal memulai/memuat ulang dengan kesalahan berikut ini dalam file <code>/var/log/nginx/error.log</code> file:</p><pre style="white-space: pre-wrap;">nginx: [emerg] membuka() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" gagal (24: Terlalu banyak file yang terbuka)</pre></li><li><p>Beberapa atau semua situs web tidak dapat diakses</p></li><li><p>Peringatan ditampilkan di <strong>Alat &amp; Pengaturan &gt; Diagnose &amp; repair</strong>:</p><pre style="white-space: pre-wrap;">Memeriksa nilai nginx ULIMIT domain N telah ditemukan di server. Masalah dengan batas default nginx untuk file yang terbuka mungkin terjadi</pre></li><li><p>Aplikasi web NodeJS dan Ruby menunjukkan kesalahan 502 Bad Gateway ketika melakukan beberapa tugas Plesk seperti membuat domain, langganan, perubahan di Apache atau Nginx, dll:</p><pre style="white-space: pre-wrap;">Kesalahan Server<br>502 Bad Gateway <br>Server web menerima respons yang tidak valid saat bertindak sebagai gateway atau server proxy.</pre></li><li><p>Setelah <a href="https://support.plesk.com/hc/en-us/articles/12377676289815-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">menginstal sertifikat untuk domain</a>, sertifikat yang lama masih ditampilkan di peramban web, namun, sertifikat yang benar yang dipilih di halaman <strong>Domain &gt; example.com &gt; Pengaturan Hosting</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Host virtual Nginx membuka 4 file log untuk setiap host virtual dengan hosting fisik:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Hasil dari fakta ini, jumlah maksimum file yang terbuka oleh server nginx melebihi batas karena banyaknya domain (biasanya lebih dari 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Meningkatkan batas file yang dibuka',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Peringatan:</strong> Menjalankan utilitas <code>websrv_ulimits</code> tanpa pilihan <strong>--no-restart</strong> memulai pembuatan ulang file konfigurasi web untuk semua domain dan dapat menyebabkan waktu henti yang signifikan jika ada sejumlah besar situs web yang dihosting.<br><br>Menjalankan perintah selama jangka waktu pemeliharaan.</div><p>Ini adalah praktik yang baik untuk menetapkan nilai batas file terbuka lebih dari <strong>jumlah domain di Plesk * 16</strong>. Pada contoh di bawah ini, disediakan tindakan cara mengatur batas ke 4096</p><ol><li><p>Sambungkan ke server melalui <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Atur batas file yang terbuka hingga 4096 untuk Apache dan Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Mulai ulang layanan Apache dan layanan nginx di <strong><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Alat &amp; Pengaturan &gt; Pengelolaan Pengaturan</strong> untuk menerapkan perubahan.</p></li><li><p>Periksa \'Batas maks file yang terbuka\' sudah diterapkan dengan tepat, setelah layanan web dimulai ulang:</p><pre># grep \'Maks file yang terbuka\' /proc/$(cat /var/run/nginx.pid)/<br>Maks file yang terbuka 4096 4096 file</pre></li><li><p>Jika solusi di atas tidak membantu, atur batas dengan menggunakan <code>ulimit</code> utilitas:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Badan respons terlalu besar"',
    'problem-detail.apache-modsec-response-body-too-large.description' => 'Segera siap.',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Akses ditolak oleh kode 403"',
    'problem-detail.modsec-access-denied.description' => '<h4>Gejala</h4><ul><li><p>ModSecurity diinstal dan diaktifkan di <strong>Alat & Pengaturan > Firewall Aplikasi Web (ModSecurity) > Mode firewall aplikasi web > Aktif</strong>.</p></li><li>Situs web yang dihosting di Plesk gagal dimuat. Tidak mungkin melakukan operasi di situs web seperti mengelola WordPress, mengakses email web, atau mengakses file <code>robots.txt</code>. Peramban dapat menampilkan salah satu kesalahan berikut: <pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 Forbidden</pre><hr><pre>Kesalahan Server Internal 500</pre><hr><pre> ERR_CONNECTION_TIMED_OUT</pre></li><li>Pesan kesalahan ModSecurity seperti di bawah ini muncul di file log <code>/var/log/modsec_audit.log</code> atau di halaman Log di Plesk (<strong>Domains</strong> &gt; <strong>example.com</strong> &gt; <strong>Log</strong>): <pre>ModSecurity: Akses ditolak dengan kode 403 (fase 2). Operator GE mencocokkan 5 di TX:anomaly_score. [file "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_4-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [baris "57"] [id "949110"] [msg "Skor Anomali Masuk Melebihi (Total Skor: 5)"] [severity "CRITICAL"] [tag "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com "] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>ModSecurity Firewall Aplikasi Web diaktifkan dengan kumpulan aturan yang sangat ketat seperti OWASP, Comodo, atau kumpulan aturan khusus seperti Imunify360. Kumpulan aturan yang membatasi dapat memblokir beberapa operasi di situs web.</p><p><Strong>Catatan:</strong> Kesalahan ModSecurity mungkin mengindikasikan serangan pada server Anda. Gunakan solusi di bawah ini hanya jika Anda yakin ModSecurity memblokir penggunaan situs web Anda yang valid.</p>',
    'problem-detail.modsec-access-denied.solution1.title' => 'Menonaktifkan peraturan ModSecurity yang ditetapkan oleh ID atau tag',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>Temukan ID aturan yang memblokir penggunaan sah situs web Anda. Anda dapat menemukan ID di dalam pesan kesalahan di log file <code>/var/log/modsec_audit.log</code>. ID adalah bilangan bulat dalam tanda kutip dengan awalan <code>id</code> dalam tanda kurung siku, misalnya <strong>[id "210831"]</strong>.</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/12377453278871" target="_blank" rel="noopener">Nonaktifkan kumpulan aturan tertentu di Plesk</a>.</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => 'Ganti ke set aturan ModSecurity lainnya',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>Beralih ke kumpulan aturan ModSecurity yang tidak terlalu ketat, misalnya, "Aturan ModSecurity Atom". Untuk melakukannya, buka <strong>Alat & Pengaturan</strong> > <strong>Firewall Aplikasi Web (ModSecurity)</strong> > <strong>Pengaturan</strong>, pilih <strong>Standar Atom</strong>, lalu klik <strong>OK</strong> untuk menerapkan perubahan.</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Kesalahan Server Internal 500: Ukuran memori yang diizinkan XXX habis"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>Gejala</h4><ul><li><p>Situs web yang dihosting di Plesk tidak dapat diakses:</p><pre>Kesalahan Server Internal 500</pre></li><li><p>Kesalahan berikut ditampilkan di log situs web:</p><pre>Mendapat kesalahan "Pesan PHP: PHP Kesalahan fatal: Ukuran memori yang diizinkan 4194304 byte habis (mencoba mengalokasikan 4000032 byte) di /var/www/vhosts/example.com/httpdocs/somethingBig.php on line 3"</pre></li> </ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>Situs web tidak memiliki memori yang cukup yang dialokasikan untuk diproses.</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => 'Meningkatkan memory_limit situs web',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510316183" target="_blank" rel="noopener">Baca artikel KB dan ikuti instruksi </a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "pembatasan open_basedir berlaku"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>Gejala</h4><ul><li><p>Situs web tidak dapat diakses dengan salah satu kesalahan berikut di peramban web:</p><pre>404 file tidak ditemukan</pre><hr><pre>Kesalahan Server Internal 500</pre><hr><pre>Kesalahan 500 move_uploaded_file(): pembatasan open_basedir berlaku. File(/path/to/the/directory) tidak berada dalam jalur yang diizinkan: (/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>Pesan kesalahan berikut muncul di halaman Log domain (<strong>Domains</strong> > <strong>example.com</strong> > <strong>Log</strong>):</p><pre> <...> pembatasan open_basedir berlaku. File(/path/to/the/directory) tidak berada dalam jalur yang diizinkan <...></pre><hr><pre>Pengecualian Tidak Tertangkap: Sesi: Jalur penyimpanan yang dikonfigurasi "/path/to/the /directory" bukan direktori, tidak ada atau tidak dapat dibuat.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'Skrip PHP mencoba mengakses direktori yang aksesnya tidak diizinkan. Pembatasan ini ditentukan oleh arahan PHP <code>open_basedir</code> secara individual untuk setiap domain. Secara default, <code>open_basedir</code> memungkinkan akses ke <code>tmp</code> dan direktori akar dokumen domain, serta jalur sesi default sistem.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => 'Menambahkan jalur ekstra ke open_basedir directive',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510714135" target="_blank" rel="noopener">Baca artikel KB dan ikuti instruksi </a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => 'Nonaktifkan open_basedir directive',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p>Menuju halaman<strong>Pengaturan PHP Domains &gt example.com &gt</strong> dan mengatur perintah <code>open_basedir</code> ke "none".</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Forbidden AH01797: klien ditolak oleh konfigurasi server"',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>Gejala</h4><ul><li><p>Situs web menunjukkan kesalahan yang mirip dengan yang berikut:</p><pre>Kesalahan Server 403<br>Forbidden</pre></li> <li><p>File log <code>/var/www/vhosts/system/example.com/logs/error_log</code> berisi kesalahan seperti berikut:</p><pre>AH01797: klien ditolak menurut konfigurasi server: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>Konfigurasi Apache saat ini tidak mengizinkan akses ke situs web.</p><p>Ini diharapkan untuk file seperti .htaccess dan .htpasswd, karena file ini tidak boleh diakses melalui server web.</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => 'Periksa konfigurasi server dan file .htaccess',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Baca artikel KB dan ikuti instruksi </a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Tidak dapat mengakses direktori situs web di Plesk: 403 Forbidden"',
    'problem-detail.apache-no-directory-index.description' => '<h4>Gejala</h4><ul><li><p>Tidak dapat mengakses lokasi situs web tertentu, misalnya <code>http://example.com/some_folder</code>. Terjadi kesalahan berikut:</p><pre>Kesalahan Server 403<br>Forbidden</pre></li><li><p>Kesalahan berikut muncul di file <code>/var/www/vhosts/example.com/logs/error_log<code/>:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Tidak dapat melayani direktori /var/www/vhosts /example.com/httpdocs/some_folder/: Tidak ditemukan DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) yang cocok, dan indeks direktori yang dibuat server dilarang oleh arahan Opsi</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>Direktori yang diminta tidak berisi file indeks atau penjelajahan direktori tidak diaktifkan.</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => 'Menambahkan file indeks ke direktori',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Baca artikel KB dan ikuti instruksi </a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => 'Mengaktifkan penjelajahan direktori',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Baca artikel KB dan ikuti instruksi </a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Tidak dapat mengakses direktori situs web di Plesk: 403 Forbidden"',
    'problem-detail.nginx-no-directory-index.description' => '<h4>Gejala</h4><ul><li><p>Tidak dapat mengakses lokasi situs web tertentu, misalnya <code>http://example.com/some_folder</code>. Terjadi kesalahan berikut:</p><pre>Kesalahan Server 403<br>Forbidden</pre></li><li><p>Kesalahan berikut muncul di <code>/var/www/vhosts/example.com/logs/error_log file</code>:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Tidak dapat melayani direktori /var/www/vhosts /example.com/httpdocs/some_folder/: Tidak ditemukan DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) yang cocok, dan indeks direktori yang dibuat server dilarang oleh arahan Opsi</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>Direktori yang diminta tidak berisi file indeks atau penjelajahan direktori tidak diaktifkan.</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => 'Menambahkan file indeks ke direktori',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Baca artikel KB dan ikuti instruksi </a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => 'Mengaktifkan penjelajahan direktori',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Baca artikel KB dan ikuti instruksi </a>.</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "server mencapai pengaturan MaxRequestWorkers"',
    'problem-detail.apache-reached-max-request-workers.description' => 'Segera siap.',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'Batas badan permintaan PHP "klien bermaksud mengirim badan terlalu besar"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => 'Segera siap.',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'Batas badan permintaan PHP "klien bermaksud mengirim badan terlalu besar"',
    'problem-detail.nginx-client-sent-too-large-body.description' => 'Segera siap.',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'Sesi PHP "Kesalahan Server Internal 503" atau "Gagal membaca data sesi"',
    'problem-detail.php-failed-to-read-session-data.description' => 'Segera siap.',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: tidak dapat memeriksa file htaccess, pastikan ini bisa dibaca"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>Gejala</h4><ul><li><p>Situs web yang dihosting di Plesk tidak berfungsi:</p><pre>Anda tidak memiliki izin untuk mengakses/berada di server ini. <br> Selain itu, terjadi kesalahan 403 Forbidden saat mencoba menggunakan ErrorDocument untuk menangani permintaan.</pre><p>Alih-alih kesalahan di atas, Anda juga dapat melihat halaman kosong.</p></li><li><p>Log kesalahan domain di <strong>Domains &gt example.com &gt Logs</strong> berisi hal berikut:</p><pre>(13)Izin ditolak: [klien 203.0.113.2:39024] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: tidak dapat memeriksa file htaccess, pastikan itu dapat dibaca dan "/var/www/vhosts/example.com/httpdocs/" dapat dieksekusi</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => 'Izin salah untuk file dan folder domain.',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => 'Memperbaiki izin untuk konten situs web',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377773681815" target="_blank" rel="noopener">Baca artikel KB dan ikuti instruksi </a>.</p></li></ol>',
];
