/*  This file is part of FreeDoko.
    FreeDoko is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version (see <http://www.gnu.org/licenses/>).

    Diese Datei ist Teil von FreeDoko.
    FreeDoko ist Freie Software: Sie können es unter den Bedingungen der GNU General Public License, wie von der Free Software Foundation, Version 3 der Lizenz oder (nach Ihrer Wahl) jeder neueren veröffentlichten Version, weiter verteilen und/oder modifizieren (siehe <https://www.gnu.org/licenses/>).
    */

#pragma once

#include "constants.h"

enum class AiconfigHeuristic {
  error = -1,
  no_heuristic = 0,
  manual,
  bug_report,
  only_one_valid_card,
  valid_card,
  gametree,

  remaining_tricks_to_me,
  start_with_color,
  start_with_low_color,
  start_with_low_trump,
  start_with_color_blank_ace,
  start_with_color_single_ace,
  start_with_color_double_ace,
  start_with_color_ten,
  start_with_lowest_color,
  start_with_lowest_trump,
  jab_with_color_ace,
  jab_with_color_ten,
  jab_first_color_run,
  jab_second_color_run,
  jab_small_color_card,
  jab_color_over_fox,
  jab_color_trick_high,
  jab_rich_trick,
  jab_trump_over_fox,
  jab_trump_because_of_partner_announcement,
  jab_trump_high_because_of_partner_announcement,
  jab_trump_high_after_opponent_announcement,
  jab_with_highest_trump,
  jab_with_lowest_card,
  jab_with_lowest_card_below_trump_card_limit,
  jab_with_relative_low_trump,
  high_after_partner_low,
  second_last_jab_for_following_pfund,
  last_player_jab_with_trump_ace_or_ten,
  last_player_jab_for_points,
  last_player_pass_small_trick,
  jab_with_opponent_backhand,
  serve_with_lowest_card,
  serve_partner_with_lowest_card,

  retry_color,
  start_with_trump_for_partner_color_ace,
  play_color_for_partner_to_jab,
  play_color_for_last_player_to_jab,
  play_color_for_partner_ace,
  play_bad_color,
  save_dulle,
  save_dulle_from_swines,
  save_swines_from_hyperswines,
  jab_swine_with_hyperswine,
  pfund_in_first_color_run,
  serve_color_trick,
  serve_trump_trick,
  pfund_high_for_sure,
  pfund_for_sure,
  pfund_high_for_unsure,
  pfund_for_unsure,
  start_with_trump_pfund,
  pfund_before_partner,
  jab_for_ace,
  create_blank_color,
  play_trump,
  jab_fox,
  jab_for_doppelkopf,
  try_for_doppelkopf,
  play_for_partner_worries,
  partner_backhand_draw_trump,
  draw_trump,
  draw_remaining_trump,
  draw_trump_for_team_announcement,
  play_to_jab_later,
  play_highest_color_card_in_game,
  jab_to_win,
  jab_to_not_loose,
  grab_trick,
  cannot_jab,
  play_last_trumps,

  start_to_marry,
  jab_to_marry,
  start_to_get_married,
  start_to_get_married_last_chance,
  pfund_in_marriage_determination_trick,

  poverty_special_start_with_trump,
  poverty_special_play_pfund,
  poverty_special_give_no_points,
  poverty_special_offer_pfund,
  poverty_re_jab_as_last_player,
  poverty_re_jab_color_trick_with_trump,
  poverty_re_start_with_trump,
  poverty_contra_start_with_color,
  poverty_contra_jab_color_trick_with_trump,
  poverty_contra_pfund_high_for_sure,
  poverty_contra_pfund_for_sure,
  poverty_contra_pfund_high_for_unsure,
  poverty_contra_pfund_for_unsure,
  poverty_contra_pfund_before_partner,
  poverty_leave_to_partner,
  poverty_overjab_re,

  play_color_in_solo,

  color_jab_for_ace,
  color_pfund_in_first_color_run,
  color_pfund_high_for_sure,
  color_pfund_for_sure,
  color_pfund_high_for_unsure,
  color_pfund_for_unsure,
  color_overjab_to_get_partner_backhand,

  picture_pull_down_color,
  picture_start_with_highest_color,
  picture_get_first_trumps,
  picture_get_last_trumps,
  picture_get_trumps_before_blank_color_ace,
  picture_draw_trumps,
  picture_serve_trump_trick,
  picture_jab_trump_trick,
  picture_start_with_winning_card_before_bad_loosing_cards,
  picture_start_with_loosing_solo_color,
  picture_play_last_trumps,
  picture_pfund_high_for_sure,
  picture_pfund_for_sure,
  picture_pfund_high_for_unsure,
  picture_pfund_for_unsure,
  picture_jab_color_trick_for_sure,
  picture_contra_discard_color_card,
  picture_contra_jab_color_trick,
  picture_contra_jab_with_high_color_card,

  meatless_start_with_best_color,
  meatless_pull_down_color,
  meatless_play_blank_color_of_soloplayer,
  meatless_retry_last_color,
  meatless_overjab_re,
  meatless_pfund_for_sure,
  meatless_pfund_before_partner,
  meatless_play_color_for_partner_ace,
  meatless_serve_color_trick,
  meatless_serve_trick_re,
  meatless_serve_trick_contra,
  meatless_play_highest_color_card_in_game,
};
// NOLINTNEXTLINE(cppcoreguidelines-avoid-c-arrays,hicpp-avoid-c-arrays,modernize-avoid-c-arrays)
constexpr AiconfigHeuristic aiconfig_heuristic_list[] = {
  AiconfigHeuristic::no_heuristic,
  AiconfigHeuristic::manual,
  AiconfigHeuristic::bug_report,
  AiconfigHeuristic::only_one_valid_card,
  AiconfigHeuristic::valid_card,
  AiconfigHeuristic::gametree,

  AiconfigHeuristic::start_with_color_blank_ace,
  AiconfigHeuristic::start_with_color_single_ace,
  AiconfigHeuristic::start_with_color_double_ace,
  AiconfigHeuristic::start_with_color_ten,
  AiconfigHeuristic::start_with_lowest_color,
  AiconfigHeuristic::start_with_lowest_trump,
  AiconfigHeuristic::jab_with_color_ace,
  AiconfigHeuristic::jab_with_color_ten,
  AiconfigHeuristic::pfund_in_first_color_run,
  AiconfigHeuristic::jab_first_color_run,
  AiconfigHeuristic::jab_second_color_run,
  AiconfigHeuristic::jab_small_color_card,
  AiconfigHeuristic::jab_color_over_fox,
  AiconfigHeuristic::jab_color_trick_high,
  AiconfigHeuristic::jab_rich_trick,
  AiconfigHeuristic::jab_trump_over_fox,
  AiconfigHeuristic::jab_trump_because_of_partner_announcement,
  AiconfigHeuristic::jab_trump_high_because_of_partner_announcement,
  AiconfigHeuristic::jab_trump_high_after_opponent_announcement,
  AiconfigHeuristic::jab_with_highest_trump,
  AiconfigHeuristic::jab_with_lowest_card,
  AiconfigHeuristic::jab_with_lowest_card_below_trump_card_limit,
  AiconfigHeuristic::jab_with_relative_low_trump,
  AiconfigHeuristic::high_after_partner_low,
  AiconfigHeuristic::second_last_jab_for_following_pfund,
  AiconfigHeuristic::last_player_jab_with_trump_ace_or_ten,
  AiconfigHeuristic::last_player_jab_for_points,
  AiconfigHeuristic::jab_with_opponent_backhand,
  AiconfigHeuristic::serve_with_lowest_card,
  AiconfigHeuristic::serve_partner_with_lowest_card,

  AiconfigHeuristic::remaining_tricks_to_me,
  AiconfigHeuristic::start_with_color,
  AiconfigHeuristic::start_with_low_color,
  AiconfigHeuristic::start_with_low_trump,
  AiconfigHeuristic::retry_color,
  AiconfigHeuristic::start_with_trump_for_partner_color_ace,
  AiconfigHeuristic::play_color_for_partner_to_jab,
  AiconfigHeuristic::play_color_for_last_player_to_jab,
  AiconfigHeuristic::play_color_for_partner_ace,
  AiconfigHeuristic::play_bad_color,
  AiconfigHeuristic::save_dulle,
  AiconfigHeuristic::save_dulle_from_swines,
  AiconfigHeuristic::save_swines_from_hyperswines,
  AiconfigHeuristic::jab_swine_with_hyperswine,
  AiconfigHeuristic::serve_color_trick,
  AiconfigHeuristic::serve_trump_trick,
  AiconfigHeuristic::pfund_high_for_sure,
  AiconfigHeuristic::pfund_for_sure,
  AiconfigHeuristic::pfund_high_for_unsure,
  AiconfigHeuristic::pfund_for_unsure,
  AiconfigHeuristic::start_with_trump_pfund,
  AiconfigHeuristic::pfund_before_partner,
  AiconfigHeuristic::jab_for_ace,
  AiconfigHeuristic::create_blank_color,
  AiconfigHeuristic::play_trump,
  AiconfigHeuristic::jab_fox,
  AiconfigHeuristic::jab_for_doppelkopf,
  AiconfigHeuristic::try_for_doppelkopf,
  AiconfigHeuristic::play_for_partner_worries,
  AiconfigHeuristic::partner_backhand_draw_trump,
  AiconfigHeuristic::draw_trump,
  AiconfigHeuristic::draw_remaining_trump,
  AiconfigHeuristic::draw_trump_for_team_announcement,
  AiconfigHeuristic::play_to_jab_later,
  AiconfigHeuristic::play_highest_color_card_in_game,
  AiconfigHeuristic::jab_to_win,
  AiconfigHeuristic::jab_to_not_loose,
  AiconfigHeuristic::grab_trick,
  AiconfigHeuristic::last_player_pass_small_trick,
  AiconfigHeuristic::cannot_jab,
  AiconfigHeuristic::play_last_trumps,

  AiconfigHeuristic::start_to_marry,
  AiconfigHeuristic::jab_to_marry,
  AiconfigHeuristic::start_to_get_married,
  AiconfigHeuristic::start_to_get_married_last_chance,
  AiconfigHeuristic::pfund_in_marriage_determination_trick,

  AiconfigHeuristic::poverty_special_start_with_trump,
  AiconfigHeuristic::poverty_special_play_pfund,
  AiconfigHeuristic::poverty_special_give_no_points,
  AiconfigHeuristic::poverty_special_offer_pfund,
  AiconfigHeuristic::poverty_re_jab_as_last_player,
  AiconfigHeuristic::poverty_re_jab_color_trick_with_trump,
  AiconfigHeuristic::poverty_re_start_with_trump,
  AiconfigHeuristic::poverty_contra_start_with_color,
  AiconfigHeuristic::poverty_contra_jab_color_trick_with_trump,
  AiconfigHeuristic::poverty_contra_pfund_high_for_sure,
  AiconfigHeuristic::poverty_contra_pfund_for_sure,
  AiconfigHeuristic::poverty_contra_pfund_high_for_unsure,
  AiconfigHeuristic::poverty_contra_pfund_for_unsure,
  AiconfigHeuristic::poverty_contra_pfund_before_partner,
  AiconfigHeuristic::poverty_leave_to_partner,
  AiconfigHeuristic::poverty_overjab_re,

  AiconfigHeuristic::play_color_in_solo,

  AiconfigHeuristic::color_jab_for_ace,
  AiconfigHeuristic::color_pfund_in_first_color_run,
  AiconfigHeuristic::color_pfund_high_for_sure,
  AiconfigHeuristic::color_pfund_for_sure,
  AiconfigHeuristic::color_pfund_high_for_unsure,
  AiconfigHeuristic::color_pfund_for_unsure,
  AiconfigHeuristic::color_overjab_to_get_partner_backhand,

  AiconfigHeuristic::picture_start_with_highest_color,
  AiconfigHeuristic::picture_pull_down_color,
  AiconfigHeuristic::picture_get_first_trumps,
  AiconfigHeuristic::picture_get_last_trumps,
  AiconfigHeuristic::picture_get_trumps_before_blank_color_ace,
  AiconfigHeuristic::picture_draw_trumps,
  AiconfigHeuristic::picture_serve_trump_trick,
  AiconfigHeuristic::picture_jab_trump_trick,
  AiconfigHeuristic::picture_start_with_winning_card_before_bad_loosing_cards,
  AiconfigHeuristic::picture_start_with_loosing_solo_color,
  AiconfigHeuristic::picture_play_last_trumps,
  AiconfigHeuristic::picture_pfund_high_for_sure,
  AiconfigHeuristic::picture_pfund_for_sure,
  AiconfigHeuristic::picture_pfund_high_for_unsure,
  AiconfigHeuristic::picture_pfund_for_unsure,
  AiconfigHeuristic::picture_jab_color_trick_for_sure,
  AiconfigHeuristic::picture_contra_discard_color_card,
  AiconfigHeuristic::picture_contra_jab_color_trick,
  AiconfigHeuristic::picture_contra_jab_with_high_color_card,

  AiconfigHeuristic::meatless_start_with_best_color,
  AiconfigHeuristic::meatless_pull_down_color,
  AiconfigHeuristic::meatless_play_blank_color_of_soloplayer,
  AiconfigHeuristic::meatless_retry_last_color,
  AiconfigHeuristic::meatless_overjab_re,
  AiconfigHeuristic::meatless_pfund_for_sure,
  AiconfigHeuristic::meatless_pfund_before_partner,
  AiconfigHeuristic::meatless_play_color_for_partner_ace,
  AiconfigHeuristic::meatless_serve_color_trick,
  AiconfigHeuristic::meatless_serve_trick_re,
  AiconfigHeuristic::meatless_serve_trick_contra,
  AiconfigHeuristic::meatless_play_highest_color_card_in_game,
};

constexpr size_t aiconfig_heuristic_size = sizeof(aiconfig_heuristic_list) / sizeof(aiconfig_heuristic_list[0]);

auto is_real(          AiconfigHeuristic heuristic) -> bool;
auto is_general(       AiconfigHeuristic heuristic) -> bool;
auto for_marriage(     AiconfigHeuristic heuristic) -> bool;
auto for_poverty(      AiconfigHeuristic heuristic) -> bool;
auto for_solo(         AiconfigHeuristic heuristic) -> bool;
auto for_color_solo(   AiconfigHeuristic heuristic) -> bool;
auto for_picture_solo( AiconfigHeuristic heuristic) -> bool;
auto for_meatless_solo(AiconfigHeuristic heuristic) -> bool;


auto to_string(AiconfigHeuristic heuristic) -> string;
auto AiconfigHeuristic_from_name(string const& name) -> AiconfigHeuristic;

auto operator<<(ostream& ostr, AiconfigHeuristic heuristic) -> ostream&;
auto gettext(AiconfigHeuristic heuristic)             -> string;
auto gettext_description(AiconfigHeuristic heuristic) -> string;
